/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.exporter.AreaExportType;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.math.projection.CoordinateFactory;

public abstract class ExportAreaDialog
extends CommonDialog {
    private static final long serialVersionUID = -6325261876242871518L;
    private ModelEnviroment modelEnvironment;
    private EnumComboBox<AreaExportType> areaExportType;
    private EnumComboBox<CoordinateFactory.Projections> coordinateFactory;
    private AreaLayerComboBox areaLayerComboBox;
    private JCheckBox extendToFullRange;
    private boolean withLayer;

    public ExportAreaDialog(Window parent, String title, ModelEnviroment modelEnvironment, boolean withLayer) {
        super((Component)parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnvironment = modelEnvironment;
        this.withLayer = withLayer;
        this.buildLayout();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    public ExportAreaDialog(Window parent, String title) {
        this(parent, title, null, false);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -3905674216715135028L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAreaDialog.this.dispose();
                ExportAreaDialog.this.export(ExportAreaDialog.this, (AreaExportType)((Object)ExportAreaDialog.this.areaExportType.getSelectedValue()), (CoordinateFactory.Projections)((Object)ExportAreaDialog.this.coordinateFactory.getSelectedValue()), ExportAreaDialog.this.withLayer ? (AreaLayerModel)ExportAreaDialog.this.areaLayerComboBox.getSelectedItem() : null, ExportAreaDialog.this.extendToFullRange.isSelected(), false);
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 1947343066802700578L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAreaDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new SpringLayout());
        if (this.withLayer) {
            innerPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
            this.areaLayerComboBox = new AreaLayerComboBox(this.modelEnvironment, false, AreaObjectGenInfoDiscriminator.values());
            innerPanel.add(this.areaLayerComboBox);
        }
        innerPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(AreaExportType.class)));
        this.areaExportType = new EnumComboBox<AreaExportType>(AreaExportType.class, false);
        this.areaExportType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAreaDialog.this.setWidgetEnabled();
            }
        });
        this.areaExportType.setSelectedValue(AreaExportType.STREET_CSV);
        innerPanel.add(this.areaExportType);
        innerPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(CoordinateFactory.Projections.class)));
        this.coordinateFactory = new EnumComboBox<CoordinateFactory.Projections>(CoordinateFactory.Projections.class, false, CoordinateFactory.getListableProjections());
        this.coordinateFactory.setSelectedValue(CoordinateFactory.Projections.Wgs84);
        innerPanel.add(this.coordinateFactory);
        innerPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumbersEndAt", new Serializable[0])));
        this.extendToFullRange = new JCheckBox();
        innerPanel.add(this.extendToFullRange);
        SpringUtilities.makeCompactGrid(innerPanel, 3 + (this.withLayer ? 1 : 0), 2, 5, 5, 2, 2);
        panel.add((Component)innerPanel, "North");
        this.setWidgetEnabled();
        return panel;
    }

    private void setWidgetEnabled() {
        if (this.extendToFullRange != null && this.coordinateFactory != null) {
            switch (this.areaExportType.getSelectedValue()) {
                case SHP: {
                    this.extendToFullRange.setEnabled(false);
                    this.coordinateFactory.setEnabled(true);
                    break;
                }
                case STREET_CSV: {
                    this.extendToFullRange.setEnabled(true);
                    this.coordinateFactory.setEnabled(false);
                }
            }
        }
    }

    protected abstract void export(ExportAreaDialog var1, AreaExportType var2, CoordinateFactory.Projections var3, AreaLayerModel var4, boolean var5, boolean var6);
}

