/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import org.ktde.util.StringUtil;

public enum AreaNameRenderingType {
    SHORTCUT,
    DISPLAY_NAME,
    SHORTCUT_DISPLAY_NAME;


    public static AreaNameRenderingType getValue(String pattern) {
        if (pattern.contains("shortcut") && pattern.contains("displayName")) {
            return SHORTCUT_DISPLAY_NAME;
        }
        if (pattern.contains("shortcut")) {
            return SHORTCUT;
        }
        if (pattern.contains("displayName")) {
            return DISPLAY_NAME;
        }
        return null;
    }

    public String formate(String pattern, AreaObjectModel area) {
        String s = "";
        if (area == null) {
            return s;
        }
        if (StringUtil.isBlank(pattern)) {
            switch (this) {
                case DISPLAY_NAME: {
                    s = area.getDisplayname();
                    break;
                }
                case SHORTCUT: {
                    s = area.getShortcut();
                    break;
                }
                case SHORTCUT_DISPLAY_NAME: {
                    s = AreaObjectModelUtil.getShortcutAndDisplayname(area);
                }
            }
        } else {
            s = pattern.replaceAll("%%%shortcut%%%", area.getShortcut());
            s = s.replaceAll("%%%displayname%%%", area.getDisplayname());
        }
        return s;
    }
}

