/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.address;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListedAddressPane
extends JPanel {
    private static final long serialVersionUID = -8029236227205828023L;
    private CountryComboBox country;
    private JTextField postcode;
    private JTextField city;
    private JTextField district;
    private JTextField street;
    private JTextField housenumber;
    private JTextField housenumberExtension;
    private List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    public ListedAddressPane(Country[] countries, Country preselectedCountry) {
        super(new SpringLayout());
        this.buildLayout(countries, preselectedCountry);
    }

    private void buildLayout(Country[] countries, Country preselectedCountry) {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        this.country = new CountryComboBox(countries, true, preselectedCountry);
        this.add(this.country);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        this.postcode = new JTextField(20);
        this.add(this.postcode);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        this.city = new JTextField(20);
        this.add(this.city);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        this.district = new JTextField(20);
        this.add(this.district);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        this.street = new JTextField(20);
        this.add(this.street);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        this.housenumber = new JTextField(20);
        this.add(this.housenumber);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        this.housenumberExtension = new JTextField(20);
        this.add(this.housenumberExtension);
        SpringUtilities.makeCompactGrid(this, 7, 2, 5, 5, 2, 2);
        ListedAddressPaneDocumentListener documentListener = new ListedAddressPaneDocumentListener();
        this.postcode.getDocument().addDocumentListener(documentListener);
        this.city.getDocument().addDocumentListener(documentListener);
        this.district.getDocument().addDocumentListener(documentListener);
        this.street.getDocument().addDocumentListener(documentListener);
        this.housenumber.getDocument().addDocumentListener(documentListener);
        this.housenumberExtension.getDocument().addDocumentListener(documentListener);
        this.country.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListedAddressPane.this.fireChangeEvent(new ChangeEvent(e));
            }
        });
    }

    public Country getCountry() {
        return this.country.getSelectedItem();
    }

    public String getPostcode() {
        return this.postcode.getText();
    }

    public String getCity() {
        return this.city.getText();
    }

    public String getDistrict() {
        return this.district.getText();
    }

    public String getStreet() {
        return this.street.getText();
    }

    public String getHousenumber() {
        return this.housenumber.getText();
    }

    public String getHousenumberExtension() {
        return this.housenumberExtension.getText();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    private class ListedAddressPaneDocumentListener
    implements DocumentListener {
        private ListedAddressPaneDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ListedAddressPane.this.fireChangeEvent(new ChangeEvent(e));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ListedAddressPane.this.fireChangeEvent(new ChangeEvent(e));
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ListedAddressPane.this.fireChangeEvent(new ChangeEvent(e));
        }
    }
}

