/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.address;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.MessageResolver;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.ktde.util.StringUtil;

public class AddressTable
extends JTable {
    private static final long serialVersionUID = 2793841638672730115L;
    private boolean withId;
    private boolean withMatching;
    private ModelEnviroment modelEnviroment;

    public AddressTable(boolean withId, boolean withMatching, ModelEnviroment modelEnviroment) {
        super(new DefaultTableModel(new Object[0][], AddressTable.getHeaderNames(withId, withMatching)));
        this.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.withId = withId;
        this.withMatching = withMatching;
        this.modelEnviroment = modelEnviroment;
    }

    private static String[] getHeaderNames(boolean withId, boolean withMatching) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        String[] titles = new String[7 + (withId ? 1 : 0) + (withMatching ? 1 : 0)];
        int i = 0;
        if (withId) {
            titles[i++] = messageResolver.resolveMessage("messages.default.id", new Serializable[0]);
        }
        titles[i++] = messageResolver.resolveMessage("address.country", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.postcode", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.city", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.district", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.street", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.housenumber", new Serializable[0]);
        titles[i++] = messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]);
        if (withMatching) {
            titles[i++] = messageResolver.resolveMessage("address.matching", new Serializable[0]);
        }
        return titles;
    }

    public void addLogisticLocationDto(LogisticLocationDto<Long> logisticLocationDto) {
        Object[] row = this.createRowForLogisticLocationDto(logisticLocationDto);
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addRow(row);
    }

    private String[] createRowForLogisticLocationDto(LogisticLocationDto<Long> logisticLocationDto) {
        String[] row = new String[7 + (this.withId ? 1 : 0) + (this.withMatching ? 1 : 0)];
        int i = 0;
        if (this.withId) {
            row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getId());
        }
        Country country = logisticLocationDto.getCountry();
        row[i++] = country == null ? "" : country.getVehicleSign();
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getPostcode());
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getCity());
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getDistrict());
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getStreet());
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getHousenumber());
        row[i++] = StringUtil.nullToEmpty(logisticLocationDto.getExtension());
        if (this.withMatching) {
            row[i++] = "";
        }
        return row;
    }

    public void addLogisticQualifiedLocationDto(LogisticQualifiedLocationDto logisticQualifiedLocationDto) {
        Object[] row = this.createRowForLogisticLocationDto(logisticQualifiedLocationDto);
        if (this.withMatching) {
            row[7 + (this.withId ? 1 : 0)] = StringUtil.nullToEmpty(logisticQualifiedLocationDto.getMatching());
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addRow(row);
    }

    public void addParcel(ParcelModel parcelModel, Double matching) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        Object[] row = new String[7 + (this.withId ? 1 : 0) + (this.withMatching ? 1 : 0)];
        int i = 0;
        if (this.withId) {
            String key = parcelModel == null ? "?" : parcelModel.getImportKey();
            row[i++] = key;
        }
        StreetModel street = parcelModel.getStreet();
        PostcodeDistrictRelationModel postcodeDistrictRelation = null;
        DistrictModel district = null;
        CityModel city = null;
        PostcodeModel postcode = null;
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
        }
        Country country = postcode == null ? null : postcode.getCountry();
        row[i++] = country == null ? "" : country.getVehicleSign();
        row[i++] = postcode == null ? "" : StringUtil.nullToEmpty(postcode.getName());
        row[i++] = city == null ? "" : StringUtil.nullToEmpty(city.getName());
        row[i++] = district == null ? "" : StringUtil.nullToEmpty(district.getName());
        row[i++] = street == null ? "" : StringUtil.nullToEmpty(street.getName());
        row[i++] = StringUtil.nullToEmpty(parcelModel.getHouseNumber());
        row[i++] = StringUtil.nullToEmpty(parcelModel.getHouseNumberExtension());
        if (this.withMatching) {
            row[i++] = matching == null ? "" : matching.toString();
        }
        model.addRow(row);
    }

    public void removeAllRows() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            model.removeRow(i);
        }
    }

    private class TableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public TableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

