/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.lucene.SearchType;
import de.datomino.peppergis.util.FormUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompletableJTextField<O>
extends JTextField
implements ListSelectionListener {
    private static final long serialVersionUID = 8135139715964693660L;
    private Completer completer;
    private JList completionList;
    private DefaultListModel completionListModel;
    private JScrollPane popupScrollPane;
    private JWindow popupWindow;
    private O selectedObject;
    private AbstractListCellRenderer<O> cellRenderer;
    private boolean popupVisible = true;

    public CompletableJTextField(AbstractListCellRenderer<O> cellRenderer, Window parent) {
        if (cellRenderer == null) {
            cellRenderer = new AbstractListCellRenderer<O>(){

                @Override
                protected String getStringFromValue(O o) {
                    return o == null ? "" : o.toString();
                }
            };
        }
        this.cellRenderer = cellRenderer;
        this.completer = new Completer();
        this.completionListModel = new DefaultListModel();
        this.completionList = new JList(this.completionListModel);
        this.completionList.setSelectionMode(0);
        this.completionList.addListSelectionListener(this);
        this.completionList.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                CompletableJTextField.this.completionList.setSelectedIndex(CompletableJTextField.this.completionList.locationToIndex(p));
            }
        });
        this.completionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                CompletableJTextField.this.completionList.setSelectedIndex(CompletableJTextField.this.completionList.locationToIndex(p));
                CompletableJTextField.this.makeSelection();
            }
        });
        this.completionList.setCellRenderer(cellRenderer);
        this.popupScrollPane = new JScrollPane(this.completionList, 20, 31);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)this.popupScrollPane, "Center");
        mainPane.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5592807641093311949L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableJTextField.this.setSelectedObject(CompletableJTextField.this.getSelectedObject());
            }
        }), "South");
        try {
            this.popupWindow = new JWindow(parent);
            this.popupWindow.getContentPane().add(mainPane);
            this.popupWindow.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    CompletableJTextField.this.requestFocus();
                }
            });
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    CompletableJTextField.this.setText(CompletableJTextField.this.cellRenderer.getStringFromValue(CompletableJTextField.this.selectedObject));
                    CompletableJTextField.this.popupWindow.setVisible(false);
                } else if (e.getKeyCode() == 40) {
                    CompletableJTextField.this.completionList.setSelectedIndex(CompletableJTextField.this.getNewIndex(1));
                } else if (e.getKeyCode() == 38) {
                    CompletableJTextField.this.completionList.setSelectedIndex(CompletableJTextField.this.getNewIndex(-1));
                } else if (e.getKeyCode() == 10) {
                    CompletableJTextField.this.makeSelection();
                }
            }
        });
    }

    private int getNewIndex(int i) {
        int newIndex = this.completionList.getSelectedIndex();
        if ((newIndex += i) < 0) {
            newIndex = this.completionListModel.size() - 1;
        } else if (newIndex >= this.completionListModel.size()) {
            newIndex = 0;
        }
        return newIndex;
    }

    public void addCompletion(O o) {
        this.completer.addCompletion(o);
    }

    public void removeCompletion(O o) {
        this.completer.removeCompletion(o);
    }

    public void clearCompletions() {
        this.completer.clearCompletions();
    }

    public void makeSelection() {
        this.selectedObject = this.completionList.getSelectedValue();
        super.setText(this.cellRenderer.getStringFromValue(this.selectedObject));
        this.popupWindow.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.completionListModel.getSize() == 0) {
            return;
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.popupScrollPane.setPreferredSize(new Dimension(w, 200));
    }

    public O getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(O o) {
        this.selectedObject = o;
        super.setText(this.cellRenderer.getStringFromValue(this.selectedObject));
        this.popupWindow.setVisible(false);
    }

    public List<O> getDataList() {
        return this.completer.content;
    }

    private class Completer
    implements DocumentListener {
        private ArrayList<O> content = new ArrayList();

        public Completer() {
            CompletableJTextField.this.getDocument().addDocumentListener(this);
        }

        public void addCompletion(O o) {
            this.content.add(o);
            this.buildAndShowPopup();
        }

        public void removeCompletion(O o) {
            this.content.remove(o);
            this.buildAndShowPopup();
        }

        public void clearCompletions() {
            this.content.clear();
            this.buildAndShowPopup();
            CompletableJTextField.this.popupWindow.setVisible(false);
        }

        private void buildPopup() {
            CompletableJTextField.this.completionListModel.clear();
            for (Object o : this.content) {
                if (!FormUtil.matchs(CompletableJTextField.this.cellRenderer.getStringFromValue(o), CompletableJTextField.this.getText(), SearchType.WILD_CARD)) continue;
                CompletableJTextField.this.completionListModel.addElement(o);
            }
        }

        private void showPopup() {
            if (CompletableJTextField.this.completionListModel.getSize() == 0 || !CompletableJTextField.this.popupVisible) {
                CompletableJTextField.this.popupWindow.setVisible(false);
                return;
            }
            try {
                Point los = CompletableJTextField.this.getLocationOnScreen();
                int popX = los.x;
                int popY = los.y + CompletableJTextField.this.getHeight();
                CompletableJTextField.this.popupWindow.setLocation(popX, popY);
                CompletableJTextField.this.popupWindow.pack();
                CompletableJTextField.this.popupWindow.setVisible(true);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }

        private void buildAndShowPopup() {
            if (CompletableJTextField.this.getText().length() >= 1) {
                this.buildPopup();
                this.showPopup();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }
    }
}

