/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.AbstractAutoCompleteComboBox;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutoCompleteTextField<O>
extends JTextField {
    private static final long serialVersionUID = 5826264760641633026L;
    private List<O> datas;
    private boolean isCaseSensitive = false;
    private AbstractAutoCompleteComboBox<O> comboBox;

    public AutoCompleteTextField(List<O> datas, AbstractAutoCompleteComboBox<O> abstractAutoCompleteComboBox) {
        if (datas == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.datas = datas;
        this.comboBox = abstractAutoCompleteComboBox;
        this.init();
    }

    private void init() {
        this.setDocument(new AutoDocument());
        if (this.datas.size() > 0) {
            this.setText(this.comboBox.toDisplayString(this.datas.iterator().next()));
        }
    }

    private Object getMatch(String s) {
        Object match = null;
        int minLength = Integer.MAX_VALUE;
        for (O object : this.datas) {
            String s1 = this.comboBox.toDisplayString(object);
            if (s1 == null) continue;
            if (!this.isCaseSensitive && s1.toLowerCase().startsWith(s.toLowerCase()) && s1.length() < minLength) {
                match = object;
                minLength = s1.length();
            }
            if (!this.isCaseSensitive || !s1.startsWith(s) || s1.length() >= minLength) continue;
            match = object;
            minLength = s1.length();
        }
        return match;
    }

    @Override
    public void replaceSelection(String s) {
        AutoDocument autoDocument = (AutoDocument)this.getDocument();
        if (autoDocument != null) {
            try {
                int i = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
                int j = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
                autoDocument.replace(i, j - i, s, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public List<O> getDataList() {
        if (this.datas == null) {
            return Collections.emptyList();
        }
        return this.datas;
    }

    public void setDataList(List<O> datas) {
        if (datas == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.datas = datas;
    }

    private class AutoDocument
    extends PlainDocument {
        private static final long serialVersionUID = 513061932542392859L;

        private AutoDocument() {
        }

        @Override
        public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
            if (s == null || s.contains("class de.datomino")) {
                return;
            }
            super.remove(i, j);
            this.insertString(i, s, attributeset);
        }

        @Override
        public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
            String part1 = this.getText(0, i);
            Object data = AutoCompleteTextField.this.getMatch(part1 + s);
            int j = i + s.length() - 1;
            if (data == null) {
                data = AutoCompleteTextField.this.getMatch(part1);
                --j;
            }
            if (AutoCompleteTextField.this.comboBox != null && data != null) {
                AutoCompleteTextField.this.comboBox.setSelectedItem(data);
            }
            super.remove(0, this.getLength());
            super.insertString(0, AutoCompleteTextField.this.comboBox.toDisplayString(data), attributeset);
            AutoCompleteTextField.this.setSelectionStart(j + 1);
            AutoCompleteTextField.this.setSelectionEnd(this.getLength());
        }

        @Override
        public void remove(int i, int j) throws BadLocationException {
            int k = AutoCompleteTextField.this.getSelectionStart();
            if (k > 0) {
                --k;
            }
            Object data = AutoCompleteTextField.this.getMatch(this.getText(0, k));
            super.remove(0, this.getLength());
            super.insertString(0, AutoCompleteTextField.this.comboBox.toDisplayString(data), null);
            if (AutoCompleteTextField.this.comboBox != null && data != null) {
                AutoCompleteTextField.this.comboBox.setSelectedItem(data);
            } else {
                AutoCompleteTextField.this.comboBox.setSelectedIndex(0);
            }
            try {
                AutoCompleteTextField.this.setSelectionStart(k);
                AutoCompleteTextField.this.setSelectionEnd(this.getLength());
            }
            catch (Exception exception) {
                AutoCompleteTextField.this.comboBox.setSelectedItem(data);
            }
        }
    }
}

