/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.action.search.CommonSearchAction;
import de.datomino.peppergis.client.gui.MapEditorActions;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.util.geo.NavigatorContainer;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.ToggleAction;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningKeyListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractMapEditorPanel
extends JSplitPane
implements NavigatorContainer,
MapEditorActions {
    private static final long serialVersionUID = -3325661028641155005L;
    protected static final int SORT_ORDER_MAP = 0;
    protected static final int SORT_ORDER_AREA = 1000;
    protected static final int SORT_ORDER_AREA1 = 2000;
    protected static final int SORT_ORDER_PARCEL = 3000;
    protected static final int SORT_ORDER_DATA = 3500;
    protected static final int SORT_ORDER_LETTER = 4000;
    protected static final int SORT_ORDER_SUBSCRIPTION = 5000;
    protected static final int SORT_ORDER_POI = 6000;
    protected static final int SORT_ORDER_SEARCH = 7000;
    protected static final int SORT_ORDER_ZOOMING = 8000;
    protected static final int SORT_ORDER_MAP_SCALE = 9000;
    protected static final int SORT_ORDER_RULER = 10000;
    protected NavigatorPanel navigator;
    private CommonSearchAction searchActionButton;
    private CommonSearchAction searchActionMenu;
    private ModelEnviroment modelEnviroment;

    public AbstractMapEditorPanel() {
        this((Component)null);
    }

    public AbstractMapEditorPanel(ModelEnviroment modelEnviroment) {
        super(1);
        this.modelEnviroment = modelEnviroment;
        this.modelEnviroment.getUndoManager().joinTransaction();
    }

    public AbstractMapEditorPanel(Component parent) {
        super(1);
        this.modelEnviroment = this.createModelEnviroment(parent == null ? SwingUtils.findWindowParent(this) : parent);
        this.modelEnviroment.getUndoManager().joinTransaction();
    }

    protected ModelEnviroment createModelEnviroment(Component parent) {
        return new ModelEnviroment(parent);
    }

    protected abstract boolean isSearchOnlyForParcel();

    protected void initialize() {
        Coordinate startCoordinate = this.getStartCoordinate();
        this.navigator = this.createNavigatorPanel(startCoordinate, OpenStreetmapViewFactory.INSTANCE);
        this.addKeyListener(this.navigator);
        this.searchActionButton = new CommonSearchAction(this, this.navigator, this.modelEnviroment, true, this.isSearchOnlyForParcel());
        this.searchActionMenu = new CommonSearchAction(this, this.navigator, this.modelEnviroment, false, this.isSearchOnlyForParcel());
        this.searchActionButton.setBuddyAction(this.searchActionMenu);
        this.searchActionMenu.setBuddyAction(this.searchActionButton);
        this.searchActionButton.setSortOrder(7000);
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.add((Component)this.navigator, "Center");
        this.setRightComponent(leftPane);
        this.setDividerSize(0);
        this.navigator.setPanning(true);
        this.navigator.getPanningAction().turnOn();
    }

    public NavigatorPanel createNavigatorPanel(Coordinate startCoordinate, CoordinateFactory fac) {
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        osmNavigatorRenderer.setSortOrder(0);
        NavigatorPanel navigatorPanel = new NavigatorPanel(startCoordinate, fac, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.panning", new Serializable[0]), (Container)this);
        navigatorPanel.addRenderer(osmNavigatorRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        renderer.setNavigatorPanel(navigatorPanel);
        renderer.setSortOrder(9000);
        navigatorPanel.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(navigatorPanel);
        zoomingRenderer.setNavigatorPanel(navigatorPanel);
        zoomingRenderer.setSortOrder(8000);
        navigatorPanel.addRenderer(zoomingRenderer);
        navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
        return navigatorPanel;
    }

    protected Coordinate getStartCoordinate() {
        String startString = ModelEnviroment.getProperties().getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    @Override
    public NavigatorPanel getNavigatorPanel() {
        return this.navigator;
    }

    @Override
    public CommonSearchAction getSearchActionMenu() {
        return this.searchActionMenu;
    }

    @Override
    public CommonSearchAction getSearchActionButton() {
        return this.searchActionButton;
    }

    @Override
    public Action getSaveAction() {
        return this.modelEnviroment.getUndoManager().getSaveAction();
    }

    @Override
    public Action getRevertAction() {
        return this.modelEnviroment.getUndoManager().getRevertAction();
    }

    @Override
    public Action getUndoAction() {
        return this.modelEnviroment.getUndoManager().getUndoAction();
    }

    @Override
    public Action getRedoAction() {
        return this.modelEnviroment.getUndoManager().getRedoAction();
    }

    public UndoManager getUndoManager() {
        return this.modelEnviroment.getUndoManager();
    }

    @Override
    public ToggleAction getPanningAction() {
        return this.navigator.getPanningAction();
    }

    public void showException(RuntimeException re) {
        Container window = this.getTopLevelAncestor();
        if (window instanceof DesktopClientApplication) {
            re.printStackTrace();
            ((DesktopClientApplication)window).showMessage(re);
        } else {
            re.printStackTrace();
        }
    }

    public Window getParentWindow() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public void zoom(double zoom) {
        this.navigator.zoom(zoom);
    }

    public void zoom(double zoom, Point2D.Double pixel) {
        this.navigator.zoom(zoom, pixel);
    }

    public void zoomWithAbsolutePixel(double zoom, Point2D.Double pixel) {
        Point absolute = this.navigator.getLocationOnScreen();
        Point2D.Double fixedPoint = new Point2D.Double(pixel.getX() - absolute.getX(), pixel.getY() - absolute.getY());
        this.zoom(zoom, fixedPoint);
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public NavigatorPanningKeyListener getNavigatorPanningKeyListener() {
        return this.navigator.getNavigatorPanningKeyListener();
    }

    public static int getSortOrderData() {
        return 3500;
    }

    public void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType name, Collection<? extends Model> marked) {
    }

    public void close() {
        this.modelEnviroment.close();
        this.getNavigatorPanel().close();
    }
}

