/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.action.HoverGeoObjectBucketMouseManipulatorAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public abstract class AbstractHoverRenderer<S extends Model, T extends ImmutableGeoObject>
extends HoverGeoObjectBucketMouseManipulatorAction<S, T>
implements NavigatorRenderer {
    private static final long serialVersionUID = 7093796724085383654L;
    private Cursor hoverCursor;
    private boolean active;
    private Component parent;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;

    public AbstractHoverRenderer(NavigatorPanel navigatorPanel, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean active, Component parent) {
        super(navigatorPanel, maxUpp, title, bucketsModel, modelEnviroment);
        this.active = active;
        this.parent = parent;
    }

    @Override
    protected double getMindistForHover(int x, int y) {
        return 5.0 * this.getNavigatorPanel().getUpp();
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected Cursor getHoverCursor(Collection<S> s) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/cross.png"));
        this.hoverCursor = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        return this.hoverCursor;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return "Havor";
    }

    @Override
    protected void turnedOn() {
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        navigatorPanel.removeMouseWheelListener(navigatorPanel.getPanningAction());
        this.setActive(true);
    }

    @Override
    protected void turnedOff() {
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            navigatorPanel.setCursor(Cursor.getDefaultCursor());
        }
        this.setActive(false);
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.getNavigatorPanel().repaint(10L);
            this.fireActiveChanged();
        }
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    protected Window getParentWindow() {
        return SwingUtils.findWindowParent(this.parent);
    }

    @Override
    public void close() {
        this.getBucketsModel().clear();
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

