/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.geo.swing.ObjectSelectionChangedEvent;
import de.datomino.util.geo.swing.ObjectSelectionHandler;
import de.datomino.util.geo.swing.ObjectSelectionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractAreaLayerEditorPanel
extends AbstractMapEditorPanel
implements ObjectSelectionHandler<AreaObjectModel> {
    private static final long serialVersionUID = 2553158921122612116L;
    private Set<AreaObjectModel> selectedObjects = new LinkedHashSet<AreaObjectModel>();
    protected List<ObjectSelectionListener<AreaObjectModel>> areaObjectModelSelectionListeners = new ArrayList<ObjectSelectionListener<AreaObjectModel>>();

    public abstract AreaLayerModel getCurrentAreaLayer();

    protected abstract void updateSelectAreaObjectsInfo();

    protected abstract void setCurrentAreaObjects(Collection<AreaObjectModel> var1);

    public AbstractAreaLayerEditorPanel() {
    }

    public AbstractAreaLayerEditorPanel(ModelEnviroment modelEnviroment) {
        super(modelEnviroment);
    }

    public Set<AreaObjectModel> getSelectedObjects() {
        return this.selectedObjects;
    }

    @Override
    public void select(Collection<AreaObjectModel> object) {
        int nSize;
        if (object == null) {
            object = Collections.emptySet();
        }
        int cSize = this.selectedObjects.size();
        int n = nSize = object == null ? 0 : object.size();
        if (cSize != nSize || !this.selectedObjects.containsAll(object)) {
            HashSet<AreaObjectModel> oldSelection = new HashSet<AreaObjectModel>(this.selectedObjects);
            this.setCurrentAreaObjects(object);
            this.firePlainObjectSelectionChanged(oldSelection, this.selectedObjects);
        }
        this.updateSelectAreaObjectsInfo();
    }

    @Override
    public void appendSelection(Collection<AreaObjectModel> object) {
        if (object == null) {
            object = Collections.emptySet();
        }
        HashSet<AreaObjectModel> oldSelection = new HashSet<AreaObjectModel>(this.selectedObjects);
        this.selectedObjects.addAll(object);
        if (oldSelection.size() != this.selectedObjects.size()) {
            this.setCurrentAreaObjects(this.selectedObjects);
        }
        this.firePlainObjectSelectionChanged(oldSelection, this.selectedObjects);
        this.updateSelectAreaObjectsInfo();
    }

    @Override
    public void clearSelection() {
        if (!this.selectedObjects.isEmpty()) {
            HashSet<AreaObjectModel> oldSelection = new HashSet<AreaObjectModel>(this.selectedObjects);
            this.selectedObjects.clear();
            this.setCurrentAreaObjects(this.selectedObjects);
            this.firePlainObjectSelectionChanged(oldSelection, this.selectedObjects);
        }
    }

    @Override
    public void removeSelection(Collection<AreaObjectModel> object) {
        HashSet<AreaObjectModel> oldSelection = new HashSet<AreaObjectModel>(this.selectedObjects);
        this.selectedObjects.removeAll(object);
        if (this.selectedObjects.size() != oldSelection.size()) {
            this.setCurrentAreaObjects(this.selectedObjects);
        }
        this.firePlainObjectSelectionChanged(oldSelection, this.selectedObjects);
    }

    @Override
    public void toggleSelection(Collection<AreaObjectModel> object) {
        if (object != null && !object.isEmpty()) {
            HashSet<AreaObjectModel> oldSelection = new HashSet<AreaObjectModel>(this.selectedObjects);
            for (AreaObjectModel areaObjectModel : object) {
                if (this.selectedObjects.contains(areaObjectModel)) {
                    this.selectedObjects.remove(areaObjectModel);
                    continue;
                }
                this.selectedObjects.add(areaObjectModel);
            }
            this.setCurrentAreaObjects(new HashSet<AreaObjectModel>(this.selectedObjects));
            this.firePlainObjectSelectionChanged(oldSelection, this.selectedObjects);
        }
        this.updateSelectAreaObjectsInfo();
    }

    @Override
    public void addObjectSelectionListener(ObjectSelectionListener<AreaObjectModel> objectSelectionListener) {
        this.areaObjectModelSelectionListeners.add(objectSelectionListener);
    }

    @Override
    public void removeObjectSelectionListener(ObjectSelectionListener<AreaObjectModel> objectSelectionListener) {
        this.areaObjectModelSelectionListeners.remove(objectSelectionListener);
    }

    protected void firePlainObjectSelectionChanged(Set<AreaObjectModel> oldSelection, Set<AreaObjectModel> newSelection) {
        Set emptySet = Collections.emptySet();
        ObjectSelectionChangedEvent<AreaObjectModel> event = new ObjectSelectionChangedEvent<AreaObjectModel>(this, new Tupel(oldSelection, emptySet), new Tupel(newSelection, emptySet));
        this.fireObjectSelectionChanged(event);
    }

    protected void fireObjectSelectionChanged(ObjectSelectionChangedEvent<AreaObjectModel> event) {
        for (ObjectSelectionListener<AreaObjectModel> objectSelectionListener : this.areaObjectModelSelectionListeners) {
            objectSelectionListener.selectionChanged(event);
        }
    }
}

