/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.geometric;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.SegmentAttributeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.SegmentModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.helper.ParcelImporterStreetStandarizingType;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.ParcelSortOrderType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.peppergis.type.StopStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.CacheUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoClientHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoClientHelper.class);
    private ModelEnviroment modelEnviroment;
    private boolean newSegment;
    private DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> segmentBucketsModel;
    private double segmentSearchFactor = 3.0;

    public GeoClientHelper(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
        this.newSegment = false;
        try {
            this.newSegment = Boolean.parseBoolean(ModelEnviroment.getProperties().getProperty("tour.routing.newSegment"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        final StreetNetCaller streetNetCaller = this.modelEnviroment.getAllCaller().getStreetNetCaller();
        this.segmentBucketsModel = new DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString>(CacheUtil.FACTORY.getRefScale() * 5000.0, CacheUtil.FACTORY, new GeomExtractor<SegmentModel, ImmutableLineString>(){

            @Override
            public ImmutableLineString getGeom(SegmentModel object) {
                return object.getGeom();
            }
        }, (ImmutablePolygon)streetNetCaller.getSegmentMaxEnvelope().getGeoObject());
        this.segmentBucketsModel.setFetchCallback(new BucketsFetchCallback<SegmentModel, ImmutableLineString>(){

            @Override
            public Collection<SegmentModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                return streetNetCaller.fetchSegments(topLeft, bottomRight);
            }
        });
        Double newSegmentSearchFactor = modelEnviroment.getAllCaller().getTourCaller().getSegmentSearchFactor();
        this.segmentSearchFactor = newSegmentSearchFactor == null ? this.segmentSearchFactor : newSegmentSearchFactor;
    }

    public ImmutablePoint getAccessGeomFromPoi(PoiModel poi, RouteVehicleType routeVehicleType) {
        LocationModel location = poi.getLocation();
        return this.getAccessGeomForLocation(location, routeVehicleType);
    }

    public ImmutablePoint getAccessGeomFromSubscription(SubscriptionModel subscription, RouteVehicleType routeVehicleType) {
        LocationModel location = subscription.getLocation();
        return this.getAccessGeomForLocation(location, routeVehicleType);
    }

    public ImmutablePoint getAccessGeomForParcel(ParcelModel parcel, RouteVehicleType routeVehicleType) {
        SegmentModel routeSegment;
        ImmutablePoint accessGeom = null;
        SegmentModel segmentModel = routeSegment = this.newSegment ? null : ParcelModelUtil.getRouteSegment(parcel, routeVehicleType);
        if (routeSegment == null) {
            if (parcel != null) {
                StreetModel street = parcel.getStreet();
                String streetName = street == null ? null : street.getName();
                Tupel<ImmutablePoint, SegmentModel> tupel = this.getAccessGeom(parcel.getGeom(), streetName, routeVehicleType);
                accessGeom = tupel.getElement1();
                switch (routeVehicleType) {
                    case MOTORCAR: {
                        parcel.setMotorSegment(tupel.getElement2());
                        parcel.setManualMotorSegmentUpdate(false);
                        break;
                    }
                    case BIKE: {
                        parcel.setBikeSegment(tupel.getElement2());
                        parcel.setManualBikeSegmentUpdate(false);
                        break;
                    }
                    case FOOT: {
                        parcel.setFootSegment(tupel.getElement2());
                        parcel.setManualFootSegmentUpdate(false);
                        break;
                    }
                }
            }
        } else {
            Tupel<Double, ImmutablePoint> foot = GeoUtil.getShortestPerpendicular(parcel.getGeom(), routeSegment.getGeom());
            accessGeom = foot.getElement2();
        }
        return accessGeom;
    }

    public Tupel<ImmutablePoint, SegmentModel> getAccessGeom(ImmutablePoint point, String streetName, RouteVehicleType routeVehicleType) {
        Collection<SegmentModel> segments = this.getStreets(point, true, routeVehicleType);
        if (point == null || segments == null || segments.isEmpty()) {
            LOGGER.warn("a null point");
            return new Tupel<ImmutablePoint, Object>(point, null);
        }
        Tripel<Object, Object, Object> shortestLine = new Tripel<Object, Object, Object>(null, null, null);
        for (SegmentModel s : segments) {
            Tupel<Double, ImmutablePoint> line = GeoUtil.getShortestPerpendicular(point, s.getGeom());
            if (shortestLine.getElement1() != null && !(line.getElement1() < (Double)shortestLine.getElement1())) continue;
            shortestLine.setElement1(line.getElement1());
            shortestLine.setElement2(line.getElement2());
            shortestLine.setElement3(s);
        }
        if (shortestLine.getElement3() != null && !StringUtil.isBlank(streetName) && !this.isSamedNameSegment(streetName, shortestLine.getElement3())) {
            this.findSamedNameSegment(point, streetName, shortestLine);
        }
        return new Tupel<Object, Object>(shortestLine.getElement2(), shortestLine.getElement3());
    }

    private void findSamedNameSegment(ImmutablePoint point, String streetName, Tripel<Double, ImmutablePoint, SegmentModel> tripel) {
        ImmutableLineString transformedLineString = (ImmutableLineString)tripel.getElement3().getGeom().getTransformed(this.segmentBucketsModel.getCoordinateFactory());
        ImmutablePoint transformedPoint = (ImmutablePoint)point.getTransformed(this.segmentBucketsModel.getCoordinateFactory());
        double distance = transformedLineString.distance(transformedPoint);
        Collection founds = this.segmentBucketsModel.findObjects(transformedPoint, distance * this.segmentSearchFactor);
        for (SegmentModel f : founds) {
            if (!this.isSamedNameSegment(streetName, f)) continue;
            Tupel<Double, ImmutablePoint> line = GeoUtil.getShortestPerpendicular(point, f.getGeom());
            tripel.setElement1(line.getElement1());
            tripel.setElement2(line.getElement2());
            tripel.setElement3(f);
            break;
        }
    }

    private boolean isSamedNameSegment(String streetName, SegmentModel segment) {
        streetName = ParcelImporterStreetStandarizingType.standardize(streetName, ParcelImporterStreetStandarizingType.STR, true);
        String segmentName = SegmentModelUtil.getSegmentName(segment);
        segmentName = ParcelImporterStreetStandarizingType.standardize(segmentName, ParcelImporterStreetStandarizingType.STR, true);
        return streetName.equals(segmentName);
    }

    private boolean isValid(SegmentType streetType, SegmentStatus status, RouteVehicleType routeVehicleType) {
        boolean badStatus;
        boolean valid = false;
        boolean bl = badStatus = status != null && status.isBad(routeVehicleType);
        if (streetType != null && routeVehicleType != null && !badStatus) {
            switch (routeVehicleType) {
                case MOTORCAR: {
                    if (!streetType.isForMotor()) break;
                    valid = true;
                    break;
                }
                case BIKE: {
                    if (!streetType.isForBike()) break;
                    valid = true;
                    break;
                }
                case FOOT: {
                    if (!streetType.isForFoot()) break;
                    valid = true;
                }
            }
        }
        return valid;
    }

    private Collection<SegmentModel> getStreets(ImmutablePoint point, boolean expandable, RouteVehicleType routeVehicleType) {
        if (GeoUtil.isNullPoint(point)) {
            return null;
        }
        HashSet<SegmentModel> filteredSegments = new HashSet<SegmentModel>();
        double d = (double)CacheUtil.DEFAULTWIDTH.intValue() * point.getCoordinateFactory().getRefScale() / CacheUtil.FACTORY.getRefScale();
        for (int step = 0; filteredSegments.isEmpty() && expandable && step < 10; ++step) {
            Collection segments = this.segmentBucketsModel.findObjects(point, d * (double)step);
            for (SegmentModel segment : segments) {
                if (segment.getSegmentStatus() == null) {
                    HashMap<String, String> segmentAttributeMap = new HashMap<String, String>();
                    for (SegmentAttributeModel attribute : segment.iterableAttributes()) {
                        segmentAttributeMap.put(attribute.getKey(), attribute.getValue());
                    }
                    segment.setSegmentStatus(SegmentStatus.getSegmentStatus(segmentAttributeMap));
                }
                if (!this.isValid(segment.getSegmentType(), segment.getSegmentStatus(), routeVehicleType)) continue;
                filteredSegments.add(segment);
            }
        }
        return filteredSegments;
    }

    public ImmutablePoint getAccessGeomForLocation(LocationModel location, RouteVehicleType routeVehicleType) {
        ImmutablePoint point;
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        ImmutablePoint immutablePoint = point = locationWrapper == null ? null : locationWrapper.getGeoLocation();
        if (GeoUtil.isNullPoint(point)) {
            return null;
        }
        if (location.getParcel() != null) {
            switch (routeVehicleType) {
                case MOTORCAR: {
                    if (location.getMotorSegment() != null && !this.newSegment) break;
                    ImmutablePoint accessGeom = this.getAccessGeomForParcel(location.getParcel(), RouteVehicleType.MOTORCAR);
                    location.setMotorSegment(location.getParcel().getMotorSegment());
                    return accessGeom;
                }
                case FOOT: {
                    if (location.getFootSegment() != null && !this.newSegment) break;
                    ImmutablePoint accessGeom = this.getAccessGeomForParcel(location.getParcel(), RouteVehicleType.FOOT);
                    location.setFootSegment(location.getParcel().getFootSegment());
                    return accessGeom;
                }
                case BIKE: {
                    if (location.getBikeSegment() != null && !this.newSegment) break;
                    ImmutablePoint accessGeom = this.getAccessGeomForParcel(location.getParcel(), RouteVehicleType.BIKE);
                    location.setBikeSegment(location.getParcel().getBikeSegment());
                    return accessGeom;
                }
            }
        }
        ImmutablePoint accessGeom = null;
        switch (routeVehicleType) {
            case MOTORCAR: {
                if (location.getParcel() != null && location.getParcel().getMotorSegment() != null) {
                    location.setMotorSegment(location.getParcel().getMotorSegment());
                }
                if (location.getMotorSegment() != null && !this.newSegment) {
                    Tupel<Double, ImmutablePoint> accessPoint = GeoUtil.getShortestPerpendicular(point, location.getMotorSegment().getGeom());
                    accessGeom = accessPoint.getElement2();
                    break;
                }
                Tupel<ImmutablePoint, SegmentModel> tupel = this.getAccessGeom(point, null, RouteVehicleType.MOTORCAR);
                accessGeom = tupel.getElement1();
                location.setMotorSegment(tupel.getElement2());
                break;
            }
            case BIKE: {
                if (location.getParcel() != null && location.getParcel().getBikeSegment() != null) {
                    location.setBikeSegment(location.getParcel().getBikeSegment());
                }
                if (location.getBikeSegment() != null && !this.newSegment) {
                    Tupel<Double, ImmutablePoint> accessPoint = GeoUtil.getShortestPerpendicular(point, location.getBikeSegment().getGeom());
                    accessGeom = accessPoint.getElement2();
                    break;
                }
                Tupel<ImmutablePoint, SegmentModel> tupel = this.getAccessGeom(point, null, RouteVehicleType.BIKE);
                accessGeom = tupel.getElement1();
                location.setBikeSegment(tupel.getElement2());
                break;
            }
            case FOOT: {
                if (location.getParcel() != null && location.getParcel().getFootSegment() != null) {
                    location.setFootSegment(location.getParcel().getFootSegment());
                }
                if (location.getFootSegment() != null && !this.newSegment) {
                    Tupel<Double, ImmutablePoint> accessPoint = GeoUtil.getShortestPerpendicular(point, location.getFootSegment().getGeom());
                    accessGeom = accessPoint.getElement2();
                    break;
                }
                Tupel<ImmutablePoint, SegmentModel> tupel = this.getAccessGeom(point, null, RouteVehicleType.FOOT);
                accessGeom = tupel.getElement1();
                location.setFootSegment(tupel.getElement2());
                break;
            }
        }
        return accessGeom;
    }

    public Map<TourPartModel, Collection<StopModel>> checkStopModels(TourModel tour, RouteVehicleType routeVehicleType, RouteType routeType, OptimizationAlgorithmType algorithmType, boolean ignoreTimeWindow) {
        HashMap<TourPartModel, Collection<StopModel>> exceptionMap = new HashMap<TourPartModel, Collection<StopModel>>();
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPartModel = tourPartIter.next();
            HashSet<Model> exceptionModels = new HashSet<Model>();
            exceptionMap.put(tourPartModel, exceptionModels);
            Iterator<StopModel> stopIter = tourPartModel.iterateStops();
            ArrayList<StopModel> stopsWithGeom = new ArrayList<StopModel>();
            ArrayList<PointEntity> pointEntitys = new ArrayList<PointEntity>();
            while (stopIter.hasNext()) {
                LocationModel location;
                ImmutablePoint point;
                StopModel stop = stopIter.next();
                StopStatus stopStatus = stop.getStopStatus();
                if (stopStatus != null && stopStatus == StopStatus.BAD_TIME_WINDOW) {
                    if (ignoreTimeWindow) {
                        stop.setStopStatus(StopStatus.NORMAL);
                    } else {
                        exceptionModels.add(stop);
                        continue;
                    }
                }
                if ((point = this.getAccessGeomForLocation(location = stop.getLocation(), routeVehicleType)) == null) {
                    exceptionModels.add(stop);
                    LOGGER.warn("no geom - " + LocationModelUtil.getAddressShortString(location));
                    continue;
                }
                PointEntity pointEntity = new PointEntity(new PointEntityId(stop.getId(), PointEntityId.PointEnityType.STOP), LocationModelUtil.getGeom(location), point);
                SegmentModel segment = null;
                switch (routeVehicleType) {
                    case FOOT: {
                        segment = location == null ? null : location.getBikeSegment();
                        break;
                    }
                    case BIKE: {
                        segment = location == null ? null : location.getFootSegment();
                        break;
                    }
                    default: {
                        SegmentModel segmentModel = segment = location == null ? null : location.getMotorSegment();
                    }
                }
                if (segment != null) {
                    pointEntity.setRouteSegmentId(segment.getTempUUID());
                    pointEntity.setRouteSegmentLineString(segment.getGeom());
                } else if (algorithmType == OptimizationAlgorithmType.DEFAULT_STREET_SIDE || algorithmType == OptimizationAlgorithmType.CLUSTERING_STREET_SIDE) {
                    exceptionModels.add(stop);
                    LOGGER.warn("no route street - " + LocationModelUtil.getAddressShortString(location));
                    continue;
                }
                stopsWithGeom.add(stop);
                pointEntitys.add(pointEntity);
            }
            List<Model> badModels = this.findPointsInBadSegment(stopsWithGeom, pointEntitys, routeVehicleType, routeType);
            exceptionModels.addAll(badModels);
        }
        return exceptionMap;
    }

    public static List<ImmutablePoint> getPoints(GeoDistanceMatrixWrapper geoDistance) {
        LinkedList<ImmutablePoint> points;
        block3: {
            GeoDecimal100Factory factory = GeoDecimal100Factory.INSTANCE;
            points = new LinkedList<ImmutablePoint>();
            try {
                points.addAll(((ImmutableLineString)((ImmutableLineString)geoDistance.getLineString().getGeoObject()).getTransformed(factory)).getCoordinates());
            }
            catch (Exception e) {
                if (geoDistance.getStart() != null && geoDistance.getStart().getGeoObject() != null) {
                    points.add((ImmutablePoint)((ImmutablePoint)geoDistance.getStart().getGeoObject()).getTransformed(factory));
                }
                if (geoDistance.getTarget() == null || geoDistance.getTarget().getGeoObject() == null) break block3;
                points.add((ImmutablePoint)((ImmutablePoint)geoDistance.getTarget().getGeoObject()).getTransformed(factory));
            }
        }
        return points;
    }

    public void clearSegmentBucket() {
        this.segmentBucketsModel.clear();
    }

    public void addPointEntityForParcel(RouteVehicleType routeVehicleType, List<PointEntity> accessPoints, ParcelModel parcel, Long id, AreaObjectModel areaObject, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round, ParcelSortOrderType type) {
        if (id == null) {
            id = parcel.getTempUUID();
        }
        if (ParcelModelUtil.checkGeomOfParcel(parcel)) {
            PostcodeDistrictRelationModel relation;
            StreetModel street;
            PointEntity point = new PointEntity(new PointEntityId(id, PointEntityId.PointEnityType.PARCEL), parcel.getGeom(), this.getAccessGeomForParcel(parcel, routeVehicleType));
            point.setParcelLocation(ParcelModelUtil.getParcelLocation(parcel));
            SegmentModel routeSegment = ParcelModelUtil.getRouteSegment(parcel, routeVehicleType);
            if (routeSegment != null) {
                point.setRouteSegmentId(routeSegment.getTempUUID());
                point.setRouteSegmentLineString(routeSegment.getGeom());
            }
            if (otherRouteVehicleType != null) {
                point.setOtherAccessGeom(this.getAccessGeomForParcel(parcel, otherRouteVehicleType));
                SegmentModel otherRouteSegment = ParcelModelUtil.getRouteSegment(parcel, otherRouteVehicleType);
                point.setOtherRouteSegmentId(otherRouteSegment == null ? null : otherRouteSegment.getId());
            }
            point.setStreet((street = parcel.getStreet()) == null ? null : FormUtil.getStringDisplay(street.getName()));
            if (street != null && (relation = street.getPostcodeDistrictRelation()) != null) {
                point.setPostcode(relation.getPostcode() == null ? null : relation.getPostcode().getName());
            }
            point.setHousenumber(parcel.getHouseNumber());
            point.setExtension(parcel.getHouseNumberExtension());
            point.setSortOrder(ParcelModelUtil.getSortOrder(parcel, areaObject, routeVehicleType, round, type));
            accessPoints.add(point);
        }
    }

    public OptimizationType addPointEntityForPoi(OptimizationType optimizationType, RouteVehicleType routeVehicleType, PoiModel poi, List<PointEntity> accessPoints, Long id, boolean withCalculation) {
        if (poi != null && poi.getLocation() != null) {
            LocationWrapper locationWrapper;
            if (id == null) {
                id = poi.getTempUUID();
            }
            if ((locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(poi.getLocation())).getGeoLocation() != null) {
                ImmutablePoint accessPoint = this.getAccessGeomFromPoi(poi, routeVehicleType);
                PointEntity pointEntity = new PointEntity(new PointEntityId(id, PointEntityId.PointEnityType.POI), locationWrapper.getGeoLocation(), accessPoint);
                pointEntity.setParcelLocation(ParcelModelUtil.getParcelLocation(poi.getLocation().getParcel()));
                if (optimizationType.isStartWithPoi()) {
                    accessPoints.add(0, pointEntity);
                }
                if (optimizationType.isEndWithPoi()) {
                    accessPoints.add(pointEntity);
                }
            } else {
                LOGGER.warn("poi with null point");
                optimizationType = OptimizationType.NONFIX;
            }
        } else if (poi == null && optimizationType.isWithPoi()) {
            if (!withCalculation) {
                return null;
            }
            LOGGER.warn(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.nodepot", new Serializable[0]));
            optimizationType = OptimizationType.NONFIX;
        }
        return optimizationType;
    }

    private void addPointEntityForLetter(RouteVehicleType routeVehicleTypeInArea, List<PointEntity> accessPoints, LetterModel letter, Long id, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round) throws LogisticException {
        if (id == null) {
            id = letter.getTempUUID();
        }
        if (LetterModelUtil.checkGeomOfLetter(letter)) {
            PointEntity point = new PointEntity(new PointEntityId(id, PointEntityId.PointEnityType.LETTER), LetterModelUtil.getGeom(letter), this.getAccessGeomFromLetter(letter, routeVehicleTypeInArea));
            if (point.getAccessGeom() == null) {
                throw new LogisticException("Ein Brief (" + LetterModelUtil.getDisplayString(letter) + ") hat keine Koordinate.");
            }
            LocationModel location = letter.getLocation();
            point.setParcelLocation(ParcelModelUtil.getParcelLocation(location.getParcel()));
            SegmentModel segment = LocationModelUtil.getRouteSegment(location, routeVehicleTypeInArea);
            if (segment != null) {
                point.setRouteSegmentId(segment.getTempUUID());
                point.setRouteSegmentLineString(segment.getGeom());
            }
            if (otherRouteVehicleType != null) {
                point.setOtherAccessGeom(this.getAccessGeomFromLetter(letter, otherRouteVehicleType));
                SegmentModel otherRouteSegment = LocationModelUtil.getRouteSegment(location, otherRouteVehicleType);
                point.setRouteSegmentId(otherRouteSegment == null ? null : otherRouteSegment.getId());
            }
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            point.setStreet(locationWrapper.getStreet());
            point.setPostcode(locationWrapper.getPostcode());
            point.setHousenumber("" + locationWrapper.getHousenumber());
            point.setExtension(locationWrapper.getHousenumberExtension());
            point.setSortOrder(LetterModelUtil.getSortOrder(letter, routeVehicleTypeInArea, round));
            accessPoints.add(point);
        }
    }

    private ImmutablePoint getAccessGeomFromLetter(LetterModel letter, RouteVehicleType routeVehicleType) {
        LocationModel location = letter.getLocation();
        return this.getAccessGeomForLocation(location, routeVehicleType);
    }

    public void addPointEntityForSubscription(RouteVehicleType routeVehicleType, List<PointEntity> accessPoints, SubscriptionModel subscription, Long id, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round) throws LogisticException {
        if (id == null) {
            id = subscription.getTempUUID();
        }
        if (SubscriptionModelUtil.checkGeomOfSubscription(subscription)) {
            PointEntity point = new PointEntity(new PointEntityId(id, PointEntityId.PointEnityType.SUBSCRIPTION), SubscriptionModelUtil.getGeom(subscription), this.getAccessGeomFromSubscription(subscription, routeVehicleType));
            if (point.getAccessGeom() == null) {
                throw new LogisticException("Ein Abonnent(" + SubscriptionModelUtil.getDisplayString(subscription) + ") hat keine Koordinate.");
            }
            LocationModel location = subscription.getLocation();
            point.setParcelLocation(ParcelModelUtil.getParcelLocation(location.getParcel()));
            SegmentModel segment = LocationModelUtil.getRouteSegment(location, routeVehicleType);
            if (segment != null) {
                point.setRouteSegmentId(segment.getTempUUID());
                point.setRouteSegmentLineString(segment.getGeom());
            }
            if (otherRouteVehicleType != null) {
                point.setOtherAccessGeom(this.getAccessGeomFromSubscription(subscription, otherRouteVehicleType));
                SegmentModel otherRouteSegment = LocationModelUtil.getRouteSegment(location, otherRouteVehicleType);
                point.setRouteSegmentId(otherRouteSegment == null ? null : otherRouteSegment.getId());
            }
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            point.setStreet(locationWrapper.getStreet());
            point.setPostcode(locationWrapper.getPostcode());
            point.setHousenumber("" + locationWrapper.getHousenumber());
            point.setExtension(locationWrapper.getHousenumberExtension());
            point.setSortOrder(SubscriptionModelUtil.getSortOrder(subscription, routeVehicleType, round));
            accessPoints.add(point);
        }
    }

    public List<PointEntity> getAccessPointsForParcel(Tupel<List<ParcelModel>, List<ParcelModel>> tupel, RouteVehicleType vehicleType, RouteType routeType, AreaObjectModel areaObject, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round, ParcelSortOrderType type) {
        ArrayList<PointEntity> accessPoints = new ArrayList<PointEntity>();
        for (ParcelModel parcel : tupel.getElement1()) {
            this.addPointEntityForParcel(vehicleType, accessPoints, parcel, null, areaObject, otherRouteVehicleType, round, type);
        }
        List<Model> badModels = this.findPointsInBadSegment(tupel.getElement1(), accessPoints, vehicleType, routeType);
        tupel.getElement1().removeAll(badModels);
        tupel.getElement2().addAll(badModels);
        return accessPoints;
    }

    public List<PointEntity> getAccessPointsForSubscription(Tupel<List<SubscriptionModel>, List<SubscriptionModel>> tupel, RouteVehicleType routeVehicleType, RouteType routeType, AreaObjectModel area, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round) throws LogisticException {
        ArrayList<PointEntity> accessPoints = new ArrayList<PointEntity>();
        for (SubscriptionModel subscription : tupel.getElement1()) {
            this.addPointEntityForSubscription(routeVehicleType, accessPoints, subscription, null, otherRouteVehicleType, round);
        }
        List<Model> badModels = this.findPointsInBadSegment(tupel.getElement1(), accessPoints, routeVehicleType, routeType);
        tupel.getElement1().removeAll(badModels);
        tupel.getElement2().addAll(badModels);
        return accessPoints;
    }

    public List<PointEntity> getAccessPointsForObjects(List<Model> objectsWithGeom, List<Model> objectsWithNullGeom, RouteVehicleType routeVehicleTypeInArea, RouteType routeTypeInArea, AreaObjectModel areaObject, RouteVehicleType otherRouteVehicleType, DeliveryRoundModel round, ParcelSortOrderType type) throws LogisticException {
        ArrayList<PointEntity> accessPoints = new ArrayList<PointEntity>();
        for (Model model : objectsWithGeom) {
            if (model instanceof ParcelModel) {
                this.addPointEntityForParcel(routeVehicleTypeInArea, accessPoints, (ParcelModel)model, null, areaObject, otherRouteVehicleType, round, type);
                continue;
            }
            if (model instanceof SubscriptionModel) {
                this.addPointEntityForSubscription(routeVehicleTypeInArea, accessPoints, (SubscriptionModel)model, null, otherRouteVehicleType, round);
                continue;
            }
            if (!(model instanceof LetterModel)) continue;
            this.addPointEntityForLetter(routeVehicleTypeInArea, accessPoints, (LetterModel)model, null, otherRouteVehicleType, round);
        }
        List<Model> badModels = this.findPointsInBadSegment(objectsWithGeom, accessPoints, routeVehicleTypeInArea, routeTypeInArea);
        objectsWithGeom.removeAll(badModels);
        objectsWithNullGeom.addAll(badModels);
        return accessPoints;
    }

    public List<Model> findPointsInBadSegment(List<? extends Model> models, List<PointEntity> entities, RouteVehicleType vehicleType, RouteType routeType) {
        Model model;
        ImmutablePoint originPoint;
        List<PoiModel> origins = this.modelEnviroment.getAllCaller().getTourCaller().fetchPoisWithTypes(CollectionUtil.buildHashSet(PoiType.ORIGIN));
        ImmutablePoint immutablePoint = originPoint = origins.isEmpty() ? null : LocationModelUtil.getGeom(origins.iterator().next().getLocation());
        if (originPoint == null) {
            originPoint = ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(9.4933619E7, 5.13165916E8));
        }
        HashSet<SegmentModel> finisheds = new HashSet<SegmentModel>();
        HashSet<SegmentModel> bads = new HashSet<SegmentModel>();
        ArrayList<Integer> removeIndies = new ArrayList<Integer>();
        int index = 0;
        for (PointEntity entity : entities) {
            ImmutablePoint accessGeom = entity.getAccessGeom();
            model = models.get(index);
            SegmentModel segment = this.getRouteSegment(model, vehicleType);
            if (segment == null) continue;
            if (!finisheds.contains(segment)) {
                if (bads.contains(segment)) {
                    removeIndies.add(index);
                } else {
                    boolean b;
                    SegmentStatus segmentStatus = segment.getSegmentStatus();
                    boolean bl = b = segmentStatus == null ? true : segmentStatus.isBad(vehicleType);
                    if (segmentStatus == null) {
                        segmentStatus = this.getSegmentStatus(segment, accessGeom, originPoint, vehicleType);
                        boolean bl2 = b = segmentStatus == null ? true : segmentStatus.isBad(vehicleType);
                        if (segmentStatus != null && !segmentStatus.equals((Object)segment.getSegmentStatus())) {
                            this.modelEnviroment.getUndoManager().startTransaction();
                            segment.setSegmentStatus(segmentStatus);
                            this.modelEnviroment.getUndoManager().finishTransaction("");
                            this.modelEnviroment.getUndoManager().startTransaction();
                        }
                    }
                    if (!b) {
                        originPoint = accessGeom;
                        finisheds.add(segment);
                    } else {
                        bads.add(segment);
                        removeIndies.add(index);
                        String p1String = originPoint == null ? "" : ((ImmutablePoint)originPoint.getTransformed(Wgs84Factory.INSTANCE)).toString();
                        String p2String = accessGeom == null ? "" : ((ImmutablePoint)accessGeom.getTransformed(Wgs84Factory.INSTANCE)).toString();
                        LOGGER.warn("found bad segment - " + segment.getId() + " from " + p1String + " to " + p2String);
                    }
                }
            }
            ++index;
        }
        Collections.reverse(removeIndies);
        ArrayList<Model> modelsWithBadSegment = new ArrayList<Model>();
        Iterator iterator = removeIndies.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            entities.remove(i);
            model = models.remove(i);
            modelsWithBadSegment.add(model);
        }
        return modelsWithBadSegment;
    }

    private SegmentStatus getSegmentStatus(SegmentModel segment, ImmutablePoint point, ImmutablePoint origin, RouteVehicleType vehicleType) {
        boolean bike;
        boolean foot;
        boolean motor;
        if (vehicleType == null) {
            return null;
        }
        HashMap<String, String> segmentAttributeMap = new HashMap<String, String>();
        for (SegmentAttributeModel attribute : segment.iterableAttributes()) {
            segmentAttributeMap.put(attribute.getKey(), attribute.getValue());
        }
        SegmentStatus status = SegmentStatus.getSegmentStatus(segmentAttributeMap);
        boolean bl = motor = !status.isBadForMotor();
        if (motor && vehicleType == RouteVehicleType.MOTORCAR) {
            motor = this.checkPointFromOrigin(point, origin, RouteVehicleType.MOTORCAR, RouteType.FASTEST);
        }
        boolean bl2 = foot = !(status = SegmentStatus.getNewStatus(status, motor, RouteVehicleType.MOTORCAR)).isBadForFoot();
        if (foot && vehicleType == RouteVehicleType.FOOT) {
            foot = this.checkPointFromOrigin(point, origin, RouteVehicleType.FOOT, RouteType.SHORTEST);
        }
        boolean bl3 = bike = !(status = SegmentStatus.getNewStatus(status, foot, RouteVehicleType.FOOT)).isBadForBike();
        if (bike && vehicleType == RouteVehicleType.BIKE) {
            bike = this.checkPointFromOrigin(point, origin, RouteVehicleType.BIKE, RouteType.SHORTEST);
        }
        status = SegmentStatus.getNewStatus(status, bike, RouteVehicleType.BIKE);
        return status;
    }

    private SegmentModel getRouteSegment(Model model, RouteVehicleType vehicleType) {
        SegmentModel segment = null;
        if (model instanceof ParcelModel) {
            segment = ParcelModelUtil.getRouteSegment((ParcelModel)model, vehicleType);
        } else if (model instanceof SubscriptionModel) {
            LocationModel location = ((SubscriptionModel)model).getLocation();
            segment = LocationModelUtil.getRouteSegment(location, vehicleType, this.modelEnviroment);
        } else if (model instanceof StopModel) {
            LocationModel location = ((StopModel)model).getLocation();
            segment = LocationModelUtil.getRouteSegment(location, vehicleType, this.modelEnviroment);
        }
        return segment;
    }

    private boolean checkPointFromOrigin(ImmutablePoint point, ImmutablePoint origin, RouteVehicleType vehicleType, RouteType routeType) {
        try {
            GeoDistanceMatrixWrapper result = this.modelEnviroment.getAllCaller().getTourCaller().getGeoDistance(point, origin, vehicleType, routeType);
            if (result == null || (result.getLineString() == null || result.getLineString().getGeoObject() == null) && result.getId() != null) {
                return false;
            }
        }
        catch (LogisticException e) {
            return false;
        }
        return true;
    }

    public void setNewSegment(boolean newSegment) {
        this.newSegment = newSegment;
    }
}

