/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.frey;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.peppergis.client.frey.CoordinateAndAreasDto;
import de.datomino.peppergis.client.frey.FreyLocalisationInternalFrame;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.client.swing.baselayer.BaseLayerEditorInternalFrame;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousGeneralDto;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.exception.InsufficiantLicenseException;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.frey.FreySelectBaseLayerEditorPanel;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.ParcelParameter;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.callback.CallBack;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class FreyRequestHandlingThread
extends Thread {
    private int port;
    private ServerSocket serverSocket;
    private PepperGisDesktopApplication pepperGisDesktopApplication;

    public FreyRequestHandlingThread(int port, PepperGisDesktopApplication pepperGisDesktopApplication) {
        this.port = port;
        this.pepperGisDesktopApplication = pepperGisDesktopApplication;
    }

    @Override
    public void run() {
        super.run();
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress("localhost", this.port));
            while (true) {
                final Socket socket = this.serverSocket.accept();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                FreyRequestHandlingThread.this.handleRequest(socket);
                            }
                        }
                        catch (IOException e) {
                            System.out.println("Socket closed");
                            return;
                        }
                    }
                }).start();
            }
        }
        catch (IOException e) {
            System.out.println("Socket closed");
            return;
        }
    }

    private void handleRequest(Socket socket) throws IOException {
        InputStream in = socket.getInputStream();
        char c = Character.toUpperCase((char)in.read());
        switch (c) {
            case 'R': 
            case 'S': {
                this.showSelect(socket, c);
                break;
            }
            case 'P': {
                this.showProposal(socket);
                break;
            }
            case 'D': {
                this.showDelivery(socket);
                break;
            }
            case 'V': {
                this.createPdf(socket);
            }
        }
    }

    private void createPdf(Socket socket) throws IOException {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.pepperGisDesktopApplication);
        InputStream inputStream = socket.getInputStream();
        char c = Character.toUpperCase((char)inputStream.read());
        Long layerId = this.getLayerId('D', Character.valueOf(c));
        AreaLayerModel layer = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(layerId);
        int areaCount = inputStream.read();
        areaCount += inputStream.read() * 256;
        areaCount += inputStream.read() * 256 * 256;
        areaCount += inputStream.read() * 256 * 256 * 256;
        LinkedHashSet<AreaObjectModel> areasWithStart = new LinkedHashSet<AreaObjectModel>();
        LinkedHashSet<AreaObjectModel> areasWithoutStart = new LinkedHashSet<AreaObjectModel>();
        TreeSet<String> notFoundAreaKeys = new TreeSet<String>();
        for (int i = 0; i < areaCount; ++i) {
            String areaKey = this.readString(inputStream);
            Double x = this.readDouble(inputStream);
            Double y = this.readDouble(inputStream);
            int d = inputStream.read();
            boolean withStart = d != 0;
            AreaObjectModel areaObject = modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObject(layer, areaKey);
            if (areaObject == null) {
                notFoundAreaKeys.add(areaKey);
                continue;
            }
            if (withStart) {
                this.insertOrUpdatePoi(areaObject, x, y, modelEnviroment);
                areasWithStart.add(areaObject);
                continue;
            }
            areasWithoutStart.add(areaObject);
        }
        Map<String, byte[]> withoutPdfs = this.createPdf(areasWithoutStart, modelEnviroment, false);
        Map<String, byte[]> withPdfs = this.createPdf(areasWithStart, modelEnviroment, true);
        HashMap<String, byte[]> full = new HashMap<String, byte[]>();
        full.putAll(withoutPdfs);
        full.putAll(withPdfs);
        if (full.size() == 1) {
            try {
                PdfUtil.showPdf("peppergis-area-tour", new ByteArrayInputStream((byte[])full.values().iterator().next()), ModelEnviroment.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (full.size() > 1) {
            this.savePdfs(full);
        }
        if (!notFoundAreaKeys.isEmpty()) {
            JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, "Nicht gefundene Gebietsschl\u00fcssel: " + StringUtil.implode(notFoundAreaKeys, ", "), "Warnung", 2);
        }
    }

    private void savePdfs(Map<String, byte[]> cMap) {
        JFileChooser fileChooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public String getDescription() {
                return "Verzeichins";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setFileSelectionMode(1);
        boolean d2 = false;
        File dir = null;
        do {
            int d = fileChooser.showSaveDialog(this.pepperGisDesktopApplication);
            switch (d) {
                case 0: {
                    dir = fileChooser.getSelectedFile();
                    if (!this.checkForOverwrite(dir, cMap.keySet())) break;
                    d2 = true;
                    dir = null;
                }
            }
        } while (d2);
        for (Map.Entry<String, byte[]> entry : cMap.entrySet()) {
            String key = entry.getKey();
            if (key.equals("reviewAreaTour")) continue;
            File file = new File(dir, key);
            try {
                FileUtils.writeByteArrayToFile(file, entry.getValue());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, "Konnte Datei " + file.getAbsolutePath() + " nicht schreiben (" + e.getMessage() + ")", "Fehler", 0);
            }
        }
    }

    private boolean checkForOverwrite(File dir, Collection<String> keySet) {
        boolean existing = false;
        for (String name : keySet) {
            if (name.equals("reviewAreaTour") || !new File(dir, name).exists()) continue;
            existing = true;
            break;
        }
        if (existing) {
            int d = JOptionPane.showConfirmDialog(this.pepperGisDesktopApplication, "Dateien sind bereits (teilweise) vorhanden. \u00dcberschreiben?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
            return d != 0;
        }
        return false;
    }

    private Map<String, byte[]> createPdf(Collection<AreaObjectModel> areasWithoutStart, ModelEnviroment modelEnviroment, boolean withStart) {
        AsynchronousDto<TourExportDto> reviewAreaToursResult;
        if (areasWithoutStart.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Tupel<AreaObjectModel, List<Model>>> areas = new ArrayList<Tupel<AreaObjectModel, List<Model>>>();
        for (AreaObjectModel area : areasWithoutStart) {
            areas.add(new Tupel<AreaObjectModel, Object>(area, null));
        }
        ArrayList<AreaTourParameter> parameters = new ArrayList<AreaTourParameter>(1);
        ParcelParameter parameter = new ParcelParameter(new AreaTourType(AreaObjectType.PARCEL, AreaCalculationType.DEFAULT), withStart, false, false, RouteBackType.NONE, new Date());
        parameter.setRoutingType(withStart ? OptimizationType.STARTWITHPOI : OptimizationType.NONFIX);
        parameters.add(parameter);
        String token = modelEnviroment.getAllCaller().getAsynchronousCaller().reviewAreaTours(areas, parameters, TourExportFormat.CSV, true, false, false);
        while ((reviewAreaToursResult = modelEnviroment.getAllCaller().getAsynchronousCaller().getReviewAreaToursResult(token)).getStatus() == AsynchronousGeneralDto.Status.RUNNING) {
        }
        switch (reviewAreaToursResult.getStatus()) {
            case ERROR: {
                JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage(reviewAreaToursResult.getMainMessageKey(), reviewAreaToursResult.getMainMessageArgs()), "Fehler", 0);
                return null;
            }
            case SUCCESS: {
                Map<String, byte[]> content = ((TourExportDto)reviewAreaToursResult.getResult()).getContent();
                HashMap<String, byte[]> nMap = new HashMap<String, byte[]>(content);
                nMap.remove("reviewAreaTour");
                return nMap;
            }
        }
        return null;
    }

    private void insertOrUpdatePoi(AreaObjectModel areaObject, Double x, Double y, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        while (undoManager.isTransactionOpen()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        undoManager.startTransaction();
        String shortcut = areaObject.getShortcut();
        String poiNumber = "AREA_" + shortcut;
        PoiModel poi = modelEnviroment.getAllCaller().getBaseCaller().fetchPoiByNumber(poiNumber);
        if (poi == null) {
            poi = new PoiModelImpl();
            poi.setInformation("");
            poi.setName(poiNumber);
            poi.setPoiNumber(poiNumber);
            poi.setPoiType(PoiType.AREAOBJECT_LOCATION);
        }
        LocationModel location = poi.getLocation();
        ImmutablePoint coord = null;
        if (location == null) {
            location = new LocationModelImpl();
            poi.setLocation(location);
        } else {
            ImportedLocationModel importedLocation = location.getImportedLocation();
            if (importedLocation != null) {
                coord = importedLocation.getGeoLocation();
            }
        }
        location.setParcel(null);
        location.setExternalLocation(null);
        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(x, y));
        if (!GeoUtil.areSamedPoints(coord, newPoint, (Double)1.0)) {
            location.setFootSegment(null);
            location.setMotorSegment(null);
            ImportedLocationModelImpl importedLocationModel = new ImportedLocationModelImpl();
            importedLocationModel.setCity(shortcut);
            importedLocationModel.setDistrict(shortcut);
            importedLocationModel.setHousenumber(1);
            importedLocationModel.setHousenumberExtension("");
            importedLocationModel.setStreet(shortcut);
            importedLocationModel.setPostcode(shortcut);
            importedLocationModel.setCountry(Country.GERMANY);
            importedLocationModel.setInformation("");
            importedLocationModel.setGeoLocation(newPoint);
            location.setImportedLocation(importedLocationModel);
        }
        areaObject.setPoi(poi);
        undoManager.finishTransaction("");
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            throw new RuntimeException(e);
        }
    }

    private Double readDouble(InputStream inputStream) throws IOException {
        int l = inputStream.read();
        if (l == 0) {
            return null;
        }
        byte[] b = new byte[l];
        inputStream.read(b);
        return Double.valueOf(new String(b));
    }

    private void showSelect(final Socket socket, char op) throws IOException {
        InputStream inputStream = socket.getInputStream();
        char c = Character.toUpperCase((char)inputStream.read());
        String country = this.readString(inputStream);
        String postcode = this.readString(inputStream);
        String city = this.readString(inputStream);
        String district = this.readString(inputStream);
        String street = this.readString(inputStream);
        String housenumber = this.readString(inputStream);
        String extension = this.readString(inputStream);
        int radius = 0;
        if (op == 'R') {
            String radiusString = ModelEnviroment.getProperties().getProperty("frey.location.radius");
            try {
                radius = Integer.parseInt(radiusString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LogisticLocationDto<Object> logisticLocationDto = new LogisticLocationDto<Object>(null, null, null, CountryUtil.searchCountryFuzzy(country), postcode, city, district, street, housenumber, extension);
        Long layerId = this.getLayerId('S', Character.valueOf(c));
        FreyLocalisationInternalFrame baseLayerEditorPanelFrame = (FreyLocalisationInternalFrame)this.getBaseLayerEditorPanel("frey_localisation", layerId);
        boolean licOk = true;
        if (baseLayerEditorPanelFrame == null) {
            ModelEnviroment modelEnviroment = new ModelEnviroment(this.pepperGisDesktopApplication);
            try {
                modelEnviroment.getAllCaller().getUserCaller().loginModule(LicenseType.AREA);
                baseLayerEditorPanelFrame = new FreyLocalisationInternalFrame(this.pepperGisDesktopApplication, layerId);
                this.pepperGisDesktopApplication.addWindow(this.createBaseLayerId("frey_localisation", layerId), baseLayerEditorPanelFrame);
                try {
                    baseLayerEditorPanelFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            catch (InsufficiantLicenseException e1) {
                JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage("messages.license.insufficentLicense.area", Integer.valueOf(e1.getMaxLicenseCount())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                licOk = false;
            }
            modelEnviroment.close();
        } else {
            try {
                baseLayerEditorPanelFrame.setIcon(false);
            }
            catch (PropertyVetoException modelEnviroment) {
                // empty catch block
            }
            this.pepperGisDesktopApplication.getDesktop().setSelectedFrame(baseLayerEditorPanelFrame);
            baseLayerEditorPanelFrame.toFront();
            baseLayerEditorPanelFrame.setVisible(true);
            try {
                baseLayerEditorPanelFrame.setMaximum(true);
            }
            catch (PropertyVetoException modelEnviroment) {
                // empty catch block
            }
        }
        if (licOk) {
            FreySelectBaseLayerEditorPanel freySelectBaseLayerEditorPanel = baseLayerEditorPanelFrame.getFreySelectBaseLayerEditorPanel();
            freySelectBaseLayerEditorPanel.setFreyHandler(this.pepperGisDesktopApplication.getFreyHandler());
            CallBack<Object, CoordinateAndAreasDto> callBack = new CallBack<Object, CoordinateAndAreasDto>(){

                public Object execute(CoordinateAndAreasDto ... coordinateAndAreasDtos) {
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        CoordinateAndAreasDto coordinateAndAreasDto = coordinateAndAreasDtos[0];
                        Double x = coordinateAndAreasDto.getX();
                        String xString = FreyRequestHandlingThread.this.createDoubleString(x);
                        outputStream.write(xString.length());
                        outputStream.write(xString.getBytes("UTF-8"));
                        Double y = coordinateAndAreasDto.getY();
                        String yString = FreyRequestHandlingThread.this.createDoubleString(y);
                        outputStream.write(yString.length());
                        outputStream.write(yString.getBytes("UTF-8"));
                        String[] strings = coordinateAndAreasDto.getAreaKeys();
                        int length = strings.length;
                        outputStream.write(length % 256);
                        outputStream.write((length /= 256) % 256);
                        outputStream.write((length /= 256) % 256);
                        outputStream.write((length /= 256) % 256);
                        for (String string : strings) {
                            byte[] bytes = string.getBytes("UTF-8");
                            length = bytes.length;
                            outputStream.write(length % 256);
                            outputStream.write(length / 256 % 256);
                            outputStream.write(bytes);
                            outputStream.flush();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            freySelectBaseLayerEditorPanel.getBaseLayerEditorPanel().getFreyHandler().setSaturdaySelectCallBack(callBack);
            freySelectBaseLayerEditorPanel.getBaseLayerEditorPanel().getFreyHandler().setWednesdaySelectCallBack(callBack);
            freySelectBaseLayerEditorPanel.findAreaByAddress(logisticLocationDto, true, radius);
            try {
                baseLayerEditorPanelFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void showProposal(final Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        int areaCount = inputStream.read();
        areaCount += inputStream.read() * 256;
        areaCount += inputStream.read() * 256 * 256;
        ArrayList<String> areaKeys = new ArrayList<String>(areaCount += inputStream.read() * 256 * 256 * 256);
        for (int i = 0; i < areaCount; ++i) {
            int keyCount = inputStream.read();
            byte[] b = new byte[keyCount += inputStream.read() * 256];
            inputStream.read(b);
            String key = new String(b, "UTF-8");
            areaKeys.add(key);
            System.out.println(key);
        }
        Long layerId = this.getLayerId('P', null);
        BaseLayerEditorInternalFrame baseLayerEditorPanelFrame = (BaseLayerEditorInternalFrame)this.getBaseLayerEditorPanel("baselayer", layerId);
        boolean licOk = true;
        Long[] sourceIds = null;
        if (baseLayerEditorPanelFrame == null) {
            String prop = ModelEnviroment.getProperties().getProperty("postcodeAreaLayer");
            Long postcodeId = null;
            try {
                postcodeId = Long.valueOf(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sourceIds = postcodeId == null ? new Long[]{this.getLayerId('D', Character.valueOf('W')), this.getLayerId('D', Character.valueOf('S'))} : new Long[]{this.getLayerId('D', Character.valueOf('W')), this.getLayerId('D', Character.valueOf('S')), postcodeId};
            ModelEnviroment modelEnviroment = new ModelEnviroment(this.pepperGisDesktopApplication);
            try {
                modelEnviroment.getAllCaller().getUserCaller().loginModule(LicenseType.AREA);
                baseLayerEditorPanelFrame = new BaseLayerEditorInternalFrame(this.pepperGisDesktopApplication, layerId, null, false, false, null, sourceIds);
                this.pepperGisDesktopApplication.addWindow(this.createBaseLayerId("baselayer", layerId), baseLayerEditorPanelFrame);
            }
            catch (InsufficiantLicenseException e1) {
                JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage("messages.license.insufficentLicense.area", Integer.valueOf(e1.getMaxLicenseCount())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                licOk = false;
            }
            modelEnviroment.close();
        }
        if (licOk) {
            final BaseLayerEditorPanel baseLayerEditorPanel = (BaseLayerEditorPanel)baseLayerEditorPanelFrame.getEditorPanel();
            baseLayerEditorPanel.setFreyHandler(this.pepperGisDesktopApplication.getFreyHandler());
            ModelEnviroment modelEnviroment = baseLayerEditorPanel.getModelEnviroment();
            Collection<AreaObjectModel> areaObjectModels = modelEnviroment.getAllCaller().getAreaCaller().getAreaObjectByKeysAndLayerIds(areaKeys, Arrays.asList(sourceIds));
            baseLayerEditorPanel.setMarkedObjects(areaObjectModels);
            this.createProposalAreaObject(baseLayerEditorPanel, "Auftragsgebiet");
            baseLayerEditorPanel.getAddMarkSetAction().actionPerformed(null);
            Set<AreaObjectModel> emptySet = Collections.emptySet();
            baseLayerEditorPanel.select((Collection<AreaObjectModel>)emptySet);
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.rollbackTransaction();
            baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel().clear();
            while (undoManager.isTransactionOpen()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            undoManager.startTransaction();
            AreaObjectModelImpl areaObject = new AreaObjectModelImpl();
            areaObject.setAreaLayer(baseLayerEditorPanel.getCurrentAreaLayer());
            String key = "Auftragsgebiet";
            areaObject.setDisplayname(key);
            areaObject.setShortcut(key);
            baseLayerEditorPanel.select((Collection<AreaObjectModel>)Collections.singleton(areaObject));
            baseLayerEditorPanel.replaceWithMarkSet(true);
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.created", new Serializable[]{key, key}));
            ((DefaultGeoObjectBucketsModel)baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel()).addGeom(areaObject);
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        baseLayerEditorPanel.getCenterSelectedAreaObjectsAction().actionPerformed(null);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
            this.pepperGisDesktopApplication.getFreyHandler().setProposalCallBack(new CallBack<Object, CoordinateAndAreasDto>(){

                public Object execute(CoordinateAndAreasDto ... coordinateAndAreasDtos) {
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        CoordinateAndAreasDto coordinateAndAreasDto = coordinateAndAreasDtos[0];
                        Double x = coordinateAndAreasDto.getX();
                        String xString = FreyRequestHandlingThread.this.createDoubleString(x);
                        outputStream.write(xString.length());
                        outputStream.write(xString.getBytes("UTF-8"));
                        Double y = coordinateAndAreasDto.getY();
                        String yString = FreyRequestHandlingThread.this.createDoubleString(x);
                        outputStream.write(yString.length());
                        outputStream.write(yString.getBytes("UTF-8"));
                        String[] strings = coordinateAndAreasDto.getAreaKeys();
                        int length = strings.length;
                        System.out.println(length + " keys to send");
                        outputStream.write(length % 256);
                        outputStream.write((length /= 256) % 256);
                        outputStream.write((length /= 256) % 256);
                        outputStream.write((length /= 256) % 256);
                        for (String string : strings) {
                            System.out.println(string);
                            byte[] bytes = string.getBytes("UTF-8");
                            length = bytes.length;
                            outputStream.write(length % 256);
                            outputStream.write(length / 256 % 256);
                            outputStream.write(bytes);
                        }
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            this.toFront(baseLayerEditorPanelFrame);
        }
    }

    private String createDoubleString(Double d) {
        Long lx;
        if (d == null) {
            d = 0.0;
        }
        if ((double)(lx = Long.valueOf(Math.round(d = Double.valueOf(d * 1000000.0)))).longValue() == 0.0) {
            return "0";
        }
        String xString = lx.toString();
        xString = xString.substring(0, xString.length() - 6) + "." + xString.substring(xString.length() - 6, xString.length());
        return xString;
    }

    private void createProposalAreaObject(BaseLayerEditorPanel baseLayerEditorPanel, String key) {
        Set<AreaObjectModel> emptySet = Collections.emptySet();
        baseLayerEditorPanel.select((Collection<AreaObjectModel>)emptySet);
        ModelEnviroment modelEnviroment = baseLayerEditorPanel.getModelEnviroment();
        UndoManager undoManager = modelEnviroment.getUndoManager();
        undoManager.rollbackTransaction();
        System.out.println("rollback");
        baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel().clear();
        while (undoManager.isTransactionOpen()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        undoManager.startTransaction();
        AreaObjectModelImpl areaObject = new AreaObjectModelImpl();
        areaObject.setAreaLayer(baseLayerEditorPanel.getCurrentAreaLayer());
        areaObject.setDisplayname(key);
        areaObject.setShortcut(key);
        baseLayerEditorPanel.select((Collection<AreaObjectModel>)Collections.singleton(areaObject));
        baseLayerEditorPanel.replaceWithMarkSet(true);
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.created", new Serializable[]{key, key}));
        ((DefaultGeoObjectBucketsModel)baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel()).addGeom(areaObject);
    }

    private void showDelivery(Socket socket) throws IOException {
        InputStream in = socket.getInputStream();
        char c = Character.toUpperCase((char)in.read());
        int areaCount = in.read();
        areaCount += in.read() * 256;
        areaCount += in.read() * 256 * 256;
        ArrayList<String> areaKeys = new ArrayList<String>(areaCount += in.read() * 256 * 256 * 256);
        for (int i = 0; i < areaCount; ++i) {
            int keyCount = in.read();
            byte[] b = new byte[keyCount += in.read() * 256];
            in.read(b);
            areaKeys.add(new String(b, "UTF-8"));
        }
        Long layerId = this.getLayerId('D', Character.valueOf(c));
        BaseLayerEditorInternalFrame baseLayerEditorPanelFrame = (BaseLayerEditorInternalFrame)this.getBaseLayerEditorPanel("baselayer", layerId);
        boolean licOk = true;
        if (baseLayerEditorPanelFrame == null) {
            ModelEnviroment modelEnviroment = new ModelEnviroment(this.pepperGisDesktopApplication);
            try {
                modelEnviroment.getAllCaller().getUserCaller().loginModule(LicenseType.AREA);
                baseLayerEditorPanelFrame = new BaseLayerEditorInternalFrame(this.pepperGisDesktopApplication, layerId, null, false, false, null, new Long[0]);
                this.pepperGisDesktopApplication.addWindow(this.createBaseLayerId("baselayer", layerId), baseLayerEditorPanelFrame);
            }
            catch (InsufficiantLicenseException e1) {
                JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage("messages.license.insufficentLicense.area", Integer.valueOf(e1.getMaxLicenseCount())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                licOk = false;
            }
            modelEnviroment.close();
        }
        if (licOk) {
            BaseLayerEditorPanel baseLayerEditorPanel = (BaseLayerEditorPanel)baseLayerEditorPanelFrame.getEditorPanel();
            baseLayerEditorPanel.setFreyHandler(this.pepperGisDesktopApplication.getFreyHandler());
            if (!areaKeys.isEmpty()) {
                this.selectAndCenterArea(areaKeys, baseLayerEditorPanel);
            }
            this.toFront(baseLayerEditorPanelFrame);
        }
    }

    private void toFront(AbstractPepperGisInternalFrame baseLayerEditorPanelFrame) {
        this.pepperGisDesktopApplication.putToFront(baseLayerEditorPanelFrame);
    }

    private AbstractPepperGisInternalFrame getBaseLayerEditorPanel(String prefix, Long layerId) throws IOException {
        Map map = this.pepperGisDesktopApplication.getAllWindows();
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        String windowPrefix = prefix + "_" + layerId + "_";
        for (String key : keys) {
            if (!key.startsWith(windowPrefix)) continue;
            return (AbstractPepperGisInternalFrame)map.get(key);
        }
        return null;
    }

    private String createBaseLayerId(String prefix, Long layerId) {
        int counter = 0;
        String id = prefix + "_" + layerId + "_" + counter;
        while (this.pepperGisDesktopApplication.getWindow(id) != null) {
            id = prefix + "_" + layerId + "_" + ++counter;
        }
        return id;
    }

    private Collection<String> selectAndCenterArea(Collection<String> areaKeys, BaseLayerEditorPanel baseLayerEditorPanel) {
        Collection<AreaObjectModel> areaObjectModels = baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjects(baseLayerEditorPanel.getEditBaseLayer(), areaKeys);
        HashSet<String> keysFound = new HashSet<String>();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            keysFound.add(areaObjectModel.getShortcut());
        }
        baseLayerEditorPanel.select(areaObjectModels);
        baseLayerEditorPanel.getCenterSelectedAreaObjectsAction().actionPerformed(null);
        return keysFound;
    }

    private Long getLayerId(char type, Character day) {
        String property = "frey.";
        switch (type) {
            case 'D': 
            case 'S': {
                property = property + "delivery.";
                switch (day.charValue()) {
                    case 'W': {
                        property = property + "wednesday.id";
                        break;
                    }
                    case 'S': {
                        property = property + "saturday.id";
                    }
                }
                break;
            }
            case 'P': {
                property = property + "proposallayer.id";
            }
        }
        String lValue = ModelEnviroment.getProperties().getProperty(property);
        return Long.valueOf(lValue);
    }

    public void shutDown() throws IOException {
        this.serverSocket.close();
    }

    private String readString(InputStream inputStream) throws IOException {
        int countLow = inputStream.read();
        int countHigh = inputStream.read();
        countLow = 0 | countLow;
        countHigh = 256 * (0 | countHigh);
        byte[] b = new byte[countLow + countHigh];
        inputStream.read(b);
        return new String(b, "UTF-8");
    }
}

