/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.external.communication;

import de.datomino.peppergis.client.external.communication.ClientMessageHandler;
import de.datomino.peppergis.client.external.communication.UnknownMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.ktde.util.StringUtil;

public class ClientExternalRemoteService
extends Thread {
    private static ClientExternalRemoteService instance;
    private boolean keepRunning = true;
    private Integer port;
    private ServerSocket serverSocket;
    private List<ClientMessageHandler> clientMessageHandlers = new LinkedList<ClientMessageHandler>();

    public ClientExternalRemoteService(Properties properties) throws IOException {
        boolean run = StringUtil.isTrue(properties.getProperty("external.remoteservice.active"));
        if (run) {
            try {
                this.port = Integer.valueOf(properties.getProperty("external.remoteservice.port"));
            }
            catch (RuntimeException ex) {
                this.port = 60000;
            }
            this.serverSocket = new ServerSocket(this.port);
            this.start();
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                Socket socket = this.serverSocket.accept();
                InetAddress inetAdress = socket.getInetAddress();
                if (inetAdress.getHostAddress().startsWith("127.")) {
                    InputStream in = socket.getInputStream();
                    OutputStream out = socket.getOutputStream();
                    for (ClientMessageHandler clientMessageHandler : this.clientMessageHandlers) {
                        try {
                            clientMessageHandler.handleClientMessage(in, out);
                        }
                        catch (UnknownMessageException unknownMessageException) {}
                    }
                    out.flush();
                }
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addClientMessageHandler(ClientMessageHandler clientMessageHandler) {
        this.clientMessageHandlers.add(clientMessageHandler);
    }

    public void removeClientMessageHandler(ClientMessageHandler clientMessageHandler) {
        this.clientMessageHandlers.remove(clientMessageHandler);
    }

    public void close() throws IOException {
        this.keepRunning = false;
        this.serverSocket.close();
        instance = null;
    }

    public static ClientExternalRemoteService getInstance(Properties properties) throws IOException {
        if (instance == null) {
            instance = new ClientExternalRemoteService(properties);
        }
        return instance;
    }

    public static ClientExternalRemoteService getInstance() {
        return instance;
    }
}

