/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.export;

import de.datomino.peppergis.client.file.FileUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.util.message.Message;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractExportFileAction<T>
extends AbstractAction {
    private static final long serialVersionUID = 5692750046016642924L;
    private Window parent;
    private String fileExtension;

    public AbstractExportFileAction(String title, Window parent, String fileExtension) {
        super(title);
        this.parent = parent;
        this.fileExtension = fileExtension;
    }

    protected void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    protected Window getParent() {
        return this.parent;
    }

    protected abstract Tupel<Map<String, byte[]>, ErrorMessages> getContent(T var1) throws ClientExportException;

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            T t = this.createContext();
            if (this.checkConditions(t)) {
                try {
                    Tupel<Map<String, byte[]>, ErrorMessages> content = this.getContent(t);
                    if (content == null) break block7;
                    if (content.getElement2().hasErrors()) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(AbstractExportFileAction.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(this.parent, ModelEnviroment.getMessageResolver(), content.getElement2(), new Message("messages.default.error"), new Message("messages.default.ok"), image);
                        errorMessageDialog.setVisible(true);
                        break block7;
                    }
                    this.save(content);
                }
                catch (ClientExportException ex) {
                    JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), ex.getMessage(), 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), ex.getMessage(), 0);
                }
            }
        }
    }

    protected T createContext() {
        return null;
    }

    protected boolean checkConditions(T t) {
        return true;
    }

    protected File save(Tupel<Map<String, byte[]>, ErrorMessages> content) throws IOException {
        return FileUtil.saveFile(content.getElement1(), this.parent, this.fileExtension);
    }

    protected String getFileExtension() {
        return this.fileExtension;
    }
}

