/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.deliveryRound;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModelImpl;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.type.Product;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Holder;

public class DeliveryRoundPane
extends JPanel {
    private static final long serialVersionUID = 444597775902551267L;
    private Holder<DeliveryRoundModel> deliveryRound;
    private boolean editable;
    private JTextField name;
    private JTextArea infoArea;
    private Map<Product, JCheckBox> productMap = new HashMap<Product, JCheckBox>();

    public DeliveryRoundPane(DeliveryRoundModel deliveryRound, boolean editable) {
        super(new SpringLayout());
        this.deliveryRound = new Holder<DeliveryRoundModel>(deliveryRound);
        this.editable = editable;
        this.initialize();
        this.fillData();
    }

    private void initialize() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        this.name = ClientSwingUtil.createParameterTextField(10, null, this.editable, "Name", this.deliveryRound, this);
        this.add(this.name);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0])));
        this.infoArea = ClientSwingUtil.createParameterTextArea(5, 10, null, this.editable, "Information", this.deliveryRound, this);
        this.add(this.infoArea);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.products", new Serializable[0])));
        Box productBox = Box.createVerticalBox();
        for (final Product product : Product.values()) {
            final JCheckBox checkBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessageForEnum(product));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DeliveryRoundPane.this.getDeliveryRound() == null) {
                        return;
                    }
                    DeliveryProductModel found = null;
                    for (DeliveryProductModel model : DeliveryRoundPane.this.getDeliveryRound().iterableDeliveryProducts()) {
                        if (model.getProduct() != product) continue;
                        found = model;
                        break;
                    }
                    if (checkBox.isSelected() && found == null) {
                        DeliveryProductModelImpl newModel = new DeliveryProductModelImpl();
                        newModel.setProduct(product);
                        newModel.setDeliveryRound(DeliveryRoundPane.this.getDeliveryRound());
                    } else if (!checkBox.isSelected() && found != null) {
                        DeliveryRoundPane.this.getDeliveryRound().removeDeliveryProduct(found);
                    }
                }
            });
            checkBox.setEnabled(this.editable);
            productBox.add(checkBox);
            this.productMap.put(product, checkBox);
        }
        this.add(productBox);
        SpringUtilities.makeCompactGrid(this, 3, 2, 5, 5, 5, 5);
    }

    private void fillData() {
        DeliveryRoundModel deliveryRound = this.getDeliveryRound();
        if (deliveryRound == null) {
            this.name.setEnabled(false);
            this.infoArea.setEditable(false);
            for (JCheckBox checkBox : this.productMap.values()) {
                checkBox.setEnabled(false);
            }
        } else {
            this.name.setEnabled(this.editable);
            this.infoArea.setEditable(this.editable);
            for (JCheckBox checkBox : this.productMap.values()) {
                checkBox.setEnabled(this.editable);
            }
            for (Product product : this.productMap.keySet()) {
                boolean b = false;
                for (DeliveryProductModel model : deliveryRound.iterableDeliveryProducts()) {
                    if (model.getProduct() != product) continue;
                    b = true;
                    break;
                }
                this.productMap.get((Object)product).setSelected(b);
            }
        }
        this.repaint(10L);
    }

    public DeliveryRoundModel getDeliveryRound() {
        return this.deliveryRound.getElement();
    }

    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.deliveryRound.setElement(deliveryRound);
        this.fillData();
    }

    @Override
    public void repaint(long tm) {
        for (Component c : this.getComponents()) {
            c.repaint(tm);
        }
        super.repaint(tm);
    }
}

