/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.deliveryRound;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.deliveryRound.DeliveryRoundPane;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.common.FilteredListSelectorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundReplacementModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundReplacementModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.WeekDay;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.plaf.basic.BasicArrowButton;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;

public class AreaDeliveryRoundDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = 2576033337420398345L;
    private List<AreaDeliveryRoundModel> areaDeliveryRounds;
    private int currentIndex = 0;
    private boolean editable;
    private Map<AreaDeliveryRoundModel, List<Tupel<AreaDeliveryRoundReplacementModel, JPanel>>> replacementMap = new HashMap<AreaDeliveryRoundModel, List<Tupel<AreaDeliveryRoundReplacementModel, JPanel>>>();
    private Box replacementBox;

    public AreaDeliveryRoundDialog(List<AreaDeliveryRoundModel> areaDeliveryRounds, boolean editable, ModelEnviroment modelEnviroment, Window parent) {
        super(modelEnviroment, parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.area", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.areaDeliveryRounds = areaDeliveryRounds;
        for (AreaDeliveryRoundModel areaDeliveryRound : areaDeliveryRounds) {
            ArrayList<Tupel<AreaDeliveryRoundReplacementModel, Object>> replacementList = new ArrayList<Tupel<AreaDeliveryRoundReplacementModel, Object>>();
            this.replacementMap.put(areaDeliveryRound, replacementList);
            for (AreaDeliveryRoundReplacementModel replacement : areaDeliveryRound.iterableReplacements()) {
                if (replacement.getStartTime() == null || replacement.getEndTime() == null) {
                    replacement.delete();
                }
                replacementList.add(new Tupel<AreaDeliveryRoundReplacementModel, Object>(replacement, null));
            }
        }
        this.editable = editable;
    }

    @Override
    protected Component getMainComponent() {
        final AreaDeliveryRoundModel areaDeliveryRound = this.areaDeliveryRounds.get(this.currentIndex);
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getMonday(), WeekDay.MONDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getTuesday(), WeekDay.TUESDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getWednesday(), WeekDay.WEDNESDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getThursday(), WeekDay.THURSDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getFriday(), WeekDay.FRIDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getSaturday(), WeekDay.SATURDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday", new Serializable[0])));
        pane.add(this.createDeliveryRoundButton(areaDeliveryRound.getSunday(), WeekDay.SUNDAY));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.replacement", new Serializable[0])));
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        JButton remove = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -1185768197035957154L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List replacementList = (List)AreaDeliveryRoundDialog.this.replacementMap.get(areaDeliveryRound);
                if (!replacementList.isEmpty()) {
                    Tupel last = (Tupel)replacementList.remove(replacementList.size() - 1);
                    ((AreaDeliveryRoundReplacementModel)last.getElement1()).delete();
                }
                if (replacementList.isEmpty()) {
                    JButton button = (JButton)e.getSource();
                    button.setEnabled(false);
                }
                AreaDeliveryRoundDialog.this.fillData();
            }
        });
        remove.setText("-");
        JButton add = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -8478295816704359500L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaDeliveryRoundReplacementModelImpl replacement = new AreaDeliveryRoundReplacementModelImpl();
                Date now = new Date();
                replacement.setAreaDeliveryRound(areaDeliveryRound);
                replacement.setStartTime(TimeUtil.normalize(now));
                replacement.setEndTime(TimeUtil.getEndOfDay(now));
                List replacementList = (List)AreaDeliveryRoundDialog.this.replacementMap.get(areaDeliveryRound);
                replacementList.add(new Tupel<AreaDeliveryRoundReplacementModelImpl, Object>(replacement, null));
                if (!replacementList.isEmpty()) {
                    JButton button = (JButton)e.getSource();
                    button.setEnabled(true);
                }
                AreaDeliveryRoundDialog.this.fillData();
            }
        });
        add.setText("+");
        buttonPane.add(add);
        buttonPane.add(remove);
        this.replacementBox = Box.createVerticalBox();
        JScrollPane replacementScrollPane = new JScrollPane(this.replacementBox);
        replacementScrollPane.setPreferredSize(new Dimension(500, 300));
        JPanel replacementPane = new JPanel(new BorderLayout());
        replacementPane.add((Component)replacementScrollPane, "North");
        replacementPane.add((Component)buttonPane, "South");
        pane.add(replacementPane);
        SpringUtilities.makeCompactGrid(pane, 8, 2, 5, 5, 5, 5);
        if (this.areaDeliveryRounds.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
        return pane;
    }

    private Component createDeliveryRoundButton(DeliveryRoundRelationModel relation, WeekDay weekDay) {
        final DeliveryRoundModel deliveryRound = relation == null ? null : relation.getDeliveryRound();
        JButton button = new JButton(deliveryRound == null ? "" : deliveryRound.getName());
        button.setEnabled(deliveryRound != null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (deliveryRound != null) {
                    DeliveryRoundPane pane = new DeliveryRoundPane(deliveryRound, false);
                    JScrollPane scrollPane = new JScrollPane(pane);
                    JOptionPane.showMessageDialog(AreaDeliveryRoundDialog.this, scrollPane);
                }
            }
        });
        return button;
    }

    @Override
    protected void fillData() {
        this.sortReplacements();
        this.replacementBox.removeAll();
        Date currentDay = TimeUtil.getCurrentDay();
        Collection<DeliveryRoundModel> allDeliveryRounds = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllDeliveryRounds();
        List<Tupel<AreaDeliveryRoundReplacementModel, JPanel>> replacementList = this.replacementMap.get(this.areaDeliveryRounds.get(this.currentIndex));
        for (Tupel<AreaDeliveryRoundReplacementModel, JPanel> tupel : replacementList) {
            final AreaDeliveryRoundReplacementModel replacement = tupel.getElement1();
            Holder<AreaDeliveryRoundReplacementModel> holder = new Holder<AreaDeliveryRoundReplacementModel>(replacement);
            JPanel replacementPane = tupel.getElement2();
            if (replacementPane == null) {
                replacementPane = new JPanel(new FlowLayout(0));
                JTextField start = ClientSwingUtil.createParameterTextField(10, null, this.editable, "StartTime", holder, this, FormUtil.DATEFORMAT);
                replacementPane.add(start);
                JTextField end = ClientSwingUtil.createParameterTextField(10, null, this.editable, "EndTime", holder, this, FormUtil.DATEFORMAT);
                replacementPane.add(end);
                final AbstractModelComboBox<DeliveryRoundModel> roundComboBox = new AbstractModelComboBox<DeliveryRoundModel>(allDeliveryRounds, false){
                    private static final long serialVersionUID = 8907348935850761381L;

                    @Override
                    protected String getStringRepresentation(DeliveryRoundModel t) {
                        return t.getName();
                    }
                };
                roundComboBox.setSelectedItem(replacement.getDeliveryRound());
                roundComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        replacement.setDeliveryRound((DeliveryRoundModel)roundComboBox.getSelectedItem());
                    }
                });
                replacementPane.add(roundComboBox);
                replacementPane.setMinimumSize(new Dimension(10, 30));
                replacementPane.setMaximumSize(new Dimension(10000, 30));
                if (replacement.getEndTime().before(currentDay)) {
                    start.setEnabled(false);
                    end.setEditable(false);
                    roundComboBox.setEnabled(false);
                }
                tupel.setElement2(replacementPane);
            }
            this.replacementBox.add(replacementPane);
        }
        this.replacementBox.validate();
        super.repaint(10L);
    }

    private void sortReplacements() {
        List<Tupel<AreaDeliveryRoundReplacementModel, JPanel>> replacementList = this.replacementMap.get(this.areaDeliveryRounds.get(this.currentIndex));
        Collections.sort(replacementList, new Comparator<Tupel<AreaDeliveryRoundReplacementModel, JPanel>>(){

            @Override
            public int compare(Tupel<AreaDeliveryRoundReplacementModel, JPanel> o1, Tupel<AreaDeliveryRoundReplacementModel, JPanel> o2) {
                Date d1 = o1.getElement1().getStartTime();
                Date d2 = o2.getElement1().getStartTime();
                return d1.compareTo(d2);
            }
        });
    }

    @Override
    protected boolean close() {
        this.sortReplacements();
        Date currentDay = TimeUtil.getCurrentDay();
        String errorKey = null;
        AreaDeliveryRoundReplacementModel pred = null;
        AreaDeliveryRoundModel areaDeliveryRound = this.areaDeliveryRounds.get(this.currentIndex);
        List<Tupel<AreaDeliveryRoundReplacementModel, JPanel>> replacementList = this.replacementMap.get(areaDeliveryRound);
        for (Tupel<AreaDeliveryRoundReplacementModel, JPanel> tupel : replacementList) {
            Date predEnd;
            Date predStart;
            AreaDeliveryRoundReplacementModel succ = tupel.getElement1();
            Date succStart = TimeUtil.normalize(succ.getStartTime());
            Date succEnd = TimeUtil.getEndOfDay(succ.getEndTime());
            final DeliveryRoundModel succRound = succ.getDeliveryRound();
            if (succRound == null || !succStart.before(succEnd)) {
                errorKey = "gui.deliveryRound.replacement.error.time";
                break;
            }
            if (pred != null && TimeUtil.covers(new Tupel<Date, Date>(predStart = TimeUtil.normalize(pred.getStartTime()), predEnd = TimeUtil.getEndOfDay(pred.getEndTime())), new Tupel<Date, Date>(succStart, succEnd))) {
                errorKey = "gui.deliveryRound.replacement.error.time";
                break;
            }
            final HashSet<WeekDay> weekDaySet = new HashSet<WeekDay>();
            Date date = succStart;
            while (date.before(succEnd)) {
                weekDaySet.add(WeekDay.valueOf(TimeUtil.getDayOfWeek(date)));
            }
            if (this.isSamedDeliveryRound(succRound, weekDaySet, areaDeliveryRound)) {
                errorKey = "gui.deliveryRound.replacement.error.tooMoreRound";
            }
            if (errorKey == null && !succ.getEndTime().before(currentDay)) {
                boolean isLetter = true;
                for (DeliveryProductModel product : succRound.iterableDeliveryProducts()) {
                    if (product.getProduct() == Product.LETTER) continue;
                    isLetter = false;
                    break;
                }
                if (isLetter) {
                    final FilteredListSelectorPane<AreaObjectModel> selectorPane = new FilteredListSelectorPane<AreaObjectModel>(0){
                        private static final long serialVersionUID = -4026111073939052141L;

                        @Override
                        protected String getString(AreaObjectModel t) {
                            return StringUtil.getNotNull(t == null ? null : t.getShortcut());
                        }
                    };
                    AreaObjectGenInfoDiscriminator[] ds = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND};
                    final AreaLayerComboBox layerComboBox = new AreaLayerComboBox(this.modelEnviroment, false, ds, false, false);
                    layerComboBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                AreaCaller areaCaller = AreaDeliveryRoundDialog.this.modelEnviroment.getAllCaller().getAreaCaller();
                                List<AreaObjectModel> areaObjects = areaCaller.fetchAreaObjectsByAreaLayer(layerComboBox.getLayer(), true);
                                ArrayList<AreaObjectModel> filtered = new ArrayList<AreaObjectModel>();
                                block0: for (AreaObjectModel areaObject : areaObjects) {
                                    for (AreaDeliveryRoundModel otherAreaRound : areaObject.iterableAreaDeliveryRounds()) {
                                        boolean allowed;
                                        if (otherAreaRound == null || !(allowed = AreaDeliveryRoundDialog.this.isSamedDeliveryRound(succRound, weekDaySet, otherAreaRound))) continue;
                                        filtered.add(areaObject);
                                        continue block0;
                                    }
                                }
                                selectorPane.setValues(filtered);
                            }
                        }
                    });
                    JPanel inputPanel = new JPanel(new SpringLayout());
                    inputPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
                    inputPanel.add(layerComboBox);
                    inputPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0])));
                    inputPanel.add(selectorPane);
                    int d = JOptionPane.showConfirmDialog(this, inputPanel, ModelEnviroment.getMessageResolver().resolveMessage("gui.input.select.area", new Serializable[0]), 1);
                    switch (d) {
                        case 0: {
                            List selectedValues = selectorPane.getSelectedValues(false);
                            this.changeAreaObjectOfLetters(succ, (AreaObjectModel)selectedValues.iterator().next());
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            errorKey = "";
                        }
                    }
                }
            }
            pred = succ;
        }
        if (errorKey == null) {
            return true;
        }
        if (errorKey.length() == 0) {
            return false;
        }
        JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage(errorKey, new Serializable[0]), "", 0);
        return false;
    }

    private void changeAreaObjectOfLetters(AreaDeliveryRoundReplacementModel replacement, AreaObjectModel newAreaObject) {
        replacement.setReplacementAreaObject(newAreaObject);
        AreaObjectModel oldAreaObject = replacement.getAreaDeliveryRound().getAreaObject();
        Date start = TimeUtil.normalize(replacement.getStartTime());
        Date end = TimeUtil.getEndOfDay(replacement.getEndTime());
        for (LetterModel letter : oldAreaObject.iterableLetters()) {
            if (!TimeUtil.isBetween(letter.getDate(), start, end)) continue;
            letter.setAreaLayer(newAreaObject.getAreaLayer());
            letter.setAreaObject(newAreaObject);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSamedDeliveryRound(DeliveryRoundModel deliveryRound, Set<WeekDay> weekDaySet, AreaDeliveryRoundModel areaDeliveryRound) {
        boolean allowed = true;
        Iterator<WeekDay> iterator = weekDaySet.iterator();
        while (iterator.hasNext()) {
            WeekDay weekDay = iterator.next();
            switch (weekDay) {
                case MONDAY: {
                    if (areaDeliveryRound.getMonday().equals(deliveryRound)) break;
                    return false;
                }
                case TUESDAY: {
                    if (areaDeliveryRound.getTuesday().equals(deliveryRound)) break;
                    return false;
                }
                case WEDNESDAY: {
                    if (areaDeliveryRound.getWednesday().equals(deliveryRound)) break;
                    return false;
                }
                case THURSDAY: {
                    if (areaDeliveryRound.getThursday().equals(deliveryRound)) break;
                    return false;
                }
                case FRIDAY: {
                    if (areaDeliveryRound.getFriday().equals(deliveryRound)) break;
                    return false;
                }
                case SATURDAY: {
                    if (areaDeliveryRound.getSaturday().equals(deliveryRound)) break;
                    return false;
                }
                case SUNDAY: {
                    if (areaDeliveryRound.getSunday().equals(deliveryRound)) break;
                    return false;
                }
            }
        }
        return allowed;
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -1185768197035957154L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaDeliveryRoundDialog.this.next(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.areaDeliveryRounds.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -2166465787519311732L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaDeliveryRoundDialog.this.next(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void next(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.areaDeliveryRounds.size() - 1;
        } else if (this.currentIndex > this.areaDeliveryRounds.size() - 1) {
            this.currentIndex = 0;
        }
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }

    public static void createAndShow(List<AreaDeliveryRoundModel> areaDeliveryRounds, ModelEnviroment modelEnviroment, Window parent) {
        AreaDeliveryRoundDialog dialog = new AreaDeliveryRoundDialog(areaDeliveryRounds, true, modelEnviroment, parent);
        dialog.setVisible(true);
    }
}

