/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.auth.SaltNonceDto;
import de.datomino.peppergis.exception.InsufficiantLicenseException;
import de.datomino.peppergis.exception.UserAlreadyLogedInException;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.type.ComponentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ktde.ee.rmi.AuthenticationException;
import org.ktde.ee.rmi.KickedAuthenticationException;
import org.ktde.model.ValueChangeListener;

public class UserCallerImpl
extends AbstractCaller
implements UserCaller {
    public UserCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public UserModel login(String login, String password) throws AuthenticationException, UserAlreadyLogedInException {
        UserDto userDto = this.getGeoServerStub().getUserBi().login(login, password);
        return (UserModel)this.getModelCache().getModel(userDto);
    }

    @Override
    public UserModel login(String login, String password, boolean overwriteSessionFlag) throws AuthenticationException, UserAlreadyLogedInException {
        UserDto userDto;
        try {
            userDto = this.getGeoServerStub().getUserBi().loginExtended(login, password, overwriteSessionFlag);
        }
        catch (IllegalStateException ex) {
            userDto = this.getGeoServerStub().getUserBi().loginExtended(login, password, overwriteSessionFlag);
        }
        return (UserModel)this.getModelCache().getModel(userDto);
    }

    @Override
    public void logout() throws KickedAuthenticationException {
        this.getGeoServerStub().getUserBi().logout();
    }

    @Override
    public SaltNonceDto requestLogin(String login) {
        return this.getGeoServerStub().getUserBi().requestLogin(login);
    }

    @Override
    public List<UserModel> getAllUsers() {
        List<UserDto> userDtos = this.getGeoServerStub().getUserBi().getAllUsers();
        ArrayList<UserModel> userModels = new ArrayList<UserModel>(userDtos.size());
        for (UserDto userDto : userDtos) {
            userModels.add((UserModel)this.getModelCache().getModel(userDto));
        }
        return userModels;
    }

    @Override
    public void loginModule(LicenseType licenseType) throws InsufficiantLicenseException {
        this.getGeoServerStub().getUserBi().loginModule(licenseType);
    }

    @Override
    public void refresh() throws UserAlreadyLogedInException, KickedAuthenticationException {
        this.getGeoServerStub().getUserBi().refresh();
    }

    @Override
    public void refreshModule(LicenseType licenseType) throws InsufficiantLicenseException {
        this.getGeoServerStub().getUserBi().refreshModule(licenseType);
    }

    @Override
    public void logoutModule(LicenseType licenseType) {
        this.getGeoServerStub().getUserBi().logoutModule(licenseType);
    }

    @Override
    public UserModel createAdminUserIfNotExists(String user) {
        return (UserModel)this.getModelCache().getModel(this.getGeoServerStub().getUserBi().createAdminUserIfNotExists(user));
    }

    @Override
    public boolean isComponentEnabled(ComponentType option) {
        return this.getGeoServerStub().getUserBi().isComponentEnabled(option);
    }

    @Override
    public void requestPrintLogin(String key) throws AuthenticationException {
        this.getGeoServerStub().getUserBi().requestPrintLogin(key);
    }

    @Override
    public void loginSuperUser(String login, String password) throws AuthenticationException {
        this.getGeoServerStub().getUserBi().loginSuperUser(login, password);
    }

    @Override
    public List<UserModel> fetchUsersByIds(Collection<Long> ids) {
        List<UserDto> dtos = this.getGeoServerStub().getUserBi().fetchUsersByIds(ids);
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }
}

