/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.LogisticServiceRouteDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.peppergis.bi.TourBi;
import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.communication.tour.TourRoutingContext;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.LogisticTourDtoUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.AreaObjectProxyDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.base.LetterProxyDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.PoiAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.base.PoiProxyDto;
import de.datomino.peppergis.dto.base.ServiceDto;
import de.datomino.peppergis.dto.base.ServiceProxyDto;
import de.datomino.peppergis.dto.base.ServiceValueDescriptorDto;
import de.datomino.peppergis.dto.base.StaticChoiceValueDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.base.SubscriptionProxyDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.dto.importer.DefaultExceptionResultDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.ParcelProxyDto;
import de.datomino.peppergis.dto.mobile.GeoTrackingDto;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaStopDto;
import de.datomino.peppergis.dto.tour.AreaTourDto;
import de.datomino.peppergis.dto.tour.AreaTourScheduleDto;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.dto.tour.ServiceValueDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.dto.tour.StopSearchDto;
import de.datomino.peppergis.dto.tour.StopSearchDtoImpl;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.dto.tour.TourSearchDto;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.exception.TourCalculationBlockException;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.ServiceStatusType;
import de.datomino.peppergis.type.StopStatus;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.peppergis.util.DefaultLogisticTourUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableEnvelopeDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.time.TimeUtil;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class TourCallerImpl
extends AbstractCaller
implements TourCaller {
    public TourCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public List<DelivererModel> fetchAllDeliverers() {
        List<DelivererDto> delivererDtos = this.getGeoServerStub().getTourBi().fetchAllDeliverers();
        ArrayList<DelivererModel> delivererModels = new ArrayList<DelivererModel>(delivererDtos.size());
        for (DelivererDto delivererDto : delivererDtos) {
            delivererModels.add((DelivererModel)this.getModelCache().getModel(delivererDto));
        }
        return delivererModels;
    }

    @Override
    public List<TourModel> fetchAllTours() {
        List<TourDto> tourDtos = this.getGeoServerStub().getTourBi().fetchAllTours();
        ArrayList<TourModel> tourModels = new ArrayList<TourModel>(tourDtos.size());
        for (TourDto tourDto : tourDtos) {
            tourModels.add((TourModel)this.getModelCache().getModel(tourDto));
        }
        return tourModels;
    }

    @Override
    public List<TourModel> fetchToursInTimeWindows(Collection<Tupel<Date, Date>> timeWindows, DelivererModel deliverer, boolean withService) {
        DelivererDto delivererDto = (DelivererDto)((Object)(deliverer == null ? null : deliverer.createProxy()));
        Collection<TourDto> tourDtos = this.getGeoServerStub().getTourBi().fetchToursInTimeWindows(timeWindows, delivererDto, withService);
        return this.convertDtosToModels(tourDtos, new ValueChangeListener[0]);
    }

    @Override
    public List<TourModel> fetchToursInTimeIntervals(Collection<Tupel<Date, Date>> timeIntervals, boolean withService) {
        Collection<TourDto> tourDtos = this.getGeoServerStub().getTourBi().fetchToursInTimeIntervals(timeIntervals, withService);
        return this.convertDtosToModels(tourDtos, new ValueChangeListener[0]);
    }

    public List<TourModel> fetchAllUnsortedTours() {
        List<TourDto> tourDtos = this.getGeoServerStub().getTourBi().fetchAllUnsortedTours();
        return this.convertDtosToModels(tourDtos, new ValueChangeListener[0]);
    }

    @Override
    public List<ServiceModel> fetchAllServices() {
        List<ServiceDto> serviceDtos = this.getGeoServerStub().getTourBi().fetchAllServices();
        ArrayList<ServiceModel> serviceModels = new ArrayList<ServiceModel>(serviceDtos.size());
        for (ServiceDto serviceDto : serviceDtos) {
            serviceModels.add((ServiceModel)this.getModelCache().getModel(serviceDto));
        }
        return serviceModels;
    }

    @Override
    public List<StopModel> fetchAllUnsortedStops() {
        List<StopDto> stopDtos = this.getGeoServerStub().getTourBi().fetchAllUnsortedStops();
        ArrayList<StopModel> stopModels = new ArrayList<StopModel>(stopDtos.size());
        for (StopDto stopDto : stopDtos) {
            stopModels.add((StopModel)this.getModelCache().getModel(stopDto));
        }
        return stopModels;
    }

    @Override
    public List<StopModel> fetchAllStopsWithPoi() {
        List<StopDto> stopDtos = this.getGeoServerStub().getTourBi().fetchAllStopsWithPoi();
        ArrayList<StopModel> stopModels = new ArrayList<StopModel>(stopDtos.size());
        for (StopDto stopDto : stopDtos) {
            StopModel stop = (StopModel)this.getModelCache().getModel(stopDto);
            if (stop.getPoi().getPoiType() != PoiType.DELIVERER_LOCATION) continue;
            stopModels.add(stop);
        }
        return stopModels;
    }

    @Override
    public List<LocationModel> fetchAllLocations() {
        List<LocationDto> locationDtos = this.getGeoServerStub().getTourBi().fetchAllLocations();
        ArrayList<LocationModel> locationModels = new ArrayList<LocationModel>(locationDtos.size());
        for (LocationDto locationDto : locationDtos) {
            locationModels.add((LocationModel)this.getModelCache().getModel(locationDto));
        }
        return locationModels;
    }

    @Override
    public Collection<LocationModel> fetchLocationsWithSameAddress(LogisticLocationDto<Long> location) {
        Collection<LocationDto> locationDtos = this.getGeoServerStub().getTourBi().fetchLocationsWithSameAddress(location);
        HashSet<LocationModel> locationModels = new HashSet<LocationModel>(locationDtos.size());
        for (LocationDto locationDto : locationDtos) {
            locationModels.add((LocationModel)this.getModelCache().getModel(locationDto));
        }
        return locationModels;
    }

    @Override
    public List<PoiModel> fetchAllPois() {
        List<PoiDto> poiDtos = this.getGeoServerStub().getTourBi().fetchAllPois();
        ArrayList<PoiModel> poiModels = new ArrayList<PoiModel>(poiDtos.size());
        for (PoiDto poiDto : poiDtos) {
            poiModels.add((PoiModel)this.getModelCache().getModel(poiDto));
        }
        return poiModels;
    }

    @Override
    public List<StopModel> fetchStops(ImmutablePoint topLeft, ImmutablePoint bottomRight, boolean removeSameAddress) {
        List<StopDto> stopDtos = this.getGeoServerStub().getTourBi().fetchStops(ImmutablePointDto.create(topLeft), ImmutablePointDto.create(bottomRight), removeSameAddress);
        ArrayList<StopModel> stopModels = new ArrayList<StopModel>(stopDtos.size());
        for (StopDto stopDto : stopDtos) {
            stopModels.add((StopModel)this.getModelCache().getModel(stopDto));
        }
        return stopModels;
    }

    @Override
    public List<SubscriptionModel> fetchSubscriptions(ImmutablePoint topLeft, ImmutablePoint bottomRight) {
        List<SubscriptionDto> subscriptionDtos = this.getGeoServerStub().getTourBi().fetchSubscriptions(ImmutablePointDto.create(topLeft), ImmutablePointDto.create(bottomRight));
        ArrayList<SubscriptionModel> subscriptionModels = new ArrayList<SubscriptionModel>(subscriptionDtos.size());
        for (SubscriptionDto subscriptionDto : subscriptionDtos) {
            subscriptionModels.add((SubscriptionModel)this.getModelCache().getModel(subscriptionDto));
        }
        return subscriptionModels;
    }

    @Override
    public List<SubscriptionModel> fetchSubscriptionsByAreaObject(AreaObjectModel areaObject, SubscriptionParameter parameter) {
        List<SubscriptionDto> subscriptionDtos = this.getGeoServerStub().getTourBi().fetchSubscriptionsByAreaObject(((AreaObjectModelImpl)areaObject).createProxy(), parameter);
        ArrayList<SubscriptionModel> subscriptionModels = new ArrayList<SubscriptionModel>(subscriptionDtos.size());
        for (SubscriptionDto subscriptionDto : subscriptionDtos) {
            subscriptionModels.add((SubscriptionModel)this.getModelCache().getModel(subscriptionDto));
        }
        Collections.sort(subscriptionModels, new StreetNameComparator());
        return subscriptionModels;
    }

    @Override
    public List<ParcelModel> fetchParcels(ImmutablePoint topLeft, ImmutablePoint bottomRight, boolean withRel) {
        Collection<? extends ParcelDto> parcelDtos = this.getGeoServerStub().getStreetNetBi().fetchParcels(ImmutablePointDto.create(topLeft), ImmutablePointDto.create(bottomRight), withRel);
        ArrayList<ParcelModel> parcelModels = new ArrayList<ParcelModel>(parcelDtos.size());
        for (ParcelDto parcelDto : parcelDtos) {
            parcelModels.add((ParcelModel)this.getModelCache().getModel(parcelDto));
        }
        return parcelModels;
    }

    @Override
    public List<ParcelModel> fetchParcelsByAreaObject(AreaObjectModel areaObject, boolean withRel) {
        Collection<? extends ParcelDto> parcelDtos = this.getGeoServerStub().getStreetNetBi().fetchParcelsByAreaObject(((AreaObjectModelImpl)areaObject).createProxy(), withRel);
        ArrayList<ParcelModel> parcelModels = new ArrayList<ParcelModel>(parcelDtos.size());
        for (ParcelDto parcelDto : parcelDtos) {
            parcelModels.add((ParcelModel)this.getModelCache().getModel(parcelDto));
        }
        Collections.sort(parcelModels, new StreetNameComparator());
        return parcelModels;
    }

    @Override
    @Deprecated
    public void validateLocation(LocationModel locationModel) throws LogisticException {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(locationModel);
        LogisticLocationDto<PointEntityId> logisticLocationDto = LogisticTourDtoUtil.createLogisticLocationDto(locationWrapper, new PointEntityId(locationModel.getId(), null), null);
        LogisticQualifiedLocationDto resultLocationDto = this.getGeoServerStub().getTourBi().validateLocation(logisticLocationDto);
        this.adaptResultLocationDto(locationWrapper, resultLocationDto);
    }

    @Override
    public void calculateTour(TourModel tour, RouteVehicleType routeVehicleType, RouteType routeType, boolean saved, ModelEnviroment modelEnviroment, OptimizationAlgorithmType algorithmType, boolean ignoreBadTimeWindow, TourRoutingContext tourRoutingContext) throws LogisticException {
        if (routeVehicleType == null) {
            routeVehicleType = RouteVehicleType.MOTORCAR;
        }
        if (routeType == null) {
            routeType = RouteType.FASTEST;
        }
        GeoClientHelper geomHelper = new GeoClientHelper(modelEnviroment);
        Map<TourPartModel, Collection<StopModel>> exceptionMap = geomHelper.checkStopModels(tour, routeVehicleType, routeType, algorithmType, ignoreBadTimeWindow);
        this.calculateTourWithoutException(tour, routeVehicleType, routeType, saved ? StopModelUtil.StopTimeTyp.ESTIMATED : null, exceptionMap, modelEnviroment, tourRoutingContext);
    }

    @Override
    public void calculateTourOnlyServiceFinished(TourModel tour, RouteVehicleType routeVehicleType, RouteType routeType, ModelEnviroment modelEnviroment, OptimizationAlgorithmType algorithmType, TourRoutingContext tourRoutingContext) throws LogisticException {
        if (routeVehicleType == null) {
            routeVehicleType = RouteVehicleType.MOTORCAR;
        }
        if (routeType == null) {
            routeType = RouteType.FASTEST;
        }
        GeoClientHelper geomHelper = new GeoClientHelper(modelEnviroment);
        Map<TourPartModel, Collection<StopModel>> statusExceptionMap = geomHelper.checkStopModels(tour, routeVehicleType, routeType, algorithmType, true);
        Set<ServiceStatusType> typeSet = CollectionUtil.buildHashSet(ServiceStatusType.NOT_DONE, ServiceStatusType.PARTIALLY_DONE, null);
        Map<TourPartModel, Collection<StopModel>> exceptionMap = TourModelUtil.getStopsWithServiceStatus(tour, typeSet);
        for (TourPartModel tourPart : exceptionMap.keySet()) {
            Collection<StopModel> value = exceptionMap.get(tourPart);
            value.addAll(statusExceptionMap.get(tourPart));
        }
        this.calculateTourWithoutException(tour, routeVehicleType, routeType, StopModelUtil.StopTimeTyp.ACTUAL, exceptionMap, modelEnviroment, tourRoutingContext);
    }

    private void calculateTourWithoutException(TourModel tour, RouteVehicleType routeVehicleType, RouteType routeType, StopModelUtil.StopTimeTyp timeType, Map<TourPartModel, Collection<StopModel>> exceptionMap, ModelEnviroment modelEnviroment, TourRoutingContext tourRoutingContext) throws LogisticException {
        for (int i = 0; i < tour.countTourParts(); ++i) {
            TourPartModel lastTourPart = i == 0 ? null : tour.getTourPartAt(i - 1);
            TourPartModel nextTourPart = i >= tour.countTourParts() - 1 ? null : tour.getTourPartAt(i + 1);
            TourPartModel currentTourPart = tour.getTourPartAt(i);
            if (currentTourPart.isStopsEmpty()) continue;
            if (currentTourPart.getRouteVehicleType() == null || !currentTourPart.getRouteVehicleType().equals((Object)routeVehicleType)) {
                currentTourPart.setRouteVehicleType(routeVehicleType);
                currentTourPart.setRouteType(routeType);
            }
            boolean linkPred = currentTourPart.getTourPartType() == null ? false : currentTourPart.getTourPartType().isLinkPred();
            boolean linkNext = currentTourPart.getTourPartType() == null ? false : currentTourPart.getTourPartType().isLinkNext();
            StopModel startPointOfTourPart = lastTourPart == null || !linkPred ? null : lastTourPart.getStopAt(lastTourPart.countStops() - 1);
            StopModel endPointOfTourPart = nextTourPart == null || !linkNext ? null : nextTourPart.getStopAt(0);
            LogisticTourDto<PointEntityId> logisticTourDto = LogisticTourDtoUtil.createLogisticTourDto(currentTourPart, exceptionMap.get(currentTourPart), startPointOfTourPart, endPointOfTourPart, modelEnviroment);
            Date startTime = null;
            StopModel stop1 = currentTourPart.getStopAt(0);
            if (i == 0) {
                startTime = tour.getPlannedStartTime();
                if (startTime == null) {
                    if (stop1.getPoi() != null) {
                        stop1 = currentTourPart.getStopAt(1);
                    }
                    startTime = stop1.iterateTimeWindows().next().getStartTime();
                    tour.setPlannedStartTime(startTime);
                }
                if (timeType == StopModelUtil.StopTimeTyp.ACTUAL) {
                    if (tour.getActualStartTime() == null) {
                        tour.setActualStartTime(startTime);
                    }
                    startTime = tour.getActualStartTime();
                }
            } else if (!lastTourPart.isStopsEmpty() || startPointOfTourPart != null) {
                StopModel startStop = startPointOfTourPart == null ? lastTourPart.getStopAt(lastTourPart.countStops() - 1) : startPointOfTourPart;
                switch (timeType) {
                    case ACTUAL: {
                        startTime = startStop.getActualTimeOfArrival();
                        Integer duration = startStop.getActualDurationSeconds();
                        startTime = TimeUtil.add(startTime, 13, duration == null ? 0 : duration);
                        break;
                    }
                    case ESTIMATED: {
                        startTime = startStop.getEstimatedTimeOfArrival();
                        Integer duration = startStop.getEstimatedDurationSeconds();
                        startTime = TimeUtil.add(startTime, 13, duration == null ? 0 : duration);
                        break;
                    }
                }
            }
            logisticTourDto.setStartTime(startTime);
            logisticTourDto = this.getGeoServerStub().getTourBi().calculateTour(logisticTourDto, this.clearDistanceMatrix());
            if (tourRoutingContext.isCanceled()) continue;
            tourRoutingContext.requestAdaption();
            try {
                this.adaptCalculateResultTourDto(currentTourPart, exceptionMap.get(currentTourPart), logisticTourDto, startPointOfTourPart, endPointOfTourPart, timeType);
                tourRoutingContext.finishAdaption();
                continue;
            }
            catch (Throwable ex) {
                tourRoutingContext.rollbackAdaption();
                throw ex;
            }
        }
    }

    @Override
    public boolean optimizeTour(TourModel tour, Tripel<OptimizationType, Integer, Integer> optimizationTripel, RouteVehicleType routeVehicleType, RouteType routeType, boolean withCalculation, boolean saved, ModelEnviroment modelEnviroment, final OptimizationAlgorithmType optimizationAlgorithmType, Window parent, final TourRoutingContext tourRoutingContext) {
        TourPartModel lastTourPart;
        StopModel lastStop;
        if (routeVehicleType == null) {
            routeVehicleType = RouteVehicleType.MOTORCAR;
        }
        if (routeType == null) {
            routeType = RouteType.FASTEST;
        }
        GeoClientHelper geomHelper = new GeoClientHelper(modelEnviroment);
        StopModel firstStop = tour.countTourParts() == 0 || tour.getTourPartAt(0).countStops() == 0 ? null : tour.getTourPartAt(0).getStopAt(0);
        LocationModel location = firstStop == null ? null : firstStop.getLocation();
        tourRoutingContext.requestAdaption();
        ImmutablePoint point = geomHelper.getAccessGeomForLocation(location, routeVehicleType);
        OptimizationType optimizationType = optimizationTripel.getElement1();
        if (point == null && optimizationType.isStartFix()) {
            switch (optimizationType) {
                case STARTPOINTFIX: 
                case STARTWITHPOI: {
                    optimizationType = OptimizationType.NONFIX;
                    break;
                }
                case STARTFIXENDWITHPOI: {
                    optimizationType = OptimizationType.ENDWITHPOI;
                    break;
                }
                case STARTWITHPOIENDFIX: {
                    optimizationType = OptimizationType.ENDPOINTFIX;
                    break;
                }
                case BOTHPOINTFIX: {
                    optimizationType = OptimizationType.ENDPOINTFIX;
                    break;
                }
                case BOTHWITHPOI: {
                    optimizationType = OptimizationType.ENDWITHPOI;
                    break;
                }
            }
        }
        if ((point = geomHelper.getAccessGeomForLocation(location = (lastStop = (lastTourPart = tour.countTourParts() == 0 ? null : tour.getTourPartAt(tour.countTourParts() - 1)) == null || lastTourPart.countStops() == 0 ? null : lastTourPart.getStopAt(lastTourPart.countStops() - 1)) == null ? null : lastStop.getLocation(), routeVehicleType)) == null && optimizationType.isEndFix()) {
            switch (optimizationType) {
                case ENDPOINTFIX: 
                case ENDWITHPOI: {
                    optimizationType = OptimizationType.NONFIX;
                    break;
                }
                case STARTFIXENDWITHPOI: {
                    optimizationType = OptimizationType.STARTPOINTFIX;
                    break;
                }
                case STARTWITHPOIENDFIX: {
                    optimizationType = OptimizationType.STARTWITHPOI;
                    break;
                }
                case BOTHPOINTFIX: {
                    optimizationType = OptimizationType.STARTPOINTFIX;
                    break;
                }
                case BOTHWITHPOI: {
                    optimizationType = OptimizationType.STARTWITHPOI;
                    break;
                }
            }
        }
        Map<TourPartModel, Collection<StopModel>> stopsWithNullGeomMap = geomHelper.checkStopModels(tour, routeVehicleType, routeType, optimizationAlgorithmType, true);
        final LogisticTourDto<PointEntityId> logisticTourDto = LogisticTourDtoUtil.createLogisticTourDto(tour, stopsWithNullGeomMap, optimizationType, routeVehicleType, routeType, modelEnviroment, optimizationTripel.getElement2(), optimizationTripel.getElement3());
        AbstractAsynchronousDialog<LogisticTourDto<PointEntityId>> asynchronousDialog = new AbstractAsynchronousDialog<LogisticTourDto<PointEntityId>>(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.optimising", new Serializable[]{StringUtil.nullToEmpty(tour.getName())}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, true, modelEnviroment, true){
            private static final long serialVersionUID = -9010756475037313167L;

            @Override
            protected AsynchronousDto<LogisticTourDto<PointEntityId>> getAsynchronousDto(String token) {
                return TourCallerImpl.this.getGeoServerStub().getAsynchronousBi().getOptimizeTourResult(token);
            }

            @Override
            protected String startAsynchronous() {
                try {
                    return TourCallerImpl.this.getGeoServerStub().getAsynchronousBi().optimizeTour(logisticTourDto, optimizationAlgorithmType, TourCallerImpl.this.clearDistanceMatrix());
                }
                catch (LogisticException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            Tupel result = asynchronousDialog.run();
            if (saved && !tourRoutingContext.isCanceled()) {
                try {
                    this.updateSortOrder(tour, stopsWithNullGeomMap, (LogisticTourDto)result.getElement1());
                    if (withCalculation && !tourRoutingContext.isCanceled()) {
                        TourRoutingContext subTourRoutingContext = new TourRoutingContext(){

                            @Override
                            public void rollbackAdaption() {
                            }

                            @Override
                            public void requestAdaption() {
                            }

                            @Override
                            public boolean isCanceled() {
                                return tourRoutingContext.isCanceled();
                            }

                            @Override
                            public void finishAdaption() {
                            }

                            @Override
                            public int getTotalCount() {
                                return tourRoutingContext.getTotalCount();
                            }
                        };
                        this.calculateTour(tour, routeVehicleType, routeType, saved, modelEnviroment, optimizationAlgorithmType, !optimizationAlgorithmType.isTimeType(), subTourRoutingContext);
                    }
                    tourRoutingContext.finishAdaption();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    tourRoutingContext.rollbackAdaption();
                }
            }
            return result.getElement2();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public LogisticTourDto<PointEntityId> calculateLogisticTour(LogisticTourDto<PointEntityId> logisticTourDto, boolean clear) throws LogisticException {
        return this.getGeoServerStub().getTourBi().calculateTour(logisticTourDto, this.clearDistanceMatrix());
    }

    @Override
    public LogisticTourDto<PointEntityId> optimizeLogisticTour(LogisticTourDto<PointEntityId> logisticTourDto, boolean withCalculation, OptimizationAlgorithmType optimizationAlgorithmType) throws LogisticException {
        if (withCalculation) {
            logisticTourDto.setSaved(true);
        } else {
            logisticTourDto.setSaved(false);
        }
        logisticTourDto = this.getGeoServerStub().getTourBi().optimizeTour(logisticTourDto, optimizationAlgorithmType, this.clearDistanceMatrix());
        return logisticTourDto;
    }

    @Override
    public void calculateAreaTour(AreaTourModel areaTour, ModelEnviroment modelEnviroment, boolean saved) throws LogisticException {
        LogisticTourDto<PointEntityId> logisticTourDto = LogisticTourDtoUtil.createLogisticTourDto(areaTour);
        for (LogisticTourPartDto<PointEntityId> logisticTourPart : logisticTourDto.getTourParts()) {
            AreaObjectModelUtil.setAreaParameter(areaTour.getAreaObject(), logisticTourPart, modelEnviroment);
        }
        logisticTourDto = this.getGeoServerStub().getTourBi().calculateTour(logisticTourDto, this.clearDistanceMatrix());
        if (saved) {
            this.adaptCalculateResultTourDto(areaTour, logisticTourDto);
        }
    }

    @Override
    @Deprecated
    public void optimizeAreaTour(AreaTourModel areaTour, ModelEnviroment modelEnviroment, OptimizationAlgorithmType algorithmType) throws LogisticException {
        GeoClientHelper helper = new GeoClientHelper(modelEnviroment);
        for (AreaTourPartModel tourPart : areaTour.iterableAreaTourParts()) {
            RouteVehicleType routeVehicleType = tourPart.getRouteVehicleType();
            RouteType routeType = tourPart.getRouteType();
            OptimizationType optimizationType = areaTour.getPoi() == null ? OptimizationType.NONFIX : OptimizationType.STARTWITHPOI;
            ArrayList<PointEntity> accessPoints = new ArrayList<PointEntity>();
            for (AreaStopModel stop : tourPart.iterableAreaStops()) {
                if (stop.getPoi() != null) {
                    helper.addPointEntityForPoi(optimizationType, routeVehicleType, stop.getPoi(), accessPoints, stop.getTempUUID(), true);
                    continue;
                }
                if (stop.getParcel() != null) {
                    helper.addPointEntityForParcel(routeVehicleType, accessPoints, stop.getParcel(), stop.getTempUUID(), areaTour.getAreaObject(), null, null, null);
                    continue;
                }
                if (stop.getSubscription() == null) continue;
                helper.addPointEntityForSubscription(routeVehicleType, accessPoints, stop.getSubscription(), stop.getTempUUID(), null, null);
            }
            int startBlock = optimizationType.isWithPoi() ? 1 : 0;
            LogisticTourDto<PointEntityId> logisticTour = DefaultLogisticTourUtil.createLogisticTourDto(accessPoints, optimizationType, routeVehicleType, routeType, startBlock, 0);
            logisticTour = this.optimizeLogisticTour(logisticTour, false, algorithmType);
            this.updateSortOrder(tourPart, logisticTour);
        }
        this.calculateAreaTour(areaTour, modelEnviroment, true);
    }

    private void updateSortOrder(AreaTourPartModel tourPart, LogisticTourDto<PointEntityId> logisticTour) {
        List<LogisticStopDto<PointEntityId>> logisticStopDtos = LogisticServicesUtil.getAllStops(logisticTour);
        for (int i = 0; i < logisticStopDtos.size(); ++i) {
            for (int j = 0; j < tourPart.countAreaStops(); ++j) {
                AreaStopModel stop = tourPart.getAreaStopAt(j);
                Long stopId = ((PointEntityId)logisticStopDtos.get(i).getId()).getId();
                if (!stopId.equals(stop.getTempUUID())) continue;
                tourPart.removeAreaStopAt(j);
                tourPart.insertAreaStop(stop, i);
            }
        }
    }

    private void adaptCalculateResultTourDto(AreaTourModel areaTour, LogisticTourDto<?> logisticTourDto) {
        areaTour.setDistanceSum(logisticTourDto.getDistanceSum());
        areaTour.setDurationSum(logisticTourDto.getDurationSum());
        areaTour.setAccessSum(logisticTourDto.getAccessSum());
        for (int i = 0; i < areaTour.countAreaTourParts(); ++i) {
            AreaTourPartModel areaTourPart = areaTour.getAreaTourPartAt(i);
            LogisticTourPartDto<?> logisticTourPartDto = logisticTourDto.getTourParts().get(i);
            List<ImmutableLineString> lineStrings = LogisticTourDtoUtil.getLineStrings(logisticTourPartDto);
            if (lineStrings != null && !lineStrings.isEmpty()) {
                LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
                for (ImmutableLineString lineString : lineStrings) {
                    if (lineString == null) continue;
                    lineString = (ImmutableLineString)lineString.getTransformed(OpenStreetmapViewFactory.INSTANCE);
                    points.addAll(lineString.getCoordinates());
                }
                if (points.size() > 1) {
                    areaTourPart.setLineString(ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points));
                }
            }
            for (int j = 0; j < areaTourPart.countAreaStops(); ++j) {
                LogisticLocationDto<?> locationDto;
                AreaStopModel areaStop = areaTourPart.getAreaStopAt(j);
                LogisticStopDto<?> logisticStopDto = logisticTourPartDto.getStopDtos().get(j);
                areaStop.setMetersFromStart(logisticStopDto.getStreetMileageMetersFromStart());
                areaStop.setSecondsFromStart(logisticStopDto.getSecondsFromStart());
                if (areaStop.getLocation() == null) {
                    if (areaStop.getParcel() != null) {
                        areaStop.setLocation(areaStop.getParcel().getGeom());
                    } else if (areaStop.getSubscription() != null) {
                        LocationModel location = areaStop.getSubscription().getLocation();
                        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                        areaStop.setLocation(wrapper.getGeoLocation());
                    } else if (areaStop.getPoi() != null) {
                        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(areaStop.getPoi().getLocation());
                        areaStop.setLocation(wrapper.getGeoLocation());
                    }
                }
                if ((locationDto = logisticStopDto.getLocation()) == null || locationDto.getAccessGeom() == null) continue;
                areaStop.setAccessLocation((ImmutablePoint)((ImmutablePoint)locationDto.getAccessGeom().getGeoObject()).getGeom());
            }
        }
    }

    private boolean clearDistanceMatrix() {
        boolean clear = false;
        return clear;
    }

    private List<LogisticStopDto<PointEntityId>> getAllStops(LogisticTourDto<PointEntityId> logisticTourDto) {
        ArrayList<LogisticStopDto<PointEntityId>> stops = new ArrayList<LogisticStopDto<PointEntityId>>();
        for (LogisticTourPartDto<PointEntityId> tourPart : logisticTourDto.getTourParts()) {
            stops.addAll(tourPart.getStopDtos());
        }
        return stops;
    }

    private void adaptCalculateResultTourDto(TourPartModel tourPartModel, Collection<StopModel> exceptions, LogisticTourDto<PointEntityId> logisticTourDto, StopModel startPointOfTourPart, StopModel endPointOfTourPart, StopModelUtil.StopTimeTyp timeType) throws LogisticException {
        if (timeType == null) {
            return;
        }
        List<LogisticStopDto<PointEntityId>> logisticStopDtos = this.getAllStops(logisticTourDto);
        if (logisticStopDtos.size() < 1) {
            return;
        }
        Tupel<Integer, Integer> deviationTupel = new Tupel<Integer, Integer>(0, 0);
        int startIndex = 0;
        if (startPointOfTourPart != null) {
            ++startIndex;
            if (startPointOfTourPart.getPoi() == null) {
                this.getDeviationTupel(startPointOfTourPart, logisticStopDtos, deviationTupel, startIndex);
            }
        }
        int sumOfException = 0;
        Integer predMeter = 0;
        Date predTime = DateUtils.addSeconds(logisticStopDtos.get(0).getTimeOfArrival(), deviationTupel.getElement1());
        for (int i = 0; i < tourPartModel.countStops(); ++i) {
            TimeWindowModel nearbyTimeWindow;
            StopModel stopModel = tourPartModel.getStopAt(i);
            if (exceptions.contains(stopModel)) {
                this.saveStopRoutingDates(stopModel, null, null, timeType);
                ++sumOfException;
                continue;
            }
            LogisticStopDto<PointEntityId> logisticStopDto = logisticStopDtos.get(i - sumOfException + startIndex);
            if (i != 0) {
                Integer oldDeviationOfTime = deviationTupel.getElement1();
                int pred = 1;
                StopModel predStop = tourPartModel.getStopAt(i - pred);
                while (exceptions.contains(predStop)) {
                    if (i - ++pred < 0) {
                        predStop = null;
                        break;
                    }
                    predStop = tourPartModel.getStopAt(i - pred);
                }
                Integer duration = predStop == null ? 0 : predStop.getEstimatedDurationSeconds();
                deviationTupel.setElement1(oldDeviationOfTime + duration);
            }
            if ((nearbyTimeWindow = StopModelUtil.getNearbyTimeWindow(stopModel, predTime = DateUtils.addSeconds(logisticStopDto.getTimeOfArrival(), deviationTupel.getElement1()))) != null && nearbyTimeWindow.getStartTime() != null) {
                long newPredTime = Math.max(predTime.getTime(), nearbyTimeWindow.getStartTime().getTime());
                long newTimeDeviation = (newPredTime - predTime.getTime()) / 1000L;
                deviationTupel.setElement1(deviationTupel.getElement1() + (int)newTimeDeviation);
                predTime = DateUtils.addSeconds(predTime, (int)newTimeDeviation);
            }
            predMeter = logisticStopDto.getStreetMileageMetersFromStart() + deviationTupel.getElement2();
            this.saveStopRoutingDates(stopModel, predMeter, predTime, timeType);
        }
    }

    private void saveStopRoutingDates(StopModel stop, Integer meter, Date time, StopModelUtil.StopTimeTyp timeType) {
        switch (timeType) {
            case ESTIMATED: {
                stop.setEstimatedTimeOfArrival(time);
                break;
            }
            case ACTUAL: {
                stop.setActualTimeOfArrival(time);
            }
        }
        stop.setStreetMileageMetersFromTourStart(meter);
    }

    private void getDeviationTupel(StopModel startPointOfTourPart, List<LogisticStopDto<PointEntityId>> logisticStopDtos, Tupel<Integer, Integer> deviationTupel, int startIndex) {
        if (startPointOfTourPart != null) {
            LogisticStopDto<PointEntityId> firstLocationResultDto = logisticStopDtos.get(startIndex);
            Long starttime = firstLocationResultDto.getTimeOfArrival().getTime();
            LogisticStopDto<PointEntityId> last = logisticStopDtos.get(startIndex - 1);
            Integer durationBetweenTourParts = firstLocationResultDto.getSecondsFromStart() - last.getSecondsFromStart();
            Long lasttime = startPointOfTourPart.getEstimatedTimeOfArrival().getTime();
            Integer duration = startPointOfTourPart.getEstimatedDurationSeconds();
            if (duration == null) {
                duration = 0;
            }
            deviationTupel.setElement1((int)((lasttime - starttime) / 1000L) + durationBetweenTourParts + duration);
            deviationTupel.setElement2(startPointOfTourPart.getStreetMileageMetersFromTourStart());
        }
    }

    private void updateSortOrder(TourPartModel tourPartModel, Collection<StopModel> stopsWithNullGeom, List<LogisticStopDto<PointEntityId>> logisticStopDtos, int startIndex, int endIndex) {
        if (logisticStopDtos.size() == 0) {
            return;
        }
        for (int i = startIndex; i < endIndex - stopsWithNullGeom.size(); ++i) {
            for (int j = 0; j < tourPartModel.countStops(); ++j) {
                StopModel stopModel = tourPartModel.getStopAt(j);
                if (stopsWithNullGeom.contains(stopModel)) {
                    tourPartModel.removeStopAt(j);
                    continue;
                }
                LogisticStopDto<PointEntityId> logisticStopDto = logisticStopDtos.get(i);
                Long stopId = ((PointEntityId)logisticStopDto.getId()).getId();
                if (!stopId.equals(stopModel.getTempUUID())) continue;
                if (logisticStopDto.isBadTimeWindow()) {
                    stopModel.setStopStatus(StopStatus.BAD_TIME_WINDOW);
                } else {
                    stopModel.setStopStatus(StopStatus.NORMAL);
                }
                tourPartModel.removeStopAt(j);
                tourPartModel.insertStop(stopModel, i - startIndex);
            }
        }
        boolean endWithPoi = tourPartModel.countStops() > 2 && tourPartModel.getStopAt(tourPartModel.countStops() - 1).getPoi() != null;
        for (StopModel stop : stopsWithNullGeom) {
            if (endWithPoi) {
                tourPartModel.insertStop(stop, tourPartModel.countStops() - 1);
                continue;
            }
            tourPartModel.addStop(stop);
        }
    }

    private void updateSortOrder(TourModel tourModel, Map<TourPartModel, Collection<StopModel>> stopsWithNullGeomMap, LogisticTourDto<PointEntityId> logisticTourDto) {
        List<LogisticTourPartDto<PointEntityId>> tourParts = logisticTourDto.getTourParts();
        for (int i = 0; i < tourParts.size(); ++i) {
            LogisticTourPartDto<PointEntityId> tourPartDto = tourParts.get(i);
            TourPartModel tourPartModel = tourModel.getTourPartAt(i);
            this.updateSortOrder(tourPartModel, stopsWithNullGeomMap.get(tourPartModel), tourPartDto.getStopDtos(), 0, tourPartModel.countStops());
        }
    }

    @Deprecated
    private void adaptResultLocationDto(LocationWrapper locationWrapper, LogisticLocationDto<Long> resultLocationDto) {
        locationWrapper.setCity(resultLocationDto.getCity());
        locationWrapper.setDistrict(resultLocationDto.getDistrict());
        ImmutablePointDto pointDto = resultLocationDto.getGeom();
        locationWrapper.setGeoLocation(pointDto == null ? null : (ImmutablePoint)pointDto.getGeoObject());
        locationWrapper.setHousenumber(Integer.parseInt(resultLocationDto.getHousenumber()));
        locationWrapper.setHousenumberExtension(resultLocationDto.getExtension());
        locationWrapper.setPostcode(resultLocationDto.getPostcode());
        locationWrapper.setStreet(resultLocationDto.getStreet());
    }

    @Override
    public List<StopModel> fetchStopsWithFilter(StopFilterEntity stopFilterEntity) {
        TourBi tourBi = this.getGeoServerStub().getTourBi();
        StopSearchDto stopSearchDto = this.createStopSearchDtoFromStopFilterEntity(stopFilterEntity);
        List<StopDto> stopDtos = tourBi.fetchStopsWithFilter(stopSearchDto);
        List<StopModel> stopModels = super.convertDtosToModels(stopDtos, new ValueChangeListener[0]);
        Collections.sort(stopModels, new StreetNameComparator());
        return stopModels;
    }

    private StopSearchDto createStopSearchDtoFromStopFilterEntity(StopFilterEntity stopFilterEntity) {
        StopSearchDtoImpl stopSearchDto = new StopSearchDtoImpl();
        List<PoiDto> poiDtos = this.convertModelsToDtoProxies(stopFilterEntity.getPois());
        List<ServiceDto> serviceDtos = this.convertModelsToDtoProxies(stopFilterEntity.getServices());
        List<Tupel<ServiceValueDescriptorDto, Serializable>> serviceValueDtos = this.convertModelTupelToDtoProxies(stopFilterEntity.getServiceValues());
        List<StaticChoiceValueDto> serviceStatus = this.convertModelsToDtoProxies(stopFilterEntity.getServiceStatus());
        List<StaticChoiceValueDto> serviceSubStatus = this.convertModelsToDtoProxies(stopFilterEntity.getServiceSubStatus());
        List<DelivererDto> delivererDtos = this.convertModelsToDtoProxies(stopFilterEntity.getDeliverers());
        stopSearchDto.setStopNames(stopFilterEntity.getNames());
        stopSearchDto.setTourNames(stopFilterEntity.getTourNames());
        stopSearchDto.setPois(poiDtos);
        stopSearchDto.setEstimatedTimeOfArrival(stopFilterEntity.getEstimatedTimesOfArrival());
        stopSearchDto.setTimeWindows(stopFilterEntity.getTimeWindows());
        stopSearchDto.setServices(serviceDtos);
        stopSearchDto.setServiceValues(serviceValueDtos);
        stopSearchDto.setServiceStatusTypes(stopFilterEntity.getServiceStatusTypes());
        stopSearchDto.setServiceStatus(serviceStatus);
        stopSearchDto.setServiceSubStatus(serviceSubStatus);
        stopSearchDto.setDeliverers(delivererDtos);
        stopSearchDto.setUnsorted(stopFilterEntity.isUnsorted());
        stopSearchDto.setAllowWildcard(stopFilterEntity.isAllowWildcard());
        return stopSearchDto;
    }

    private <T extends Dto, S extends Model, U extends Serializable> List<Tupel<T, U>> convertModelTupelToDtoProxies(Collection<Tupel<S, U>> tupels) {
        if (tupels == null) {
            return null;
        }
        ArrayList<Tupel<T, U>> list = new ArrayList<Tupel<T, U>>(tupels.size());
        for (Tupel<S, U> s : tupels) {
            Model el1In = (Model)s.getElement1();
            Object el1Out = this.convertModelToDtoProxy(el1In);
            list.add(new Tupel(el1Out, s.getElement2()));
        }
        return list;
    }

    private <M extends Model> Collection createDtoCollection(Collection<M> models, Class d) {
        if (models == null) {
            return null;
        }
        HashSet dtos = new HashSet(models.size());
        for (Model model : models) {
            dtos.add(d.cast(((AbstractModel)model).createProxy()));
        }
        return dtos;
    }

    @Override
    @Deprecated
    public ServiceStatusType calculateServiceStatus(ServiceModel service, Iterable<ServiceValueModel> serviceValueModels) {
        ServiceProxyDto serviceDto = ((ServiceModelImpl)service).createProxy();
        LinkedList<ServiceValueDto> serviceValueDtos = new LinkedList<ServiceValueDto>();
        for (ServiceValueModel serviceValueModel : serviceValueModels) {
            serviceValueDtos.add(((ServiceValueModelImpl)serviceValueModel).createDto());
        }
        return this.getGeoServerStub().getTourBi().calculateServiceStatus(serviceDto, serviceValueDtos);
    }

    @Override
    public DelivererModel getDelivererById(Long id) {
        DelivererDto delivererDto = this.getGeoServerStub().getTourBi().getDelivererById(id);
        return (DelivererModel)this.getModelCache().getModel(delivererDto);
    }

    @Override
    public BranchModel getBranchById(Long id) {
        BranchDto branchDto = this.getGeoServerStub().getTourBi().getBranchById(id);
        return (BranchModel)this.getModelCache().getModel(branchDto);
    }

    @Override
    public List<BranchModel> fetchAllBranchs() {
        List<BranchDto> branchDtos = this.getGeoServerStub().getTourBi().fetchAllBranchs();
        ArrayList<BranchModel> branchModels = new ArrayList<BranchModel>(branchDtos.size());
        for (BranchDto branchDto : branchDtos) {
            branchModels.add((BranchModel)this.getModelCache().getModel(branchDto));
        }
        return branchModels;
    }

    @Override
    public Collection<PoiAttributeValueDescriptorModel> fetchAllPoiAttributeValueDescriptors() {
        Collection<PoiAttributeValueDescriptorDto> dtos = this.getGeoServerStub().getTourBi().fetchAllPoiAttributeValueDescriptors();
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    @Deprecated
    public List<String> getExpenses() {
        return this.getGeoServerStub().getTourBi().getExpenses();
    }

    @Override
    public Collection<AreaTourModel> fetchAreaTours(AreaObjectModel areaObject, AreaTourType areaTourType, PoiModel poi, RouteVehicleType vehicleType) {
        AreaObjectProxyDto areaObjectProxyDto = ((AreaObjectModelImpl)areaObject).createProxy();
        PoiProxyDto poiProxyDto = null;
        if (poi != null) {
            poiProxyDto = ((PoiModelImpl)poi).createProxy();
        }
        Collection<AreaTourDto> areaTourDtos = this.getGeoServerStub().getTourBi().fetchAreaTours(areaObjectProxyDto, areaTourType, poiProxyDto, vehicleType);
        return this.convertDtosToModels(areaTourDtos, new ValueChangeListener[0]);
    }

    @Override
    public Collection<StopModel> fetchStopsWithNullGeom(boolean removeSameAddress) {
        Collection<StopDto> dtos = this.getGeoServerStub().getTourBi().fetchStopsWithNullGeom(removeSameAddress);
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public List<PoiModel> fetchPoisWithTypes(Collection<PoiType> poiTypes) {
        List<PoiDto> dtos = this.getGeoServerStub().getTourBi().fetchPoisWithTypes(poiTypes);
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public GeoDistanceMatrixWrapper getGeoDistance(ImmutablePoint point1, ImmutablePoint point2, RouteVehicleType routeVehicleType, RouteType routeType) throws LogisticException {
        if (point1 == null || point2 == null) {
            return null;
        }
        return this.getGeoServerStub().getTourBi().getGeoDistance(ImmutablePointDto.create(point1), ImmutablePointDto.create(point2), routeVehicleType, routeType);
    }

    @Override
    public Collection<GeoTrackingModel> getGeoTrackings(DelivererModel deliverer, Collection<TourModel> tourModels, Set<GeoTrackingType> geoTrackingTypes, long IntervallInMillis, Date firstTime) {
        DelivererDto delivererDto = (DelivererDto)((Object)(deliverer == null ? null : deliverer.createProxy()));
        ArrayList<TourDto> tourDtos = null;
        if (tourModels != null && !tourModels.isEmpty()) {
            tourDtos = new ArrayList<TourDto>(tourModels.size());
            for (TourModel tourModel : tourModels) {
                tourDtos.add((TourDto)((Object)tourModel.createProxy()));
            }
        }
        Collection<GeoTrackingDto> geoTracks = this.getGeoServerStub().getTourBi().getGeoTrackings(delivererDto, tourDtos, geoTrackingTypes, IntervallInMillis, firstTime);
        return this.convertDtosToModels(geoTracks, new ValueChangeListener[0]);
    }

    @Override
    public Collection<TourModel> fetchToursForDeliverer(DelivererModel deliverer) {
        DelivererDto delivererDto = (DelivererDto)((Object)(deliverer == null ? null : deliverer.createProxy()));
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchToursForDeliverer(delivererDto), new ValueChangeListener[0]);
    }

    @Override
    public Collection<TourModel> fetchToursForDelivererInTimeInterval(DelivererModel deliverer, Tupel<Date, Date> timeInterval) {
        DelivererDto delivererDto = (DelivererDto)((Object)(deliverer == null ? null : deliverer.createProxy()));
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchToursForDelivererInTimeInterval(delivererDto, timeInterval), new ValueChangeListener[0]);
    }

    @Override
    public List<StopModel> fetchStopsWithTimeWindows(Collection<Tupel<Date, Date>> timeWindows, ImmutablePoint topLeft, ImmutablePoint bottomRight) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchStopsWithTimeWindows(timeWindows, ImmutablePointDto.create(topLeft), ImmutablePointDto.create(bottomRight)), new ValueChangeListener[0]);
    }

    @Override
    public StopModel getStopById(Long id) {
        return (StopModel)this.getModelCache().getModel(this.getGeoServerStub().getTourBi().getStopById(id));
    }

    @Override
    public Collection<AreaStopModel> fetchAreaStop(ParcelModel parcel, SubscriptionModel subscription, PoiModel poi, LetterModel letter) {
        ParcelProxyDto parcelDto = parcel == null ? null : ((ParcelModelImpl)parcel).createProxy();
        SubscriptionProxyDto subscriptionDto = subscription == null ? null : ((SubscriptionModelImpl)subscription).createProxy();
        PoiProxyDto poiDto = poi == null ? null : ((PoiModelImpl)poi).createProxy();
        LetterProxyDto letterDto = letter == null ? null : ((LetterModelImpl)letter).createProxy();
        Collection<AreaStopDto> areaStopDtos = this.getGeoServerStub().getTourBi().fetchAreaStop(parcelDto, subscriptionDto, poiDto, letterDto);
        return this.convertDtosToModels(areaStopDtos, new ValueChangeListener[0]);
    }

    @Override
    public LogisticServiceRouteDto calculateRouteBetweenPoints(ImmutablePoint pointPre, ImmutablePoint pointSucc, RouteVehicleType routeVehicleType, RouteType routeType) throws LogisticException {
        return this.getGeoServerStub().getTourBi().calculateRouteBetweenPoints(ImmutablePointDto.create(pointPre), ImmutablePointDto.create(pointSucc), routeVehicleType, routeType);
    }

    @Override
    public Collection<AreaTourModel> fetchAllAreaTours() {
        Collection<AreaTourDto> dtos = this.getGeoServerStub().getTourBi().fetchAllAreaTours();
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public TourExportDto reviewAreaTours(Collection<Tupel<AreaObjectModel, List<Model>>> areas, Collection<AreaTourParameter> parameters, TourExportFormat exportType, boolean createPdf, boolean selfParameter) throws TourCalculationBlockException {
        ArrayList<Tupel<AreaObjectDto, List<Dto>>> areaDtos = new ArrayList<Tupel<AreaObjectDto, List<Dto>>>(areas.size());
        for (Tupel<AreaObjectModel, List<Model>> tupel : areas) {
            areaDtos.add(new Tupel((AreaObjectDto)this.convertModelToDtoProxy((Model)tupel.getElement1()), this.convertModelsToDtoProxies((Collection)tupel.getElement2())));
        }
        for (AreaTourParameter parameter : parameters) {
            parameter.setDistanceMatrixClear(this.clearDistanceMatrix());
        }
        return this.getGeoServerStub().getTourBi().reviewAreaTours(areaDtos, parameters, exportType, null, createPdf, selfParameter);
    }

    @Override
    public Collection<Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>> fetchAreaTourSchedulesWithTimeWindow(Collection<AreaObjectModel> areaObjects, Date startTime, Date endTime) {
        Collection dtos = this.createDtoCollection(areaObjects, AreaObjectDto.class);
        Collection<Tupel<Collection<AreaTourScheduleDto>, Collection<HistoryAreaTourDto>>> dtoTupels = this.getGeoServerStub().getTourBi().fetchAreaTourSchedulesWithTimeWindow(dtos, startTime, endTime);
        HashSet<Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>> modelTupels = new HashSet<Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>>(dtoTupels.size());
        CollectionUtil.transform(dtoTupels, modelTupels, new Transformer<Tupel<Collection<AreaTourScheduleDto>, Collection<HistoryAreaTourDto>>, Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>>(){

            @Override
            public Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>> transform(Tupel<Collection<AreaTourScheduleDto>, Collection<HistoryAreaTourDto>> t) {
                List scheduleModels = TourCallerImpl.this.convertDtosToModels(t.getElement1(), new ValueChangeListener[0]);
                List historyModels = TourCallerImpl.this.convertDtosToModels(t.getElement2(), new ValueChangeListener[0]);
                return new Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>(scheduleModels, historyModels);
            }
        });
        return modelTupels;
    }

    @Override
    public AreaTourModel getAreaTourFromAreaObject(AreaObjectModel areaObject, AreaTourParameter parameter) {
        AreaObjectDto dto = (AreaObjectDto)this.convertModelToDtoProxy(areaObject);
        parameter.setDistanceMatrixClear(this.clearDistanceMatrix());
        AreaTourDto areaTourDto = this.getGeoServerStub().getTourBi().getAreaTourFromAreaObject(dto, parameter);
        return (AreaTourModel)this.convertDtoToModel(areaTourDto, new ValueChangeListener[0]);
    }

    @Override
    public TourExportDto findAloneInArea(Collection<AreaObjectModel> areaObjects, Collection<AreaTourType> areaTourTypes, TourExportFormat tourExportType, Quad<String, String, String, String> prefixes, Integer maxDistance, Integer maxPoints, boolean excat) {
        Collection dtos = this.createDtoCollection(areaObjects, AreaObjectDto.class);
        return this.getGeoServerStub().getTourBi().findAloneInArea(dtos, areaTourTypes, tourExportType, prefixes, maxDistance, maxPoints, excat);
    }

    @Override
    public Collection<AreaTourModel> fetchAreaToursById(Collection<Long> ids) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchAreaToursById(ids), new ValueChangeListener[0]);
    }

    @Override
    public void calculateActualTour(TourModel tour) {
        String[] property;
        HashSet<GeoTrackingType> types = new HashSet<GeoTrackingType>();
        for (String p : property = ModelEnviroment.getProperties().getProperty("tour.calculation.trackingTypes").split(",")) {
            types.add(GeoTrackingType.valueOf(p));
        }
        Tripel<Integer, Date, Date> tripel = this.getGeoServerStub().getTourBi().calculateTourTracking(((TourModelImpl)tour).createProxy(), types);
        Integer kilometerStart = tour.getKilometerStart();
        if (kilometerStart == null) {
            kilometerStart = 0;
            tour.setKilometerStart(kilometerStart);
        }
        int meter = PrimitiveUtil.nullToZero(tripel.getElement1());
        tour.setKilometerEnd(kilometerStart + Math.round(meter / 1000));
        tour.setActualStartTime(tripel.getElement2());
    }

    @Override
    public List<AreaDelivererModel> getDeliverersAttachedToHistoyAreaTour() {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().getDeliverersAttachedToHistoyAreaTour(), new ValueChangeListener[0]);
    }

    @Override
    public DefaultExceptionResultDto clearDistanceMatrix(Collection<ImmutableEnvelopeDto> envelopeDtos) {
        return this.getGeoServerStub().getTourBi().clearDistanceMatrix(envelopeDtos);
    }

    @Override
    public Collection<StopModel> fetchStopsWithBadSegment(boolean removeSameAddress) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchStopsWithBadSegment(removeSameAddress), new ValueChangeListener[0]);
    }

    @Override
    public Collection<StopModel> fetchNotCheckedStops(boolean removeSameAddress) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchNotCheckedStops(removeSameAddress), new ValueChangeListener[0]);
    }

    @Override
    public String generateTourName(Integer length, String prefix, Integer preValue) {
        String newName = this.getGeoServerStub().getTourBi().generateTourName(length, prefix, preValue);
        Collection<TourModel> cachedTours = super.getModelCache().getCachedModels(TourModel.class);
        int i = preValue == null ? 0 : preValue;
        try {
            int maxValue = Integer.parseInt(newName.replace(prefix, ""));
            i = Math.max(i, maxValue);
        }
        catch (Exception maxValue) {
            // empty catch block
        }
        while (true) {
            boolean b = false;
            for (TourModel tour : cachedTours) {
                if (!StringUtil.getNotNull(tour.getName()).equals(newName)) continue;
                b = true;
                break;
            }
            if (!b) break;
            newName = prefix + StringUtils.leftPad(String.valueOf(++i), length - prefix.length(), '0');
        }
        return newName;
    }

    @Override
    public Collection<TourDifficultyLevelModel> fetchAllTourDifficultyLevels() {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchAllTourDifficultyLevels(), new ValueChangeListener[0]);
    }

    @Override
    public Double getSegmentSearchFactor() {
        return this.getGeoServerStub().getTourBi().getSegmentSearchFactor();
    }

    @Override
    public BranchModel fetchBranchByNameAndType(String branchName, BranchType branchType) {
        return (BranchModel)this.convertDtoToModel(this.getGeoServerStub().getTourBi().fetchBranchByNameAndType(branchName, branchType), new ValueChangeListener[0]);
    }

    @Override
    public List<DelivererModel> fetchDeliverersByBranch(BranchModel branch) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchDeliverersByBranch((BranchDto)((Object)(branch == null ? null : branch.createProxy()))), new ValueChangeListener[0]);
    }

    @Override
    public List<AreaDelivererModel> fetchAllAreaDeliverers() {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchAllAreaDeliverers(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaDelivererModel> fetchAllAreaDeliverersForAreaLayer(Collection<AreaLayerModel> layers) {
        Collection layerDtos = this.createDtoCollection(layers, AreaLayerDto.class);
        Collection<AreaDelivererDto> delivererDtos = this.getGeoServerStub().getTourBi().fetchAllAreaDeliverersForAreaLayer(layerDtos);
        return this.convertDtosToModels(delivererDtos, new ValueChangeListener[0]);
    }

    @Override
    public List<LetterModel> fetchLettersByAreaObject(AreaObjectModel areaObject, SubscriptionParameter areaTourParameter) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchLettersByAreaObject((AreaObjectDto)this.convertModelToDtoProxy(areaObject), areaTourParameter), new ValueChangeListener[0]);
    }

    @Override
    public Collection<DeliveryRoundModel> fetchAllDeliveryRounds() {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchAllDeliveryRounds(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<TourModel> searchTours(TourSearchDto searchDto) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().searchTours(searchDto), new ValueChangeListener[0]);
    }

    @Override
    public List<AreaDelivererModel> fetchAreaDeliverersByBranch(BranchModel branch) {
        return this.convertDtosToModels(this.getGeoServerStub().getTourBi().fetchAreaDeliverersByBranch((BranchDto)this.convertModelToDtoProxy(branch)), new ValueChangeListener[0]);
    }

    @Override
    public boolean isUsedDeliverRound(DeliveryRoundModel round) {
        return this.getGeoServerStub().getTourBi().isUsedDeliverRound((DeliveryRoundDto)this.convertModelToDtoProxy(round));
    }

    @Override
    public boolean existsTourWithName(String name) {
        return this.getGeoServerStub().getTourBi().existsTourWithName(name);
    }
}

