/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticServiceRouteDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.communication.tour.TourRoutingContext;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.dto.importer.DefaultExceptionResultDto;
import de.datomino.peppergis.dto.tour.TourSearchDto;
import de.datomino.peppergis.exception.TourCalculationBlockException;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.ServiceStatusType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableEnvelopeDto;
import java.awt.Window;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public interface TourCaller {
    public List<DelivererModel> fetchAllDeliverers();

    public List<TourModel> fetchAllTours();

    public List<TourModel> fetchToursInTimeWindows(Collection<Tupel<Date, Date>> var1, DelivererModel var2, boolean var3);

    public List<StopModel> fetchAllUnsortedStops();

    public List<StopModel> fetchAllStopsWithPoi();

    public Collection<LocationModel> fetchLocationsWithSameAddress(LogisticLocationDto<Long> var1);

    public List<LocationModel> fetchAllLocations();

    public List<ServiceModel> fetchAllServices();

    public List<PoiModel> fetchAllPois();

    public List<StopModel> fetchStops(ImmutablePoint var1, ImmutablePoint var2, boolean var3);

    public List<SubscriptionModel> fetchSubscriptions(ImmutablePoint var1, ImmutablePoint var2);

    public List<SubscriptionModel> fetchSubscriptionsByAreaObject(AreaObjectModel var1, SubscriptionParameter var2);

    public List<ParcelModel> fetchParcels(ImmutablePoint var1, ImmutablePoint var2, boolean var3);

    public List<ParcelModel> fetchParcelsByAreaObject(AreaObjectModel var1, boolean var2);

    @Deprecated
    public void validateLocation(LocationModel var1) throws LogisticException;

    public void calculateTour(TourModel var1, RouteVehicleType var2, RouteType var3, boolean var4, ModelEnviroment var5, OptimizationAlgorithmType var6, boolean var7, TourRoutingContext var8) throws LogisticException;

    public boolean optimizeTour(TourModel var1, Tripel<OptimizationType, Integer, Integer> var2, RouteVehicleType var3, RouteType var4, boolean var5, boolean var6, ModelEnviroment var7, OptimizationAlgorithmType var8, Window var9, TourRoutingContext var10) throws LogisticException;

    public LogisticTourDto<PointEntityId> calculateLogisticTour(LogisticTourDto<PointEntityId> var1, boolean var2) throws LogisticException;

    public LogisticTourDto<PointEntityId> optimizeLogisticTour(LogisticTourDto<PointEntityId> var1, boolean var2, OptimizationAlgorithmType var3) throws LogisticException;

    public GeoDistanceMatrixWrapper getGeoDistance(ImmutablePoint var1, ImmutablePoint var2, RouteVehicleType var3, RouteType var4) throws LogisticException;

    public List<StopModel> fetchStopsWithFilter(StopFilterEntity var1);

    @Deprecated
    public ServiceStatusType calculateServiceStatus(ServiceModel var1, Iterable<ServiceValueModel> var2);

    public DelivererModel getDelivererById(Long var1);

    public BranchModel getBranchById(Long var1);

    public List<BranchModel> fetchAllBranchs();

    public Collection<PoiAttributeValueDescriptorModel> fetchAllPoiAttributeValueDescriptors();

    @Deprecated
    public List<String> getExpenses();

    public Collection<AreaTourModel> fetchAreaTours(AreaObjectModel var1, AreaTourType var2, PoiModel var3, RouteVehicleType var4);

    public Collection<AreaTourModel> fetchAllAreaTours();

    public Collection<StopModel> fetchStopsWithNullGeom(boolean var1);

    public List<PoiModel> fetchPoisWithTypes(Collection<PoiType> var1);

    public Collection<GeoTrackingModel> getGeoTrackings(DelivererModel var1, Collection<TourModel> var2, Set<GeoTrackingType> var3, long var4, Date var6);

    public Collection<TourModel> fetchToursForDeliverer(DelivererModel var1);

    public Collection<TourModel> fetchToursForDelivererInTimeInterval(DelivererModel var1, Tupel<Date, Date> var2);

    public List<StopModel> fetchStopsWithTimeWindows(Collection<Tupel<Date, Date>> var1, ImmutablePoint var2, ImmutablePoint var3);

    public Collection<AreaStopModel> fetchAreaStop(ParcelModel var1, SubscriptionModel var2, PoiModel var3, LetterModel var4);

    public LogisticServiceRouteDto calculateRouteBetweenPoints(ImmutablePoint var1, ImmutablePoint var2, RouteVehicleType var3, RouteType var4) throws LogisticException;

    public TourExportDto reviewAreaTours(Collection<Tupel<AreaObjectModel, List<Model>>> var1, Collection<AreaTourParameter> var2, TourExportFormat var3, boolean var4, boolean var5) throws TourCalculationBlockException;

    public Collection<Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>> fetchAreaTourSchedulesWithTimeWindow(Collection<AreaObjectModel> var1, Date var2, Date var3);

    public AreaTourModel getAreaTourFromAreaObject(AreaObjectModel var1, AreaTourParameter var2);

    public void calculateAreaTour(AreaTourModel var1, ModelEnviroment var2, boolean var3) throws LogisticException;

    @Deprecated
    public void optimizeAreaTour(AreaTourModel var1, ModelEnviroment var2, OptimizationAlgorithmType var3) throws LogisticException;

    public TourExportDto findAloneInArea(Collection<AreaObjectModel> var1, Collection<AreaTourType> var2, TourExportFormat var3, Quad<String, String, String, String> var4, Integer var5, Integer var6, boolean var7);

    public Collection<AreaTourModel> fetchAreaToursById(Collection<Long> var1);

    public void calculateActualTour(TourModel var1);

    public List<AreaDelivererModel> getDeliverersAttachedToHistoyAreaTour();

    public void calculateTourOnlyServiceFinished(TourModel var1, RouteVehicleType var2, RouteType var3, ModelEnviroment var4, OptimizationAlgorithmType var5, TourRoutingContext var6) throws LogisticException;

    public DefaultExceptionResultDto clearDistanceMatrix(Collection<ImmutableEnvelopeDto> var1);

    public Collection<StopModel> fetchStopsWithBadSegment(boolean var1);

    public Collection<StopModel> fetchNotCheckedStops(boolean var1);

    public String generateTourName(Integer var1, String var2, Integer var3);

    public Collection<TourDifficultyLevelModel> fetchAllTourDifficultyLevels();

    public Double getSegmentSearchFactor();

    public BranchModel fetchBranchByNameAndType(String var1, BranchType var2);

    public List<DelivererModel> fetchDeliverersByBranch(BranchModel var1);

    public List<AreaDelivererModel> fetchAllAreaDeliverers();

    public List<TourModel> fetchToursInTimeIntervals(Collection<Tupel<Date, Date>> var1, boolean var2);

    public Collection<AreaDelivererModel> fetchAllAreaDeliverersForAreaLayer(Collection<AreaLayerModel> var1);

    public List<LetterModel> fetchLettersByAreaObject(AreaObjectModel var1, SubscriptionParameter var2);

    public Collection<DeliveryRoundModel> fetchAllDeliveryRounds();

    public Collection<TourModel> searchTours(TourSearchDto var1);

    public StopModel getStopById(Long var1);

    public List<AreaDelivererModel> fetchAreaDeliverersByBranch(BranchModel var1);

    public boolean isUsedDeliverRound(DeliveryRoundModel var1);

    public boolean existsTourWithName(String var1);
}

