/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.SubscriptionCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.base.SubscriptionAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.base.SubscriptionLocationDto;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;

public class SubscriptionCallerImpl
extends AbstractCaller
implements SubscriptionCaller {
    public SubscriptionCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public SubscriptionModel getSubscriptionByNumberLayerId(String subscriptionNumber, Long areaLayerId) {
        return (SubscriptionModel)this.convertDtoToModel(this.getGeoServerStub().getSubscriptionBi().getSubscriptionByNumberLayerId(subscriptionNumber, areaLayerId), new ValueChangeListener[0]);
    }

    @Override
    public SubscriptionModel getSubscriptionByNumberLayer(String subscriptionNumber, AreaLayerModel areaLayer) {
        return (SubscriptionModel)this.convertDtoToModel(this.getGeoServerStub().getSubscriptionBi().getSubscriptionByNumberLayer(subscriptionNumber, (AreaLayerDto)this.convertModelToDtoProxy(areaLayer)), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionModel> getSubscriptionByNumberLayerName(String subscriptionNumber, String areaLayerName) {
        return this.convertDtosToModels(this.getGeoServerStub().getSubscriptionBi().getSubscriptionByNumberLayerName(subscriptionNumber, areaLayerName), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionAttributeValueDescriptorModel> getAllSubscriptionAttributeValueDescriptors() {
        Collection<SubscriptionAttributeValueDescriptorDto> dtos = this.getGeoServerStub().getSubscriptionBi().getAllSubscriptionAttributeValueDescriptors();
        ArrayList<SubscriptionAttributeValueDescriptorModel> models = new ArrayList<SubscriptionAttributeValueDescriptorModel>(dtos.size());
        for (SubscriptionAttributeValueDescriptorDto dto : dtos) {
            models.add((SubscriptionAttributeValueDescriptorModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<SubscriptionFilterModel> fetchAllSubscriptionFilters() {
        return this.convertDtosToModels(this.getGeoServerStub().getSubscriptionBi().fetchAllSubscriptionFilters(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionFilterPatternSetupModel> fetchAllSubscriptionFilterPatternSetups() {
        return this.convertDtosToModels(this.getGeoServerStub().getSubscriptionBi().fetchAllSubscriptionFilterPatternSetups(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionFilterPatternSetupModel> fetchAllSubscriptionFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> layers) {
        List<AreaLayerDto> dtos = this.convertModelsToDtoProxies(layers);
        return this.convertDtosToModels(this.getGeoServerStub().getSubscriptionBi().fetchAllSubscriptionFilterPatternSetupsForAreaLayer(dtos), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionLocationObject> fetchSubscriptionsInRectangleForLayer(Coordinate topLeft, Coordinate bottomRight, AreaLayerModel layer) {
        AreaLayerDto layerDto = (AreaLayerDto)this.convertModelToDtoProxy(layer);
        Collection<SubscriptionLocationDto> subscriptionLocationDtos = this.getGeoServerStub().getSubscriptionBi().fetchSubscriptionsInRectangleForLayer(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)), layerDto);
        ArrayList<SubscriptionLocationObject> tupels = new ArrayList<SubscriptionLocationObject>(subscriptionLocationDtos.size());
        for (SubscriptionLocationDto subscriptionLocationDto : subscriptionLocationDtos) {
            tupels.add(new SubscriptionLocationObject((SubscriptionModel)this.convertDtoToModel(subscriptionLocationDto.getSubscriptionDto(), new ValueChangeListener[0]), (ImmutablePoint)subscriptionLocationDto.getImmutablePoint().getGeoObject()));
        }
        return tupels;
    }

    @Override
    public void updateSubscriptionObjectsValueByDescriptor(SubscriptionAttributeValueDescriptorModel selectedValueDescriptorModel, String value, boolean isToOverwriteNullValues) {
        this.getGeoServerStub().getSubscriptionBi().updateSubscriptionObjectsValueByDescriptor((SubscriptionAttributeValueDescriptorDto)this.convertModelToDtoProxy(selectedValueDescriptorModel), value, isToOverwriteNullValues);
    }

    @Override
    public List<SubscriptionModel> fetchSubscriptionsByIds(List<Long> ids) {
        return this.convertDtosToModels(this.getGeoServerStub().getSubscriptionBi().fetchSubscriptionsByIds(ids), new ValueChangeListener[0]);
    }
}

