/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.bi.StreetSearchBi;
import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.StreetSearchCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.importer.DefaultCsvDto;
import de.datomino.peppergis.dto.importer.DefaultCsvResultDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.lucene.ParcelSearchDto;
import de.datomino.peppergis.dto.map.CityDto;
import de.datomino.peppergis.dto.map.DistrictDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.PostcodeDto;
import de.datomino.peppergis.dto.search.AddressSearchType;
import de.datomino.util.international.country.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tupel;

public class StreetSearchCallerImpl
extends AbstractCaller
implements StreetSearchCaller {
    public StreetSearchCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public List<PostcodeModel> searchPostcodesStartsWith(Country country, String value, boolean withParcels) {
        StreetSearchBi streetSearchBi = this.getGeoServerStub().getStreetSearchBi();
        Collection<PostcodeDto> searched = streetSearchBi.searchPostcodesStartsWith(country, value, withParcels);
        return this.convertDtosToModels(searched, new ValueChangeListener[0]);
    }

    @Override
    public List<CityModel> searchCitiesStartsWith(PostcodeModel postcode, String value, boolean withParcels) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchCitiesStartsWith((PostcodeDto)((Object)postcode.createProxy()), value, withParcels), new ValueChangeListener[0]);
    }

    @Override
    public List<DistrictModel> searchDistrictsStartsWith(PostcodeModel postcode, CityModel city, String value, boolean withParcels) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchDistrictsStartsWith((PostcodeDto)((Object)postcode.createProxy()), (CityDto)((Object)city.createProxy()), value, withParcels), new ValueChangeListener[0]);
    }

    @Override
    public List<StreetModel> searchStreetsStartsWith(PostcodeModel postcode, CityModel city, DistrictModel district, String value, boolean withParcel) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchStreetsStartsWith((PostcodeDto)((Object)postcode.createProxy()), (CityDto)((Object)city.createProxy()), (DistrictDto)((Object)district.createProxy()), value, withParcel), new ValueChangeListener[0]);
    }

    @Override
    public List<Tupel<ParcelModel, Double>> searchParcelsFuzzy(Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension) {
        List<Tupel<ParcelDto, Double>> dtoTupels = this.getGeoServerStub().getStreetSearchBi().searchParcelsFuzzy(country, postcode, city, district, street, housenumber, housenumberExtension);
        ArrayList<Tupel<ParcelModel, Double>> tupels = new ArrayList<Tupel<ParcelModel, Double>>(dtoTupels.size());
        for (Tupel<ParcelDto, Double> tupel : dtoTupels) {
            tupels.add(new Tupel<ParcelModel, Double>((ParcelModel)this.convertDtoToModel((Dto)tupel.getElement1(), new ValueChangeListener[0]), tupel.getElement2()));
        }
        return tupels;
    }

    @Override
    public Collection<Tupel<ParcelModel, Double>> searchParcelsFuzzyAddress(ParcelSearchDto parcelSearchDto) {
        Collection<Tupel<ParcelDto, Double>> dtoTupels = this.getGeoServerStub().getStreetSearchBi().searchParcelsFuzzyAddress(parcelSearchDto);
        ArrayList<Tupel<ParcelModel, Double>> tupels = new ArrayList<Tupel<ParcelModel, Double>>(dtoTupels.size());
        for (Tupel<ParcelDto, Double> tupel : dtoTupels) {
            tupels.add(new Tupel<ParcelModel, Double>((ParcelModel)this.convertDtoToModel((Dto)tupel.getElement1(), new ValueChangeListener[0]), tupel.getElement2()));
        }
        return tupels;
    }

    @Override
    public Collection<StreetModel> searchStreetsWithPart(String part) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchStreetsWithPart(part), new ValueChangeListener[0]);
    }

    @Override
    public Collection<DistrictModel> searchDistrictWithPart(String part) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchDistrictWithPart(part), new ValueChangeListener[0]);
    }

    @Override
    public Collection<CityModel> searchCityWithPart(String part) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().searchCityWithPart(part), new ValueChangeListener[0]);
    }

    @Override
    public List<StreetModel> findStreetsFuzzy(Country country, String postcode, String city, String district, String street) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().findStreetsFuzzy(country, postcode, city, district, street), new ValueChangeListener[0]);
    }

    @Override
    public Collection<StreetModel> findStreetExact(Country country, String postcode, String city, String district, String street) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().findStreetExact(country, postcode, city, district, street), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelModel> findParcelExact(Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().findParcelExact(country, postcode, city, district, street, housenumber, housenumberExtension, false), new ValueChangeListener[0]);
    }

    @Override
    public DefaultCsvResultDto bulkSearchStreets(DefaultCsvDto csvDto) {
        return this.getGeoServerStub().getStreetSearchBi().bulkSearchStreets(csvDto);
    }

    @Override
    public DefaultCsvResultDto searchPostcodeDistrictRelation(GenericCsvDto csvDto, int maxCount, List<String> headerExtension, AddressSearchType addressSearchType, boolean duplicated) {
        return this.getGeoServerStub().getStreetSearchBi().searchPostcodeDistrictRelation(csvDto, maxCount, headerExtension, addressSearchType, duplicated);
    }

    @Override
    public DefaultCsvResultDto searchStreet(GenericCsvDto csvDto, int maxCount, List<String> headerExtension, AddressSearchType addressSearchType, boolean duplicated) {
        return this.getGeoServerStub().getStreetSearchBi().searchStreet(csvDto, maxCount, headerExtension, addressSearchType, duplicated);
    }

    @Override
    public DefaultCsvResultDto searchCoordinates(GenericCsvDto csvDto, int maxCount, List<String> headerExtension, boolean duplicated, int decimalPlaces, CoordinateFactory factory) {
        return this.getGeoServerStub().getStreetSearchBi().searchCoordinates(csvDto, maxCount, headerExtension, duplicated, decimalPlaces, factory);
    }

    @Override
    public Collection<CityModel> findCitiesExact(Country country, String postcode, String city) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().findCitiesExact(country, postcode, city), new ValueChangeListener[0]);
    }

    @Override
    public Collection<DistrictModel> findDistrictsExact(Country country, String postcode, String city, String district) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetSearchBi().findDistrictsExact(country, postcode, city, district), new ValueChangeListener[0]);
    }

    @Override
    public List<Tupel<ParcelModel, Double>> searchParcelsInternal(Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension) {
        List<Tupel<ParcelDto, Double>> dtoTupels = this.getGeoServerStub().getStreetSearchBi().searchParcelsInternal(country, postcode, city, district, street, housenumber, housenumberExtension);
        ArrayList<Tupel<ParcelModel, Double>> tupels = new ArrayList<Tupel<ParcelModel, Double>>(dtoTupels.size());
        for (Tupel<ParcelDto, Double> tupel : dtoTupels) {
            tupels.add(new Tupel<ParcelModel, Double>((ParcelModel)this.convertDtoToModel((Dto)tupel.getElement1(), new ValueChangeListener[0]), tupel.getElement2()));
        }
        return tupels;
    }
}

