/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.LocationQualifierDescriptorDto;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.filter.ParcelFilterModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PlaceModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.dto.location.RangeType;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePolygonDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.error.ErrorMessages;
import java.util.Collection;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public interface StreetNetCaller {
    public Collection<SegmentModel> fetchSegmentsWithType(Coordinate var1, Coordinate var2, SegmentType ... var3);

    public Collection<SegmentModel> fetchSegments(Coordinate var1, Coordinate var2);

    public Collection<PostcodeModel> fetchPostcodeAreas(Coordinate var1, Coordinate var2);

    public Collection<ParcelModel> fetchParcels(Coordinate var1, Coordinate var2, boolean var3);

    public ParcelModel fetchParcelById(Long var1);

    public List<ParcelModel> fetchParcelsByIds(List<Long> var1);

    public Collection<Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>> searchParcelOrCoordinateRange(Country var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, RangeType var10);

    public Collection<Tripel<ParcelModel, Double, String>> searchParcelRange(Country var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, RangeType var10);

    public Collection<Tupel<ImmutablePoint, Double>> searchCoordinateRange(Country var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, RangeType var10);

    public Collection<LogisticQualifiedLocationDto> searchAddress(LogisticLocationDto<Long> var1, Integer var2, boolean var3, boolean var4);

    public Collection<LogisticQualifiedLocationDto> searchAddressWithQualifiersParameterized(LogisticLocationDto<?> var1, Integer var2, LocationQualifierDescriptorDto<?>[] var3);

    public Collection<ParcelAttributeValueDescriptorModel> fetchAllParcelAttributeValueDescriptors();

    public Collection<PostcodeModel> fetchPostcodesForCountry(Country var1, boolean var2);

    public Collection<StreetModel> fetchStreetsByPostcodeDistrictRelations(Collection<PostcodeDistrictRelationModel> var1);

    public Collection<ParcelModel> fetchParcelsWithNullGeom();

    public String generateImportParcelKey(String var1);

    public Collection<ParcelModel> fetchNotCheckedParcels();

    public Collection<ParcelFilterModel> fetchAllParcelFilters();

    public Collection<ParcelFilterPatternSetupModel> fetchAllParcelFilterPatternSetups();

    public Collection<ParcelFilterPatternSetupModel> fetchAllParcelFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> var1);

    public Collection<PlaceModel> fetchPlaces(Coordinate var1, Coordinate var2);

    public ErrorMessages deleteParcels(Collection<ParcelModel> var1, ErrorMessages var2);

    public Collection<ParcelModel> fetchParcelsWithoutSegment(Coordinate var1, Coordinate var2);

    public Collection<ParcelModel> fetchParcelByStreet(StreetModel var1);

    public ParcelModel fetchParcelByImportKey(String var1);

    public Collection<ParcelModel> fetchParcelsWithoutAreaObject();

    public ImmutablePolygonDto getSegmentMaxEnvelope();

    public Collection<Tupel<Long, Long>> getForgeinRelsForLayer(Collection<Tupel<Long, Long>> var1, AreaLayerModel var2);

    public List<Tupel<ParcelModel, ParcelModel>> fetchDoubleAddressParcels();

    public void updateParcelObjectsValueByDescriptor(ParcelAttributeValueDescriptorModel var1, String var2, boolean var3);

    public Collection<ParcelModel> fetchParcelsWithBadSegment();

    public Tupel<Collection<ParcelModel>, Integer> searchParcelByNumberPart(String var1, Integer var2);

    public Collection<ImportedLocationModel> findImportLocationsExact(Country var1, String var2, String var3, String var4, String var5, Integer var6, String var7, boolean var8);

    public DefaultExportDto deleteParcelSegmentRelations(double var1, AreaObjectModel var3, PostcodeModel var4, boolean var5, boolean var6, boolean var7, boolean var8) throws ClientExportException;

    public Collection<ParcelModel> fetchParcelExact(Country var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public Collection<Collection<ParcelModel>> fetchMultipleAdressParcels();

    public List<Tupel<Country, Integer>> fetchPostcodesWithAtLeastOneParcel();

    public Collection<StreetModel> fetchStreetsWithAtLeastOneParcel(Collection<StreetModel> var1);
}

