/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.LetterCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.filter.LetterFilterModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.model.letter.LetterLocationObject;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.base.LetterDto;
import de.datomino.peppergis.dto.base.LetterLocationObjectDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;

public class LetterCallerImpl
extends AbstractCaller
implements LetterCaller {
    public LetterCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public Collection<LetterAttributeValueDescriptorModel> getAllLetterAttributeValueDescriptors() {
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().getAllLetterAttributeValueDescriptors(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterLocationObject> fetchLetterInRectangelForLayerAndDate(Coordinate topLeft, Coordinate bottomRight, Date start, Date end, AreaLayerModel layer) {
        AreaLayerDto layerDto = (AreaLayerDto)this.convertModelToDtoProxy(layer);
        Collection<LetterLocationObjectDto> letterLocationDtos = this.getGeoServerStub().getLetterBi().fetchLetterInRectangelForLayerAndDate(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)), start, end, layerDto);
        ArrayList<LetterLocationObject> tupels = new ArrayList<LetterLocationObject>(letterLocationDtos.size());
        for (LetterLocationObjectDto letterLocationDto : letterLocationDtos) {
            tupels.add(new LetterLocationObject((LetterModel)this.convertDtoToModel(letterLocationDto.getLetterDto(), new ValueChangeListener[0]), (ImmutablePoint)letterLocationDto.getImmutablePoint().getGeoObject()));
        }
        return tupels;
    }

    @Override
    public Collection<LetterFilterModel> fetchAllLetterFilters() {
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().fetchAllLetterFilters(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterFilterPatternSetupModel> fetchAllLetterFilterPatternSetups() {
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().fetchAllLetterFilterPatternSetups(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterFilterPatternSetupModel> fetchAllLetterFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> layers) {
        List<AreaLayerDto> areaLayerDtos = this.convertModelsToDtoProxies(layers);
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().fetchAllLetterFilterPatternSetupsForAreaLayer(areaLayerDtos), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterModel> fetchLettersByIds(List<Long> ids) {
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().fetchLettersByIds(ids), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterModel> processLettersWithoutParcel(boolean ignoreDistrict) {
        return this.convertDtosToModels(this.getGeoServerStub().getLetterBi().processLettersWithoutParcel(ignoreDistrict), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LetterModel> fetchLettersByParcels(Collection<ParcelModel> parcels, AreaLayerModel areaLayer) {
        AreaLayerDto layerDto = (AreaLayerDto)this.convertModelToDtoProxy(areaLayer);
        List<ParcelDto> parcelDtos = this.convertModelsToDtoProxies(parcels);
        Collection<LetterDto> letterDtos = this.getGeoServerStub().getLetterBi().fetchLettersByParcels(parcelDtos, layerDto);
        return this.convertDtosToModels(letterDtos, new ValueChangeListener[0]);
    }
}

