/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.ImportCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.importer.DelivererCsvImportDto;
import de.datomino.peppergis.dto.importer.DelivererImportReportDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.GeoTrackCsvImportDto;
import de.datomino.peppergis.dto.importer.GeoTrackImportResultDto;
import de.datomino.peppergis.dto.importer.ParcelAreaRelationImportResultDto;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.peppergis.dto.importer.ParcelImportResultDto;
import de.datomino.peppergis.dto.importer.PoiCsvImportDto;
import de.datomino.peppergis.dto.importer.PoiImportResultDto;
import de.datomino.peppergis.dto.importer.ResultDto;
import de.datomino.peppergis.dto.importer.SubscriptionImportDto;
import de.datomino.peppergis.dto.importer.SubscriptionImportReportDto;
import de.datomino.peppergis.dto.importer.TourCsvImportDto;
import de.datomino.peppergis.dto.importer.TourImportReportDto;
import de.datomino.peppergis.dto.location.SimpleAddressDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.exception.DelivererImportException;
import de.datomino.peppergis.exception.TourImportException;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import java.util.Collection;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class ImportCallerImpl
extends AbstractCaller
implements ImportCaller {
    public ImportCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public TourImportReportDto importTourCsv(TourCsvImportDto csvTourImportDto) {
        try {
            return this.getGeoServerStub().getImportBi().importTourCsv(csvTourImportDto);
        }
        catch (TourImportException e) {
            return e.getTourImportReportDto();
        }
    }

    @Override
    public SubscriptionImportReportDto importSubscriptionCsv(SubscriptionImportDto csvSubscriptionImportDto) throws ClientImportException {
        return this.getGeoServerStub().getImportBi().importSubscriptionCsv(csvSubscriptionImportDto);
    }

    @Override
    public PoiImportResultDto importPois(PoiCsvImportDto poiCsvImportDto) {
        return this.getGeoServerStub().getImportBi().importPois(poiCsvImportDto);
    }

    @Override
    public ResultDto importParcels(ParcelImportDto parcelImportDto) throws ClientImportException {
        return this.getGeoServerStub().getImportBi().importHouseCoordinateCsv(parcelImportDto);
    }

    @Override
    public ParcelAreaRelationImportResultDto importParcelAreaRelation(GenericCsvDto dto, boolean isUpdate, AreaLayerDto areaLayerDto, DeliveryRoundDto deliveryRoundDto) throws ClientImportException {
        return this.getGeoServerStub().getImportBi().importParcelAreaRelations(dto, isUpdate, areaLayerDto, deliveryRoundDto);
    }

    @Override
    public StreetModel getStreet(Country country, String postcodeName, String cityName, String districtName, String streetName) {
        return (StreetModel)this.convertDtoToModel(this.getGeoServerStub().getImportBi().getStreet(country, postcodeName, cityName, districtName, streetName), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> downloadPmdAreas(AreaLayerModel editBaseLayer, String key, String internalKey) throws ClientImportException {
        return this.convertDtosToModels(this.getGeoServerStub().getImportBi().downloadPmdAreas((AreaLayerDto)this.convertModelToDtoProxy(editBaseLayer), key, internalKey), new ValueChangeListener[0]);
    }

    @Override
    public DelivererImportReportDto importDeliverer(DelivererCsvImportDto dto) throws DelivererImportException {
        return this.getGeoServerStub().getImportBi().importDelivererCsv(dto);
    }

    @Override
    public DelivererImportReportDto importAreaDeliverer(DelivererCsvImportDto dto) throws DelivererImportException {
        return this.getGeoServerStub().getImportBi().importAreaDelivererCsv(dto);
    }

    @Override
    public GeoTrackImportResultDto importGeoTrackings(GeoTrackCsvImportDto geoTrackCsvImportDto) throws ClientImportException {
        return this.getGeoServerStub().getImportBi().importGeoTrackingsCsv(geoTrackCsvImportDto);
    }

    @Override
    public ParcelModel importSingleParcel(String importRef, Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension, Coordinate coord) {
        return (ParcelModel)this.convertDtoToModel(this.getGeoServerStub().getImportBi().importSingleParcel(importRef, country, postcode, city, district, street, housenumber, housenumberExtension, ImmutablePointDto.create(coord == null ? null : ImmutableGeoObjectFactory.createImmutablePoint(coord))), new ValueChangeListener[0]);
    }

    @Override
    public Tupel<Collection<ParcelModel>, ParcelImportResultDto> importParcelsSetId(Collection<SimpleAddressDto> addresses, Integer idLength, String idPrefix) {
        Tupel<Collection<ParcelDto>, ParcelImportResultDto> importParcelsSetId = this.getGeoServerStub().getImportBi().importParcelsSetId(addresses, idLength, idPrefix);
        List convertDtosToModels = this.convertDtosToModels(importParcelsSetId.getElement1(), new ValueChangeListener[0]);
        return new Tupel<Collection<ParcelModel>, ParcelImportResultDto>(convertDtosToModels, importParcelsSetId.getElement2());
    }

    @Override
    public Collection<Tripel<String, String, Collection<String>>> getPmdUploadedAreaNames() throws ClientImportException {
        return this.getGeoServerStub().getImportBi().getPmdUploadedAreaNames();
    }
}

