/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.CustomerSearchCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.lucene.CustomerSearchDto;
import java.util.Collection;
import java.util.List;
import org.ktde.model.ValueChangeListener;

public class CustomerSearchCallerImpl
extends AbstractCaller
implements CustomerSearchCaller {
    public CustomerSearchCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public List<CustomerModel> searchCustomersByCustomerNumberPrefix(String prefix, Integer maxResult) {
        List<CustomerDto> dtos = this.getGeoServerStub().getCustomerSearchBi().searchCustomersByCustomerNumberPrefix(prefix, maxResult);
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public List<CustomerModel> searchCustomers(CustomerSearchDto customerSearchDto, Integer maxResults) {
        return this.convertDtosToModels(this.getGeoServerStub().getCustomerSearchBi().searchCustomers(customerSearchDto, maxResults), new ValueChangeListener[0]);
    }

    @Override
    public Collection<CustomerModel> getCustomerByNumber(String customerNumber) {
        return this.convertDtosToModels(this.getGeoServerStub().getCustomerSearchBi().getCustomerByNumber(customerNumber), new ValueChangeListener[0]);
    }

    @Override
    public List<CustomerModel> searchOfferCustomers(CustomerSearchDto customerSearchDto, Integer maxResults) {
        return this.convertDtosToModels(this.getGeoServerStub().getCustomerSearchBi().searchOfferCustomers(customerSearchDto, maxResults), new ValueChangeListener[0]);
    }

    @Override
    public List<CustomerModel> searchOfferCustomersExact(CustomerSearchDto customerSearchDto, int maxResults) {
        return this.convertDtosToModels(this.getGeoServerStub().getCustomerSearchBi().searchCustomersExact(customerSearchDto, maxResults, true), new ValueChangeListener[0]);
    }
}

