/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PdfModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PrintContentModel;
import de.datomino.peppergis.client.model.base.PrintParameterModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.wrapper.LocationableObjectsModelWrapper;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.base.ImageDto;
import de.datomino.peppergis.dto.base.ImportedLocationDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.PoiAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.base.PrintContentDto;
import de.datomino.peppergis.dto.base.PrintParameterDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.location.LocationableObjectsDto;
import de.datomino.peppergis.dto.lucene.PoiSearchDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.offer.AgencyDto;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tupel;

public class BaseCallerImpl
extends AbstractCaller
implements BaseCaller {
    private Country defaultCountry;

    public BaseCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public Collection<ImageModel> getAllImages() {
        Collection<ImageDto> images = this.getGeoServerStub().getBaseBi().getAllImages();
        return this.convertDtosToModels(images, new ValueChangeListener[0]);
    }

    @Override
    public ImageModel getImageById(Long id) {
        return (ImageModel)this.convertDtoToModel(this.getGeoServerStub().getBaseBi().getImageById(id), new ValueChangeListener[0]);
    }

    @Override
    public byte[] getDefaultImage() {
        return this.getGeoServerStub().getBaseBi().fetchDefaultImage();
    }

    @Override
    public Collection<PoiFilterModel> fetchAllPoiFilters() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchAllPoiFilters(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiFilterPatternSetupModel> fetchAllPoiFilterPatternSetups() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchAllPoiFilterPatternSetups(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiAttributeValueDescriptorModel> getAllPoiAttributeValueDescriptors() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getAllPoiAttributeValueDescriptors(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiModel> fetchPoisInRectangle(Coordinate topLeft, Coordinate bottomRight) {
        Collection<PoiDto> poiDtos = this.getGeoServerStub().getBaseBi().fetchPoisInRectangle(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)));
        return this.convertDtosToModels(poiDtos, new ValueChangeListener[0]);
    }

    @Override
    public List<LogisticQualifiedLocationDto> geocode(LogisticLocationDto<Long> logisticLocationDto, Integer maxCount) {
        return this.getGeoServerStub().getBaseBi().geocode(logisticLocationDto, maxCount);
    }

    @Override
    public Collection<SubscriptionModel> fetchSubscriptionsWithNullGeom() {
        Collection<SubscriptionDto> dtos = this.getGeoServerStub().getBaseBi().fetchSubscriptionsWithNullGeom();
        ArrayList<SubscriptionModel> models = new ArrayList<SubscriptionModel>(dtos.size());
        for (SubscriptionDto dto : dtos) {
            models.add((SubscriptionModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<AgencyModel> getAllAgencies() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getAllAgencies(), new ValueChangeListener[0]);
    }

    @Override
    public boolean isAgencyDeletable(AgencyModel agency) {
        return this.getGeoServerStub().getBaseBi().isAgencyDeletable((AgencyDto)this.convertModelToDtoProxy(agency));
    }

    @Override
    public String getNextCustomerNumber() {
        return this.getGeoServerStub().getBaseBi().getNextCustomerNumber();
    }

    @Override
    public Collection<SubscriptionModel> fetchSubscriptionsWithNoMatching() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchSubscriptionsWithNoMatching(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionModel> processSubscriptionsWithoutParcel(boolean ignoreDistrict) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().processSubscriptionsWithoutParcel(ignoreDistrict), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiFilterPatternSetupModel> fetchAllPoiFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> areaLayerModels) {
        List<AreaLayerDto> dtos = this.convertModelsToDtoProxies(areaLayerModels);
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchAllPoiFilterPatternSetupsForAreaLayer(dtos), new ValueChangeListener[0]);
    }

    @Override
    public Tupel<ImmutablePoint, ImmutablePoint> getPoiGeometricalBounds() {
        return this.getGeoServerStub().getBaseBi().getPoiGeometricalBounds();
    }

    @Override
    public ImageModel getImageByName(String name) {
        return (ImageModel)this.convertDtoToModel(this.getGeoServerStub().getBaseBi().getImageByName(name), new ValueChangeListener[0]);
    }

    @Override
    public Collection<LocationModel> getLocationsForParcel(ParcelModel parcelModel) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getLocationsForParcel((ParcelDto)this.convertModelToDtoProxy(parcelModel)), new ValueChangeListener[0]);
    }

    @Override
    public String getDefaultPdfSignature() {
        return this.getGeoServerStub().getBaseBi().getDefaultPdfSignature();
    }

    @Override
    public Collection<AttributeGroupModel> getAttributeGroupForType(AttributeGroupType ... types) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getAttributeGroupForType(types), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiModel> fetchPoiByIds(Collection<Long> ids) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchPoisByIds(ids), new ValueChangeListener[0]);
    }

    @Override
    public PoiModel fetchPoiByNumber(String poi) {
        return (PoiModel)this.convertDtoToModel(this.getGeoServerStub().getBaseBi().fetchPoiByNumber(poi), new ValueChangeListener[0]);
    }

    @Override
    public Collection<SubscriptionModel> fetchSubscriptionsByParcels(Collection<ParcelModel> parcels, AreaLayerModel areaLayer) {
        List<ParcelDto> parcelDtos = this.convertModelsToDtoProxies(parcels);
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchSubscriptionsByParcels(parcelDtos, (AreaLayerDto)this.convertModelToDtoProxy(areaLayer)), new ValueChangeListener[0]);
    }

    @Override
    public void updatePoiObjectsValueByDescriptor(PoiAttributeValueDescriptorModel selectedValueDescriptorModel, String value, boolean isToOverwriteNullValues) {
        this.getGeoServerStub().getBaseBi().updatePoiObjectsValueByDescriptor((PoiAttributeValueDescriptorDto)this.convertModelToDtoProxy(selectedValueDescriptorModel), value, isToOverwriteNullValues);
    }

    @Override
    public Collection<SubscriptionModel> fetchSubscriptionsWithBadSegment() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchSubscriptionsWithBadSegment(), new ValueChangeListener[0]);
    }

    @Override
    public boolean isLocationAttachedToAnyObject(LocationModel location) {
        return this.getGeoServerStub().getBaseBi().isLocationAttachedToAnyObject((LocationDto)this.convertModelToDtoProxy(location));
    }

    @Override
    public Collection<PoiModel> fetchPoisWithNullGeom() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchPoisWithNullGeom(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<? extends PoiModel> fetchNotCheckedPois() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().fetchNotCheckedPois(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<Model> getLocationAttached(LocationModel location) {
        LocationDto locationDto = (LocationDto)this.convertModelToDtoProxy(location);
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getLocationAttached(locationDto), new ValueChangeListener[0]);
    }

    @Override
    public boolean isPoiAttachedToAnyObject(PoiModel poi) {
        return this.getGeoServerStub().getBaseBi().isPoiAttachedToAnyObject((PoiDto)this.convertModelToDtoProxy(poi));
    }

    @Override
    public Collection<PoiModel> searchPoi(PoiSearchDto poiSearchDto, boolean allowWildcard) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().searchPois(poiSearchDto, allowWildcard), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PoiModel> searchPoi(PoiSearchDto poiSearchDto, boolean fuzzy, boolean allowWildcard) {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().searchPoisWithWildcard(poiSearchDto, fuzzy, allowWildcard), new ValueChangeListener[0]);
    }

    @Override
    public Date getCurrentServerTime() {
        return this.getGeoServerStub().getBaseBi().getCurrentServerTime();
    }

    @Override
    public LocationableObjectsModelWrapper getObjectsAttachedToImportedLocation(ImportedLocationModel importedLocation) {
        LocationableObjectsDto dto = this.getGeoServerStub().getBaseBi().getObjectsAttachedToImportedLocation((ImportedLocationDto)this.convertModelToDtoProxy(importedLocation));
        LocationableObjectsModelWrapper wrapper = new LocationableObjectsModelWrapper();
        List customerModels = this.convertDtosToModels(dto.getCustomers(), new ValueChangeListener[0]);
        wrapper.getCustomers().addAll(customerModels);
        List poiModels = this.convertDtosToModels(dto.getPois(), new ValueChangeListener[0]);
        wrapper.getPois().addAll(poiModels);
        List stopModels = this.convertDtosToModels(dto.getStops(), new ValueChangeListener[0]);
        wrapper.getStops().addAll(stopModels);
        List subscriptionModels = this.convertDtosToModels(dto.getSubscriptions(), new ValueChangeListener[0]);
        wrapper.getSubscriptions().addAll(subscriptionModels);
        return wrapper;
    }

    @Override
    public Collection<PdfModel> getAllPdfs() {
        return this.convertDtosToModels(this.getGeoServerStub().getBaseBi().getAllPdfs(), new ValueChangeListener[0]);
    }

    @Override
    public PrintProperties fetchPrintProperties() {
        return this.getGeoServerStub().getBaseBi().fetchPrintProperties();
    }

    @Override
    public Tupel<Collection<PrintContentModel>, Collection<PrintParameterModel>> fetchAllPrintObjects() {
        Tupel<Collection<PrintContentDto>, Collection<PrintParameterDto>> dtosTupel = this.getGeoServerStub().getBaseBi().fetchAllPrintObjects();
        Tupel<Object, Object> modelsTupel = new Tupel<Object, Object>(null, null);
        List models1 = this.convertDtosToModels(dtosTupel.getElement1(), new ValueChangeListener[0]);
        List models2 = this.convertDtosToModels(dtosTupel.getElement2(), new ValueChangeListener[0]);
        modelsTupel.setElement1(models1);
        modelsTupel.setElement2(models2);
        return modelsTupel;
    }

    @Override
    public Long getMainDelivererLocationPoiId() {
        return this.getGeoServerStub().getBaseBi().getMainDelivererLocationPoiId();
    }

    @Override
    public PoiModel fetchPoiByLocationAndType(LocationModel location, PoiType poiType) {
        PoiDto poiDto = this.getGeoServerStub().getBaseBi().fetchPoiByLocationAndType((LocationDto)this.convertModelToDtoProxy(location), poiType);
        return (PoiModel)this.convertDtoToModel(poiDto, new ValueChangeListener[0]);
    }

    @Override
    public Properties getAllServerProperties() {
        return this.getGeoServerStub().getBaseBi().getAllServerProperties();
    }

    @Override
    public boolean savePropertiesToServer(Properties currentProperties) {
        return this.getGeoServerStub().getBaseBi().savePropertiesToServer(currentProperties);
    }

    @Override
    public void updateUserProperties(Properties properties) {
        Properties allProperties = new Properties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = properties.getProperty(key);
            allProperties.setProperty(key, value);
        }
        this.getGeoServerStub().getBaseBi().updateUserProperties(allProperties);
    }

    @Override
    public Properties getUserProperties() {
        return this.getGeoServerStub().getBaseBi().getUserProperties();
    }

    @Override
    public Country getDefaultCountry() {
        if (this.defaultCountry == null) {
            this.defaultCountry = this.getGeoServerStub().getBaseBi().getDefaultCountry();
        }
        return this.defaultCountry;
    }
}

