/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PdfModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PrintContentModel;
import de.datomino.peppergis.client.model.base.PrintParameterModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.wrapper.LocationableObjectsModelWrapper;
import de.datomino.peppergis.dto.lucene.PoiSearchDto;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.datatypes.Tupel;

public interface BaseCaller {
    public Collection<ImageModel> getAllImages();

    public ImageModel getImageById(Long var1);

    public byte[] getDefaultImage();

    public Collection<PoiFilterModel> fetchAllPoiFilters();

    public Collection<PoiFilterPatternSetupModel> fetchAllPoiFilterPatternSetups();

    public Collection<PoiFilterPatternSetupModel> fetchAllPoiFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> var1);

    public Collection<PoiAttributeValueDescriptorModel> getAllPoiAttributeValueDescriptors();

    public Collection<PoiModel> fetchPoisInRectangle(Coordinate var1, Coordinate var2);

    public List<LogisticQualifiedLocationDto> geocode(LogisticLocationDto<Long> var1, Integer var2);

    public Collection<SubscriptionModel> fetchSubscriptionsWithNullGeom();

    public Collection<SubscriptionModel> fetchSubscriptionsWithNoMatching();

    public Collection<AgencyModel> getAllAgencies();

    public boolean isAgencyDeletable(AgencyModel var1);

    public String getNextCustomerNumber();

    public ImageModel getImageByName(String var1);

    public Collection<LocationModel> getLocationsForParcel(ParcelModel var1);

    public Tupel<ImmutablePoint, ImmutablePoint> getPoiGeometricalBounds();

    public String getDefaultPdfSignature();

    public Collection<AttributeGroupModel> getAttributeGroupForType(AttributeGroupType ... var1);

    public Collection<PoiModel> fetchPoiByIds(Collection<Long> var1);

    public PoiModel fetchPoiByNumber(String var1);

    public Collection<SubscriptionModel> fetchSubscriptionsByParcels(Collection<ParcelModel> var1, AreaLayerModel var2);

    public void updatePoiObjectsValueByDescriptor(PoiAttributeValueDescriptorModel var1, String var2, boolean var3);

    public Collection<SubscriptionModel> fetchSubscriptionsWithBadSegment();

    public boolean isLocationAttachedToAnyObject(LocationModel var1);

    public Collection<PoiModel> fetchPoisWithNullGeom();

    public Collection<? extends PoiModel> fetchNotCheckedPois();

    public Collection<Model> getLocationAttached(LocationModel var1);

    public boolean isPoiAttachedToAnyObject(PoiModel var1);

    public Collection<PoiModel> searchPoi(PoiSearchDto var1, boolean var2);

    public Collection<PoiModel> searchPoi(PoiSearchDto var1, boolean var2, boolean var3);

    public Date getCurrentServerTime();

    public LocationableObjectsModelWrapper getObjectsAttachedToImportedLocation(ImportedLocationModel var1);

    public Collection<PdfModel> getAllPdfs();

    public PrintProperties fetchPrintProperties();

    public Tupel<Collection<PrintContentModel>, Collection<PrintParameterModel>> fetchAllPrintObjects();

    public Long getMainDelivererLocationPoiId();

    public PoiModel fetchPoiByLocationAndType(LocationModel var1, PoiType var2);

    public Properties getAllServerProperties();

    public boolean savePropertiesToServer(Properties var1);

    public void updateUserProperties(Properties var1);

    public Properties getUserProperties();

    public Country getDefaultCountry();

    public Collection<SubscriptionModel> processSubscriptionsWithoutParcel(boolean var1);
}

