/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.area.MakroParameter;
import de.datomino.peppergis.client.areagenerator.DefaultUnionAreaGenerator;
import de.datomino.peppergis.client.areagenerator.FreehandAreaGenerator;
import de.datomino.peppergis.client.areagenerator.UnionAreaGenerator;
import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.listener.AreaObjectDetaillessUpdateListener;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.area.AreaAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.area.AreaFilterPatternSetupDto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.DetaillessAreaObjectGeometryDto;
import de.datomino.peppergis.dto.base.SubscriptionAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.filter.AreaFilterDto;
import de.datomino.peppergis.dto.map.ParcelAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.type.AggregateType;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.MicrocellDescriptorType;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import de.datomino.util.message.error.ErrorMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class AreaCallerImpl
extends AbstractCaller
implements AreaCaller {
    private static final Integer DEFAULT_MAX_SIDE_COUNT = 2000;
    private AreaObjectDetaillessUpdateListener areaObjectDetaillessUpdateListener = new AreaObjectDetaillessUpdateListener(this);

    public AreaCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public Collection<AreaLayerModel> getAreaLayer(String layername) {
        Collection<AreaLayerDto> dtos = this.getGeoServerStub().getAreaBi().getAreaLayer(layername);
        ArrayList<AreaLayerModel> models = new ArrayList<AreaLayerModel>(dtos.size());
        for (AreaLayerDto dto : dtos) {
            AreaLayerModel model = (AreaLayerModel)this.getModelCache().getModel(dto);
            models.add(model);
            model.addValueChangeListener(this.areaObjectDetaillessUpdateListener);
        }
        return models;
    }

    @Override
    public Collection<AreaLayerModel> getAreaLayerForIds(Collection<Long> layerIds) {
        Collection<AreaLayerDto> dtos = this.getGeoServerStub().getAreaBi().getAreaLayerForIds(layerIds);
        List<AreaLayerModel> models = this.convertDtosToModels(dtos, new ValueChangeListener[0]);
        return models;
    }

    @Override
    public AreaLayerModel getAreaLayer(Long layerid) {
        return (AreaLayerModel)this.getModelCache().getModel(this.getGeoServerStub().getAreaBi().getAreaLayerById(layerid));
    }

    @Override
    public Collection<AreaObjectModel> fetchAreaObjects(AreaLayerModel areaLayerModel, Coordinate topLeft, Coordinate bottomRight) {
        Collection<AreaObjectDto> dtos = this.getGeoServerStub().getAreaBi().fetchAreaObjects(((AreaLayerModelImpl)areaLayerModel).createProxy(), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)));
        List<AreaObjectModel> models = this.convertDtosToModels(dtos, this.areaObjectDetaillessUpdateListener);
        return models;
    }

    @Override
    public List<AreaObjectModel> fetchAreaObjectsByAreaLayer(AreaLayerModel areaLayerModel, boolean extendWithAreaDeliveryRounds) {
        List<AreaObjectDto> dtos = this.getGeoServerStub().getAreaBi().fetchAreaObjectsByAreaLayer(((AreaLayerModelImpl)areaLayerModel).createProxy(), extendWithAreaDeliveryRounds);
        ArrayList<AreaObjectModel> models = new ArrayList<AreaObjectModel>(dtos.size());
        for (AreaObjectDto dto : dtos) {
            AreaObjectModel model = (AreaObjectModel)this.getModelCache().getModel(dto);
            model.addValueChangeListener(this.areaObjectDetaillessUpdateListener);
            models.add(model);
        }
        return models;
    }

    @Override
    public AreaObjectModel fetchAreaObject(AreaLayerModel areaLayerModel, String key) {
        AreaObjectModel model = (AreaObjectModel)this.getModelCache().getModel(this.getGeoServerStub().getAreaBi().fetchAreaObject(((AreaLayerModelImpl)areaLayerModel).createProxy(), key));
        if (model != null) {
            model.addValueChangeListener(this.areaObjectDetaillessUpdateListener);
        }
        return model;
    }

    @Override
    public void createAreaGeometryReplace(AreaObjectModel selectedObject, Collection<AreaObjectModel> objectMarkSets, Collection<ImmutablePolygonKind> freeHands, Integer maxSideCount, ModelEnviroment modelEnviroment) {
        switch (selectedObject.getAreaLayer().getDiscriminator()) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                if (objectMarkSets == null || objectMarkSets.isEmpty()) {
                    return;
                }
                AreaObjectModelUtil.updateNumberAttributeValues(selectedObject, objectMarkSets, AreaObjectModelUtil.AreaObjectChangeType.REPLACE);
                this.getUnionAreaGenerator().createAreaGeometryReplaceAreaObjects(selectedObject, objectMarkSets, modelEnviroment);
                break;
            }
            case AREA_OBJECT_GEN_FREEHAND: {
                FreehandAreaGenerator.INSTANCE.createAreaGeometryReplace(selectedObject, freeHands, modelEnviroment);
                break;
            }
        }
    }

    @Override
    public void createAreaGeometryReplace(AreaObjectModel selectedObject, Collection<AreaObjectModel> objectMarkSets, Collection<ImmutablePolygonKind> freeHands, ModelEnviroment modelEnviroment) {
        this.createAreaGeometryReplace(selectedObject, objectMarkSets, freeHands, DEFAULT_MAX_SIDE_COUNT, modelEnviroment);
    }

    @Override
    public void createAreaGeometryRemove(AreaObjectModel selectedObject, Collection<AreaObjectModel> objectMarkSets, Collection<ImmutablePolygonKind> freehandSelection, ModelEnviroment modelEnviroment) {
        AreaObjectGenInfoDiscriminator discriminator;
        AreaLayerModel areaLayer;
        if (selectedObject != null && (areaLayer = selectedObject.getAreaLayer()) != null && (discriminator = areaLayer.getDiscriminator()) != null) {
            switch (discriminator) {
                case AREA_OBJECT_GEN_AREA_OBJECT: {
                    if (objectMarkSets == null || objectMarkSets.isEmpty()) break;
                    AreaObjectModelUtil.updateNumberAttributeValues(selectedObject, objectMarkSets, AreaObjectModelUtil.AreaObjectChangeType.REMOVE);
                    this.getUnionAreaGenerator().createAreaGeometryRemoveAreaObjects(selectedObject, objectMarkSets, modelEnviroment);
                    break;
                }
                case AREA_OBJECT_GEN_FREEHAND: {
                    if (freehandSelection == null || freehandSelection.isEmpty()) break;
                    FreehandAreaGenerator.INSTANCE.createAreaGeometryRemovePolygons(selectedObject, freehandSelection, modelEnviroment);
                    break;
                }
            }
        }
    }

    @Override
    public void createAreaGeometryAdd(AreaObjectModel selectedObject, Collection<AreaObjectModel> objectMarkSets, Collection<ImmutablePolygonKind> freehandSelection, ModelEnviroment modelEnviroment) {
        if (selectedObject != null) {
            switch (selectedObject.getAreaLayer().getDiscriminator()) {
                case AREA_OBJECT_GEN_AREA_OBJECT: {
                    if (objectMarkSets == null || objectMarkSets.isEmpty()) break;
                    AreaObjectModelUtil.updateNumberAttributeValues(selectedObject, objectMarkSets, AreaObjectModelUtil.AreaObjectChangeType.ADD);
                    this.getUnionAreaGenerator().createAreaGeometryAddAreaObjects(selectedObject, objectMarkSets, modelEnviroment);
                    break;
                }
                case AREA_OBJECT_GEN_FREEHAND: {
                    FreehandAreaGenerator.INSTANCE.createAreaGeometryAddPolygons(selectedObject, freehandSelection, modelEnviroment);
                    break;
                }
            }
        }
    }

    private UnionAreaGenerator getUnionAreaGenerator() {
        return DefaultUnionAreaGenerator.INSTANCE;
    }

    @Override
    public Collection<AreaObjectModel> getAreaObjectByKey(Collection<String> areaKeys) {
        Collection<AreaObjectDto> areaObjectDtos = this.getGeoServerStub().getAreaBi().getAreaObjectsByKey(areaKeys);
        return this.convertDtosToModels(areaObjectDtos, this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public Collection<AreaObjectModel> fetchAreaObjectsById(Collection<Long> ids) {
        Collection<AreaObjectDto> areaObjectDtos = this.getGeoServerStub().getAreaBi().fetchAreaObjectsById(ids);
        return this.convertDtosToModels(areaObjectDtos, this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public Collection<AreaObjectModel> fetchAreaObjects(AreaLayerModel areaLayerModel, Collection<String> keys) {
        Collection<AreaObjectDto> areaObjectDtos = this.getGeoServerStub().getAreaBi().fetchAreaObjectsByAreaLayerAndKeys(((AreaLayerModelImpl)areaLayerModel).createProxy(), keys);
        return this.convertDtosToModels(areaObjectDtos, this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public Collection<AreaAttributeValueDescriptorModel> fetchAllAreaAttributeValueDescriptors() {
        Collection<AreaAttributeValueDescriptorDto> dtos = this.getGeoServerStub().getAreaBi().fetchAllAreaAttributeValueDescriptors();
        ArrayList<AreaAttributeValueDescriptorModel> models = new ArrayList<AreaAttributeValueDescriptorModel>(dtos.size());
        for (AreaAttributeValueDescriptorDto dto : dtos) {
            models.add((AreaAttributeValueDescriptorModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<AreaFilterModel> fetchAllAreaFilters() {
        Collection<AreaFilterDto> dtos = this.getGeoServerStub().getAreaBi().fetchAllAreaFilters();
        ArrayList<AreaFilterModel> models = new ArrayList<AreaFilterModel>(dtos.size());
        for (AreaFilterDto dto : dtos) {
            models.add((AreaFilterModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<AreaFilterPatternSetupModel> fetchAllAreaFilterPatternSetupModels() {
        Collection<AreaFilterPatternSetupDto> dtos = this.getGeoServerStub().getAreaBi().fetchAllAreaFilterPatternSetups();
        ArrayList<AreaFilterPatternSetupModel> models = new ArrayList<AreaFilterPatternSetupModel>(dtos.size());
        for (AreaFilterPatternSetupDto dto : dtos) {
            models.add((AreaFilterPatternSetupModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<AreaLayerModel> getAreaLayersForType(AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminator) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().getAreaLayersForType(areaObjectGenInfoDiscriminator), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> findAreasWithCoordWithin(Coordinate coordinate, long ... layerIds) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().findAreasWithCoordWithin(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(coordinate)), layerIds), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public List<AreaObjectModel> fetchAreaObjectsByLayerAndPrefixes(AreaLayerModel areaLayer, String shortcut, String displayName, Integer maxCount) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().fetchAreaObjectsByLayerAndPrefixes((AreaLayerDto)this.convertModelToDtoProxy(areaLayer), shortcut, displayName, maxCount), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public void copyAndReduceLayer(AreaLayerModel areaLayer, String newLayerName, double optimizeForUpp) {
        this.getGeoServerStub().getAreaBi().copyAndReduceLayer((AreaLayerDto)this.convertModelToDtoProxy(areaLayer), newLayerName, optimizeForUpp);
    }

    @Override
    public Collection<Tupel<Long, String>> fetchAreaIdNameTupelsByAreaLayer(AreaLayerModel areaLayerModel) {
        return this.getGeoServerStub().getAreaBi().fetchAreaIdNameTupelsByAreaLayer((AreaLayerDto)this.convertModelToDtoProxy(areaLayerModel));
    }

    @Override
    public Collection<AreaObjectModel> getAreaObjectByKeysAndLayerIds(Collection<String> areaKeys, Collection<Long> layerIds) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().getAreaObjectsByKeyAndLayerIds(areaKeys, layerIds), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public void calcAreasFromParcels(AreaLayerModel areaLayer, boolean reduceOverlappings, boolean includeSegmentConnectionPoints) {
        this.getGeoServerStub().getAreaBi().calcAreasFromParcels((AreaLayerDto)((Object)areaLayer.createProxy()), reduceOverlappings, includeSegmentConnectionPoints);
    }

    @Override
    public Collection<AreaFilterPatternSetupModel> fetchAllAreaFilterPatternSetupModelsForAreaLayer(Collection<AreaLayerModel> areaLayers) {
        List<AreaLayerDto> dtos = this.convertModelsToDtoProxies(areaLayers);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().fetchAllAreaFilterPatternSetupModelsForAreaLayer(dtos), new ValueChangeListener[0]);
    }

    @Override
    public List<Tripel<Long, String, String>> getAreaObjectsIdAndCaptionsForLayer(AreaLayerModel areaLayerModel) {
        return this.getGeoServerStub().getAreaBi().getAreaObjectsIdAndCaptionsForLayer((AreaLayerDto)this.convertModelToDtoProxy(areaLayerModel));
    }

    @Override
    public Tupel<ImmutablePoint, ImmutablePoint> getTopLeftAndBottomRightForLayer(AreaLayerModel areaLayerModel, Set<Long> areaObjectIdsNotToShow) {
        Tupel<ImmutablePointDto, ImmutablePointDto> tupel = this.getGeoServerStub().getAreaBi().getTopLeftAndBottomRightForLayer((AreaLayerDto)this.convertModelToDtoProxy(areaLayerModel), areaObjectIdsNotToShow);
        return tupel == null ? null : new Tupel(tupel.getElement1().getGeoObject(), tupel.getElement2().getGeoObject());
    }

    @Override
    public Collection<AreaObjectModel> calculateCover(Collection<AreaObjectModel> areaObjects, Collection<ImmutablePolygonKind> otherPolygons, AreaLayerModel targetLayer, Double percentage) {
        List<AreaObjectDto> sourceAreaObjects = this.convertModelsToFullDtos(areaObjects);
        AreaLayerDto targetLayerDto = (AreaLayerDto)this.convertModelToDtoProxy(targetLayer);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().calculateCover(sourceAreaObjects, ImmutablePolygonKindDto.createList(otherPolygons), targetLayerDto, percentage), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public void aggregateSubAreaAttributeValues(AreaLayerModel targetLayer, AreaAttributeValueDescriptorModel targetDescriptor, AreaAttributeValueDescriptorModel sourceDescriptor, AggregateType aggregateType) {
        this.getGeoServerStub().getAreaBi().aggregateSubAreaAttributeValues((AreaLayerDto)this.convertModelToDtoProxy(targetLayer), (AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(targetDescriptor), (AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(sourceDescriptor), aggregateType);
    }

    @Override
    public void aggregateParcelAttributeValues(AreaLayerModel targetLayer, AreaAttributeValueDescriptorModel targetDescriptor, ParcelAttributeValueDescriptorModel sourceDescriptor, AggregateType aggregateType) {
        this.getGeoServerStub().getAreaBi().aggregateParcelAttributeValues((AreaLayerDto)this.convertModelToDtoProxy(targetLayer), (AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(targetDescriptor), (ParcelAttributeValueDescriptorDto)this.convertModelToDtoProxy(sourceDescriptor), aggregateType);
    }

    @Override
    public void aggregateSubscriptionAttributeValues(AreaLayerModel targetLayer, AreaAttributeValueDescriptorModel targetDescriptor, SubscriptionAttributeValueDescriptorModel sourceDescriptor, AggregateType aggregateType) {
        this.getGeoServerStub().getAreaBi().aggregateSubscriptionAttributeValues((AreaLayerDto)this.convertModelToDtoProxy(targetLayer), (AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(targetDescriptor), (SubscriptionAttributeValueDescriptorDto)this.convertModelToDtoProxy(sourceDescriptor), aggregateType);
    }

    @Override
    public void createParcelAreaRelationsForLayerByGeometry(AreaLayerModel targetLayer, boolean keepSetParcels) {
        this.getGeoServerStub().getAreaBi().createParcelAreaRelationsForLayerByGeometry((AreaLayerDto)this.convertModelToDtoProxy(targetLayer), keepSetParcels);
    }

    @Override
    public Collection<AreaAttributeValueModel> getAreaAttributeValuesByAreaObject(AreaObjectModel areaObject) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().getAreaAttributeValuesByAreaObject((AreaObjectDto)this.convertModelToDtoProxy(areaObject)), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> fetchAreaObjectsWithoutIds(AreaLayerModel areaLayerModel, Coordinate topLeft, Coordinate bottomRight, Collection<Long> excludedIds) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().fetchAreaObjectsWithoutIds((AreaLayerDto)this.convertModelToDtoProxy(areaLayerModel), topLeft == null ? null : ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), bottomRight == null ? null : ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)), excludedIds), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public Collection<Tupel<AreaObjectModel, List<Double>>> getDetaillessSteps(Collection<AreaObjectModel> model) {
        List<AreaObjectDto> dtos = this.convertModelsToDtoProxies(model);
        Collection<Tupel<AreaObjectDto, List<Double>>> detaillessSteps = this.getGeoServerStub().getAreaBi().getDetaillessSteps(dtos);
        ArrayList<Tupel<AreaObjectModel, List<Double>>> result = new ArrayList<Tupel<AreaObjectModel, List<Double>>>(detaillessSteps.size());
        for (Tupel<AreaObjectDto, List<Double>> tupel : detaillessSteps) {
            result.add(new Tupel<AreaObjectModel, List<Double>>((AreaObjectModel)this.convertDtoToModel((Dto)tupel.getElement1(), this.areaObjectDetaillessUpdateListener), tupel.getElement2()));
        }
        return result;
    }

    public List<Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>> getDetaillessAreaGeometryForUpp(Collection<AreaObjectModel> model, Double upp) {
        List<AreaObjectDto> dtos = this.convertModelsToDtoProxies(model);
        Collection<Tupel<AreaObjectDto, DetaillessAreaObjectGeometryDto>> detailless = this.getGeoServerStub().getAreaBi().getDetaillessAreaGeometryForUpp(dtos, upp);
        ArrayList<Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>> result = new ArrayList<Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>>(detailless.size());
        for (Tupel<AreaObjectDto, DetaillessAreaObjectGeometryDto> tupel : detailless) {
            result.add(new Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>((AreaObjectModel)this.convertDtoToModel((Dto)tupel.getElement1(), this.areaObjectDetaillessUpdateListener), (DetaillessAreaObjectGeometryModel)this.convertDtoToModel((Dto)tupel.getElement2(), new ValueChangeListener[0])));
        }
        return result;
    }

    @Override
    public void createReducedAreasForLayer(AreaLayerModel areaLayer, Double upp, Double tolerance) {
        this.getGeoServerStub().getAreaBi().createReducedAreasForLayer((AreaLayerDto)this.convertModelToDtoProxy(areaLayer), tolerance, upp);
    }

    @Override
    public void cutAreaLayerInMicrocell(AreaLayerModel areaLayer, RouteVehicleType routeVehicleType, Collection<ParcelModel> parcels, Map<MicrocellDescriptorType, Model> descriptorMap, boolean clear, ErrorMessages errorMessages) {
        AreaLayerDto areaLayerDto = (AreaLayerDto)this.convertModelToDtoProxy(areaLayer);
        HashMap<MicrocellDescriptorType, Dto> dtoMap = new HashMap<MicrocellDescriptorType, Dto>();
        for (MicrocellDescriptorType type : descriptorMap.keySet()) {
            Object descriptorDto = this.convertModelToDtoProxy(descriptorMap.get((Object)type));
            dtoMap.put(type, (Dto)descriptorDto);
        }
        List<ParcelDto> parcelDtos = this.convertModelsToFullDtos(parcels);
        this.getGeoServerStub().getAreaBi().cutAreaLayerIntoMicrocells(areaLayerDto, routeVehicleType, parcelDtos, dtoMap, clear, errorMessages);
    }

    @Override
    public Collection<AreaObjectModel> findAreasWithCoordInRange(Coordinate coordinate, int radius, long ... layerId) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().findAreasWithCoordInRange(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(coordinate)), radius, layerId), this.areaObjectDetaillessUpdateListener);
    }

    @Override
    public Collection<AreaObjectModel> findAreasByEuclideanCircleSearch(Coordinate coordinate, int radius, AreaLayerModel areaLayerModel, boolean included, Collection<AreaFilterModel> filtersSelected, Collection<AreaFilterModel> allFilters, Boolean showDefault) {
        List<AreaFilterDto> selectedFiltersDtoList = this.convertModelsToFullDtos(filtersSelected);
        List<AreaFilterDto> allFilterDtoList = this.convertModelsToFullDtos(allFilters);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().findAreasByEuclideanCircleSearch(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(coordinate)), radius, (AreaLayerDto)this.convertModelToFullDto(areaLayerModel), included, selectedFiltersDtoList, allFilterDtoList, showDefault), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> findAreasByAttributeAggregation(Coordinate coordinate, AreaAttributeValueDescriptorModel descriptorModel, double limit, AreaLayerModel areaLayer, Collection<Long> areaObjectIdsNotToShow, Collection<AreaFilterModel> filtersSelected, Collection<AreaFilterModel> allFilters, Boolean showDefault) {
        List<AreaFilterDto> selectedFiltersDtoList = this.convertModelsToFullDtos(filtersSelected);
        List<AreaFilterDto> allFilterDtoList = this.convertModelsToFullDtos(allFilters);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().findAreasByAttributeAggregation(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(coordinate)), (AreaAttributeValueDescriptorDto)this.convertModelToFullDto(descriptorModel), limit, (AreaLayerDto)this.convertModelToFullDto(areaLayer), areaObjectIdsNotToShow, selectedFiltersDtoList, allFilterDtoList, showDefault), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> findAreasWithFootOrCarDistance(AreaLayerModel areaLayerModel, Coordinate coordinate, RouteVehicleType carOrFoot, RouteType routeType, int distanceOrTimeValue, Collection<AreaFilterModel> filtersSelected, Collection<AreaFilterModel> allFilters, Boolean showDefault) throws LogisticException {
        List<AreaFilterDto> selectedFiltersDtoList = this.convertModelsToFullDtos(filtersSelected);
        List<AreaFilterDto> allFilterDtoList = this.convertModelsToFullDtos(allFilters);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().findAreasWithFootOrCarDistance((AreaLayerDto)this.convertModelToFullDto(areaLayerModel), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(coordinate)), carOrFoot, routeType, distanceOrTimeValue, selectedFiltersDtoList, allFilterDtoList, showDefault), new ValueChangeListener[0]);
    }

    @Override
    public void createReducedAreasForLayerByConfig(AreaLayerModel areaLayerModel, Collection<Tupel<Double, Double>> uppsAndTolerances) {
        this.getGeoServerStub().getAreaBi().createReducedAreasForLayerByConfig((AreaLayerDto)this.convertModelToDtoProxy(areaLayerModel), uppsAndTolerances);
    }

    @Override
    public ImmutablePolygonKind createReducedGeom(ImmutablePolygonKind geom, Double tolerance) {
        ImmutablePolygonKindDto geomDto = this.getGeoServerStub().getAreaBi().createReducedGeom(ImmutablePolygonKindDto.create(geom), tolerance);
        return (ImmutablePolygonKind)geomDto.getGeoObject();
    }

    @Override
    public void createMakrocellLayer(String makrocellName, Long microcellId, MakroParameter makroParameter, ErrorMessages errorMessages) {
        this.getGeoServerStub().getAreaBi().createMakrocellLayer(makrocellName, microcellId, makroParameter, errorMessages);
    }

    @Override
    public void deleteAreaLayer(AreaLayerModel areaLayer) {
        this.getGeoServerStub().getAreaBi().deleteAreaLayer((AreaLayerDto)this.convertModelToFullDto(areaLayer));
    }

    @Override
    public void updateAreaObjectsValueByDescriptor(AreaAttributeValueDescriptorModel selectedValueDescriptorModel, String value, boolean isToOverwriteNullValues) {
        this.getGeoServerStub().getAreaBi().updateAreaObjectsValueByDescriptor((AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(selectedValueDescriptorModel), value, isToOverwriteNullValues);
    }

    @Override
    public boolean isMicroCellAllowed() {
        return this.getGeoServerStub().getAreaBi().isMicroCellAllowed();
    }

    @Override
    public boolean isMacroCellAllowed() {
        return this.getGeoServerStub().getAreaBi().isMacroCellAllowed();
    }

    @Override
    public Collection<AreaAttributeValueModel> getAreaAttributeValuesByAreaLayerAndDescriptor(AreaLayerModel currentLayer, AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel) {
        AreaLayerDto areaLayerDto = (AreaLayerDto)this.convertModelToDtoProxy(currentLayer);
        AreaAttributeValueDescriptorDto areaAttributeValueDescriptorDto = (AreaAttributeValueDescriptorDto)this.convertModelToDtoProxy(areaAttributeValueDescriptorModel);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().getAreaAttributeValuesByAreaLayerAndDescriptor(areaLayerDto, areaAttributeValueDescriptorDto), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaLayerModel> getAreaLayerForWage(AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators) {
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().getAreaLayerForWage(areaObjectGenInfoDiscriminators), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> fetchAllAreasWithoutParcelsAndSubscriptions(Collection<AreaLayerModel> layers) {
        List<AreaLayerDto> layerDtos = this.convertModelsToDtoProxies(layers);
        return this.convertDtosToModels(this.getGeoServerStub().getAreaBi().fetchAllAreasWithoutParcelsAndSubscriptions(layerDtos), new ValueChangeListener[0]);
    }

    @Override
    public void deleteAreaObjects(Collection<AreaObjectModel> areaObjects) {
        List<AreaObjectDto> areaObjectDtos = this.convertModelsToDtoProxies(areaObjects);
        this.getGeoServerStub().getAreaBi().deleteAreaObjects(areaObjectDtos);
    }

    @Override
    public Collection<Long> checkParcelSortOrder(Collection<Long> areaObjectIds, RouteVehicleType vehicle, Long deliveryRoundId) {
        return this.getGeoServerStub().getAreaBi().checkParcelSortOrder(areaObjectIds, vehicle, deliveryRoundId);
    }

    @Override
    public DeliveryRoundRelationModel fetchRoundRelation(DeliveryRoundModel round, WageParameterModel parameter) {
        DeliveryRoundDto roundProxy = (DeliveryRoundDto)this.convertModelToDtoProxy(round);
        WageParameterDto parameterProxy = (WageParameterDto)this.convertModelToDtoProxy(parameter);
        return (DeliveryRoundRelationModel)this.convertDtoToModel(this.getGeoServerStub().getAreaBi().fetchRoundRelation(roundProxy, parameterProxy), new ValueChangeListener[0]);
    }

    @Override
    public Collection<Tupel<Long, Long>> fetchLayerIdsForAreaObjectIds(Collection<Long> areaObjectIds) {
        return this.getGeoServerStub().getAreaBi().fetchLayerIdsForAreaObjectIds(areaObjectIds);
    }
}

