/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.dto.Dto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ktde.model.ValueChangeListener;

public abstract class AbstractCaller {
    private GeoServerStub geoServerStub;
    private ModelCache modelCache;

    public AbstractCaller(GeoServerStub geoServerStub, ModelCache modelCache) {
        this.geoServerStub = geoServerStub;
        this.modelCache = modelCache;
    }

    protected GeoServerStub getGeoServerStub() {
        return this.geoServerStub;
    }

    protected ModelCache getModelCache() {
        return this.modelCache;
    }

    public <T extends Model, S extends Dto> List<T> convertDtosToModels(Collection<S> dtos, ValueChangeListener ... changeListeners) {
        if (dtos == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(dtos.size());
        for (Dto s : dtos) {
            T model = this.convertDtoToModel(s, changeListeners);
            list.add(model);
        }
        return list;
    }

    public <T extends Model, S extends Dto> T convertDtoToModel(S s, ValueChangeListener ... changeListeners) {
        if (s == null) {
            return null;
        }
        try {
            Object model = this.getModelCache().getModel(s);
            for (ValueChangeListener valueChangeListener : changeListeners) {
                model.addValueChangeListener(valueChangeListener);
            }
            return model;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public <T extends Model, S extends Dto> List<T> convertDtosToModelsExcludeDeleted(Collection<S> dtos, ValueChangeListener ... changeListeners) {
        if (dtos == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(dtos.size());
        for (Dto s : dtos) {
            T model = this.convertDtoToModelExcludeDeleted(s, changeListeners);
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    protected <T extends Model, S extends Dto> T convertDtoToModelExcludeDeleted(S s, ValueChangeListener ... changeListeners) {
        T model = this.convertDtoToModel(s, changeListeners);
        return model.isDeleted() ? null : (T)model;
    }

    protected <T extends Dto, S extends Model> T convertModelToDtoProxy(S s) {
        if (s == null) {
            return null;
        }
        return (T)s.createProxy();
    }

    protected <T extends Dto, S extends Model> List<T> convertModelsToDtoProxies(Collection<S> models) {
        if (models == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(models.size());
        for (Model s : models) {
            list.add(this.convertModelToDtoProxy(s));
        }
        return list;
    }

    protected <T extends Dto, S extends Model> T convertModelToFullDto(S s) {
        if (s == null) {
            return null;
        }
        return (T)s.createDto();
    }

    protected <T extends Dto, S extends Model> List<T> convertModelsToFullDtos(Collection<S> models) {
        if (models == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(models.size());
        for (Model s : models) {
            list.add(this.convertModelToFullDto(s));
        }
        return list;
    }
}

