/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias.bulk;

import de.datomino.peppergis.client.alias.bulk.AbstractBulkAliasInsertAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.international.country.Country;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.util.StringUtil;

public class StreetBulkAliasInsertAction
extends AbstractBulkAliasInsertAction<StreetModel> {
    private static final long serialVersionUID = 5305248687863294354L;

    public StreetBulkAliasInsertAction(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void createAlias(StreetModel t, String newAlias) {
        StreetAliasModelImpl streetAliasModel = new StreetAliasModelImpl();
        streetAliasModel.setName(newAlias);
        streetAliasModel.setSearch(StringUtil.normalize(newAlias));
        streetAliasModel.setStreet(t);
    }

    @Override
    protected String getSearchTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkStreetSearch", new Serializable[0]);
    }

    @Override
    protected String getConfirmTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkStreetConfirm", new Serializable[0]);
    }

    @Override
    protected List<StreetModel> getMatchedModels(String part) {
        Collection<StreetModel> streets = this.getModelEnviroment().getAllCaller().getStreetSearchCaller().searchStreetsWithPart(part);
        return new ArrayList<StreetModel>(streets);
    }

    @Override
    protected String getDescription(StreetModel t) {
        PostcodeDistrictRelationModel postcodeDistrictRelation = t.getPostcodeDistrictRelation();
        DistrictModel district = null;
        PostcodeModel postcode = null;
        CityModel city = null;
        Country country = null;
        if (postcodeDistrictRelation != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
            if (postcode != null) {
                country = postcode.getCountry();
            }
        }
        return (country == null ? "?" : country.getVehicleSign()) + ", " + (postcode == null ? "?" : postcode.getName()) + " " + (city == null ? "?" : city.getName()) + " - " + (district == null ? "?" : district.getName()) + ", " + t.getName();
    }

    @Override
    protected String getReplacedValue(StreetModel t, String part, String replacement) {
        String name = t.getName();
        int index = name.toLowerCase().indexOf(part.toLowerCase());
        if (index >= 0) {
            return name.substring(0, index) + replacement + name.substring(index + part.length(), name.length());
        }
        return name;
    }

    @Override
    protected List<String> getAliasNames(StreetModel t) {
        ArrayList<String> aliasNames = new ArrayList<String>(t.countAlias());
        for (StreetAliasModel alias : t.iterableAlias()) {
            aliasNames.add(alias.getName());
        }
        Collections.sort(aliasNames);
        return aliasNames;
    }
}

