/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias.bulk;

import de.datomino.peppergis.client.alias.bulk.AbstractBulkAliasInsertAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityAliasModelImpl;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.util.international.country.Country;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.ktde.util.StringUtil;

public class CityBulkAliasInsertAction
extends AbstractBulkAliasInsertAction<CityModel> {
    private static final long serialVersionUID = 5305248687863294354L;

    public CityBulkAliasInsertAction(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void createAlias(CityModel t, String newAlias) {
        CityAliasModelImpl cityAliasModel = new CityAliasModelImpl();
        cityAliasModel.setName(newAlias);
        cityAliasModel.setSearch(StringUtil.normalize(newAlias));
        cityAliasModel.setCity(t);
    }

    @Override
    protected String getSearchTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkCitySearch", new Serializable[0]);
    }

    @Override
    protected String getConfirmTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkCityConfirm", new Serializable[0]);
    }

    @Override
    protected List<CityModel> getMatchedModels(String part) {
        Collection<CityModel> streets = this.getModelEnviroment().getAllCaller().getStreetSearchCaller().searchCityWithPart(part);
        return new ArrayList<CityModel>(streets);
    }

    @Override
    protected String getDescription(CityModel t) {
        HashSet<Country> countries = new HashSet<Country>();
        TreeSet<String> postcodes = new TreeSet<String>();
        for (DistrictModel district : t.iterableDistrict()) {
            for (PostcodeDistrictRelationModel postcodeRelationModel : district.iterablePostcodes()) {
                PostcodeModel postcode = postcodeRelationModel.getPostcode();
                Country country = postcode.getCountry();
                if (country != null) {
                    countries.add(country);
                }
                postcodes.add(postcode.getName());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (countries.isEmpty()) {
            sb.append("?");
        } else if (countries.size() == 1) {
            sb.append(((Country)countries.iterator().next()).getVehicleSign());
        } else {
            sb.append("(");
            Iterator iter = countries.iterator();
            sb.append(((Country)iter.next()).getVehicleSign());
            do {
                sb.append(", ").append(((Country)iter.next()).getVehicleSign());
            } while (iter.hasNext());
            sb.append(")");
        }
        sb.append(", ");
        if (postcodes.isEmpty()) {
            sb.append("?");
        } else if (postcodes.size() == 1) {
            sb.append((String)postcodes.iterator().next());
        } else {
            sb.append("(").append(this.getPostcodeString(postcodes)).append(")");
        }
        sb.append(" ").append(t.getName());
        return sb.toString();
    }

    private String getPostcodeString(Collection<String> sorted) {
        Integer start = null;
        String startString = null;
        Integer pred = null;
        String predString = null;
        LinkedList<String> parts = new LinkedList<String>();
        for (String postcode : sorted) {
            Integer parsed = null;
            try {
                parsed = Integer.valueOf(postcode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parsed == null) {
                if (start != null) {
                    String add = startString;
                    if (pred != null) {
                        add = add + "-" + predString;
                    }
                    parts.add(add);
                }
                parts.add(postcode);
                start = null;
                pred = null;
                continue;
            }
            if (pred != null) {
                if (parsed - pred == 1) {
                    pred = parsed;
                    predString = postcode;
                    continue;
                }
                parts.add(startString + "-" + predString);
                start = parsed;
                startString = postcode;
                pred = null;
                continue;
            }
            if (start != null) {
                if (parsed - start == 1) {
                    pred = parsed;
                    predString = postcode;
                    continue;
                }
                parts.add(startString);
                start = parsed;
                startString = postcode;
                continue;
            }
            start = parsed;
            startString = postcode;
        }
        if (start != null) {
            String add = startString;
            if (pred != null) {
                add = add + "-" + predString;
            }
            parts.add(add);
        }
        return StringUtil.implode(parts, ", ");
    }

    @Override
    protected String getReplacedValue(CityModel t, String part, String replacement) {
        String name = t.getName();
        int index = name.toLowerCase().indexOf(part.toLowerCase());
        if (index >= 0) {
            return name.substring(0, index) + replacement + name.substring(index + part.length(), name.length());
        }
        return name;
    }

    @Override
    protected List<String> getAliasNames(CityModel t) {
        ArrayList<String> aliasNames = new ArrayList<String>(t.countAlias());
        for (CityAliasModel alias : t.iterableAlias()) {
            aliasNames.add(alias.getName());
        }
        Collections.sort(aliasNames);
        return aliasNames;
    }
}

