/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias.bulk;

import de.datomino.peppergis.client.alias.bulk.BulkAliasConfirmPane;
import de.datomino.peppergis.client.alias.bulk.BulkAliasSearchPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.exception.ValidateException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public abstract class AbstractBulkAliasInsertAction<T extends Model>
extends AbstractAction {
    private static final long serialVersionUID = 8719342926000983005L;
    private Window parent;
    private ModelEnviroment modelEnviroment;

    public AbstractBulkAliasInsertAction(Window parent, ModelEnviroment modelEnviroment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkInsertAction", new Serializable[0]));
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BulkAliasSearchPane bulkAliasSearchPane = new BulkAliasSearchPane();
        int d = JOptionPane.showConfirmDialog(this.parent, bulkAliasSearchPane, this.getSearchTitle(), 2);
        if (d == 0) {
            String part = bulkAliasSearchPane.getPart();
            String replacement = bulkAliasSearchPane.getReplacement();
            List<T> matched = this.getMatchedModels(part);
            int size = matched.size();
            int count = 1;
            for (Model t : matched) {
                BulkAliasConfirmPane bulkAliasConfirmPane = new BulkAliasConfirmPane(this.getDescription(t), this.getReplacedValue(t, part, replacement), this.getAliasNames(t));
                d = JOptionPane.showConfirmDialog(this.parent, bulkAliasConfirmPane, this.getConfirmTitle() + " (" + count + "/" + size + ")", 1);
                if (d == 0) {
                    UndoManager undoManager = this.modelEnviroment.getUndoManager();
                    undoManager.startTransaction();
                    this.createAlias(t, bulkAliasConfirmPane.getNewAlias());
                    undoManager.finishTransaction("");
                    try {
                        undoManager.storeTransactions();
                    }
                    catch (ValidateException e1) {
                        undoManager.rollbackTransaction();
                    }
                } else if (d == 2) break;
                ++count;
            }
        }
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected abstract void createAlias(T var1, String var2);

    protected abstract String getSearchTitle();

    protected abstract String getConfirmTitle();

    protected abstract List<T> getMatchedModels(String var1);

    protected abstract String getDescription(T var1);

    protected abstract String getReplacedValue(T var1, String var2, String var3);

    protected abstract List<String> getAliasNames(T var1);
}

