/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.DeleteParcelDialog;
import de.datomino.peppergis.client.gui.parcel.StreetComparator;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class MultiHousenumberPane
extends JPanel {
    private static final long serialVersionUID = 4135778429447258768L;
    private JTree tree;
    private ModelEnviroment modelEnviroment;

    public MultiHousenumberPane(Map<StreetModel, Collection<Collection<ParcelModel>>> multiParcels, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        ArrayList<StreetModel> streets = new ArrayList<StreetModel>(multiParcels.keySet());
        Collections.sort(streets, StreetComparator.INSTANCE);
        for (StreetModel street : streets) {
            DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(street);
            Collection<Collection<ParcelModel>> parcels = multiParcels.get(street);
            ArrayList<Collection<ParcelModel>> cList = new ArrayList<Collection<ParcelModel>>(parcels);
            Collections.sort(cList, ParcelCollectionComparator.INSTANCE);
            for (Collection collection : cList) {
                ParcelModel first = (ParcelModel)collection.iterator().next();
                DefaultMutableTreeNode mPNode = new DefaultMutableTreeNode(new Tupel<String, String>(first.getHouseNumber(), first.getHouseNumberExtension()));
                ArrayList sParcels = new ArrayList(collection);
                Collections.sort(sParcels, ParcelComparator.INSTANCE);
                for (ParcelModel tupel : sParcels) {
                    DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(tupel);
                    mPNode.add(pNode);
                }
                sNode.add(mPNode);
            }
            root.add(sNode);
        }
        this.tree = new JTree(root);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new TreeRenderer(this.tree.getCellRenderer()));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = 2121140428059536692L;

            @Override
            public void addSelectionPath(TreePath path) {
                if (path.getPathCount() == 4) {
                    super.addSelectionPath(path);
                }
            }

            @Override
            public void setSelectionPath(TreePath path) {
                if (path.getPathCount() == 4) {
                    super.setSelectionPath(path);
                }
            }
        });
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.add((Component)new JScrollPane(this.tree), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)new JButton(new RemoveAction()), "East");
        this.add((Component)buttonPanel, "South");
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -3186685334218733430L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] selectionPaths = MultiHousenumberPane.this.tree.getSelectionPaths();
            HashSet<ParcelModel> toDelete = new HashSet<ParcelModel>();
            for (TreePath treePath : selectionPaths) {
                DefaultMutableTreeNode mtn;
                Object o;
                Object last = treePath.getLastPathComponent();
                if (!(last instanceof DefaultMutableTreeNode) || !((o = (mtn = (DefaultMutableTreeNode)last).getUserObject()) instanceof ParcelModel)) continue;
                ParcelModel parcelModel = (ParcelModel)o;
                toDelete.add(parcelModel);
            }
            ErrorMessages errorMessages = new ErrorMessages();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)MultiHousenumberPane.this.tree.getModel().getRoot();
            final DefaultTreeModel dtm = (DefaultTreeModel)MultiHousenumberPane.this.tree.getModel();
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode sNode = (DefaultMutableTreeNode)root.getChildAt(i);
                for (int j = sNode.getChildCount() - 1; j >= 0; --j) {
                    final DefaultMutableTreeNode mNode = (DefaultMutableTreeNode)sNode.getChildAt(j);
                    for (int k = mNode.getChildCount() - 1; k >= 0; --k) {
                        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)mNode.getChildAt(k);
                        ParcelModel parcel = (ParcelModel)pNode.getUserObject();
                        if (!toDelete.contains(parcel)) continue;
                        final int fk = k;
                        DeleteParcelDialog dialog = new DeleteParcelDialog(parcel, MultiHousenumberPane.this.modelEnviroment, MultiHousenumberPane.this, errorMessages, false){
                            private static final long serialVersionUID = 6872425691291769576L;

                            @Override
                            public void after() {
                                mNode.remove(fk);
                                dtm.nodeStructureChanged(mNode);
                            }
                        };
                        dialog.setVisible(true);
                    }
                    if (mNode.getChildCount() != 0) continue;
                    sNode.remove(j);
                    dtm.nodeStructureChanged(sNode);
                }
                if (sNode.getChildCount() != 0) continue;
                root.remove(i);
                dtm.nodeStructureChanged(root);
            }
            if (errorMessages.hasErrors()) {
                BufferedImage image;
                try {
                    image = ImageIO.read(MultiHousenumberPane.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(MultiHousenumberPane.this), ModelEnviroment.getMessageResolver(), errorMessages, image);
                errorMessageDialog.setVisible(true);
            }
        }
    }

    private class TreeRenderer
    implements TreeCellRenderer {
        private TreeCellRenderer parent;

        public TreeRenderer(TreeCellRenderer parent) {
            this.parent = parent;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object nValue = value;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)value;
                Object o = mtn.getUserObject();
                if (o instanceof StreetModel) {
                    StreetModel street = (StreetModel)o;
                    PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
                    PostcodeModel p = pdr.getPostcode();
                    DistrictModel district = pdr.getDistrict();
                    CityModel city = district.getCity();
                    Country country = p.getCountry();
                    nValue = (country == null ? "?" : country.getVehicleSign()) + " " + p.getName() + " " + city.getName() + " - " + district.getName() + ", " + street.getName();
                } else if (o instanceof ParcelModel) {
                    ParcelModel parcelModel = (ParcelModel)o;
                    ImmutablePoint geom = parcelModel.getGeom();
                    if (geom != null) {
                        geom = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
                    }
                    double x = geom == null ? 0.0 : geom.getX();
                    double y = geom == null ? 0.0 : geom.getY();
                    nValue = (parcelModel == null ? "?" : parcelModel.getImportKey()) + " - X: " + PrimitiveUtil.formatDouble(x, 6, false) + " Y: " + PrimitiveUtil.formatDouble(y, 6, false);
                } else if (o instanceof Tupel) {
                    Tupel tupel = (Tupel)o;
                    Object element1 = tupel.getElement1();
                    Object element2 = tupel.getElement2();
                    nValue = StringUtil.nullToEmpty(element1) + StringUtil.nullToEmpty(element2);
                }
            }
            return this.parent.getTreeCellRendererComponent(tree, nValue, selected, expanded, leaf, row, hasFocus);
        }
    }

    private static class ParcelComparator
    implements Comparator<ParcelModel> {
        private static final ParcelComparator INSTANCE = new ParcelComparator();

        private ParcelComparator() {
        }

        @Override
        public int compare(ParcelModel o1, ParcelModel o2) {
            String ref1 = o1 == null ? "" : StringUtil.nullToEmpty(o1.getImportKey());
            String ref2 = o2 == null ? "" : StringUtil.nullToEmpty(o2.getImportKey());
            return ref1.compareTo(ref2);
        }
    }

    private static class ParcelCollectionComparator
    implements Comparator<Collection<ParcelModel>> {
        private static final ParcelCollectionComparator INSTANCE = new ParcelCollectionComparator();

        private ParcelCollectionComparator() {
        }

        @Override
        public int compare(Collection<ParcelModel> o1, Collection<ParcelModel> o2) {
            String housenumber2;
            ParcelModel p1 = o1.iterator().next();
            ParcelModel p2 = o2.iterator().next();
            String housenumber1 = StringUtil.nullToEmpty(p1.getHouseNumber());
            int d = housenumber1.compareTo(housenumber2 = StringUtil.nullToEmpty(p2.getHouseNumber()));
            if (d == 0) {
                String ext1 = StringUtil.nullToEmpty(p1.getHouseNumberExtension());
                String ext2 = StringUtil.nullToEmpty(p2.getHouseNumberExtension());
                d = ext1.compareTo(ext2);
            }
            return d;
        }
    }
}

