/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias;

import de.datomino.peppergis.client.alias.ParcelComparator;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.DistrictComboBox;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModelImpl;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.map.StreetModelImpl;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AliasStreetSplitPane
extends JPanel {
    private static final long serialVersionUID = -5550696274604121127L;
    private StreetModel street;
    private ModelEnviroment modelEnviroment;
    private JTable table;
    private List<DistrictComboBox> districtComboBoxes;
    private List<ParcelModel> parcels;
    private JSpinner multiLowerHousenumber;
    private JSpinner multiUpperHousenumber;
    private DistrictComboBox multiDistrictComboBox;

    public AliasStreetSplitPane(StreetModel street, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.street = street;
        this.modelEnviroment = modelEnviroment;
        this.parcels = new ArrayList<ParcelModel>(street.countParcels());
        for (ParcelModel parcel : street.iterableParcels()) {
            this.parcels.add(parcel);
        }
        Collections.sort(this.parcels, new ParcelComparator());
        this.buildLayout();
        this.fillValue();
    }

    private void fillValue() {
        CityModel city = this.street.getPostcodeDistrictRelation().getDistrict().getCity();
        this.multiDistrictComboBox.setCity(city);
        for (DistrictComboBox districtComboBox : this.districtComboBoxes) {
            districtComboBox.setCity(city);
        }
        if (!this.parcels.isEmpty()) {
            SpinnerNumberModel spinnerNumberModel;
            ParcelModel lParcel = this.parcels.get(0);
            String lHousenumber = lParcel.getHouseNumber();
            Integer iLHousenumber = null;
            try {
                iLHousenumber = Integer.valueOf(lHousenumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ParcelModel hParcel = this.parcels.get(this.parcels.size() - 1);
            String hHousenumber = hParcel.getHouseNumber();
            Integer iHHousenumber = null;
            try {
                iHHousenumber = Integer.valueOf(hHousenumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iLHousenumber != null) {
                this.multiLowerHousenumber.setValue(iLHousenumber);
                spinnerNumberModel = (SpinnerNumberModel)this.multiLowerHousenumber.getModel();
                spinnerNumberModel.setMinimum(iLHousenumber);
                spinnerNumberModel = (SpinnerNumberModel)this.multiUpperHousenumber.getModel();
                spinnerNumberModel.setMinimum(iLHousenumber);
            }
            if (iHHousenumber != null) {
                this.multiUpperHousenumber.setValue(iHHousenumber);
                spinnerNumberModel = (SpinnerNumberModel)this.multiLowerHousenumber.getModel();
                spinnerNumberModel.setMaximum(iHHousenumber);
                spinnerNumberModel = (SpinnerNumberModel)this.multiUpperHousenumber.getModel();
                spinnerNumberModel.setMaximum(iHHousenumber);
            }
        }
    }

    private void buildLayout() {
        this.table = new JTable(new AliasStreetSplitTableModel());
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(30);
        columnModel.getColumn(1).setPreferredWidth(20);
        columnModel.getColumn(2).setPreferredWidth(20);
        columnModel.getColumn(3).setPreferredWidth(100);
        this.districtComboBoxes = new ArrayList<DistrictComboBox>(this.parcels.size());
        int i = 0;
        while (i < this.parcels.size()) {
            DistrictComboBox sComboBox = new DistrictComboBox(false, true);
            this.districtComboBoxes.add(sComboBox);
            final int index = i++;
            sComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AliasStreetSplitTableModel model = (AliasStreetSplitTableModel)AliasStreetSplitPane.this.table.getModel();
                    model.fireValueChanged(index);
                }
            });
        }
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.setDefaultRenderer(DistrictModel.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -1893319080897603874L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DistrictComboBox districtComboBox = (DistrictComboBox)AliasStreetSplitPane.this.districtComboBoxes.get(row);
                Color color = isSelected ? table.getSelectionBackground() : table.getBackground();
                districtComboBox.setBackground(color);
                Component editorComponent = districtComboBox.getEditor().getEditorComponent();
                editorComponent.setBackground(color);
                return districtComboBox;
            }
        });
        this.table.setDefaultEditor(DistrictModel.class, new DistrictComboboxCellEditor());
        JPanel multiSetPanel = new JPanel(new SpringLayout());
        multiSetPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.rangesplit.lowerHousenumber", new Serializable[0])));
        multiSetPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.rangesplit.upperHousenumber", new Serializable[0])));
        this.multiLowerHousenumber = new JSpinner(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        multiSetPanel.add(this.multiLowerHousenumber);
        this.multiUpperHousenumber = new JSpinner(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        multiSetPanel.add(this.multiUpperHousenumber);
        multiSetPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0])));
        multiSetPanel.add(new JLabel());
        this.multiDistrictComboBox = new DistrictComboBox(false, true);
        multiSetPanel.add(this.multiDistrictComboBox);
        JButton multiSetButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.rangesplit", new Serializable[0])){
            private static final long serialVersionUID = -2771719025056731972L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AliasStreetSplitPane.this.multiSplit();
            }
        });
        multiSetPanel.add(multiSetButton);
        SpringUtilities.makeCompactGrid(multiSetPanel, 4, 2, 5, 5, 2, 2);
        multiSetPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.rangesplit", new Serializable[0])));
        this.add((Component)multiSetPanel, "South");
    }

    private void multiSplit() {
        Integer lower = (Integer)this.multiLowerHousenumber.getValue();
        Integer upper = (Integer)this.multiUpperHousenumber.getValue();
        DistrictModel district = this.multiDistrictComboBox.getSelectedItem();
        Iterator<ParcelModel> pIter = this.parcels.iterator();
        Iterator<DistrictComboBox> dIter = this.districtComboBoxes.iterator();
        while (pIter.hasNext()) {
            Integer i;
            ParcelModel parcel = pIter.next();
            DistrictComboBox districtComboBox = dIter.next();
            String h = parcel.getHouseNumber();
            try {
                i = Integer.valueOf(h);
            }
            catch (Exception ex) {
                continue;
            }
            if (i < lower || i > upper) continue;
            districtComboBox.setSelectedItem(district);
        }
    }

    protected void executeSplit() {
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        Iterator<ParcelModel> pIter = this.parcels.iterator();
        Iterator<DistrictComboBox> dIter = this.districtComboBoxes.iterator();
        PostcodeModel currentPostcode = this.street.getPostcodeDistrictRelation().getPostcode();
        block0: while (pIter.hasNext()) {
            ParcelModel parcel = pIter.next();
            DistrictComboBox districtComboBox = dIter.next();
            DistrictModel district = districtComboBox.getSelectedItem();
            PostcodeDistrictRelationModel foundPdr = null;
            for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                if (pdr.getPostcode() != currentPostcode) continue;
                foundPdr = pdr;
                break;
            }
            if (foundPdr == null) {
                foundPdr = new PostcodeDistrictRelationModelImpl();
                foundPdr.setDistrict(district);
                foundPdr.setPostcode(currentPostcode);
            }
            StreetModel foundStreet = null;
            for (StreetModel street : foundPdr.iterableStreets()) {
                if (this.street == street) continue block0;
                if (!street.getName().equals(this.street.getName())) continue;
                foundStreet = street;
            }
            if (foundStreet == null) {
                foundStreet = new StreetModelImpl();
                foundStreet.setColor_code(this.street.getColor_code());
                foundStreet.setName(this.street.getName());
                foundStreet.setPostcodeDistrictRelation(foundPdr);
                for (StreetAliasModel streetAlias : this.street.iterableAlias()) {
                    StreetAliasModelImpl copy = new StreetAliasModelImpl();
                    copy.setName(streetAlias.getName());
                    copy.setSearch(streetAlias.getSearch());
                    copy.setStreet(foundStreet);
                }
            }
            parcel.setStreet(foundStreet);
        }
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.split", new Serializable[0]));
    }

    public Action getOkAction(final Window parent) {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -7409714951179971277L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AliasStreetSplitPane.this.executeSplit();
                parent.dispose();
            }
        };
    }

    public Action getCancelAction(final Window parent) {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6834731378705799199L;

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.dispose();
            }
        };
    }

    private class DistrictComboboxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 469313275561352608L;
        private DistrictComboBox districtCombobox;

        private DistrictComboboxCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.districtCombobox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DistrictComboBox districtComboBox = (DistrictComboBox)AliasStreetSplitPane.this.districtComboBoxes.get(row);
            Color color = isSelected ? table.getSelectionBackground() : table.getBackground();
            districtComboBox.setBackground(color);
            Component editorComponent = districtComboBox.getEditor().getEditorComponent();
            editorComponent.setBackground(color);
            this.districtCombobox = districtComboBox;
            return districtComboBox;
        }
    }

    private class AliasStreetSplitTableModel
    implements TableModel {
        private List<TableModelListener> tableModelListeners = new LinkedList<TableModelListener>();

        private AliasStreetSplitTableModel() {
        }

        @Override
        public int getRowCount() {
            return AliasStreetSplitPane.this.street.countParcels();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcelId", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumber", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0]);
                }
                case 3: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0]);
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return DistrictModel.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParcelModel parcel = (ParcelModel)AliasStreetSplitPane.this.parcels.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return parcel.getImportKey();
                }
                case 1: {
                    return parcel.getHouseNumber();
                }
                case 2: {
                    return parcel.getHouseNumberExtension();
                }
                case 3: {
                    DistrictComboBox districtComboBox = (DistrictComboBox)AliasStreetSplitPane.this.districtComboBoxes.get(rowIndex);
                    return districtComboBox.getSelectedItem();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableModelListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableModelListeners.remove(l);
        }

        protected void fireValueChanged(int row) {
            TableModelEvent tableModelEvent = new TableModelEvent(this, row);
            for (TableModelListener listener : this.tableModelListeners) {
                listener.tableChanged(tableModelEvent);
            }
        }
    }
}

