/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias;

import de.datomino.peppergis.client.alias.AbstractListCellRenderer;
import de.datomino.peppergis.client.alias.AbstractMoveAddressPartList;
import de.datomino.peppergis.client.alias.AliasStreetSplitPane;
import de.datomino.peppergis.client.alias.MultiHousenumberPane;
import de.datomino.peppergis.client.alias.ParcelComparator;
import de.datomino.peppergis.client.alias.bulk.CityBulkAliasInsertAction;
import de.datomino.peppergis.client.alias.bulk.DistrictBulkAliasInsertAction;
import de.datomino.peppergis.client.alias.bulk.StreetBulkAliasInsertAction;
import de.datomino.peppergis.client.gui.common.AbstractEditableJList;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManagerEvent;
import de.datomino.peppergis.client.model.UndoManagerListener;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityAliasModelImpl;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModelImpl;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.DistrictModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.collections.CollectionUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AliasPane
extends JPanel {
    private static final long serialVersionUID = 7037758451526089510L;
    private CountryComboBox country;
    private JTextField postcode;
    private JList postcodes;
    private JTextField city;
    private AbstractMoveAddressPartList<CityModel> cities;
    private AbstractEditableJList<CityAliasModel> cityAliases;
    private JTextField district;
    private AbstractMoveAddressPartList<DistrictModel> districts;
    private AbstractEditableJList<DistrictAliasModel> districtAliases;
    private JTextField street;
    private AbstractMoveAddressPartList<StreetModel> streets;
    private AbstractEditableJList<StreetAliasModel> streetAliases;
    private ModelEnviroment modelEnviroment;
    private Map<Country, List<PostcodeModel>> cachedPostcodeLists;
    private SearchListSelectionListener postcodeSearchListSelectionListener;
    private SearchListSelectionListener citySearchListSelectionListener;
    private SearchListSelectionListener districtSearchListSelectionListener;
    private SearchListSelectionListener streetSearchListSelectionListener;
    protected JList parcelList;
    private boolean withParcelsOnly = true;

    public AliasPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.cachedPostcodeLists = new HashMap<Country, List<PostcodeModel>>();
        String withParcelOnlyString = ModelEnviroment.getProperties().getProperty("alias.withParcelsOnly");
        if (!StringUtil.isBlank(withParcelOnlyString)) {
            try {
                this.withParcelsOnly = StringUtil.isTrue(withParcelOnlyString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.buildLayout();
        this.modelEnviroment.getUndoManager().addUndoManagerListener(new UndoManagerListener(){

            @Override
            public void undone(UndoManagerEvent event) {
                AliasPane.this.refreshData();
            }

            @Override
            public void redone(UndoManagerEvent event) {
                AliasPane.this.refreshData();
            }
        });
        this.updateList(this.postcodes, this.loadPostcodes(""));
    }

    private void buildLayout() {
        JComponent[] components;
        JPanel subPanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier = new WidthUnifier();
        List<Tupel<Country, Integer>> countries = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchPostcodesWithAtLeastOneParcel();
        Country country = this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry();
        boolean found = false;
        for (Tupel<Country, Integer> tupel : countries) {
            if (tupel.getElement1() != country) continue;
            found = true;
            break;
        }
        if (!found && !countries.isEmpty()) {
            country = countries.get(0).getElement1();
        }
        this.country = new CountryComboBox(false, country);
        this.country.addActionListener(new CountryActionListener());
        Window parentWindow = SwingUtils.findWindowParent(this);
        subPanel.add(this.country);
        widthUnifier.add(this.country);
        JButton cityBulkAliasInsert = new JButton(new CityBulkAliasInsertAction(parentWindow, this.modelEnviroment));
        JButton disctrictBulkAliasInsert = new JButton(new DistrictBulkAliasInsertAction(parentWindow, this.modelEnviroment));
        JButton streetBulkAliasInsert = new JButton(new StreetBulkAliasInsertAction(parentWindow, this.modelEnviroment));
        subPanel.add(cityBulkAliasInsert);
        widthUnifier.add(cityBulkAliasInsert);
        subPanel.add(disctrictBulkAliasInsert);
        widthUnifier.add(disctrictBulkAliasInsert);
        subPanel.add(streetBulkAliasInsert);
        widthUnifier.add(streetBulkAliasInsert);
        JLabel l = new JLabel();
        subPanel.add(l);
        widthUnifier.add(l);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
        subPanel.add(l);
        widthUnifier.add(l);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]));
        subPanel.add(l);
        widthUnifier.add(l);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0]));
        subPanel.add(l);
        widthUnifier.add(l);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]));
        subPanel.add(l);
        widthUnifier.add(l);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
        subPanel.add(l);
        widthUnifier.add(l);
        this.postcode = new JTextField(20);
        subPanel.add(this.postcode);
        widthUnifier.add(this.postcode);
        this.city = new JTextField(20);
        subPanel.add(this.city);
        widthUnifier.add(this.city);
        this.district = new JTextField(20);
        subPanel.add(this.district);
        widthUnifier.add(this.district);
        this.street = new JTextField(20);
        subPanel.add(this.street);
        widthUnifier.add(this.street);
        this.postcodes = new JList(new DefaultListModel());
        this.postcodes.setSelectionMode(0);
        this.postcodes.setCellRenderer(new AbstractListCellRenderer<PostcodeModel>(){
            private static final long serialVersionUID = -6180650477827362538L;

            @Override
            protected String getStringRepresentation(PostcodeModel t) {
                return t.getName();
            }
        });
        l = new JLabel();
        subPanel.add(l);
        widthUnifier.add(l);
        JScrollPane scroll = new JScrollPane(this.postcodes);
        scroll.setHorizontalScrollBarPolicy(32);
        subPanel.add(scroll);
        widthUnifier.add(scroll);
        this.cities = new AbstractMoveAddressPartList<CityModel>(false, true){
            private static final long serialVersionUID = 604117688411474887L;

            @Override
            protected void rename(List<CityModel> cityList) {
                CityModel cityOldModel = (CityModel)AliasPane.this.cities.getList().getSelectedValue();
                String cityOldName = StringUtil.nullToEmpty(cityOldModel.getName());
                String newName = AliasPane.this.getNewName();
                if (newName != null) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    HashSet<CityModel> eCities = new HashSet<CityModel>();
                    HashMap map = new HashMap();
                    for (CityModel t : cityList) {
                        for (DistrictModel district : t.iterableDistrict()) {
                            for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                                for (PostcodeDistrictRelationModel sPdr : pdr.getPostcode().iterableDistricts()) {
                                    CityModel city = sPdr.getDistrict().getCity();
                                    if (!city.getName().equals(newName)) continue;
                                    eCities.add(city);
                                }
                            }
                        }
                        eCities.remove(t);
                        t.setName(newName);
                        Map multiParcels = AliasPane.this.mergeCities(t, eCities);
                        map.putAll(multiParcels);
                    }
                    if (AliasPane.this.showMultiParcels(map)) {
                        AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                        AliasPane.this.postcodeSearchListSelectionListener.valueChanged(null);
                    } else {
                        AliasPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                    CityModel cityNewModel = (CityModel)AliasPane.this.cities.getList().getSelectedValue();
                    if (cityNewModel != null && !newName.equals(cityOldName)) {
                        String alias = newName;
                        if (!StringUtil.isBlank(alias)) {
                            AliasPane.this.createNewCityAlias(cityNewModel, alias);
                        }
                        DefaultListModel dlm = AliasPane.this.cityAliases.getModel();
                        for (CityAliasModel cyAliasModel : cityNewModel.iterableAlias()) {
                            if (cityOldName.equals(StringUtil.nullToEmpty(cyAliasModel.getName())) && !dlm.contains(cyAliasModel)) {
                                dlm.addElement(cyAliasModel);
                            }
                            if (alias == null || !alias.equals(StringUtil.nullToEmpty(cyAliasModel.getName())) || !dlm.contains(cyAliasModel)) continue;
                            dlm.removeElement(cyAliasModel);
                        }
                    }
                    AliasPane.this.refreshData();
                }
            }

            @Override
            protected void move(List<CityModel> t) {
            }

            @Override
            protected String getStringRepresentation(CityModel t) {
                return t.getName();
            }
        };
        subPanel.add(this.cities);
        widthUnifier.add(this.cities);
        this.districts = new AbstractMoveAddressPartList<DistrictModel>(){
            private static final long serialVersionUID = -7350249780568533188L;

            @Override
            protected void rename(List<DistrictModel> districts) {
                String newName;
                Collection<PostcodeDistrictRelationModel> includes;
                DistrictModel districtOldModel = (DistrictModel)AliasPane.this.districts.getList().getSelectedValue();
                Tupel<Collection<PostcodeDistrictRelationModel>, Collection<PostcodeDistrictRelationModel>> tupel = this.getSplit(districtOldModel);
                if (tupel != null && !(includes = tupel.getElement1()).isEmpty() && (newName = AliasPane.this.getNewName()) != null) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    Collection<PostcodeDistrictRelationModel> excludes = tupel.getElement2();
                    if (!excludes.isEmpty()) {
                        DistrictModelImpl keepDistrictModel = new DistrictModelImpl();
                        keepDistrictModel.setCity(districtOldModel.getCity());
                        keepDistrictModel.setName(districtOldModel.getName());
                        for (PostcodeDistrictRelationModel pdr : excludes) {
                            pdr.setDistrict(keepDistrictModel);
                        }
                    }
                    CityModel city = districtOldModel.getCity();
                    String cityName = city.getName();
                    HashSet<PostcodeModel> postcodes = new HashSet<PostcodeModel>();
                    for (PostcodeDistrictRelationModel pdr : includes) {
                        postcodes.add(pdr.getPostcode());
                    }
                    Set<DistrictModel> equalDistricts = this.findEqualDistricts(newName, cityName, postcodes);
                    Map mergeDistricts = AliasPane.this.mergeDistricts(districtOldModel, equalDistricts);
                    boolean showMultiParcels = AliasPane.this.showMultiParcels(mergeDistricts);
                    if (showMultiParcels) {
                        districtOldModel.setName(newName);
                        boolean found = false;
                        for (DistrictAliasModel alias : districtOldModel.iterableAlias()) {
                            String name = alias.getName();
                            if (!name.equals(newName)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            DistrictAliasModelImpl alias = new DistrictAliasModelImpl();
                            alias.setDistrict(districtOldModel);
                            alias.setName(newName);
                            alias.setSearch(StringUtil.normalize(newName));
                        }
                        AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                    } else {
                        AliasPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                }
                AliasPane.this.refreshData();
            }

            private Set<DistrictModel> findEqualDistricts(String newName, String cityName, Set<PostcodeModel> postcodes) {
                HashSet<DistrictModel> districts = new HashSet<DistrictModel>();
                for (PostcodeModel postcode : postcodes) {
                    for (PostcodeDistrictRelationModel pdr : postcode.iterableDistricts()) {
                        CityModel city;
                        DistrictModel district = pdr.getDistrict();
                        if (!newName.equals(district.getName()) || !cityName.equals((city = district.getCity()).getName()) || !AliasPane.this.hasParcels(district, postcode)) continue;
                        districts.add(district);
                    }
                }
                return districts;
            }

            private Tupel<Collection<PostcodeDistrictRelationModel>, Collection<PostcodeDistrictRelationModel>> getSplit(DistrictModel district) {
                HashMap<PostcodeModel, HashSet<PostcodeDistrictRelationModel>> map = new HashMap<PostcodeModel, HashSet<PostcodeDistrictRelationModel>>();
                for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                    PostcodeModel postcode = pdr.getPostcode();
                    HashSet<PostcodeDistrictRelationModel> pdrs = (HashSet<PostcodeDistrictRelationModel>)map.get(postcode);
                    if (pdrs == null) {
                        pdrs = new HashSet<PostcodeDistrictRelationModel>();
                        map.put(postcode, pdrs);
                    }
                    pdrs.add(pdr);
                }
                if (map.size() > 1) {
                    PostcodeModel selectedPostcode = (PostcodeModel)AliasPane.this.postcodes.getSelectedValue();
                    JPanel panel = new JPanel(new SpringLayout());
                    DefaultListModel<PostcodeModel> dataModel = new DefaultListModel<PostcodeModel>();
                    TreeSet<PostcodeModel> postcodes = new TreeSet<PostcodeModel>(new Comparator<PostcodeModel>(){

                        @Override
                        public int compare(PostcodeModel p1, PostcodeModel p2) {
                            if (p1 == p2) {
                                return 0;
                            }
                            Country c1 = p1.getCountry();
                            Country c2 = p2.getCountry();
                            int d = 0;
                            if (c1 == c2) {
                                d = 0;
                            } else {
                                if (c1 == null) {
                                    return -1;
                                }
                                if (c2 == null) {
                                    return 1;
                                }
                                d = c1.getVehicleSign().compareTo(c2.getVehicleSign());
                            }
                            if (d == 0) {
                                String n1 = StringUtil.nullToEmpty(p1.getName());
                                String n2 = StringUtil.nullToEmpty(p2.getName());
                                d = n1.compareTo(n2);
                            }
                            return d;
                        }
                    });
                    postcodes.addAll(map.keySet());
                    for (PostcodeModel postcode : postcodes) {
                        dataModel.addElement(postcode);
                    }
                    JList poList = new JList(dataModel);
                    final ListCellRenderer cellRenderer = poList.getCellRenderer();
                    ListCellRenderer newCellRenderer = new ListCellRenderer(){

                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Object nValue = value;
                            if (value instanceof PostcodeModel) {
                                PostcodeModel postcode = (PostcodeModel)value;
                                nValue = postcode.getCountry().getVehicleSign() + " - " + postcode.getName();
                            }
                            return cellRenderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
                        }
                    };
                    poList.setCellRenderer(newCellRenderer);
                    poList.setSelectedValue(selectedPostcode, true);
                    poList.setSelectionMode(2);
                    panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.postcodeToRename", new Serializable[0])));
                    JScrollPane scroll = new JScrollPane(poList);
                    scroll.setHorizontalScrollBarPolicy(32);
                    panel.add(scroll);
                    SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 5, 20);
                    int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(AliasPane.this), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                    if (d == 0) {
                        Object[] selectedValues = poList.getSelectedValues();
                        HashSet includes = new HashSet();
                        HashSet excludes = new HashSet();
                        for (Object o : selectedValues) {
                            Collection pdrs = (Collection)map.remove(o);
                            includes.addAll(pdrs);
                        }
                        for (Collection pdrs : map.values()) {
                            excludes.addAll(pdrs);
                        }
                        return new Tupel<Collection<PostcodeDistrictRelationModel>, Collection<PostcodeDistrictRelationModel>>(includes, excludes);
                    }
                    return null;
                }
                Set emptySet = Collections.emptySet();
                return new Tupel<Collection<PostcodeDistrictRelationModel>, Collection<PostcodeDistrictRelationModel>>((Collection<PostcodeDistrictRelationModel>)map.values().iterator().next(), emptySet);
            }

            @Override
            protected String getStringRepresentation(DistrictModel t) {
                String name = t.getName();
                if (StringUtil.isBlank(name)) {
                    return "-";
                }
                return name;
            }

            @Override
            protected void move(List<DistrictModel> districts) {
                CityModel city;
                TreeSet<CityModel> cities = new TreeSet<CityModel>(new Comparator<CityModel>(){

                    @Override
                    public int compare(CityModel o1, CityModel o2) {
                        int d = o1.getName().compareTo(o2.getName());
                        if (d == 0) {
                            d = o1.getTempUUID().compareTo(o2.getTempUUID());
                        }
                        return d;
                    }
                });
                for (DistrictModel t : districts) {
                    HashSet<PostcodeModel> postcodes = new HashSet<PostcodeModel>();
                    for (PostcodeDistrictRelationModel pdr : t.iterablePostcodes()) {
                        postcodes.add(pdr.getPostcode());
                    }
                    for (PostcodeModel postcode : postcodes) {
                        for (PostcodeDistrictRelationModel pdr : postcode.iterableDistricts()) {
                            cities.add(pdr.getDistrict().getCity());
                        }
                    }
                }
                AbstractModelComboBox<CityModel> combo = new AbstractModelComboBox<CityModel>(cities, false){
                    private static final long serialVersionUID = -1531447701383738252L;

                    @Override
                    protected String getStringRepresentation(CityModel t) {
                        return t.getName();
                    }
                };
                JPanel panel = new JPanel(new FlowLayout());
                panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0])));
                panel.add(combo);
                int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(AliasPane.this), combo, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                if (d == 0 && this.checkForLastDistrictInCityWithParcels(districts, city = (CityModel)combo.getSelectedItem())) {
                    Set<PostcodeModel> postcodes = this.getPostcodesForCity(city);
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    HashMap map = new HashMap();
                    for (DistrictModel t : districts) {
                        Set<DistrictModel> eDistricts = this.getEqualNameDistricts(city, postcodes, t, t.getName());
                        eDistricts.remove(t);
                        t.setCity(city);
                        Map multiParcels = AliasPane.this.mergeDistricts(t, eDistricts);
                        map.putAll(multiParcels);
                    }
                    if (AliasPane.this.showMultiParcels(map)) {
                        AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                        AliasPane.this.citySearchListSelectionListener.valueChanged(null);
                    } else {
                        AliasPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                    AliasPane.this.refreshData();
                }
            }

            private boolean checkForLastDistrictInCityWithParcels(List<DistrictModel> districts, CityModel city) {
                HashSet<CityModel> citiesToCheck = new HashSet<CityModel>();
                for (DistrictModel district : districts) {
                    CityModel oCity = district.getCity();
                    if (city == oCity) continue;
                    citiesToCheck.add(oCity);
                }
                LinkedList<String> emptyCityNames = new LinkedList<String>();
                for (CityModel oCity : citiesToCheck) {
                    boolean found = false;
                    block2: for (DistrictModel sDistrict : oCity.iterableDistrict()) {
                        if (districts.contains(sDistrict)) continue;
                        for (PostcodeDistrictRelationModel pdr : sDistrict.iterablePostcodes()) {
                            for (StreetModel street : pdr.iterableStreets()) {
                                if (street.isParcelsEmpty()) continue;
                                found = true;
                                break block2;
                            }
                        }
                    }
                    if (found) continue;
                    emptyCityNames.add(oCity.getName());
                }
                if (emptyCityNames.isEmpty()) {
                    return true;
                }
                Collections.sort(emptyCityNames);
                return 0 == JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(AliasPane.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.emptyCity", new Serializable[]{StringUtil.implode(emptyCityNames, ", ")}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            }

            private Set<DistrictModel> getEqualNameDistricts(CityModel city, Set<PostcodeModel> postcodes, DistrictModel t, String name) {
                HashSet<DistrictModel> eDistricts = new HashSet<DistrictModel>();
                for (PostcodeDistrictRelationModel pdr : t.iterablePostcodes()) {
                    PostcodeModel sPostcode = pdr.getPostcode();
                    if (!postcodes.contains(sPostcode)) continue;
                    for (PostcodeDistrictRelationModel nPdr : sPostcode.iterableDistricts()) {
                        DistrictModel pDistrict = nPdr.getDistrict();
                        if (!pDistrict.getName().equals(name) || !city.equals(pDistrict.getCity())) continue;
                        eDistricts.add(pDistrict);
                    }
                }
                return eDistricts;
            }

            private Set<PostcodeModel> getPostcodesForCity(CityModel city) {
                HashSet<PostcodeModel> postcodes = new HashSet<PostcodeModel>();
                for (DistrictModel district : city.iterableDistrict()) {
                    for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                        postcodes.add(pdr.getPostcode());
                    }
                }
                return postcodes;
            }
        };
        subPanel.add(this.districts);
        widthUnifier.add(this.districts);
        final StreetSplitAction streetSplitAction = new StreetSplitAction();
        streetSplitAction.setEnabled(false);
        this.streets = new AbstractMoveAddressPartList<StreetModel>(){
            private static final long serialVersionUID = 8610746183422113349L;

            @Override
            protected Action[] getAdditionalActions() {
                Action[] actions2 = super.getAdditionalActions();
                Action[] nActions = new Action[actions2.length + 1];
                System.arraycopy(actions2, 0, nActions, 0, actions2.length);
                nActions[actions2.length] = streetSplitAction;
                return nActions;
            }

            @Override
            protected void setEnablings(boolean selected) {
                super.setEnablings(selected);
                streetSplitAction.setEnabled(selected);
            }

            @Override
            protected void rename(List<StreetModel> streets) {
                StreetModel streetOldModel = (StreetModel)AliasPane.this.streets.getList().getSelectedValue();
                String streetOldName = StringUtil.nullToEmpty(streetOldModel.getName());
                String newName = AliasPane.this.getNewName();
                if (newName != null) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    HashMap<StreetModel, Collection> map = new HashMap<StreetModel, Collection>();
                    for (StreetModel t : streets) {
                        PostcodeDistrictRelationModel pdr = t.getPostcodeDistrictRelation();
                        PostcodeModel postcode = pdr.getPostcode();
                        DistrictModel district = pdr.getDistrict();
                        Collection<StreetModel> eStreets = AliasPane.this.modelEnviroment.getAllCaller().getStreetSearchCaller().findStreetExact(postcode.getCountry(), postcode.getName(), district.getCity().getName(), district.getName(), newName);
                        eStreets = new HashSet<StreetModel>(eStreets);
                        eStreets.remove(t);
                        t.setName(newName);
                        Collection multiParcel = AliasPane.this.mergeStreets(t, eStreets);
                        if (multiParcel.isEmpty()) continue;
                        map.put(t, multiParcel);
                    }
                    if (AliasPane.this.showMultiParcels(map)) {
                        AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                        AliasPane.this.districtSearchListSelectionListener.valueChanged(null);
                    } else {
                        AliasPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                    StreetModel streetNewModel = (StreetModel)AliasPane.this.streets.getList().getSelectedValue();
                    if (streetNewModel != null && !newName.equals(streetOldName)) {
                        String alias1 = newName;
                        String alias2 = null;
                        if (!StringUtil.isBlank(alias1)) {
                            AliasPane.this.createNewStreetAlias(streetNewModel, alias1);
                            alias2 = alias1.replace(".", "");
                            alias2 = alias2.replace("\u00df", "ss");
                            if (alias2.toLowerCase().endsWith("str")) {
                                alias2 = alias2.substring(0, alias2.length() - 3).concat("Strasse");
                                AliasPane.this.createNewStreetAlias(streetNewModel, alias2);
                            } else if (alias2.toLowerCase().endsWith("strasse")) {
                                alias2 = alias2.substring(0, alias2.length() - 7).concat("Str.");
                                AliasPane.this.createNewStreetAlias(streetNewModel, alias2);
                            }
                        }
                        DefaultListModel dlm = AliasPane.this.streetAliases.getModel();
                        for (StreetAliasModel stAliasModel : streetNewModel.iterableAlias()) {
                            if (streetOldName.equals(StringUtil.nullToEmpty(stAliasModel.getName())) && !dlm.contains(stAliasModel)) {
                                dlm.addElement(stAliasModel);
                            }
                            if (alias1 != null && alias1.equals(StringUtil.nullToEmpty(stAliasModel.getName()))) {
                                if (!dlm.contains(stAliasModel)) continue;
                                dlm.removeElement(stAliasModel);
                                continue;
                            }
                            if (alias2 == null || !alias2.equals(StringUtil.nullToEmpty(stAliasModel.getName())) || !dlm.contains(stAliasModel)) continue;
                            dlm.removeElement(stAliasModel);
                        }
                    }
                    AliasPane.this.refreshData();
                }
            }

            @Override
            protected String getStringRepresentation(StreetModel t) {
                return t.getName();
            }

            @Override
            protected void move(List<StreetModel> streets) {
                DistrictModel district;
                TreeSet<DistrictModel> districts = new TreeSet<DistrictModel>(new Comparator<DistrictModel>(){

                    @Override
                    public int compare(DistrictModel o1, DistrictModel o2) {
                        int d = o1.getName().compareTo(o2.getName());
                        if (d == 0) {
                            d = o1.getTempUUID().compareTo(o2.getTempUUID());
                        }
                        return d;
                    }
                });
                for (StreetModel t : streets) {
                    PostcodeDistrictRelationModel pdr = t.getPostcodeDistrictRelation();
                    CityModel city = pdr.getDistrict().getCity();
                    PostcodeModel postcode = pdr.getPostcode();
                    for (DistrictModel district2 : city.iterableDistrict()) {
                        boolean found = false;
                        for (PostcodeDistrictRelationModel sPdr : district2.iterablePostcodes()) {
                            if (!postcode.equals(sPdr.getPostcode())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        districts.add(district2);
                    }
                }
                AbstractModelComboBox<DistrictModel> combo = new AbstractModelComboBox<DistrictModel>(districts, false){
                    private static final long serialVersionUID = -1531447701383738252L;

                    @Override
                    protected String getStringRepresentation(DistrictModel t) {
                        return t.getName();
                    }
                };
                JPanel panel = new JPanel(new FlowLayout());
                panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0])));
                panel.add(combo);
                int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(AliasPane.this), combo, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                if (d == 0 && this.checkForLastStreetInDistrictWithParcels(streets, district = (DistrictModel)combo.getSelectedItem())) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    HashMap<StreetModel, Collection> map = new HashMap<StreetModel, Collection>();
                    for (StreetModel t : streets) {
                        PostcodeModel postcode = t.getPostcodeDistrictRelation().getPostcode();
                        HashSet<StreetModel> eStreets = new HashSet<StreetModel>();
                        PostcodeDistrictRelationModel nPdr = null;
                        for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                            if (!pdr.getPostcode().equals(postcode)) continue;
                            nPdr = pdr;
                            for (StreetModel street : pdr.iterableStreets()) {
                                if (!street.getName().equals(t.getName())) continue;
                                eStreets.add(street);
                            }
                        }
                        eStreets.remove(t);
                        if (nPdr == null) {
                            throw new RuntimeException();
                        }
                        t.setPostcodeDistrictRelation(nPdr);
                        Collection multiParcels = AliasPane.this.mergeStreets(t, eStreets);
                        if (multiParcels.isEmpty()) continue;
                        map.put(t, multiParcels);
                    }
                    if (AliasPane.this.showMultiParcels(map)) {
                        AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                        AliasPane.this.districtSearchListSelectionListener.valueChanged(null);
                    } else {
                        AliasPane.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    }
                    AliasPane.this.refreshData();
                }
            }

            private boolean checkForLastStreetInDistrictWithParcels(List<StreetModel> streets, DistrictModel district) {
                HashSet<DistrictModel> districtsToCheck = new HashSet<DistrictModel>();
                for (StreetModel street : streets) {
                    PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
                    DistrictModel oDistrict = pdr.getDistrict();
                    if (oDistrict == district) continue;
                    districtsToCheck.add(oDistrict);
                }
                LinkedList<String> emptyDistrictNames = new LinkedList<String>();
                for (DistrictModel oDistrict : districtsToCheck) {
                    boolean found = false;
                    block2: for (PostcodeDistrictRelationModel pdr : oDistrict.iterablePostcodes()) {
                        for (StreetModel street : pdr.iterableStreets()) {
                            if (streets.contains(street) || street.isParcelsEmpty()) continue;
                            found = true;
                            break block2;
                        }
                    }
                    if (found) continue;
                    emptyDistrictNames.add(oDistrict.getName());
                }
                if (emptyDistrictNames.isEmpty()) {
                    return true;
                }
                Collections.sort(emptyDistrictNames);
                return 0 == JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(AliasPane.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.emptyDistrict", new Serializable[]{StringUtil.implode(emptyDistrictNames, ", ")}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            }
        };
        subPanel.add(this.streets);
        widthUnifier.add(this.streets);
        this.parcelList = new JList(new DefaultListModel());
        this.parcelList.setCellRenderer(new AbstractListCellRenderer<ParcelModel>(){
            private static final long serialVersionUID = -4166079844810433433L;

            @Override
            protected String getStringRepresentation(ParcelModel t) {
                String houseNumber = t.getHouseNumber();
                String houseNumberExtension = t.getHouseNumberExtension();
                boolean blankHouseNumber = StringUtil.isBlank(houseNumber);
                boolean blankHouseNumberExtension = StringUtil.isBlank(houseNumberExtension);
                if (blankHouseNumber && blankHouseNumberExtension) {
                    return "?";
                }
                String s = StringUtil.nullToEmpty(houseNumber);
                if (!blankHouseNumberExtension) {
                    char c = houseNumberExtension.trim().charAt(0);
                    if (Character.isDigit(c)) {
                        s = s + "/";
                    }
                    s = s + houseNumberExtension;
                }
                return s;
            }
        });
        this.parcelList.setEnabled(false);
        scroll = new JScrollPane(this.parcelList);
        scroll.setHorizontalScrollBarPolicy(32);
        subPanel.add(scroll);
        widthUnifier.add(scroll);
        l = new JLabel();
        subPanel.add(l);
        widthUnifier.add(l);
        this.cityAliases = new AbstractEditableJList<CityAliasModel>(){
            private static final long serialVersionUID = 4075308276512178496L;

            @Override
            protected CityAliasModel getAdd() {
                String alias;
                CityModel cityModel = (CityModel)AliasPane.this.cities.getList().getSelectedValue();
                if (cityModel != null && !StringUtil.isBlank(alias = AliasPane.this.getAliasName())) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    CityAliasModelImpl cityAliasModel = new CityAliasModelImpl();
                    cityAliasModel.setCity(cityModel);
                    cityAliasModel.setName(alias);
                    cityAliasModel.setSearch(StringUtil.normalize(alias));
                    AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                    if (alias.equals(StringUtil.nullToEmpty(cityModel.getName()))) {
                        return null;
                    }
                    return cityAliasModel;
                }
                return null;
            }

            @Override
            protected String getStringRepresentation(CityAliasModel t) {
                return t.getName();
            }

            @Override
            protected void remove(CityAliasModel t) {
                AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                t.setCity(null);
                t.delete();
                AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
            }

            @Override
            protected void update(CityAliasModel t) {
            }
        };
        subPanel.add(this.cityAliases);
        widthUnifier.add(this.cityAliases);
        this.districtAliases = new AbstractEditableJList<DistrictAliasModel>(){
            private static final long serialVersionUID = -7153818777413557057L;

            @Override
            protected DistrictAliasModel getAdd() {
                String alias;
                DistrictModel districtModel = (DistrictModel)AliasPane.this.districts.getList().getSelectedValue();
                if (districtModel != null && !StringUtil.isBlank(alias = AliasPane.this.getAliasName())) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    DistrictAliasModelImpl districtAliasModel = new DistrictAliasModelImpl();
                    districtAliasModel.setDistrict(districtModel);
                    districtAliasModel.setName(alias);
                    districtAliasModel.setSearch(StringUtil.normalize(alias));
                    AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                    if (alias.equals(StringUtil.nullToEmpty(districtModel.getName()))) {
                        return null;
                    }
                    return districtAliasModel;
                }
                return null;
            }

            @Override
            protected String getStringRepresentation(DistrictAliasModel t) {
                String name = t.getName();
                if (StringUtil.isBlank(name)) {
                    return "-";
                }
                return name;
            }

            @Override
            protected void remove(DistrictAliasModel t) {
                AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                t.setDistrict(null);
                t.delete();
                AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
            }

            @Override
            protected void update(DistrictAliasModel t) {
            }
        };
        subPanel.add(this.districtAliases);
        widthUnifier.add(this.districtAliases);
        this.streetAliases = new AbstractEditableJList<StreetAliasModel>(){
            private static final long serialVersionUID = 6731049921241549317L;

            @Override
            protected StreetAliasModel getAdd() {
                String alias;
                StreetModel streetModel = (StreetModel)AliasPane.this.streets.getList().getSelectedValue();
                if (streetModel != null && !StringUtil.isBlank(alias = AliasPane.this.getAliasName())) {
                    AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                    StreetAliasModelImpl streetAliasModel = new StreetAliasModelImpl();
                    streetAliasModel.setStreet(streetModel);
                    streetAliasModel.setName(alias);
                    String normalize = StringUtil.normalize(alias);
                    streetAliasModel.setSearch(normalize);
                    AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
                    if (alias.equals(StringUtil.nullToEmpty(streetModel.getName()))) {
                        return null;
                    }
                    return streetAliasModel;
                }
                return null;
            }

            @Override
            protected String getStringRepresentation(StreetAliasModel t) {
                return t.getName();
            }

            @Override
            protected void remove(StreetAliasModel t) {
                AliasPane.this.modelEnviroment.getUndoManager().startTransaction();
                t.setStreet(null);
                t.delete();
                AliasPane.this.modelEnviroment.getUndoManager().finishTransaction("");
            }

            @Override
            protected void update(StreetAliasModel t) {
            }
        };
        subPanel.add(this.streetAliases);
        widthUnifier.add(this.streetAliases);
        l = new JLabel();
        subPanel.add(l);
        widthUnifier.add(l);
        int textFieldHeight = this.postcode.getPreferredSize().height;
        int buttonHeight = cityBulkAliasInsert.getPreferredSize().height;
        for (JComponent component : components = new JComponent[]{this.postcode, this.city, this.district, this.street, this.country, cityBulkAliasInsert, disctrictBulkAliasInsert, streetBulkAliasInsert}) {
            int height = component instanceof JButton ? buttonHeight : textFieldHeight;
            Dimension min = component.getMinimumSize();
            Dimension pref = component.getPreferredSize();
            Dimension max = component.getMaximumSize();
            min.setSize(min.width, height);
            pref.setSize(pref.width, height);
            max.setSize(max.width, height);
            component.setMinimumSize(min);
            component.setPreferredSize(pref);
            component.setMaximumSize(max);
        }
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(subPanel, 5, 5, 5, 5, 2, 2);
        this.add((Component)subPanel, "Center");
        this.postcode.getDocument().addDocumentListener(new SearchDocumentListener<PostcodeModel>(this.postcode, this.postcodes){

            @Override
            protected List<PostcodeModel> fetchObjects(String value) {
                return AliasPane.this.loadPostcodes(value);
            }

            @Override
            protected SearchListSelectionListener getSearchListSelectionListenerToFire() {
                return AliasPane.this.postcodeSearchListSelectionListener;
            }
        });
        this.city.getDocument().addDocumentListener(new SearchDocumentListener<CityModel>(this.city, this.cities.getList()){

            @Override
            protected List<CityModel> fetchObjects(String value) {
                return AliasPane.this.loadCities(value);
            }

            @Override
            protected SearchListSelectionListener getSearchListSelectionListenerToFire() {
                return AliasPane.this.citySearchListSelectionListener;
            }
        });
        this.district.getDocument().addDocumentListener(new SearchDocumentListener<DistrictModel>(this.district, this.districts.getList()){

            @Override
            protected List<DistrictModel> fetchObjects(String value) {
                return AliasPane.this.loadDistricts(value);
            }

            @Override
            protected SearchListSelectionListener getSearchListSelectionListenerToFire() {
                return AliasPane.this.districtSearchListSelectionListener;
            }
        });
        this.street.getDocument().addDocumentListener(new SearchDocumentListener<StreetModel>(this.street, this.streets.getList()){

            @Override
            protected List<StreetModel> fetchObjects(String value) {
                return AliasPane.this.loadStreets(value);
            }

            @Override
            protected SearchListSelectionListener getSearchListSelectionListenerToFire() {
                return AliasPane.this.streetSearchListSelectionListener;
            }
        });
        this.postcodeSearchListSelectionListener = new SearchListSelectionListener(){

            @Override
            protected void loadSubValues() {
                List cities = AliasPane.this.loadCities(AliasPane.this.city.getText());
                AliasPane.this.updateList(AliasPane.this.cities.getList(), cities);
            }

            @Override
            protected void loadAliases() {
            }

            @Override
            protected void setEnablings() {
            }
        };
        this.postcodes.addListSelectionListener(this.postcodeSearchListSelectionListener);
        this.citySearchListSelectionListener = new SearchListSelectionListener(){

            @Override
            protected void loadSubValues() {
                List districts = AliasPane.this.loadDistricts(AliasPane.this.district.getText());
                AliasPane.this.updateList(AliasPane.this.districts.getList(), districts);
            }

            @Override
            protected void loadAliases() {
                DefaultListModel dlm = AliasPane.this.cityAliases.getModel();
                dlm.removeAllElements();
                AliasPane.this.cityAliases.clearUneditableElements();
                CityModel cityModel = (CityModel)AliasPane.this.cities.getList().getSelectedValue();
                if (cityModel != null) {
                    for (CityAliasModel cityAliasModel : cityModel.iterableAlias()) {
                        dlm.addElement(cityAliasModel);
                        if (!StringUtil.nullToEmpty(cityModel.getName()).equals(StringUtil.nullToEmpty(cityAliasModel.getName()))) continue;
                        AliasPane.this.cityAliases.addUneditableElement(cityAliasModel);
                    }
                }
            }

            @Override
            protected void setEnablings() {
                int i = AliasPane.this.cities.getList().getSelectedIndex();
                AliasPane.this.cityAliases.setEnabled(i >= 0);
            }
        };
        this.cities.getList().addListSelectionListener(this.citySearchListSelectionListener);
        this.districtSearchListSelectionListener = new SearchListSelectionListener(){

            @Override
            protected void loadSubValues() {
                List streets = AliasPane.this.loadStreets(AliasPane.this.street.getText());
                AliasPane.this.updateList(AliasPane.this.streets.getList(), streets);
            }

            @Override
            protected void loadAliases() {
                DefaultListModel dlm = AliasPane.this.districtAliases.getModel();
                dlm.removeAllElements();
                AliasPane.this.districtAliases.clearUneditableElements();
                DistrictModel districtModel = (DistrictModel)AliasPane.this.districts.getList().getSelectedValue();
                if (districtModel != null) {
                    for (DistrictAliasModel districtAliasModel : districtModel.iterableAlias()) {
                        dlm.addElement(districtAliasModel);
                        if (!StringUtil.nullToEmpty(districtModel.getName()).equals(StringUtil.nullToEmpty(districtAliasModel.getName()))) continue;
                        AliasPane.this.districtAliases.addUneditableElement(districtAliasModel);
                    }
                }
            }

            @Override
            protected void setEnablings() {
                int i = AliasPane.this.districts.getList().getSelectedIndex();
                boolean enabled = i >= 0;
                AliasPane.this.districtAliases.setEnabled(enabled);
            }
        };
        this.districts.getList().addListSelectionListener(this.districtSearchListSelectionListener);
        this.streetSearchListSelectionListener = new SearchListSelectionListener(){

            @Override
            protected void loadSubValues() {
                AliasPane.this.loadParcelsForSelectedStreet();
            }

            @Override
            protected void loadAliases() {
                DefaultListModel dlm = AliasPane.this.streetAliases.getModel();
                dlm.removeAllElements();
                AliasPane.this.streetAliases.clearUneditableElements();
                StreetModel streetModel = (StreetModel)AliasPane.this.streets.getList().getSelectedValue();
                if (streetModel != null) {
                    for (StreetAliasModel streetAliasModel : streetModel.iterableAlias()) {
                        dlm.addElement(streetAliasModel);
                        if (!StringUtil.nullToEmpty(streetModel.getName()).equals(StringUtil.nullToEmpty(streetAliasModel.getName()))) continue;
                        AliasPane.this.streetAliases.addUneditableElement(streetAliasModel);
                    }
                }
            }

            @Override
            protected void setEnablings() {
                int i = AliasPane.this.streets.getList().getSelectedIndex();
                AliasPane.this.streetAliases.setEnabled(i >= 0);
            }
        };
        this.streets.getList().addListSelectionListener(this.streetSearchListSelectionListener);
    }

    private String getAliasName() {
        String alias = JOptionPane.showInputDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.street.insertAliasQuestion", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.street.alias", new Serializable[0]), 3);
        return alias;
    }

    private String getNewName() {
        String alias = JOptionPane.showInputDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 3);
        return alias == null ? null : alias.trim();
    }

    private List<StreetModel> loadStreets(String value) {
        PostcodeModel postcode = (PostcodeModel)this.postcodes.getSelectedValue();
        CityModel city = (CityModel)this.cities.getList().getSelectedValue();
        DistrictModel district = (DistrictModel)this.districts.getList().getSelectedValue();
        if (postcode == null || city == null || district == null) {
            return Collections.emptyList();
        }
        HashSet<PostcodeDistrictRelationModel> pdrs1 = new HashSet<PostcodeDistrictRelationModel>(CollectionUtil.iterableToList(postcode.iterableDistricts()));
        HashSet<PostcodeDistrictRelationModel> pdrs2 = new HashSet<PostcodeDistrictRelationModel>(CollectionUtil.iterableToList(district.iterablePostcodes()));
        Collection pdrs = CollectionUtils.intersection(pdrs1, pdrs2);
        TreeSet<StreetModel> streets = new TreeSet<StreetModel>(new Comparator<StreetModel>(){

            @Override
            public int compare(StreetModel o1, StreetModel o2) {
                int d = o1.getName().compareTo(o2.getName());
                return d == 0 ? o1.getId().compareTo(o2.getId()) : d;
            }
        });
        String start = value.toLowerCase();
        Collection<StreetModel> streetsToCheck = new HashSet<StreetModel>();
        for (PostcodeDistrictRelationModel pdr : pdrs) {
            for (StreetModel street : pdr.iterableStreets()) {
                if (!street.getName().toLowerCase().startsWith(start)) continue;
                if (!this.withParcelsOnly || street.isParcelsInitialized() && !street.isParcelsEmpty()) {
                    streets.add(street);
                    continue;
                }
                streetsToCheck.add(street);
            }
        }
        if (!streetsToCheck.isEmpty()) {
            streetsToCheck = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchStreetsWithAtLeastOneParcel(streetsToCheck);
            streets.addAll(streetsToCheck);
        }
        return new ArrayList<StreetModel>(streets);
    }

    private List<DistrictModel> loadDistricts(String value) {
        PostcodeModel postcode = (PostcodeModel)this.postcodes.getSelectedValue();
        CityModel city = (CityModel)this.cities.getList().getSelectedValue();
        if (postcode == null || city == null) {
            return Collections.emptyList();
        }
        TreeSet<DistrictModel> districts = new TreeSet<DistrictModel>(new Comparator<DistrictModel>(){

            @Override
            public int compare(DistrictModel o1, DistrictModel o2) {
                int d = o1.getName().compareTo(o2.getName());
                return d == 0 ? o1.getId().compareTo(o2.getId()) : d;
            }
        });
        String start = value.toLowerCase();
        for (PostcodeDistrictRelationModel pdr : postcode.iterableDistricts()) {
            DistrictModel district = pdr.getDistrict();
            if (!StringUtil.getNotNull(district.getName()).toLowerCase().startsWith(start) || district.getCity() != city || this.withParcelsOnly && !this.hasParcels(district, postcode)) continue;
            districts.add(district);
        }
        return new ArrayList<DistrictModel>(districts);
    }

    private boolean hasParcels(DistrictModel district, PostcodeModel postcode) {
        System.out.println(new Date() + " hasParcel " + district.getId());
        for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
            if (pdr.getPostcode() != postcode) continue;
            for (StreetModel street : pdr.iterableStreets()) {
                if (street.isParcelsEmpty()) continue;
                System.out.println(new Date() + " hasParcel finished");
                return true;
            }
        }
        System.out.println(new Date() + " hasParcel finished (false)");
        return false;
    }

    private List<CityModel> loadCities(String value) {
        PostcodeModel postcode = (PostcodeModel)this.postcodes.getSelectedValue();
        if (postcode == null) {
            return Collections.emptyList();
        }
        TreeSet<CityModel> cities = new TreeSet<CityModel>(new Comparator<CityModel>(){

            @Override
            public int compare(CityModel o1, CityModel o2) {
                int d = o1.getName().compareTo(o2.getName());
                return d == 0 ? o1.getId().compareTo(o2.getId()) : d;
            }
        });
        String start = value.toLowerCase();
        for (PostcodeDistrictRelationModel pdr : postcode.iterableDistricts()) {
            CityModel city;
            DistrictModel district = pdr.getDistrict();
            if (this.withParcelsOnly && !this.hasParcels(district, postcode) || !(city = district.getCity()).getName().toLowerCase().startsWith(start)) continue;
            cities.add(city);
        }
        return new ArrayList<CityModel>(cities);
    }

    private List<PostcodeModel> loadPostcodes(String value) {
        Country country = this.country.getSelectedItem();
        List<PostcodeModel> list = this.cachedPostcodeLists.get(country);
        if (list == null) {
            list = this.modelEnviroment.getAllCaller().getStreetSearchCaller().searchPostcodesStartsWith(country, "", this.withParcelsOnly);
            this.cachedPostcodeLists.put(country, list);
        }
        if (value.isEmpty()) {
            return list;
        }
        LinkedList<PostcodeModel> filtered = new LinkedList<PostcodeModel>();
        boolean found = false;
        for (PostcodeModel postcode : list) {
            String name = postcode.getName();
            if (name.startsWith(value)) {
                found = true;
                filtered.add(postcode);
                continue;
            }
            if (!found) continue;
            break;
        }
        return filtered;
    }

    private <T> boolean updateList(JList list, List<T> found) {
        Object selected = list.getSelectedValue();
        DefaultListModel<T> dlm = new DefaultListModel<T>();
        boolean selectedFound = false;
        for (T t : found) {
            dlm.addElement(t);
            if (selectedFound || selected == null || !selected.equals(t)) continue;
            selectedFound = true;
        }
        list.setModel(dlm);
        if (selectedFound) {
            list.setSelectedValue(selected, true);
            return true;
        }
        return false;
    }

    private Map<StreetModel, Collection<Collection<ParcelModel>>> mergeCities(CityModel t, Collection<CityModel> cities) {
        HashSet<String> setAlias = new HashSet<String>();
        for (CityAliasModel cityAliasModel : t.iterableAlias()) {
            setAlias.add(cityAliasModel.getSearch());
        }
        for (CityModel cityModel : cities) {
            HashSet<DistrictModel> districts = new HashSet<DistrictModel>();
            for (DistrictModel district : cityModel.iterableDistrict()) {
                districts.add(district);
            }
            for (DistrictModel district : districts) {
                district.setCity(t);
            }
            HashSet<CityAliasModel> toDelete = new HashSet<CityAliasModel>();
            HashSet<CityAliasModel> toMove = new HashSet<CityAliasModel>();
            for (CityAliasModel cityAlias : cityModel.iterableAlias()) {
                String search = cityAlias.getSearch();
                if (setAlias.contains(search)) {
                    toDelete.add(cityAlias);
                    continue;
                }
                toMove.add(cityAlias);
                setAlias.add(search);
            }
            for (CityAliasModel alias : toDelete) {
                alias.setCity(null);
                alias.delete();
            }
            for (CityAliasModel alias : toMove) {
                alias.setCity(t);
            }
            cityModel.delete();
        }
        HashMap multipleDistricts = new HashMap();
        for (DistrictModel district : t.iterableDistrict()) {
            String name = district.getName();
            Tupel m = (Tupel)multipleDistricts.get(name);
            if (m == null) {
                multipleDistricts.put(name, new Tupel(district, new LinkedList()));
                continue;
            }
            ((Collection)m.getElement2()).add(district);
        }
        HashMap<StreetModel, Collection<Collection<ParcelModel>>> hashMap = new HashMap<StreetModel, Collection<Collection<ParcelModel>>>();
        for (Tupel entry : multipleDistricts.values()) {
            Map<StreetModel, Collection<Collection<ParcelModel>>> mMap = this.mergeDistricts((DistrictModel)entry.getElement1(), (Collection)entry.getElement2());
            hashMap.putAll(mMap);
        }
        return hashMap;
    }

    private Map<StreetModel, Collection<Collection<ParcelModel>>> mergeDistricts(DistrictModel t, Collection<DistrictModel> districts) {
        HashSet<String> setAlias = new HashSet<String>();
        for (DistrictAliasModel districtAliasModel : t.iterableAlias()) {
            setAlias.add(districtAliasModel.getSearch());
        }
        HashMap<PostcodeModel, PostcodeDistrictRelationModel> pdrMap = new HashMap<PostcodeModel, PostcodeDistrictRelationModel>();
        for (PostcodeDistrictRelationModel pdr : t.iterablePostcodes()) {
            pdrMap.put(pdr.getPostcode(), pdr);
        }
        for (DistrictModel district : districts) {
            HashSet<PostcodeDistrictRelationModel> toMovePdr = new HashSet<PostcodeDistrictRelationModel>();
            HashSet<PostcodeDistrictRelationModel> toDeletePdr = new HashSet<PostcodeDistrictRelationModel>();
            for (PostcodeDistrictRelationModel pdr : district.iterablePostcodes()) {
                PostcodeModel postcode = pdr.getPostcode();
                PostcodeDistrictRelationModel sPdr = (PostcodeDistrictRelationModel)pdrMap.get(postcode);
                if (sPdr == null) {
                    toMovePdr.add(pdr);
                    pdrMap.put(postcode, pdr);
                    continue;
                }
                toDeletePdr.add(pdr);
                ArrayList<StreetModel> streets = new ArrayList<StreetModel>(pdr.countStreets());
                for (StreetModel street : pdr.iterableStreets()) {
                    streets.add(street);
                }
                for (StreetModel street : streets) {
                    street.setPostcodeDistrictRelation(sPdr);
                }
            }
            for (PostcodeDistrictRelationModel pdr : toMovePdr) {
                pdr.setDistrict(t);
            }
            for (PostcodeDistrictRelationModel pdr : toDeletePdr) {
                pdr.setDistrict(null);
                pdr.setPostcode(null);
                pdr.delete();
            }
            HashSet<DistrictAliasModel> toDelete = new HashSet<DistrictAliasModel>();
            HashSet<DistrictAliasModel> toMove = new HashSet<DistrictAliasModel>();
            for (DistrictAliasModel districtAlias : district.iterableAlias()) {
                String search = districtAlias.getSearch();
                if (setAlias.contains(search)) {
                    toDelete.add(districtAlias);
                    continue;
                }
                toMove.add(districtAlias);
                setAlias.add(search);
            }
            for (DistrictAliasModel alias : toDelete) {
                alias.setDistrict(null);
                alias.delete();
            }
            for (DistrictAliasModel alias : toMove) {
                alias.setDistrict(t);
            }
            district.setCity(null);
            district.delete();
        }
        HashMap<StreetModel, Collection<Collection<ParcelModel>>> hashMap = new HashMap<StreetModel, Collection<Collection<ParcelModel>>>();
        for (PostcodeDistrictRelationModel pdr : t.iterablePostcodes()) {
            HashMap multipleStreets = new HashMap();
            for (StreetModel street : pdr.iterableStreets()) {
                String name = street.getName();
                Tupel m = (Tupel)multipleStreets.get(name);
                if (m == null) {
                    multipleStreets.put(name, new Tupel(street, new LinkedList()));
                    continue;
                }
                ((Collection)m.getElement2()).add(street);
            }
            for (Tupel tupel : multipleStreets.values()) {
                StreetModel street = (StreetModel)tupel.getElement1();
                Collection<Collection<ParcelModel>> multiParcels = this.mergeStreets(street, (Collection)tupel.getElement2());
                if (multiParcels.isEmpty()) continue;
                hashMap.put(street, multiParcels);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Collection<ParcelModel>> mergeStreets(StreetModel t, Collection<StreetModel> streets) {
        HashSet<String> setAlias = new HashSet<String>();
        for (StreetAliasModel streetAliasModel : t.iterableAlias()) {
            setAlias.add(streetAliasModel.getSearch());
        }
        for (StreetModel streetModel : streets) {
            HashSet<ParcelModel> parcels = new HashSet<ParcelModel>();
            for (ParcelModel parcelModel : streetModel.iterableParcels()) {
                parcels.add(parcelModel);
            }
            for (ParcelModel parcelModel : parcels) {
                parcelModel.setStreet(t);
            }
            HashSet<SegmentModel> segments = new HashSet<SegmentModel>();
            for (SegmentModel segment : streetModel.iterableSegments()) {
                segments.add(segment);
            }
            for (SegmentModel segment : segments) {
                segment.setStreet(t);
            }
            HashSet<StreetAliasModel> hashSet = new HashSet<StreetAliasModel>();
            HashSet<StreetAliasModel> toMove = new HashSet<StreetAliasModel>();
            for (StreetAliasModel districtAlias : streetModel.iterableAlias()) {
                String search = districtAlias.getSearch();
                if (setAlias.contains(search)) {
                    hashSet.add(districtAlias);
                    continue;
                }
                toMove.add(districtAlias);
                setAlias.add(search);
            }
            for (StreetAliasModel alias : hashSet) {
                alias.setStreet(null);
                alias.delete();
            }
            for (StreetAliasModel alias : toMove) {
                alias.setStreet(t);
            }
            streetModel.setPostcodeDistrictRelation(null);
            streetModel.delete();
        }
        HashMap map = new HashMap();
        for (ParcelModel parcel : t.iterableParcels()) {
            void var8_22;
            Tupel<String, String> tupel = new Tupel<String, String>(parcel.getHouseNumber().trim(), parcel.getHouseNumberExtension().trim());
            Collection collection = (Collection)map.get(tupel);
            if (collection == null) {
                HashSet hashSet = new HashSet();
                map.put(tupel, hashSet);
            }
            var8_22.add(parcel);
        }
        LinkedList<Collection<ParcelModel>> linkedList = new LinkedList<Collection<ParcelModel>>();
        for (Collection parcels : map.values()) {
            if (parcels.size() <= 1) continue;
            linkedList.add(parcels);
        }
        return linkedList;
    }

    private boolean showMultiParcels(Map<StreetModel, Collection<Collection<ParcelModel>>> map) {
        if (!map.isEmpty()) {
            MultiHousenumberPane multiHousenumberPane = new MultiHousenumberPane(map, this.modelEnviroment);
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), multiHousenumberPane, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 2, 1);
            return d == 0;
        }
        return true;
    }

    private void refreshData() {
        PostcodeModel selectedPostcode = (PostcodeModel)this.postcodes.getSelectedValue();
        List<CityModel> selectedCities = this.cities.getSelectedValues();
        List<DistrictModel> selectedDistricts = this.districts.getSelectedValues();
        List<StreetModel> selectedStreets = this.streets.getSelectedValues();
        List<CityAliasModel> selectedCityAliases = this.cityAliases.getSelectedValues();
        List<DistrictAliasModel> selectedDistrictAliases = this.districtAliases.getSelectedValues();
        List<StreetAliasModel> selectedStreetAliases = this.streetAliases.getSelectedValues();
        this.postcodeSearchListSelectionListener.valueChanged(null);
        this.citySearchListSelectionListener.valueChanged(null);
        this.districtSearchListSelectionListener.valueChanged(null);
        this.streetSearchListSelectionListener.valueChanged(null);
        this.postcodes.setSelectedValue(selectedPostcode, true);
        this.cities.setSelectedValues(selectedCities, true);
        this.districts.setSelectedValues(selectedDistricts, true);
        this.streets.setSelectedValues(selectedStreets, true);
        this.cityAliases.setSelectedValues(selectedCityAliases, true);
        this.districtAliases.setSelectedValues(selectedDistrictAliases, true);
        this.streetAliases.setSelectedValues(selectedStreetAliases, true);
    }

    protected void createNewStreetAlias(StreetModel streetNewModel, String alias) {
        boolean alreadyExists = false;
        for (StreetAliasModel stAlias : streetNewModel.iterableAlias()) {
            String aliasName = stAlias.getName() != null ? stAlias.getName() : "";
            if (!alias.equals(aliasName)) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            this.modelEnviroment.getUndoManager().startTransaction();
            StreetAliasModelImpl streetAliasModel = new StreetAliasModelImpl();
            streetAliasModel.setStreet(streetNewModel);
            streetAliasModel.setName(alias);
            streetAliasModel.setSearch(StringUtil.normalize(alias));
            this.modelEnviroment.getUndoManager().finishTransaction("");
        }
    }

    protected void createNewDistrictAlias(DistrictModel districtNewModel, String alias) {
        boolean alreadyExists = false;
        for (DistrictAliasModel dtAlias : districtNewModel.iterableAlias()) {
            String aliasName = dtAlias.getName() != null ? dtAlias.getName() : "";
            if (!alias.equals(aliasName)) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            this.modelEnviroment.getUndoManager().startTransaction();
            DistrictAliasModelImpl districtAliasModel = new DistrictAliasModelImpl();
            districtAliasModel.setDistrict(districtNewModel);
            districtAliasModel.setName(alias);
            districtAliasModel.setSearch(StringUtil.normalize(alias));
            this.modelEnviroment.getUndoManager().finishTransaction("");
        }
    }

    protected void createNewCityAlias(CityModel cityNewModel, String alias) {
        boolean alreadyExists = false;
        for (CityAliasModel ctAlias : cityNewModel.iterableAlias()) {
            String aliasName = ctAlias.getName() != null ? ctAlias.getName() : "";
            if (!alias.equals(aliasName)) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            this.modelEnviroment.getUndoManager().startTransaction();
            CityAliasModelImpl cityAliasModel = new CityAliasModelImpl();
            cityAliasModel.setCity(cityNewModel);
            cityAliasModel.setName(alias);
            cityAliasModel.setSearch(StringUtil.normalize(alias));
            this.modelEnviroment.getUndoManager().finishTransaction("");
        }
    }

    private void loadParcelsForSelectedStreet() {
        StreetModel streetModel = (StreetModel)this.streets.getList().getSelectedValue();
        DefaultListModel dlm = (DefaultListModel)this.parcelList.getModel();
        dlm.clear();
        if (streetModel != null) {
            TreeSet<ParcelModel> parcels = new TreeSet<ParcelModel>(new ParcelComparator());
            for (ParcelModel parcel : streetModel.iterableParcels()) {
                parcels.add(parcel);
            }
            for (ParcelModel parcel : parcels) {
                dlm.addElement(parcel);
            }
        }
    }

    protected CountryComboBox getCountryComboBox() {
        return this.country;
    }

    protected JTextField getPostcodeTextField() {
        return this.postcode;
    }

    protected JList getPostcodesList() {
        return this.postcodes;
    }

    protected JTextField getCityTextField() {
        return this.city;
    }

    protected AbstractMoveAddressPartList<CityModel> getCities() {
        return this.cities;
    }

    protected AbstractEditableJList<CityAliasModel> getCityAliases() {
        return this.cityAliases;
    }

    protected JTextField getDistrictTextField() {
        return this.district;
    }

    protected AbstractMoveAddressPartList<DistrictModel> getDistricts() {
        return this.districts;
    }

    protected AbstractEditableJList<DistrictAliasModel> getDistrictAliases() {
        return this.districtAliases;
    }

    protected JTextField getStreetTextField() {
        return this.street;
    }

    protected AbstractMoveAddressPartList<StreetModel> getStreets() {
        return this.streets;
    }

    protected AbstractEditableJList<StreetAliasModel> getStreetAliases() {
        return this.streetAliases;
    }

    protected JList getParcelList() {
        return this.parcelList;
    }

    private class StreetSplitAction
    extends AbstractAction {
        private static final long serialVersionUID = -6552087411547193719L;

        public StreetSplitAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.split", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreetModel streetModel = (StreetModel)AliasPane.this.streets.getList().getSelectedValue();
            PostcodeDistrictRelationModel pdr = streetModel.getPostcodeDistrictRelation();
            PostcodeModel postcode = pdr.getPostcode();
            DistrictModel district = pdr.getDistrict();
            String address = postcode.getCountry().getVehicleSign() + " " + postcode.getName() + " " + district.getCity().getName() + " - " + district.getName() + ", " + streetModel.getName();
            final AliasStreetSplitPane aliasStreetSplitPane = new AliasStreetSplitPane(streetModel, AliasPane.this.modelEnviroment){

                @Override
                protected void executeSplit() {
                    super.executeSplit();
                    AliasPane.this.loadParcelsForSelectedStreet();
                }
            };
            Window parent = SwingUtils.findWindowParent(AliasPane.this);
            CommonDialog commonDialog = new CommonDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.splitStreetDialogTitle", new Serializable[]{address}), Dialog.ModalityType.APPLICATION_MODAL){
                private static final long serialVersionUID = -4426748692241825256L;

                @Override
                protected Action getOkAction() {
                    return aliasStreetSplitPane.getOkAction(this);
                }

                @Override
                protected Component getMainComponent() {
                    return aliasStreetSplitPane;
                }

                @Override
                protected Action getCancelAction() {
                    return aliasStreetSplitPane.getCancelAction(this);
                }
            };
            commonDialog.buildLayout();
            commonDialog.pack();
            SwingUtils.center((Window)commonDialog, parent);
            commonDialog.setVisible(true);
        }
    }

    private class CountryActionListener
    implements ActionListener {
        private CountryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List postcodes = AliasPane.this.loadPostcodes(AliasPane.this.postcode.getText());
            AliasPane.this.updateList(AliasPane.this.postcodes, postcodes);
        }
    }

    private abstract class SearchListSelectionListener
    implements ListSelectionListener {
        private boolean active = true;

        private SearchListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.active) {
                this.loadSubValues();
                this.loadAliases();
                this.setEnablings();
            }
        }

        protected abstract void loadSubValues();

        protected abstract void loadAliases();

        protected abstract void setEnablings();

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    private abstract class SearchDocumentListener<T>
    implements DocumentListener {
        private JTextField field;
        private JList list;

        public SearchDocumentListener(JTextField field, JList list) {
            this.field = field;
            this.list = list;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateList();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateList();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateList();
        }

        private void updateList() {
            AliasPane.this.postcodeSearchListSelectionListener.setActive(false);
            AliasPane.this.citySearchListSelectionListener.setActive(false);
            AliasPane.this.districtSearchListSelectionListener.setActive(false);
            AliasPane.this.streetSearchListSelectionListener.setActive(false);
            List<T> found = this.fetchObjects(this.field.getText());
            boolean selected = AliasPane.this.updateList(this.list, found);
            AliasPane.this.postcodeSearchListSelectionListener.setActive(true);
            AliasPane.this.citySearchListSelectionListener.setActive(true);
            AliasPane.this.districtSearchListSelectionListener.setActive(true);
            AliasPane.this.streetSearchListSelectionListener.setActive(true);
            if (!selected) {
                this.getSearchListSelectionListenerToFire().valueChanged(null);
            }
        }

        protected abstract List<T> fetchObjects(String var1);

        protected abstract SearchListSelectionListener getSearchListSelectionListenerToFire();
    }
}

