/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias;

import de.datomino.peppergis.client.alias.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractMoveAddressPartList<T extends Model>
extends JPanel {
    private static final long serialVersionUID = -8252045754776107760L;
    private JList list = new JList(new DefaultListModel());
    private Action renameAction;
    private Action moveAction;

    public AbstractMoveAddressPartList() {
        this(true, true);
    }

    public AbstractMoveAddressPartList(boolean moveable, boolean renameable) {
        super(new BorderLayout());
        this.list.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setHorizontalScrollBarPolicy(32);
        this.add((Component)scroll, "Center");
        Action[] additionalActions = this.getAdditionalActions();
        if (moveable || renameable || additionalActions.length > 0) {
            JPanel panel = new JPanel(new FlowLayout());
            if (renameable) {
                this.renameAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.rename", new Serializable[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List t = AbstractMoveAddressPartList.this.getSelectedValues();
                        AbstractMoveAddressPartList.this.rename(t);
                    }
                };
                this.renameAction.setEnabled(false);
                panel.add(new JButton(this.renameAction));
            }
            if (moveable) {
                this.moveAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.move", new Serializable[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List t = AbstractMoveAddressPartList.this.getSelectedValues();
                        AbstractMoveAddressPartList.this.move(t);
                    }
                };
                this.moveAction.setEnabled(false);
                panel.add(new JButton(this.moveAction));
            }
            for (Action action : additionalActions) {
                panel.add(new JButton(action));
            }
            this.add((Component)panel, "South");
        }
        MoveAddressPartListSelectionListener listener = new MoveAddressPartListSelectionListener();
        this.list.addListSelectionListener(listener);
        this.list.getModel().addListDataListener(listener);
        this.list.setCellRenderer(new AbstractListCellRenderer<T>(){

            @Override
            protected String getStringRepresentation(T t) {
                return AbstractMoveAddressPartList.this.getStringRepresentation(t);
            }
        });
    }

    public List<T> getSelectedValues() {
        Object[] selectedValues = this.list.getSelectedValues();
        ArrayList<Model> t = new ArrayList<Model>(selectedValues.length);
        for (Object value : selectedValues) {
            t.add((Model)value);
        }
        return t;
    }

    protected abstract String getStringRepresentation(T var1);

    protected abstract void rename(List<T> var1);

    protected abstract void move(List<T> var1);

    private void setEnablings() {
        boolean selected = this.list.getSelectedIndex() >= 0;
        this.setEnablings(selected);
    }

    protected void setEnablings(boolean selected) {
        if (this.renameAction != null) {
            this.renameAction.setEnabled(selected);
        }
        if (this.moveAction != null) {
            this.moveAction.setEnabled(selected);
        }
    }

    public JList getList() {
        return this.list;
    }

    public void setSelectedValues(Collection<T> selects, boolean b) {
        DefaultListModel dlm = (DefaultListModel)this.list.getModel();
        ArrayList<Integer> s = new ArrayList<Integer>(selects.size());
        for (int i = 0; i < dlm.size(); ++i) {
            for (Model select : selects) {
                if (!dlm.elementAt(i).equals(select)) continue;
                s.add(i);
            }
        }
        int[] sa = new int[s.size()];
        int count = 0;
        Integer min = null;
        for (Integer i : s) {
            sa[count++] = i;
            min = min == null ? i : Math.min(min, i);
        }
        this.list.setSelectedIndices(sa);
        if (b && min != null) {
            this.list.ensureIndexIsVisible(min);
        }
    }

    protected Action[] getAdditionalActions() {
        return new Action[0];
    }

    private class MoveAddressPartListSelectionListener
    implements ListSelectionListener,
    ListDataListener {
        private MoveAddressPartListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AbstractMoveAddressPartList.this.setEnablings();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            AbstractMoveAddressPartList.this.setEnablings();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            AbstractMoveAddressPartList.this.setEnablings();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            AbstractMoveAddressPartList.this.setEnablings();
        }
    }
}

