/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.AbstractAreaLayerEditorPanel;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.PanelGroupPlacer;
import org.ktde.swing.navigator.NavigatorPanel;

public class SearchAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 6202677938713404589L;
    private AbstractAreaLayerEditorPanel areaLayerEditorPanel;

    public SearchAreaAction(AbstractAreaLayerEditorPanel baseLayerEditorPanel) {
        this.areaLayerEditorPanel = baseLayerEditorPanel;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        this.putValue("Name", this.getTitle());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createAndShowAreaSearchDialog();
    }

    private void createAndShowAreaSearchDialog() {
        JTextField shortcut = new JTextField();
        shortcut.setPreferredSize(new Dimension(200, shortcut.getPreferredSize().height));
        JTextField displayName = new JTextField();
        displayName.setPreferredSize(new Dimension(200, displayName.getPreferredSize().height));
        JRadioButton polygon = new JRadioButton();
        polygon.setPreferredSize(new Dimension(200, polygon.getPreferredSize().height));
        polygon.setSelected(true);
        JRadioButton parcels = new JRadioButton();
        parcels.setPreferredSize(new Dimension(200, parcels.getPreferredSize().height));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(polygon);
        buttonGroup.add(parcels);
        polygon.setSelected(true);
        JComponent[] components = new JComponent[]{shortcut, displayName, polygon, parcels};
        boolean isGenArea = this.areaLayerEditorPanel.getCurrentAreaLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT;
        String labelKey = isGenArea ? "messages.area.areaKey.order" : "messages.area.areaKey";
        String[] labels = new String[]{ModelEnviroment.getMessageResolver().resolveMessage(labelKey, new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.search.centerSurface", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.search.centerParcels", new Serializable[0])};
        JPanel searchAreaPanel = new JPanel();
        PanelGroupPlacer.createGroup((Container)searchAreaPanel, components, labels);
        boolean done = false;
        NavigatorPanel panel = this.areaLayerEditorPanel.getNavigatorPanel();
        AreaCaller areaCaller = this.areaLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller();
        List<AreaObjectModel> areaObjectModels = null;
        do {
            int d;
            if ((d = JOptionPane.showConfirmDialog(this.areaLayerEditorPanel, searchAreaPanel, this.getTitle(), 2)) == 0) {
                areaObjectModels = areaCaller.fetchAreaObjectsByLayerAndPrefixes(this.areaLayerEditorPanel.getCurrentAreaLayer(), shortcut.getText(), displayName.getText(), 1);
                if (areaObjectModels.isEmpty()) {
                    done = false;
                    JOptionPane.showMessageDialog(this.areaLayerEditorPanel, ModelEnviroment.getMessageResolver().resolveMessage(isGenArea ? "messages.areas.notFound.order" : "messages.areas.notFound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        if (areaObjectModels != null && !areaObjectModels.isEmpty()) {
            AreaObjectModel areaObject = areaObjectModels.get(0);
            this.areaLayerEditorPanel.select((Collection<AreaObjectModel>)Collections.singleton(areaObject));
            boolean polygonSelected = polygon.isSelected();
            boolean parcelsSelected = parcels.isSelected();
            Collection<Coordinate> coords = this.getCoordinatesToCenter(areaObject, polygonSelected, parcelsSelected);
            if (!coords.isEmpty()) {
                if (coords.size() == 1) {
                    panel.center(coords.iterator().next());
                } else {
                    panel.center(coords, 5);
                }
                panel.repaint(20L);
            }
            this.doSpecialActionsIfSearchSuccessFul(polygonSelected, parcelsSelected);
        }
    }

    protected void doSpecialActionsIfSearchSuccessFul(boolean polygonSelected, boolean parcelsSelected) {
    }

    private Collection<Coordinate> getCoordinatesToCenter(AreaObjectModel areaObject, boolean polygon, boolean parcels) {
        LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
        if (polygon) {
            coords.addAll(AreaObjectModelUtil.getAreaRectangle(areaObject));
        }
        if (parcels) {
            ImmutablePoint geom;
            for (AreaObjectParcelRelModel rel : areaObject.iterableAreaObjectParcelRel()) {
                ParcelModel parcel = rel.getParcel();
                geom = parcel.getGeom();
                if (GeoUtil.isNullPoint(geom)) continue;
                coords.add(geom.getCoordinate());
            }
            for (SubscriptionModel subscription : areaObject.iterableSubscriptions()) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(subscription.getLocation());
                if (locationWrapper == null || GeoUtil.isNullPoint(geom = locationWrapper.getGeoLocation())) continue;
                coords.add(geom.getCoordinate());
            }
        }
        return coords;
    }

    private String getTitle() {
        AreaLayerModel currentAreaLayer;
        String key = "messages.area.search";
        if (this.areaLayerEditorPanel != null && (currentAreaLayer = this.areaLayerEditorPanel.getCurrentAreaLayer()) != null && currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
            key = "messages.area.search.order";
        }
        return ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]);
    }
}

