/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.GeoObjectBucketMouseManipulatorAction;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;

public abstract class HoverGeoObjectBucketMouseManipulatorAction<S extends Model, T extends ImmutableGeoObject>
extends GeoObjectBucketMouseManipulatorAction<S, T> {
    private static final long serialVersionUID = -3193472969508841590L;
    protected Collection<S> hover;
    protected ModelEnviroment modelEnviroment;

    public HoverGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment) {
        super(navigatorPanel, maxUpp, title, bucketsModel);
        this.modelEnviroment = modelEnviroment;
    }

    protected abstract void renderHover(Collection<S> var1);

    protected abstract double getMindistForHover(int var1, int var2);

    protected abstract Cursor getHoverCursor(Collection<S> var1);

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    @Override
    protected void turnedOn() {
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        navigatorPanel.removeMouseWheelListener(navigatorPanel.getPanningAction());
        navigatorPanel.repaint(10L);
    }

    @Override
    protected void turnedOff() {
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            navigatorPanel.setCursor(Cursor.getDefaultCursor());
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseMoved(int x, int y) {
        Collection underMouse = this.findObjects(x, y, this.getMindistForHover(x, y));
        if (!underMouse.isEmpty()) {
            if (!CollectionUtil.isEqualsCollection(this.hover, underMouse)) {
                this.hover = underMouse;
                this.renderHover(null);
                this.renderHover(this.hover);
                this.getNavigatorPanel().setCursor(this.getHoverCursor(this.hover));
                this.getNavigatorPanel().repaint(10L);
            }
        } else if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }
}

