/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.dto.importer.DefaultExceptionResultDto;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.dto.ImmutableEnvelopeDto;
import de.datomino.util.message.Message;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.PanelGroupPlacer;
import org.ktde.swing.navigator.NavigatorPanel;

public class ClearDistanceMatrixAction
extends AbstractAction {
    private static final long serialVersionUID = -5529534192587863203L;
    private BusyHandler busyHandler;
    private NavigatorPanel navigatorPanel;
    private ModelEnviroment modelEnviroment;
    private Component parent;

    public ClearDistanceMatrixAction(String name, BusyHandler busyHandler, NavigatorPanel navigatorPanel, ModelEnviroment modelEnviroment, Component parent) {
        super(name);
        this.busyHandler = busyHandler;
        this.navigatorPanel = navigatorPanel;
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton useCoord = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useCoordinate", new Serializable[0]));
        Point2D.Double boundaryBottomLeft = this.navigatorPanel.getRealBoundaryBottomLeft();
        Point2D.Double boundaryTopRight = this.navigatorPanel.getRealBoundaryTopRight();
        CoordinateFactory coordinateFactory = this.navigatorPanel.getCoordinateFactory();
        Coordinate bottomLeft = boundaryBottomLeft == null ? Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0) : Wgs84Factory.INSTANCE.createCoordinate(coordinateFactory.createCoordinate(boundaryBottomLeft));
        Coordinate topRight = boundaryTopRight == null ? Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0) : Wgs84Factory.INSTANCE.createCoordinate(coordinateFactory.createCoordinate(boundaryTopRight));
        EnumComboBox<CoordinateFactory.Projections> coordinateFormat = new EnumComboBox<CoordinateFactory.Projections>(CoordinateFactory.Projections.class, false, CoordinateFactory.getListableProjections());
        coordinateFormat.setSelectedValue(CoordinateFactory.Projections.Wgs84);
        JTextField minX = new JTextField(String.valueOf(bottomLeft.getX()));
        JTextField maxX = new JTextField(String.valueOf(topRight.getX()));
        JTextField minY = new JTextField(String.valueOf(bottomLeft.getY()));
        JTextField maxY = new JTextField(String.valueOf(topRight.getY()));
        JComponent[] components = new JComponent[]{minX, maxX, minY, maxY, coordinateFormat};
        String[] labels = new String[]{"Min-X", "Max-X", "Min-Y", "Max-Y", "Format"};
        JPanel envelopePanel = new JPanel();
        PanelGroupPlacer.createGroup((Container)envelopePanel, components, labels);
        JPanel pane1 = new JPanel(new BorderLayout());
        pane1.add((Component)useCoord, "North");
        pane1.add((Component)envelopePanel, "Center");
        pane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JRadioButton useAreas = new JRadioButton("Verwende Gebiete");
        AreaObjectGenInfoDiscriminator[] ds = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND};
        final DefaultAreaObjectChooserPane areaObjectChooserPane = new DefaultAreaObjectChooserPane(null, this.modelEnviroment, false){
            private static final long serialVersionUID = 119648988278687902L;

            @Override
            protected String getShowAllMessageKey() {
                return "messages.area.selectAll";
            }
        };
        final AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, true, ds);
        areaLayerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    areaObjectChooserPane.setAreaLayerModel((AreaLayerModel)areaLayerComboBox.getSelectedItem());
                    areaObjectChooserPane.clearSelection();
                }
            }
        });
        components = new JComponent[]{areaLayerComboBox, areaObjectChooserPane};
        labels = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaLayer", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0])};
        JPanel areaPanel = new JPanel();
        PanelGroupPlacer.createGroup((Container)areaPanel, components, labels);
        JPanel pane2 = new JPanel(new BorderLayout());
        pane2.add((Component)useAreas, "North");
        pane2.add((Component)areaPanel, "Center");
        pane2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonGroup group = new ButtonGroup();
        group.add(useCoord);
        group.add(useAreas);
        useAreas.setSelected(true);
        Box box = Box.createVerticalBox();
        box.add(pane2);
        box.add(pane1);
        boolean tryagain = true;
        block7: while (tryagain && JOptionPane.showConfirmDialog(this.parent, box, "Fl\u00e4chen", 2) == 0) {
            DefaultExceptionResultDto resultDto;
            tryagain = false;
            HashSet<ImmutableEnvelopeDto> envelopeDtos = new HashSet<ImmutableEnvelopeDto>();
            if (useAreas.isSelected()) {
                AreaLayerModel selectedLayer = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
                if (selectedLayer == null) {
                    JOptionPane.showMessageDialog(this.parent, "Ein Gebiets-Layer muss ausgew\u00e4hlt werden");
                    tryagain = true;
                    continue;
                }
                AreaCaller areaCaller = this.modelEnviroment.getAllCaller().getAreaCaller();
                Collection<AreaObjectModel> selectedAreaObjects = areaCaller.fetchAreaObjectsById(areaObjectChooserPane.getSelectedAreaObjects());
                for (AreaObjectModel areaObject : selectedAreaObjects) {
                    if (areaObject == null || areaObject.getGeom() == null) {
                        JOptionPane.showMessageDialog(this.parent, "Die Gebiets-ID kann nicht gefunden werden - " + areaObject.getShortcut());
                        tryagain = true;
                        continue block7;
                    }
                    ImmutableEnvelope envelope = areaObject.getGeom().getEnvelope();
                    envelopeDtos.add(ImmutableEnvelopeDto.create(envelope));
                }
            } else {
                Coordinate bottomRight = null;
                Coordinate topLeft = null;
                CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFormat.getSelectedValue());
                try {
                    bottomRight = factory.createCoordinate(ClientFormUtil.getNumber(maxX.getText()).doubleValue(), ClientFormUtil.getNumber(minY.getText()).doubleValue());
                    topLeft = factory.createCoordinate(ClientFormUtil.getNumber(minX.getText()).doubleValue(), ClientFormUtil.getNumber(maxY.getText()).doubleValue());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.parent, "Die Koordinaten sind nicht akzeptiert");
                    tryagain = true;
                    continue;
                }
                if (bottomRight.getX() == topLeft.getX() || bottomRight.getY() == topLeft.getY()) {
                    JOptionPane.showMessageDialog(this.parent, "Die Koordinaten sind nicht akzeptiert");
                    tryagain = true;
                    continue;
                }
                ImmutableEnvelope envelope = ImmutableGeoObjectFactory.createImmutableLineString(bottomRight, topLeft, new Coordinate[0]).getEnvelope();
                envelopeDtos.add(ImmutableEnvelopeDto.create(envelope));
            }
            if (this.busyHandler != null) {
                this.busyHandler.start();
            }
            try {
                TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
                resultDto = tourCaller.clearDistanceMatrix(envelopeDtos);
            }
            finally {
                if (this.busyHandler != null) {
                    this.busyHandler.stop();
                }
            }
            if (resultDto != null && resultDto.isError()) {
                BufferedImage image;
                Window window = SwingUtils.findWindowParent(this.parent);
                try {
                    image = ImageIO.read(ClearDistanceMatrixAction.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(window, ModelEnviroment.getMessageResolver(), resultDto.getErrorMessages(), new Message("messages.default.error"), new Message("messages.default.ok"), image);
                errorMessageDialog.setVisible(true);
                continue;
            }
            JOptionPane.showMessageDialog(this.parent, "Distance-Matrix wurde erfolgreich gel\u00f6scht");
        }
    }
}

