/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.gui.area.ExportAreaDialog;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.file.FileChooseUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.AreaExportDto;
import de.datomino.peppergis.dto.exporter.AreaExportType;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.ExceptionMessageDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractExportAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 3258859003376469768L;
    private ModelEnviroment modelEnvironment;
    private boolean withLayer;

    public AbstractExportAreaAction(String name, ModelEnviroment modelEnvironment, boolean withLayer) {
        super(name);
        this.modelEnvironment = modelEnvironment;
        this.withLayer = withLayer;
    }

    protected ModelEnviroment getModelEnvironment() {
        return this.modelEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String title = this.getDialogTitle();
        ExportAreaDialog exportDialog = new ExportAreaDialog(this.getParentWindow(), title, this.modelEnvironment, this.withLayer){
            private static final long serialVersionUID = 5925983653723594857L;

            @Override
            protected void export(ExportAreaDialog dialog, final AreaExportType areaExportType, final CoordinateFactory.Projections coordinateFactory, final AreaLayerModel areaLayerModel, final boolean houseNumbersExtendToFullRange, final boolean showParcelsWithoutArea) {
                Tupel run;
                AbstractAsynchronousDialog<AreaExportDto> asynchronousDialog = new AbstractAsynchronousDialog<AreaExportDto>(dialog.getOwner(), ModelEnviroment.getMessageResolver().resolveMessage("messages.exporter.area.exporting", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.exporter.area.exporting", new Serializable[0]), 1, false, AbstractExportAreaAction.this.modelEnvironment){
                    private static final long serialVersionUID = 6036304173038341494L;

                    @Override
                    protected AsynchronousDto<AreaExportDto> getAsynchronousDto(String token) {
                        return AbstractExportAreaAction.this.getAsynchronousDto(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return AbstractExportAreaAction.this.startAsynchronousExport(areaExportType, coordinateFactory, areaLayerModel, houseNumbersExtendToFullRange, showParcelsWithoutArea);
                    }
                };
                try {
                    run = asynchronousDialog.run();
                }
                catch (Exception ex) {
                    ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(AbstractExportAreaAction.this.getParentWindow(), ex, this.getImageIcon());
                    exceptionMessageDialog.setVisible(true);
                    return;
                }
                if (!run.getElement2().booleanValue()) {
                    AreaExportDto areaExportDto = (AreaExportDto)run.getElement1();
                    ErrorMessages errorMessages = areaExportDto.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(dialog.getOwner(), ModelEnviroment.getMessageResolver(), errorMessages, this.getImageIcon());
                        errorMessageDialog.setVisible(true);
                    } else {
                        try {
                            AbstractExportAreaAction.this.writeData(areaExportDto, areaExportType);
                        }
                        catch (IOException e) {
                            ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(AbstractExportAreaAction.this.getParentWindow(), e, this.getImageIcon());
                            exceptionMessageDialog.setVisible(true);
                        }
                    }
                }
            }
        };
        exportDialog.setVisible(true);
    }

    protected abstract String getDialogTitle();

    private void writeData(AreaExportDto areaExportDto, AreaExportType areaExportType) throws IOException {
        List<byte[]> data = areaExportDto.getData();
        switch (areaExportType) {
            case SHP: {
                File file = FileChooseUtil.chooseSaveFile(this.getParentWindow());
                if (file == null) break;
                String path = file.getAbsolutePath();
                File dbf = new File(path + ".dbf");
                boolean write = true;
                if (dbf.exists()) {
                    write = this.askToWriteFile(dbf);
                }
                File shp = new File(path + ".shp");
                if (write && shp.exists()) {
                    write = this.askToWriteFile(shp);
                }
                File shx = new File(path + ".shx");
                if (write && shx.exists()) {
                    write = this.askToWriteFile(shx);
                }
                File prj = null;
                if (write && data.size() > 3 && (prj = new File(path + ".prj")).exists()) {
                    write = this.askToWriteFile(prj);
                }
                if (!write) break;
                FileUtils.writeByteArrayToFile(dbf, data.get(0));
                FileUtils.writeByteArrayToFile(shp, data.get(1));
                FileUtils.writeByteArrayToFile(shx, data.get(2));
                if (prj == null) break;
                FileUtils.writeByteArrayToFile(prj, data.get(3));
                break;
            }
            case STREET_CSV: {
                File file = FileChooseUtil.chooseSaveFile(this.getParentWindow());
                if (file == null || file.exists() && !this.askToWriteFile(file)) break;
                FileUtils.writeByteArrayToFile(file, data.get(0));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected abstract Window getParentWindow();

    private boolean askToWriteFile(File file) {
        int d = JOptionPane.showConfirmDialog(this.getParentWindow(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[]{file.getName()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
        return d == 0;
    }

    protected abstract String startAsynchronousExport(AreaExportType var1, CoordinateFactory.Projections var2, AreaLayerModel var3, boolean var4, boolean var5);

    protected abstract AsynchronousDto<AreaExportDto> getAsynchronousDto(String var1);
}

