/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.importer.DefaultCsvDto;
import de.datomino.peppergis.dto.importer.ResultDto;
import de.datomino.util.swing.blocking.BlockingDialog;
import de.datomino.util.swing.blocking.BusyDialog;
import de.datomino.util.swing.csv.CsvHeaderChooserDialog;
import de.datomino.util.swing.csv.CsvHeaderChooserPane;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.util.io.CsvReader;

public abstract class AbstractCsvAction<T extends DefaultCsvDto, U extends ResultDto>
extends AbstractAction {
    private static final long serialVersionUID = -3268720230212400191L;
    private Window parent;

    public AbstractCsvAction(Window parent, String actionName) {
        super(actionName);
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("csv", "csv");
        fileChooser.addChoosableFileFilter(fileFilter);
        fileChooser.setFileFilter(fileFilter);
        fileChooser.setMultiSelectionEnabled(false);
        int d = fileChooser.showOpenDialog(this.parent);
        if (d == 0) {
            final File file = fileChooser.getSelectedFile();
            try {
                CsvReader csvReader = new CsvReader(file, "ISO-8859-1");
                List<String> line = csvReader.readLine();
                csvReader.close();
                Collection<CsvHeaderChooserPane.CsvField> csvFields = this.getCsvFields();
                CsvHeaderChooserDialog csvHeaderChooserDialog = new CsvHeaderChooserDialog(this.parent, csvFields, line, csvFields.size() / 30 + 1){
                    private static final long serialVersionUID = 6947927976056123988L;

                    @Override
                    protected void doOkAction() {
                        this.dispose();
                        BlockingDialog blockingDialog = AbstractCsvAction.this.createBlockingDialog(AbstractCsvAction.this.parent);
                        Map<Serializable, String> headerMapping = this.getCsvHeaderChooserPane().getSelectedValues();
                        Object t = AbstractCsvAction.this.createDto(headerMapping);
                        ((DefaultCsvDto)t).setHeaderMapping(headerMapping);
                        Worker worker = new Worker(AbstractCsvAction.this, t, file, blockingDialog);
                        new Thread(worker).start();
                        blockingDialog.setVisible(true);
                        Exception ex = worker.getEx();
                        if (ex != null) {
                            throw new RuntimeException(ex);
                        }
                        Object u = worker.getResult();
                        if (u.isError()) {
                            AbstractCsvAction.this.handleError(u, this);
                        } else {
                            AbstractCsvAction.this.handleOk(u);
                            AbstractCsvAction.this.afterWork(u);
                        }
                    }

                    @Override
                    protected Component getSpecialNorthComponent() {
                        return AbstractCsvAction.this.getSpecialComponent();
                    }
                };
                csvHeaderChooserDialog.setVisible(true);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract void afterWork(U var1);

    protected Object createReportMessage(U u) {
        return "Ok";
    }

    protected abstract T createDto(Map<Serializable, String> var1);

    protected abstract Collection<CsvHeaderChooserPane.CsvField> getCsvFields();

    protected abstract U doWork(T var1, byte[] var2, BlockingDialog var3);

    protected BlockingDialog createBlockingDialog(Window parent) {
        BufferedImage image;
        try {
            image = ImageIO.read(AbstractCsvAction.class.getResourceAsStream("/images/pepper.png"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new BusyDialog(parent, "Importiere", image);
    }

    protected void handleError(U u, CsvHeaderChooserDialog csvHeaderChooserDialog) {
        JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessages(u.getErrorMessages(), "\n"), "Fehler", 0);
        csvHeaderChooserDialog.setVisible(true);
    }

    protected void handleOk(U u) {
        JOptionPane.showMessageDialog(this.parent, this.createReportMessage(u), "Report", 1);
    }

    protected JDialog[] getAdditionalDialogs() {
        return new JDialog[0];
    }

    protected Window getParent() {
        return this.parent;
    }

    protected abstract Component getSpecialComponent();

    private static class Worker
    implements Runnable {
        private T t;
        private File file;
        private U u;
        private Exception ex;
        private BlockingDialog busyDialog;
        final /* synthetic */ AbstractCsvAction this$0;

        public Worker(T t, File file, BlockingDialog busyDialog) {
            this.this$0 = var1_1;
            this.t = t;
            this.file = file;
            this.busyDialog = busyDialog;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
                byte[] content = FileUtils.readFileToByteArray(this.file);
                ((DefaultCsvDto)this.t).setContent(content);
                this.u = this.this$0.doWork(this.t, content, this.busyDialog);
            }
            catch (Exception ex) {
                this.ex = ex;
            }
            this.busyDialog.disposeManually();
        }

        public Exception getEx() {
            return this.ex;
        }

        public U getResult() {
            return this.u;
        }
    }
}

