/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.bi;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.LogisticServiceRouteDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.auth.Authorization;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.base.LetterDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.PoiAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.base.ServiceDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.dto.importer.DefaultExceptionResultDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.mobile.GeoTrackingDto;
import de.datomino.peppergis.dto.report.adp.AdpReportDto;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaStopDto;
import de.datomino.peppergis.dto.tour.AreaTourDto;
import de.datomino.peppergis.dto.tour.AreaTourScheduleDto;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.dto.tour.ServiceValueDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.dto.tour.StopSearchDto;
import de.datomino.peppergis.dto.tour.TourDifficultyLevelDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.dto.tour.TourSearchDto;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.exception.TourCalculationBlockException;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.ServiceStatusType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.geo.dto.ImmutableEnvelopeDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public interface TourBi {
    public List<DelivererDto> fetchAllDeliverers();

    public List<TourDto> fetchAllTours();

    public List<StopDto> fetchAllStops();

    public List<StopDto> fetchAllUnsortedStops();

    public List<StopDto> fetchAllStopsWithPoi();

    public List<ServiceDto> fetchAllServices();

    public List<LocationDto> fetchAllLocations();

    public Collection<LocationDto> fetchLocationsWithSameAddress(LogisticLocationDto<Long> var1);

    public List<PoiDto> fetchAllPois();

    public String fetchPoiNumberByAreaObjectId(Long var1);

    public List<StopDto> fetchStops(ImmutablePointDto var1, ImmutablePointDto var2, boolean var3);

    public List<SubscriptionDto> fetchSubscriptions(ImmutablePointDto var1, ImmutablePointDto var2);

    public List<SubscriptionDto> fetchSubscriptionsByAreaObject(AreaObjectDto var1, SubscriptionParameter var2);

    public LogisticQualifiedLocationDto validateLocation(LogisticLocationDto<?> var1) throws LogisticException;

    public LogisticTourDto<PointEntityId> calculateTour(LogisticTourDto<PointEntityId> var1, boolean var2) throws LogisticException;

    public LogisticTourDto<PointEntityId> optimizeTour(LogisticTourDto<PointEntityId> var1, OptimizationAlgorithmType var2, boolean var3) throws LogisticException;

    public List<StopDto> fetchStopsWithFilter(StopSearchDto var1);

    public ServiceStatusType calculateServiceStatus(ServiceDto var1, Collection<ServiceValueDto> var2);

    @Authorization
    public DelivererDto getDelivererById(Long var1);

    public BranchDto getBranchById(Long var1);

    public List<BranchDto> fetchAllBranchs();

    public Collection<PoiAttributeValueDescriptorDto> fetchAllPoiAttributeValueDescriptors();

    @Deprecated
    public List<String> getExpenses();

    public Collection<AreaTourDto> fetchAreaTours(AreaObjectDto var1, AreaTourType var2, PoiDto var3, RouteVehicleType var4);

    public Collection<StopDto> fetchStopsWithNullGeom(boolean var1);

    public List<PoiDto> fetchPoisWithTypes(Collection<PoiType> var1);

    public GeoDistanceMatrixWrapper getGeoDistance(ImmutablePointDto var1, ImmutablePointDto var2, RouteVehicleType var3, RouteType var4) throws LogisticException;

    public Collection<TourDto> fetchToursInTimeWindows(Collection<Tupel<Date, Date>> var1, DelivererDto var2, boolean var3);

    public List<TourDto> fetchAllUnsortedTours();

    public Collection<GeoTrackingDto> getGeoTrackings(DelivererDto var1, Collection<TourDto> var2, Set<GeoTrackingType> var3, long var4, Date var6);

    public Collection<TourDto> fetchToursForDeliverer(DelivererDto var1);

    public Collection<TourDto> fetchToursForDelivererInTimeInterval(DelivererDto var1, Tupel<Date, Date> var2);

    public List<StopDto> fetchStopsWithTimeWindows(Collection<Tupel<Date, Date>> var1, ImmutablePointDto var2, ImmutablePointDto var3);

    public Collection<AreaStopDto> fetchAreaStop(ParcelDto var1, SubscriptionDto var2, PoiDto var3, LetterDto var4);

    public LogisticServiceRouteDto calculateRouteBetweenPoints(ImmutablePointDto var1, ImmutablePointDto var2, RouteVehicleType var3, RouteType var4) throws LogisticException;

    public Collection<AreaTourDto> fetchAllAreaTours();

    public TourExportDto reviewAreaTours(Collection<Tupel<AreaObjectDto, List<Dto>>> var1, Collection<AreaTourParameter> var2, TourExportFormat var3, Quad<String, String, String, String> var4, boolean var5, boolean var6) throws TourCalculationBlockException;

    public TourExportDto reviewAreaToursExtended(Collection<Tupel<AreaObjectDto, List<Dto>>> var1, Collection<AreaTourParameter> var2, TourExportFormat var3, Quad<String, String, String, String> var4, boolean var5, boolean var6, boolean var7) throws TourCalculationBlockException;

    public Collection<Tupel<Collection<AreaTourScheduleDto>, Collection<HistoryAreaTourDto>>> fetchAreaTourSchedulesWithTimeWindow(Collection<AreaObjectDto> var1, Date var2, Date var3);

    public AreaTourDto getAreaTourFromAreaObject(AreaObjectDto var1, AreaTourParameter var2);

    public TourExportDto findAloneInArea(Collection<AreaObjectDto> var1, Collection<AreaTourType> var2, TourExportFormat var3, Quad<String, String, String, String> var4, Integer var5, Integer var6, boolean var7);

    public Collection<AreaTourDto> fetchAreaToursById(Collection<Long> var1);

    public Tripel<Integer, Date, Date> calculateTourTracking(TourDto var1, Set<GeoTrackingType> var2);

    public Collection<AreaDelivererDto> getDeliverersAttachedToHistoyAreaTour();

    public DefaultExceptionResultDto clearDistanceMatrix(Collection<ImmutableEnvelopeDto> var1);

    public Collection<StopDto> fetchStopsWithBadSegment(boolean var1);

    public Collection<StopDto> fetchNotCheckedStops(boolean var1);

    public AdpReportDto getAdpReport(Date var1, Date var2);

    public TourExportDto reviewOrigAreaTours(Collection<Tupel<AreaObjectDto, List<Dto>>> var1, Collection<AreaTourParameter> var2, TourExportFormat var3, boolean var4, boolean var5, boolean var6) throws TourCalculationBlockException;

    public String generateTourName(Integer var1, String var2, Integer var3);

    public Collection<TourDifficultyLevelDto> fetchAllTourDifficultyLevels();

    public Double getSegmentSearchFactor();

    public BranchDto fetchBranchByNameAndType(String var1, BranchType var2);

    public Collection<DelivererDto> fetchDeliverersByBranch(BranchDto var1);

    public List<AreaDelivererDto> fetchAllAreaDeliverers();

    public Collection<TourDto> fetchToursInTimeIntervals(Collection<Tupel<Date, Date>> var1, boolean var2);

    public Collection<AreaDelivererDto> fetchAllAreaDeliverersForAreaLayer(Collection<AreaLayerDto> var1);

    public Collection<LetterDto> fetchLettersByAreaObject(AreaObjectDto var1, SubscriptionParameter var2);

    public Collection<DeliveryRoundDto> fetchAllDeliveryRounds();

    public Collection<TourDto> searchTours(TourSearchDto var1);

    public StopDto getStopById(Long var1);

    public Collection<AreaDelivererDto> fetchAreaDeliverersByBranch(BranchDto var1);

    public boolean isUsedDeliverRound(DeliveryRoundDto var1);

    public boolean existsTourWithName(String var1);
}

