/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.util;

import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.model.AreaScheduleTimeBucketModel;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaTourScheduleModelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaTourScheduleModelUtil.class);
    public static String AREA_SCHEDULE_CELL_PATTERN;

    public static List<AreaTourScheduleNode> getSchedulesColorMap(Collection<AreaScheduleEntity> scheduleSet) {
        Color color = null;
        ArrayList<AreaTourScheduleNode> list = new ArrayList<AreaTourScheduleNode>(scheduleSet.size());
        for (AreaScheduleEntity schedule : scheduleSet) {
            color = GeoUtil.getNextColor(color);
            list.add(new AreaTourScheduleNode(schedule, color));
        }
        return list;
    }

    public static String getDisplayForTable(AreaTourScheduleModel schedule, String sep) {
        DeliveryRoundRelationModel rel = schedule.getDeliveryRound();
        String s1 = rel == null ? ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.noExists", new Serializable[0]) : rel.getDeliveryRound().getName();
        AreaDelivererModel deliverer = schedule.getDeliverer();
        String s2 = deliverer == null ? "" : deliverer.getDelivererNumber() + " - " + deliverer.getName();
        return s1 + sep + s2;
    }

    public static String getDisplayForLegend(AreaTourScheduleModel schedule) {
        if (schedule == null) {
            return "";
        }
        String s = schedule.getAreaObject().getShortcut() + " - ";
        s = s + DelivererModelUtil.getDisplayForPlanTable(schedule.getDeliverer(), false, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer1", new Serializable[0]));
        if (schedule.getDeliveryRound() != null) {
            s = s + " - " + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]) + ": " + schedule.getDeliveryRound().getDeliveryRound().getName();
        }
        return s;
    }

    public static String getPrintingInformation(AreaTourScheduleModel schedule, HistoryAreaTourModelWageResult wageResult, String pattern) {
        String info = pattern == null ? "" : pattern;
        info = info.replaceAll("%%%name%%%", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": " + schedule.getAreaObject().getShortcut());
        info = info.replaceAll("%%%deliverer%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer1", new Serializable[0]) + ": " + DelivererModelUtil.getDisplayString(schedule.getDeliverer()));
        info = info.replaceAll("%%%plannedStartTime%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(schedule.getPlannedStartTime()));
        if (wageResult == null) {
            return info;
        }
        HistoryAreaTourModel model = wageResult.getModel();
        info = info.replaceAll("%%%duration%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{AreaTourScheduleModelUtil.getMinuteDurationOfTour(wageResult)}));
        info = info.replaceAll("%%%distance%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", Integer.valueOf(NumericUtil.getIntegerValue(model.getLength()))));
        info = info.replaceAll("%%%numberOfStops%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfStops", Integer.valueOf(model.countHistoryAreaTourStop())));
        String[] ss = info.split("\n");
        info = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            if (StringUtil.isBlank(ss[i]) || ss[i].contains("%%%")) continue;
            info = info + "\n" + ss[i];
        }
        return info;
    }

    public static void loadInfoBox(Box box, HistoryAreaTourModelWageResult r) {
        if (r == null) {
            return;
        }
        if (box.getComponentCount() != 0) {
            box.add(new JLabel("------"));
        }
        HistoryAreaTourModel model = r.getModel();
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{AreaTourScheduleModelUtil.getMinuteDurationOfTour(r)}), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", Integer.valueOf(NumericUtil.getIntegerValue(model.getLength()))), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfStops", Integer.valueOf(model.countHistoryAreaTourStop())), 5));
    }

    public static String getMinuteDurationOfTour(HistoryAreaTourModelWageResult wageResult) {
        HistoryAreaTourModel model = wageResult.getModel();
        double duration = (double)NumericUtil.getIntegerValue(model.getDuration()) + wageResult.getReceptionTimeSum() + wageResult.getThrowTimeSum();
        return ClientFormUtil.getSecondTimeString(duration);
    }

    public static double calculateSalary(AreaDelivererModel deliverer, Date startTime, AreaScheduleTimeBucketModel bucket, boolean forecast) {
        Tupel<Date, Date> monthTupel = TimeUtil.getMonthTupel(startTime);
        Map<AreaObjectModel, Collection<AreaScheduleEntity>> map = bucket.findObjects(monthTupel.getElement1(), monthTupel.getElement2(), false);
        double salary = 0.0;
        Date lastScheduleTime = null;
        for (AreaObjectModel key : map.keySet()) {
            Collection<AreaScheduleEntity> entities = map.get(key);
            for (AreaScheduleEntity entity : entities) {
                Map<DeliveryRoundRelationModel, Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> roundMap = entity.getAllElements();
                for (Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult> tupel : roundMap.values()) {
                    AreaTourScheduleModel schedule = tupel.getElement1();
                    HistoryAreaTourModelWageResult result = tupel.getElement2();
                    if (schedule == null || schedule.getDeliverer() == null || !schedule.getDeliverer().equals(deliverer) || result == null || result.getModel() == null) continue;
                    Date plannedStartTime = schedule.getPlannedStartTime();
                    Tripel<Double, Double, Double> dayWork = AreaTourScheduleModelUtil.getDayWorkTripel(result, plannedStartTime);
                    salary += AreaTourScheduleModelUtil.calculateSalary(deliverer, plannedStartTime, dayWork);
                    if (lastScheduleTime != null && !plannedStartTime.after(lastScheduleTime)) continue;
                    lastScheduleTime = plannedStartTime;
                }
            }
        }
        if (forecast && lastScheduleTime != null) {
            HashMap weekDayMap = new HashMap();
            while (!TimeUtil.isSamedDay(lastScheduleTime, monthTupel.getElement2())) {
                Calendar calendar = TimeUtil.convertDateToCalendar(lastScheduleTime);
                calendar.add(5, 1);
                lastScheduleTime = calendar.getTime();
                int weekDay = calendar.get(7);
                ArrayList<Tripel<Double, Double, Double>> dayList = (ArrayList<Tripel<Double, Double, Double>>)weekDayMap.get(weekDay);
                if (dayList == null) {
                    dayList = new ArrayList<Tripel<Double, Double, Double>>();
                    for (int i = -1; i > -11 && dayList.size() <= 4; --i) {
                        calendar.add(3, i);
                        Tupel<Date, Date> dayTupel = TimeUtil.getDayTupel(calendar.getTime());
                        Map<AreaObjectModel, Collection<AreaScheduleEntity>> map2 = bucket.findObjects((Date)dayTupel.getElement1(), (Date)dayTupel.getElement2(), false);
                        for (AreaObjectModel key : map2.keySet()) {
                            for (AreaScheduleEntity entity : map2.get(key)) {
                                Map<DeliveryRoundRelationModel, Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> roundMap = entity.getAllElements();
                                for (Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult> tupel : roundMap.values()) {
                                    AreaTourScheduleModel schedule = tupel.getElement1();
                                    HistoryAreaTourModelWageResult result = tupel.getElement2();
                                    if (schedule == null || schedule.getDeliverer() == null || !schedule.getDeliverer().equals(deliverer) || result == null || result.getModel() == null) continue;
                                    dayList.add(AreaTourScheduleModelUtil.getDayWorkTripel(result, schedule.getPlannedStartTime()));
                                }
                            }
                        }
                    }
                    weekDayMap.put(weekDay, dayList);
                }
                Tripel<Double, Double, Double> sum = new Tripel<Double, Double, Double>(0.0, 0.0, 0.0);
                for (Tripel tripel : dayList) {
                    sum.setElement1((Double)sum.getElement1() + (Double)tripel.getElement1());
                    sum.setElement2((Double)sum.getElement2() + (Double)tripel.getElement2());
                    sum.setElement3((Double)sum.getElement3() + (Double)tripel.getElement3());
                }
                Tripel<Double, Double, Double> average = dayList.isEmpty() ? sum : new Tripel<Double, Double, Double>((Double)sum.getElement1() / (double)dayList.size(), (Double)sum.getElement2() / (double)dayList.size(), (Double)sum.getElement3() / (double)dayList.size());
                salary += AreaTourScheduleModelUtil.calculateSalary(deliverer, lastScheduleTime, average);
            }
        }
        return salary;
    }

    private static double calculateSalary(AreaDelivererModel deliverer, Date time, Tripel<Double, Double, Double> dayWork) {
        AreaDelivererRewardModel reward = DelivererModelUtil.getReward(deliverer, time);
        double hourReward = NumericUtil.getDoubleValue(reward == null ? null : reward.getHourReward());
        double salary = hourReward * dayWork.getElement1() / 3600.0;
        salary += NumericUtil.getDoubleValue(DelivererModelUtil.getSurcharge(deliverer, time));
        salary += NumericUtil.getDoubleValue(DelivererModelUtil.getNightSurcharge(deliverer, time)) * hourReward * dayWork.getElement2() / 3600.0;
        return salary += NumericUtil.getDoubleValue(reward == null ? null : reward.getKilometerRewardMotor()) * dayWork.getElement3() / 1000.0;
    }

    private static Tripel<Double, Double, Double> getDayWorkTripel(HistoryAreaTourModelWageResult result, Date startTime) {
        double timeSum = result == null ? 0.0 : result.getTimeSum();
        Tripel<Double, Double, Double> day = new Tripel<Double, Double, Double>(timeSum, 0.0, result == null ? 0.0 : (double)NumericUtil.getIntegerValue(result.getModel().getLength()));
        Date endTime = TimeUtil.add(startTime, 13, (int)Math.round(timeSum));
        int startNightSeconds = AreaTourModelUtil.NIGHT.getNightSeconds(startTime);
        int endNightSeconds = AreaTourModelUtil.NIGHT.getNightSeconds(endTime);
        if (startNightSeconds > 0 && endNightSeconds > 0) {
            day.setElement2(Double.valueOf(endNightSeconds - startNightSeconds));
        } else if (startNightSeconds > 0) {
            day.setElement2(Double.valueOf(AreaTourModelUtil.NIGHT.nightSecondSum() - startNightSeconds));
        } else if (endNightSeconds > 0) {
            day.setElement2(Double.valueOf(endNightSeconds));
        }
        return day;
    }

    static {
        String cellPattern = ModelEnviroment.getProperties().getProperty("areaSchedule.tablecell.pattern");
        AREA_SCHEDULE_CELL_PATTERN = StringUtil.nullToEmpty(cellPattern);
    }
}

