/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.util;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.wage.ProductWeightParameter;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class AreaScheduleEntity {
    private static ProductWeightParameter productWeightParameter;
    private Date date;
    private List<DeliveryRoundRelationModel> roundRels;
    private Collection<AreaTourScheduleModel> schedules;
    private Collection<HistoryAreaTourModelWageResult> historyResult;

    public AreaScheduleEntity(AreaObjectModel area, Date date, Collection<AreaTourScheduleModel> schedules, Collection<HistoryAreaTourModel> historys, ModelEnviroment modelEnviroment) {
        this.date = date;
        this.roundRels = AreaObjectModelUtil.getRounds(area, date);
        AreaScheduleEntity.getProductWeightParameter(modelEnviroment);
        final TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        this.schedules = schedules;
        historys = historys == null ? Collections.emptyList() : historys;
        this.historyResult = new HashSet<HistoryAreaTourModelWageResult>(historys.size());
        CollectionUtil.transform(historys, this.historyResult, new Transformer<HistoryAreaTourModel, HistoryAreaTourModelWageResult>(){

            @Override
            public HistoryAreaTourModelWageResult transform(HistoryAreaTourModel t) {
                return t == null ? null : new HistoryAreaTourModelWageResult(t, productWeightParameter, tourCaller);
            }
        });
    }

    private static synchronized void getProductWeightParameter(ModelEnviroment modelEnviroment) {
        if (productWeightParameter == null) {
            productWeightParameter = modelEnviroment.getAllCaller().getWageCaller().getProductWeightParameter();
        }
    }

    public Collection<AreaTourScheduleModel> getModel() {
        return this.schedules;
    }

    public Collection<HistoryAreaTourModelWageResult> getHistoryResult() {
        return this.historyResult;
    }

    public Map<DeliveryRoundRelationModel, Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> getAllElements() {
        HashMap<DeliveryRoundRelationModel, Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> map = new HashMap<DeliveryRoundRelationModel, Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>>();
        for (DeliveryRoundRelationModel rel : this.roundRels) {
            DeliveryRoundModel round = rel.getDeliveryRound();
            AreaTourScheduleModel foundSchedule = null;
            for (AreaTourScheduleModel schedule : this.schedules) {
                if (!rel.equals(schedule.getDeliveryRound())) continue;
                foundSchedule = schedule;
                break;
            }
            HistoryAreaTourModelWageResult foundHistory = null;
            for (HistoryAreaTourModelWageResult result : this.historyResult) {
                String deliveryRound = result.getModel().getDeliveryRound();
                if (!round.getName().equals(deliveryRound)) continue;
                foundHistory = result;
                break;
            }
            map.put(rel, new Tupel<AreaTourScheduleModel, Object>(foundSchedule, foundHistory));
        }
        return map;
    }

    public Date getDate() {
        return this.date;
    }

    public List<DeliveryRoundRelationModel> getRoundRels() {
        return this.roundRels;
    }
}

