/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import de.datomino.peppergis.util.RewardEntity;
import de.datomino.util.NumericUtil;
import de.datomino.util.time.TimeUtil;
import java.util.Calendar;
import java.util.Date;
import org.ktde.util.datatypes.Tupel;

public class AreaDelivererHistoryResult {
    private HistoryAreaTourModelWageResult wageResult;
    private RewardEntity rewardEntity;
    private NightSurchargeTimeWindow nightTimeWindow;

    public AreaDelivererHistoryResult(AreaDelivererModel deliverer, HistoryAreaTourModelWageResult wageResult) {
        this.wageResult = wageResult;
        Date date = this.wageResult.getModel().getDate();
        AreaDelivererRewardModel reward = DelivererModelUtil.getReward(deliverer, date);
        double kmRewardMotor = NumericUtil.getDoubleValue(reward.getKilometerRewardMotor());
        double kmRewardBike = NumericUtil.getDoubleValue(reward.getKilometerRewardBike());
        double kmRewardFoot = NumericUtil.getDoubleValue(reward.getKilometerRewardFoot());
        double hourReward = NumericUtil.getDoubleValue(reward.getHourReward());
        double nightSurcharge = NumericUtil.getDoubleValue(DelivererModelUtil.getNightSurcharge(deliverer, date));
        double extraCharge = NumericUtil.getDoubleValue(DelivererModelUtil.getSurcharge(deliverer, date));
        int nightSurchargeMinSeconds = 0;
        try {
            nightSurchargeMinSeconds = Integer.valueOf(ModelEnviroment.getProperties().getProperty("areatour.cost.nightSurchargeMinMinutes"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rewardEntity = new RewardEntity(kmRewardMotor, kmRewardBike, kmRewardFoot, hourReward, nightSurcharge, nightSurchargeMinSeconds, extraCharge);
        this.nightTimeWindow = AreaTourModelUtil.NIGHT.clone();
        Date nightStart = TimeUtil.createDate(0, 0, 0, AreaTourModelUtil.NIGHT.getStartHour(), AreaTourModelUtil.NIGHT.getStartMinute(), 0);
        Date nightEnd = TimeUtil.createDate(0, 0, 0, AreaTourModelUtil.NIGHT.getEndHour(), AreaTourModelUtil.NIGHT.getEndMinute(), 0);
        Calendar c = Calendar.getInstance();
        c.setTime(nightStart);
        this.nightTimeWindow.setStartHour(c.get(11));
        this.nightTimeWindow.setStartMinute(c.get(12));
        c.setTime(nightEnd);
        this.nightTimeWindow.setEndHour(c.get(11));
        this.nightTimeWindow.setEndMinute(c.get(12));
    }

    public double calcTimeSum() {
        Integer tourDuration = this.wageResult.getModel().getDuration();
        tourDuration = tourDuration == null ? 0 : tourDuration;
        return (double)tourDuration.intValue() + this.calcRestTime();
    }

    private double calcRestTime() {
        return this.wageResult.getThrowTimeSum() + this.wageResult.getReceptionTimeSum() + this.wageResult.getDifference();
    }

    public double calcTimeReward() {
        return this.rewardEntity.getHourReward() * this.calcTimeSum() / 3600.0;
    }

    public double calcRewardSum() {
        HistoryAreaTourModel history = this.wageResult.getModel();
        WageParameterModel parameter = history.getParameter();
        RouteVehicleType vehiclePoi = parameter.getVehicelTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = this.rewardEntity.getRewardForVehicle(vehiclePoi);
        double distanceCost = (double)history.getLengthFromPoi().intValue() * rewardEntityPoi.getElement1() + (double)history.getLengthToPoi().intValue() * rewardEntityPoi.getElement1();
        double durationCost = (double)history.getDurationFromPoi().intValue() * rewardEntityPoi.getElement2() + (double)history.getDurationToPoi().intValue() * rewardEntityPoi.getElement2();
        RouteVehicleType vehiclePickPoint = parameter.getVehicelTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = this.rewardEntity.getRewardForVehicle(vehiclePickPoint);
        distanceCost += (double)history.getLengthFromPickPoint().intValue() * rewardEntityPickPoint.getElement1() + (double)history.getLengthToPickPoint().intValue() * rewardEntityPickPoint.getElement1();
        durationCost += (double)history.getDurationFromPickPoint().intValue() * rewardEntityPickPoint.getElement2() + (double)history.getDurationToPickPoint().intValue() * rewardEntityPickPoint.getElement2();
        RouteVehicleType vehicleArea = parameter.getVehicelTypeInArea();
        Tupel<Double, Double> rewardEntityArea = this.rewardEntity.getRewardForVehicle(vehicleArea);
        int streetDistanceArea = NumericUtil.getIntegerValue(history.getLength()) - NumericUtil.getIntegerValue(history.getParcelLength());
        int durationSum = NumericUtil.getIntegerValue(history.getDuration());
        double streetDurationArea = (double)durationSum - (double)NumericUtil.getIntegerValue(history.getParcelLength()) / 1.3888888888888888;
        distanceCost += (double)(streetDistanceArea -= history.getLengthFromPoi() - history.getLengthToPoi() - history.getLengthFromPickPoint() - history.getLengthToPickPoint()) * rewardEntityArea.getElement1();
        durationCost += (streetDurationArea -= (double)(history.getDurationFromPoi() - history.getDurationToPoi() - history.getDurationFromPickPoint() - history.getDurationToPickPoint())) * rewardEntityArea.getElement2();
        Tupel<Double, Double> rewardEntityAccess = this.rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        distanceCost += (double)NumericUtil.getIntegerValue(history.getParcelLength()) * rewardEntityAccess.getElement1();
        durationCost += (double)NumericUtil.getIntegerValue(history.getParcelLength()) / 1.3888888888888888 * rewardEntityAccess.getElement2();
        durationCost += this.calcRestTime() * this.rewardEntity.getHourReward();
        int nightTime = this.getNightTime();
        if (nightTime < this.rewardEntity.getNightSurchargeMinMinutes() * 60) {
            nightTime = 0;
        }
        if (nightTime > 0) {
            nightTime = durationSum == 0 ? 0 : nightTime / durationSum;
        }
        durationCost += durationCost * (double)nightTime * this.rewardEntity.getNightSurcharge() / 100.0;
        return distanceCost / 1000.0 + durationCost * (1.0 + this.rewardEntity.getExtraCharge() / 100.0) / 3600.0;
    }

    public double calcNightSurcharge() {
        HistoryAreaTourModel history = this.wageResult.getModel();
        WageParameterModel parameter = history.getParameter();
        RouteVehicleType vehiclePoi = parameter.getVehicelTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = this.rewardEntity.getRewardForVehicle(vehiclePoi);
        double durationCost = (double)history.getDurationFromPoi().intValue() * rewardEntityPoi.getElement2() + (double)history.getDurationToPoi().intValue() * rewardEntityPoi.getElement2();
        RouteVehicleType vehiclePickPoint = parameter.getVehicelTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = this.rewardEntity.getRewardForVehicle(vehiclePickPoint);
        durationCost += (double)history.getDurationFromPickPoint().intValue() * rewardEntityPickPoint.getElement2() + (double)history.getDurationToPickPoint().intValue() * rewardEntityPickPoint.getElement2();
        RouteVehicleType vehicleArea = parameter.getVehicelTypeInArea();
        Tupel<Double, Double> rewardEntityArea = this.rewardEntity.getRewardForVehicle(vehicleArea);
        int durationSum = NumericUtil.getIntegerValue(history.getDuration());
        double streetDurationArea = (double)durationSum - (double)NumericUtil.getIntegerValue(history.getParcelLength()) / 1.3888888888888888;
        durationCost += (streetDurationArea -= (double)(history.getDurationFromPoi() - history.getDurationToPoi() - history.getDurationFromPickPoint() - history.getDurationToPickPoint())) * rewardEntityArea.getElement2();
        Tupel<Double, Double> rewardEntityAccess = this.rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        durationCost += (double)NumericUtil.getIntegerValue(history.getParcelLength()) / 1.3888888888888888 * rewardEntityAccess.getElement2();
        durationCost += this.calcRestTime() * this.rewardEntity.getHourReward();
        int nightTime = this.getNightTime();
        if (nightTime < this.rewardEntity.getNightSurchargeMinMinutes() * 60) {
            nightTime = 0;
        }
        if (nightTime > 0) {
            nightTime = durationSum == 0 ? 0 : nightTime / durationSum;
        }
        return durationCost * (double)nightTime * this.rewardEntity.getNightSurcharge() / 100.0 / 3600.0;
    }

    private int getNightTime() {
        HistoryAreaTourModel history = this.wageResult.getModel();
        Date date = history.getDate();
        int startNightSeconds = this.nightTimeWindow.getNightSeconds(date);
        int endNightSeconds = this.nightTimeWindow.getNightSeconds(TimeUtil.add(date, 13, NumericUtil.getIntegerValue(history.getDuration())));
        int nightTime = 0;
        if (startNightSeconds > 0 && endNightSeconds > 0) {
            nightTime = endNightSeconds - startNightSeconds;
        } else if (startNightSeconds > 0) {
            nightTime = this.nightTimeWindow.nightSecondSum() - startNightSeconds;
        } else if (endNightSeconds > 0) {
            nightTime = endNightSeconds;
        }
        return nightTime;
    }

    public double calctExtraSurcharge() {
        return this.calcRewardSum() - this.calcTimeReward() - this.calctKmReward() - this.calcNightSurcharge();
    }

    public double calctKmReward() {
        HistoryAreaTourModel history = this.wageResult.getModel();
        WageParameterModel parameter = history.getParameter();
        RouteVehicleType vehiclePoi = parameter.getVehicelTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = this.rewardEntity.getRewardForVehicle(vehiclePoi);
        double distanceCost = (double)history.getLengthFromPoi().intValue() * rewardEntityPoi.getElement1() + (double)history.getLengthToPoi().intValue() * rewardEntityPoi.getElement1();
        RouteVehicleType vehiclePickPoint = parameter.getVehicelTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = this.rewardEntity.getRewardForVehicle(vehiclePickPoint);
        distanceCost += (double)history.getLengthFromPickPoint().intValue() * rewardEntityPickPoint.getElement1() + (double)history.getLengthToPickPoint().intValue() * rewardEntityPickPoint.getElement1();
        RouteVehicleType vehicleArea = parameter.getVehicelTypeInArea();
        Tupel<Double, Double> rewardEntityArea = this.rewardEntity.getRewardForVehicle(vehicleArea);
        int streetDistanceArea = NumericUtil.getIntegerValue(history.getLength()) - NumericUtil.getIntegerValue(history.getParcelLength());
        distanceCost += (double)(streetDistanceArea -= history.getLengthFromPoi() - history.getLengthToPoi() - history.getLengthFromPickPoint() - history.getLengthToPickPoint()) * rewardEntityArea.getElement1();
        Tupel<Double, Double> rewardEntityAccess = this.rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        return (distanceCost += (double)NumericUtil.getIntegerValue(history.getParcelLength()) * rewardEntityAccess.getElement1()) / 1000.0;
    }

    public HistoryAreaTourModelWageResult getWageResult() {
        return this.wageResult;
    }
}

