/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.peppergis.client.gui.file.FileChooseUtil;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourPdfModel;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.ktde.util.datatypes.Tupel;

public class WagePrinter {
    public static void printHistories(Component parent, Collection<Tupel<String, List<HistoryAreaTourPdfModel>>> toPrint, boolean show) {
        block13: {
            ArrayList<Tupel<String, byte[]>> saveList;
            block14: {
                saveList = new ArrayList<Tupel<String, byte[]>>(toPrint.size());
                for (Tupel<String, List<HistoryAreaTourPdfModel>> tupel : toPrint) {
                    byte[] data;
                    List<HistoryAreaTourPdfModel> list = tupel.getElement2();
                    if (list.isEmpty()) continue;
                    if (list.size() == 1) {
                        data = list.get(0).getData();
                    } else {
                        try {
                            data = WagePrinter.mergePdfs(list);
                        }
                        catch (COSVisitorException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    saveList.add(new Tupel<String, byte[]>(tupel.getElement1(), data));
                }
                if (saveList == null || saveList.isEmpty()) break block13;
                if (!show) break block14;
                for (Tupel<String, List<HistoryAreaTourPdfModel>> tupel : saveList) {
                    try {
                        PdfUtil.showPdf(new ByteArrayInputStream((byte[])tupel.getElement2()));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                break block13;
            }
            File dir = FileChooseUtil.chooseSaveDirectory(SwingUtils.findWindowParent(parent));
            if (dir == null) break block13;
            for (Tupel tupel : saveList) {
                File pdf = new File(dir, (String)tupel.getElement1() + ".pdf");
                int count = 0;
                while (pdf.exists()) {
                    pdf = new File(dir, (String)tupel.getElement1() + "_" + StringUtils.leftPad(Integer.toString(count), 3, '0') + ".pdf");
                    ++count;
                }
                try {
                    FileUtils.writeByteArrayToFile(pdf, (byte[])tupel.getElement2());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static byte[] mergePdfs(List<HistoryAreaTourPdfModel> list) throws COSVisitorException, IOException {
        ArrayList<byte[]> inputs = new ArrayList<byte[]>(list.size());
        CollectionUtil.transform(list, inputs, new Transformer<HistoryAreaTourPdfModel, byte[]>(){

            @Override
            public byte[] transform(HistoryAreaTourPdfModel t) {
                return t.getData();
            }
        });
        InputStream pdf = PdfUtil.mergePdfs(inputs);
        return IOUtils.toByteArray(pdf);
    }
}

