/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.printer.AreaManagerPrinterImpl;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrintAction;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionPane;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.ScheduleInfoPrintType;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.KeyStroke;
import org.ktde.util.datatypes.Tupel;

public class PrintScreenshotAction
extends AbstractManagerPrintAction<AreaScheduleEntity> {
    private static final long serialVersionUID = -9086953323308238174L;
    private ManagerPrintOptionPane printOptionPane;

    public PrintScreenshotAction(AreaManagerMapGui mapGui, String title) {
        super(title, AbstractManagerPrintAction.PrintActionName.SCREENSHOT, new AreaManagerPrinterImpl(mapGui), mapGui);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
    }

    @Override
    protected Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> print() throws Exception {
        PrinterInformation printerInformation;
        ErrorMessage errorMessage = null;
        InputStream inputStream = null;
        if (this.printOptionPane == null) {
            this.printOptionPane = super.createPrintOptionPane(false, false, false);
        }
        if ((printerInformation = super.getPrintingInformation(this.printOptionPane)) != null && printerInformation.getPrintType() != null) {
            inputStream = this.managerPrinter.printScreenshot(this.mapGui.getNavigatorPanel(), printerInformation);
            if (inputStream == null) {
                errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.error.createpdf", new Serializable[0]));
            }
            return new Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages>(Collections.singletonList(new Tupel<String, InputStream>("", inputStream)), errorMessage == null ? new ErrorMessages() : new ErrorMessages(errorMessage));
        }
        return null;
    }

    @Override
    protected Tupel<InfoPrintPosition, String> getTypeTupel() {
        PrintProperties printProperties = this.mapGui.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> properties = printProperties.getScheduleProperties();
        ScheduleInfoPrintType scheduleNamePrintType = (ScheduleInfoPrintType)((Object)properties.get(PrintParameterKey.INFO_POSITION));
        String scheduleNameRenderingType = (String)((Object)properties.get(PrintParameterKey.INFO_PATTERN));
        return new Tupel<InfoPrintPosition, String>(scheduleNamePrintType, scheduleNameRenderingType);
    }

    @Override
    protected String[] getButtonItems() {
        return new String[]{ModelEnviroment.getMessageResolver().resolveMessage("buttons.ok", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])};
    }

    @Override
    protected PrinterInformation.PrintType getPrintType(int select) {
        switch (select) {
            case 0: {
                return PrinterInformation.PrintType.SCREENSHOT;
            }
        }
        return null;
    }

    @Override
    protected String getPropertyPrefix() {
        return "screenshot";
    }
}

