/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.pdf.engine.Format;
import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.pdf.printer.ImageInfoBox;
import de.datomino.pdf.printer.PrintRenderer;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.AreaScheduleLayerRenderer;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.printer.AreaManagerPrinter;
import de.datomino.peppergis.areamanager.printer.SchedulePrintingInformation;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.NotThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrinter;
import de.datomino.peppergis.client.manager.printer.AreaLegendPrintingInformation;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.print.HeaderType;
import de.datomino.peppergis.client.print.PlaceNameRenderer;
import de.datomino.peppergis.client.print.StreetNameRenderer;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.ScheduleInfoPrintType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Image;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.lang.math.NumberUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaManagerPrinterImpl
extends AbstractManagerPrinter<AreaTourScheduleNode>
implements AreaManagerPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaManagerPrinterImpl.class);
    private static final String TEMPLATEFORSCREEN = "fo/screenshot2pdf.vm";
    private static final String TEMPLATEFORSCHEDULE = "fo/schedule2pdf.vm";
    private static final String TEMPLATEFORLEGEND = "fo/legend2pdf.vm";
    private AreaManagerMapGui mapGui;

    public AreaManagerPrinterImpl(AreaManagerMapGui mapGui) {
        super(mapGui.getModelEnviroment(), TEMPLATEFORSCREEN, TEMPLATEFORLEGEND);
        this.mapGui = mapGui;
    }

    @Override
    public InputStream printSelectedSchedulesInPages(NavigatorPanel navigatorPanel, List<AreaTourScheduleNode> schedules, PrinterInformation printerInformation, byte[] layerLogoImage) throws Exception {
        if (schedules == null || schedules.isEmpty()) {
            return null;
        }
        int i = 1;
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Double footerHeight = super.setFootAndGetAdditionalLineHeightInCm(inputDatas, printerInformation);
        Tupel<Integer, Integer> rectangle = super.setParameter(printerInformation, inputDatas, layerLogoImage, footerHeight);
        ModelEnviroment modelEnviroment = this.mapGui.getModelEnviroment();
        HashSet<SchedulePrintingInformation> printingInformations = new HashSet<SchedulePrintingInformation>();
        for (AreaTourScheduleNode schedule : schedules) {
            for (HistoryAreaTourModelWageResult r : schedule.getEntity().getHistoryResult()) {
                SchedulePrintingInformation printingInformation = new SchedulePrintingInformation(schedule, (Format)inputDatas.get("format"), modelEnviroment);
                Collection<Coordinate> coordinates = r.getAreaRectangle(printerInformation.isWithPoi());
                NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanelForSchedule(navigatorPanel, CollectionUtil.buildArrayList(schedule), rectangle.getElement1(), rectangle.getElement2(), printerInformation);
                if (printerInformation.isUseVector()) {
                    HashMap<AreaTourScheduleNode, Color> nodeMap = new HashMap<AreaTourScheduleNode, Color>(1);
                    nodeMap.put(schedule, schedule.getColor());
                    String fetchSvg = super.createSvgForModel(printNavigatorPanel, nodeMap, coordinates, rectangle.getElement1().intValue(), rectangle.getElement2().intValue(), printerInformation);
                    printingInformation.setImagePath(fetchSvg);
                } else {
                    Image image = super.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
                    int logoWidth = (int)((double)NumberUtils.toFloat((String)inputDatas.get("logoWidth")) * printerInformation.getScale());
                    int logoHeight = (int)((double)Integer.parseInt((String)inputDatas.get("logoHeight")) * printerInformation.getScale() / 1.2);
                    Image imageWithLogo = inputDatas.get("logoImage") == null ? image : ClientSwingUtil.addLogoOnImage(image, (Image)inputDatas.get("logoImage"), logoWidth, logoHeight, printerInformation.getPosition());
                    printingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(imageWithLogo));
                }
                ScheduleInfoPrintType infoPrintType = (ScheduleInfoPrintType)printerInformation.getNamePrintType();
                if (infoPrintType != ScheduleInfoPrintType.NONE) {
                    switch (infoPrintType) {
                        case TOP: {
                            printingInformation.setTop(true);
                            break;
                        }
                        case DOWN: {
                            printingInformation.setDown(true);
                            break;
                        }
                    }
                }
                printingInformation.initialize(printerInformation);
                printingInformations.add(printingInformation);
            }
            LOGGER.info("create pdf from schedules - " + i++ + "/" + schedules.size());
        }
        inputDatas.put("schedules", printingInformations);
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(TEMPLATEFORSCHEDULE, inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    @Override
    public InputStream printSelectedSchedules(NavigatorPanel navigatorPanel, List<AreaTourScheduleNode> schedules, PrinterInformation printerInformation, byte[] layerLogoImage) throws Exception {
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Double footerHeight = super.setFootAndGetAdditionalLineHeightInCm(inputDatas, printerInformation);
        Tupel<Integer, Integer> rectangle = super.setParameter(printerInformation, inputDatas, layerLogoImage, footerHeight);
        SchedulePrintingInformation printingInformation = new SchedulePrintingInformation(schedules, null, (Format)inputDatas.get("format"), this.mapGui.getModelEnviroment());
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        for (AreaTourScheduleNode schedule : schedules) {
            for (HistoryAreaTourModelWageResult r : schedule.getEntity().getHistoryResult()) {
                if (r == null) continue;
                coordinates.addAll(r.getAreaRectangle(printerInformation.isWithPoi()));
            }
        }
        NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanelForSchedule(navigatorPanel, schedules, rectangle.getElement1(), rectangle.getElement2(), printerInformation);
        if (printerInformation.isUseVector()) {
            HashMap<AreaTourScheduleNode, Color> nodeMap = new HashMap<AreaTourScheduleNode, Color>(schedules.size());
            for (AreaTourScheduleNode node : schedules) {
                nodeMap.put(node, node.getColor());
            }
            String fetchSvg = super.createSvgForModel(printNavigatorPanel, nodeMap, coordinates, rectangle.getElement1().intValue(), rectangle.getElement2().intValue(), printerInformation);
            printingInformation.setImagePath(fetchSvg);
        } else {
            Image image = super.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
            int logoWidth = (int)((double)NumberUtils.toFloat((String)inputDatas.get("logoWidth")) * printerInformation.getScale());
            int logoHeight = (int)((double)NumberUtils.toFloat((String)inputDatas.get("logoHeight")) * printerInformation.getScale() / 1.2);
            Image imageWithLogo = inputDatas.get("logoImage") == null ? image : ClientSwingUtil.addLogoOnImage(image, (Image)inputDatas.get("logoImage"), logoWidth, logoHeight, printerInformation.getPosition());
            printingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(imageWithLogo));
        }
        printingInformation.initialize(printerInformation);
        inputDatas.put("schedules", CollectionUtil.buildLinkedList(printingInformation));
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(TEMPLATEFORSCHEDULE, inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    @Override
    protected Tupel<SVGGraphics2D, Double> renderSvg(NavigatorPanel navigatorPanel, Map<AreaTourScheduleNode, Color> models, int width, int height, Coordinate topLeft, Coordinate bottomRight, PrinterInformation printInformation) {
        NavigatorPanel printNavigatorPanel = new NavigatorPanel(null, navigatorPanel.getCoordinateFactory(), null);
        AreaScheduleLayerRenderer layerRenderer = new AreaScheduleLayerRenderer(this.mapGui, this.mapGui.getModelEnviroment());
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (!(navigatorRenderer instanceof AreaScheduleLayerRenderer) || !navigatorRenderer.isActive()) continue;
            if (models != null) {
                try {
                    layerRenderer.setSchedulesWithColor(models.keySet());
                }
                catch (LogisticException e) {
                    ErrorMessagesDialog.creatAndShow(e.getLocalizedMessage(), this.mapGui);
                }
                layerRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(layerRenderer);
                break;
            }
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
            break;
        }
        PrintRenderer printRenderer = new PrintRenderer(navigatorPanel, layerRenderer, topLeft, bottomRight);
        return printRenderer.render(width, height);
    }

    private NavigatorPanel createPrintNavigatorPanelForSchedule(NavigatorPanel navigatorPanel, List<AreaTourScheduleNode> schedules, Integer width, int height, PrinterInformation printerInformation) {
        NavigatorPanel printNavigatorPanel = super.creatEmptyPrintNavigatorPanel(navigatorPanel, width, height, printerInformation);
        ModelEnviroment modelEnviroment = this.mapGui.getModelEnviroment();
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (navigatorRenderer instanceof AreaScheduleLayerRenderer && navigatorRenderer.isActive()) {
                if (schedules != null) {
                    AreaScheduleLayerRenderer layerRenderer = new AreaScheduleLayerRenderer(this.mapGui, modelEnviroment);
                    try {
                        layerRenderer.setSchedulesWithColor(schedules);
                    }
                    catch (LogisticException e) {
                        ErrorMessagesDialog.creatAndShow(e.getLocalizedMessage(), this.mapGui);
                    }
                    layerRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(layerRenderer);
                    continue;
                }
                navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(navigatorRenderer);
                continue;
            }
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) {
                NotThreadingOsmNavigatorRenderer osmrenderer = new NotThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
                osmrenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(osmrenderer);
                try {
                    if (printerInformation.getPrintPlacesFont() != null) {
                        PlaceNameRenderer placeNameRenderer = new PlaceNameRenderer(modelEnviroment, printerInformation.getPrintPlacesFont());
                        placeNameRenderer.setNavigatorPanel(printNavigatorPanel);
                        printNavigatorPanel.addRenderer(placeNameRenderer);
                    }
                }
                catch (Exception placeNameRenderer) {
                    // empty catch block
                }
                try {
                    if (printerInformation.getPrintStreetsFont() == null) continue;
                    StreetNameRenderer streetNameRenderer = new StreetNameRenderer(modelEnviroment, printerInformation.getPrintStreetsFont());
                    streetNameRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(streetNameRenderer);
                }
                catch (Exception exception) {}
                continue;
            }
            if (navigatorRenderer instanceof AreaLayerRenderer && navigatorRenderer.isActive()) {
                navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(navigatorRenderer);
                continue;
            }
            if (schedules != null) continue;
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
        }
        return printNavigatorPanel;
    }

    @Override
    protected Tupel<AreaLayerModel, AreaObjectModel> getAreaObject() {
        return new Tupel<AreaLayerModel, Object>(this.mapGui.getLayer(), null);
    }

    @Override
    public InputStream printAreaLegend(NavigatorPanel navigatorPanel, List<AreaObjectLogisticTourMapNode> tourNodes, PrinterInformation printerInformation, byte[] layerLogoImage) throws Exception {
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Double footerHeight = super.setFootAndGetAdditionalLineHeightInCm(inputDatas, printerInformation);
        Tupel<Integer, Integer> rectangle = this.setParameter(printerInformation, inputDatas, layerLogoImage, footerHeight);
        ArrayList<AreaLegendPrintingInformation> printingInformations = new ArrayList<AreaLegendPrintingInformation>(tourNodes.size());
        for (AreaObjectLogisticTourMapNode node : tourNodes) {
            LogisticStopDto<PointEntityId> firstModel;
            HeaderType headerType = null;
            AllObjectFilterLayerRenderer objectRenderer = node.getAllObjectFilterLayerRenderer();
            if (objectRenderer != null) {
                AreaTourType areaTourType = objectRenderer.getAreaTourType();
                switch (areaTourType.getAreaObjectType()) {
                    case LETTER: {
                        headerType = HeaderType.LETTER;
                        break;
                    }
                    case PARCEL: 
                    case PARCEL_WITHOUT_SUBSCRIPTION: {
                        headerType = HeaderType.PARCEL;
                        break;
                    }
                    case SUBSCRIPTION: {
                        headerType = HeaderType.SUBSCRIPTION;
                        break;
                    }
                    case PARCEL_WITH_LETTER: 
                    case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: 
                    case SUBSCRIPTION_WITH_LETTER: 
                    case PARCEL_SUBSCRIPTION: 
                    case PARCEL_SUBSCRIPTION_LETTER: {
                        headerType = HeaderType.MIXED;
                    }
                }
            }
            System.err.println("Creating print legend information");
            List<LogisticStopDto<PointEntityId>> stops = LogisticServicesUtil.getAllStops(node.getTour());
            ArrayList<LegendObject<Object>> models = new ArrayList<LegendObject<Object>>(node.getModelSum());
            int sortOrder = 1;
            for (LogisticStopDto<PointEntityId> stop : stops) {
                models.add(new LegendObject<LogisticStopDto<PointEntityId>>(stop, Color.BLACK, sortOrder));
                ++sortOrder;
            }
            sortOrder = 1;
            if (objectRenderer != null) {
                for (Model model : objectRenderer.getAllNullGeoms()) {
                    models.add(new LegendObject<Model>(model, Color.BLACK, sortOrder));
                    ++sortOrder;
                }
            }
            AreaLegendPrintingInformation printingInformation = new AreaLegendPrintingInformation(models, null, (Format)inputDatas.get("format"), headerType, this.modelEnviroment);
            Map<PrintPropertyKey, Serializable> areaTourProperties = this.modelEnviroment.getPrintProperties().getAreaTourProperties();
            String poiMaxDistanceString = String.valueOf(areaTourProperties.get(PrintParameterKey.POI_MAX_DISTANCE));
            LogisticStopDto<PointEntityId> logisticStopDto = firstModel = stops.size() < 2 ? null : stops.get(0);
            if (!StringUtil.isBlank(poiMaxDistanceString) && firstModel != null && firstModel.getStopType() != null && firstModel.getStopType().isPoi()) {
                try {
                    int poiMaxDistance = Integer.parseInt(poiMaxDistanceString);
                    ImmutablePointDto geomDto0 = firstModel.getLocation().getGeom();
                    ImmutablePoint geom0 = geomDto0 == null ? null : (ImmutablePoint)geomDto0.getGeoObject();
                    LogisticStopDto<PointEntityId> m1 = stops.get(1);
                    ImmutablePointDto geomDto1 = m1.getLocation().getGeom();
                    ImmutablePoint geom1 = geomDto1 == null ? null : (ImmutablePoint)geomDto1.getGeoObject();
                    double fromPoi = GeoUtils.getDistanceInMeter(geom0, geom1);
                    printerInformation.setWithPoi((double)poiMaxDistance > fromPoi);
                }
                catch (Exception e) {
                    System.err.println("failed poi max distance - " + poiMaxDistanceString);
                }
            }
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(objectRenderer.getAreaRectangles(!printerInformation.isWithPoi()));
            System.err.println("Creating panel");
            Tupel<NavigatorPanel, List<NavigatorRenderer>> printNavigatorPanelTupel = this.createPrintNavigatorPanel(navigatorPanel, coordinates, rectangle.getElement1(), rectangle.getElement2(), printerInformation, false, false);
            NavigatorPanel printNavigatorPanel = printNavigatorPanelTupel.getElement1();
            objectRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(objectRenderer);
            if (printerInformation.isUseVector()) {
                String fetchSvg = this.createSvgForScreenshot(printerInformation, inputDatas, printNavigatorPanel, navigatorPanel);
                printingInformation.setImagePath(fetchSvg);
            } else {
                Image image = this.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
                Image logoImage = (Image)inputDatas.get("logoImage");
                Image imageWithLogo = logoImage == null ? image : ClientSwingUtil.addLogoOnImage(image, logoImage, (int)NumberUtils.toFloat((String)inputDatas.get("logoWidth")), (int)NumberUtils.toFloat((String)inputDatas.get("logoHeight")), printerInformation.getPosition());
                printingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(imageWithLogo));
                double widthMM = (double)imageWithLogo.getWidth(null) / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0 / printerInformation.getScale();
                double heightMM = (double)imageWithLogo.getHeight(null) / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0 / printerInformation.getScale();
                String heightString = heightMM + "mm";
                inputDatas.put("imageHeight", heightString);
                String widthString = widthMM + "mm";
                inputDatas.put("imageWidth", widthString);
            }
            String info = node.getTourInfo(printerInformation.getNameRenderingType());
            List<String> lines = this.extractLines(printerInformation.getSpecialMessage());
            if (lines != null) {
                info = info + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0]) + "\n";
                for (String line : lines) {
                    info = info + line + "\n";
                }
                info = info + "\n";
            }
            AreaObjectModel areaObject = node.getAreaObject();
            System.err.println("Initializing");
            printingInformation.initialize(printerInformation, info);
            ImageInfoBox imageInfoBox = (ImageInfoBox)inputDatas.get("imageInfoBox");
            if (imageInfoBox.isActive() && areaObject != null) {
                ImageInfoBox currentImageInfoBox = imageInfoBox.clone();
                String imageInfo = currentImageInfoBox.getInfo().replaceAll("%%%shortcut%%%", areaObject.getShortcut());
                imageInfo = imageInfo.replaceAll("%%%displayname%%%", areaObject.getDisplayname());
                currentImageInfoBox.setInfo(imageInfo);
                printingInformation.setImageInfoBox(currentImageInfoBox);
            }
            if (areaObject != null) {
                String headInfo = (String)inputDatas.get("headInfoArea");
                headInfo = headInfo.replaceAll("%%%shortcut%%%", areaObject.getShortcut());
                headInfo = headInfo.replaceAll("%%%displayname%%%", areaObject.getDisplayname());
                printingInformation.setHeadInfo(headInfo);
            }
            printingInformations.add(printingInformation);
        }
        inputDatas.put("legends", printingInformations);
        Map<PrintPropertyKey, Serializable> commonProperties = this.modelEnviroment.getPrintProperties().getCommonProperties();
        boolean showDate = ((PrintContentValue)commonProperties.get(PrintContentKey.PRINTING_DATE)).isPrint();
        if (showDate) {
            inputDatas.put("showDate", showDate);
        } else {
            inputDatas.put("showDate", null);
        }
        inputDatas.put("currentDate", sm.format(new Date()));
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        System.err.println("Creating pdf");
        return pdfCreator.createPdf(this.legendTemplate, inputDatas, null, ModelEnviroment.getMessageResolver());
    }
}

