/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.printer.AreaManagerPrinter;
import de.datomino.peppergis.areamanager.printer.AreaManagerPrinterImpl;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrintAction;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionPane;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.print.PrintOptionPane;
import de.datomino.peppergis.print.LegendNamePrintType;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public class AreaFromMapPrintAction
extends AbstractManagerPrintAction<AreaScheduleEntity> {
    private static final long serialVersionUID = -1073067664729255816L;
    private ManagerPrintOptionPane printOptionPane;
    private AreaManagerMapGui areaManagerMapGui;
    private ExtendedOptionPane extendedOptionPane;

    public AreaFromMapPrintAction(AreaManagerMapGui areaManagerMapGui, String title) {
        super(title, AbstractManagerPrintAction.PrintActionName.LEGEND, new AreaManagerPrinterImpl(areaManagerMapGui), areaManagerMapGui);
        this.areaManagerMapGui = areaManagerMapGui;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 512));
    }

    @Override
    protected Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> print() throws Exception {
        AreaManagerPrinter printer = (AreaManagerPrinter)this.managerPrinter;
        ErrorMessage errorMessage = null;
        InputStream inputStream = null;
        String tourAndAreaName = "";
        List<AreaObjectLogisticTourMapNode> tourNodes = ((AreaManagerMapGui)this.mapGui).getLogisticTourNodes();
        if (tourNodes.isEmpty()) {
            errorMessage = new ErrorMessage("gui.tour.message.noTour");
        } else {
            PrinterInformation printerInformation;
            if (this.printOptionPane == null) {
                this.printOptionPane = super.createPrintOptionPane(true, true, false);
            }
            if (this.extendedOptionPane == null) {
                this.extendedOptionPane = this.createExtendedOptionPane();
            }
            if ((printerInformation = super.getPrintingInformation(this.printOptionPane, this.extendedOptionPane)) != null && printerInformation.getPrintType() != null) {
                ImageModel logo = this.areaManagerMapGui.getAreaManager().getCurrentLayer().getLogo();
                boolean withPoi = this.extendedOptionPane.getWithPoi().isSelected();
                printerInformation.setWithPoi(withPoi);
                inputStream = printer.printAreaLegend(this.mapGui.getNavigatorPanel(), tourNodes, printerInformation, logo == null ? null : logo.getData());
                if (inputStream == null) {
                    errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.error.createpdf", new Serializable[0]));
                }
            }
        }
        if (inputStream == null) {
            return null;
        }
        if (tourNodes.size() == 1) {
            AreaObjectLogisticTourMapNode node = tourNodes.get(0);
            tourAndAreaName = node.getAreaObject() == null ? "" : node.getAreaObject().getShortcut() + "_" + this.areaManagerMapGui.getAreaManager().getCurrentLayer().getDisplayname();
        }
        return new Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages>(Collections.singletonList(new Tupel<String, Object>(tourAndAreaName, inputStream)), errorMessage == null ? new ErrorMessages() : new ErrorMessages(errorMessage));
    }

    private ExtendedOptionPane createExtendedOptionPane() {
        return new ExtendedOptionPane(this.printOptionPane);
    }

    @Override
    protected Tupel<InfoPrintPosition, String> getTypeTupel() {
        PrintProperties printProperties = this.mapGui.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> properties = printProperties.getAreaTourProperties();
        LegendNamePrintType legendNamePrintType = (LegendNamePrintType)((Object)properties.get(PrintParameterKey.INFO_POSITION));
        String legendNameRenderingType = (String)((Object)properties.get(PrintParameterKey.INFO_PATTERN));
        return new Tupel<InfoPrintPosition, String>(legendNamePrintType, legendNameRenderingType);
    }

    @Override
    protected String[] getButtonItems() {
        return new String[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.run", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])};
    }

    @Override
    protected PrinterInformation.PrintType getPrintType(int select) {
        switch (select) {
            case 0: {
                return PrinterInformation.PrintType.MULTIPLE_PAGES;
            }
        }
        return null;
    }

    @Override
    protected String getPropertyPrefix() {
        return "tour";
    }

    private class ExtendedOptionPane
    extends JPanel {
        private static final long serialVersionUID = 5236324321701129139L;
        private JRadioButton withPoi;
        private JRadioButton withoutPoi;

        public ExtendedOptionPane(PrintOptionPane printOptionPane) {
            super(new BorderLayout());
            this.buildLayout(printOptionPane);
        }

        private void buildLayout(PrintOptionPane printOptionPane) {
            this.add((Component)printOptionPane, "Center");
            JPanel subPanel = new JPanel(new SpringLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.withPoi = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.withPoi", new Serializable[0]));
            subPanel.add(this.withPoi);
            buttonGroup.add(this.withPoi);
            this.withoutPoi = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.withoutPoi", new Serializable[0]));
            subPanel.add(this.withoutPoi);
            buttonGroup.add(this.withoutPoi);
            SpringUtilities.makeCompactGrid(subPanel, 1, 2, 5, 5, 5, 5);
            this.withPoi.setSelected(true);
            this.add((Component)subPanel, "South");
        }

        public JRadioButton getWithPoi() {
            return this.withPoi;
        }
    }
}

