/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectHistoryTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.printer.AreaFromMapPrintAction;
import de.datomino.peppergis.areamanager.printer.AreaManagerPrintWaySelectionPane;
import de.datomino.peppergis.areamanager.printer.FilterFromMapPrintAction;
import de.datomino.peppergis.areamanager.printer.PrintScreenshotAction;
import de.datomino.peppergis.areamanager.printer.WagePrinter;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourPdfModel;
import de.datomino.peppergis.client.util.common.EnumWrapper;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class AllPrintAction
extends AbstractAction {
    private static final long serialVersionUID = 7521508247277688958L;
    private AreaManagerPrintWaySelectionPane areaManagerPrintWaySelectionPane;
    private AreaManagerMapGui areaManagerMapGui;
    private PrintScreenshotAction printScreenshotAction;
    private FilterFromMapPrintAction filterFromMapPrintAction;
    private AreaFromMapPrintAction areaFromMapPrintAction;

    public AllPrintAction(AreaManagerMapGui areaManagerMapGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.print", new Serializable[0]));
        this.areaManagerMapGui = areaManagerMapGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.areaManagerPrintWaySelectionPane == null) {
            this.areaManagerPrintWaySelectionPane = new AreaManagerPrintWaySelectionPane();
        }
        if (this.filterFromMapPrintAction == null) {
            this.filterFromMapPrintAction = new FilterFromMapPrintAction(this.areaManagerMapGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.print", new Serializable[0]));
        }
        if (this.areaFromMapPrintAction == null) {
            this.areaFromMapPrintAction = new AreaFromMapPrintAction(this.areaManagerMapGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.print", new Serializable[0]));
        }
        this.areaManagerPrintWaySelectionPane.setEnablings(this.areaManagerMapGui, this.filterFromMapPrintAction.hasToursToPrint());
        ImageIcon imageIcon = new ImageIcon(new ImageIcon(AllPrintAction.class.getResource("/images/pepper.png")).getImage().getScaledInstance(47, 47, 1));
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.areaManagerMapGui), this.areaManagerPrintWaySelectionPane, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.print", new Serializable[0]), 0, 3, imageIcon);
        if (d == 0) {
            switch (this.areaManagerPrintWaySelectionPane.getSelectedPrintWay()) {
                case SCREENSHOT: {
                    if (this.printScreenshotAction == null) {
                        this.printScreenshotAction = new PrintScreenshotAction(this.areaManagerMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.screenshot", new Serializable[0]));
                    }
                    this.printScreenshotAction.actionPerformed(e);
                    break;
                }
                case CALENDAR_SELECTION: {
                    List<Tupel<String, List<HistoryAreaTourPdfModel>>> toPrint;
                    Object[] options = new Object[]{new EnumWrapper<PrinterInformation.PrintType>(PrinterInformation.PrintType.ONE_PAGE), new EnumWrapper<PrinterInformation.PrintType>(PrinterInformation.PrintType.MULTIPLE_PAGES)};
                    int d2 = JOptionPane.showOptionDialog(SwingUtils.findWindowParent(this.areaManagerMapGui), ModelEnviroment.getMessageResolver().resolveMessage("messages.print.oneOrMultipleQuestion", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 2, 3, null, options, new EnumWrapper<PrinterInformation.PrintType>(PrinterInformation.PrintType.ONE_PAGE));
                    if (d2 == -1) break;
                    boolean multi = d2 != 1;
                    List<AreaObjectHistoryTourMapNode> historyTourNodes = this.areaManagerMapGui.getHistoryTourNodes();
                    HashSet<HistoryAreaTourModel> already = new HashSet<HistoryAreaTourModel>();
                    if (multi) {
                        toPrint = new ArrayList<Tupel<String, List<HistoryAreaTourPdfModel>>>();
                        for (AreaObjectHistoryTourMapNode node : historyTourNodes) {
                            HistoryAreaTourModelWageResult result = (HistoryAreaTourModelWageResult)node.getUserObject();
                            HistoryAreaTourModel model = result.getModel();
                            if (already.contains(model)) continue;
                            already.add(model);
                            Tupel<String, Collection<HistoryAreaTourPdfModel>> tupel = this.extractPdf(node);
                            if (tupel == null) continue;
                            toPrint.add(new Tupel<String, ArrayList<HistoryAreaTourPdfModel>>(tupel.getElement1(), new ArrayList<HistoryAreaTourPdfModel>(tupel.getElement2())));
                        }
                    } else {
                        ArrayList<HistoryAreaTourPdfModel> pdfs = new ArrayList<HistoryAreaTourPdfModel>();
                        for (AreaObjectHistoryTourMapNode node : historyTourNodes) {
                            HistoryAreaTourModelWageResult result = (HistoryAreaTourModelWageResult)node.getUserObject();
                            HistoryAreaTourModel model = result.getModel();
                            if (already.contains(model)) continue;
                            already.add(model);
                            Tupel<String, Collection<HistoryAreaTourPdfModel>> tupel = this.extractPdf(node);
                            if (tupel == null) continue;
                            pdfs.addAll(tupel.getElement2());
                        }
                        toPrint = Collections.singletonList(new Tupel("gebiete", pdfs));
                    }
                    already = null;
                    WagePrinter.printHistories(this.areaManagerMapGui, toPrint, true);
                    break;
                }
                case AREA_DELIVERER_WEEK: {
                    List<AreaTourScheduleNode> schedules = AreaTourScheduleModelUtil.getSchedulesColorMap(this.areaManagerMapGui.getAreaManager().getPlanTablePane().getAllEntities());
                    Collection<Tupel<String, List<HistoryAreaTourPdfModel>>> toPrint = this.splitSchedulesForWeek(schedules);
                    int count = 0;
                    for (Tupel<String, List<HistoryAreaTourPdfModel>> tupel : toPrint) {
                        List<HistoryAreaTourPdfModel> list = tupel.getElement2();
                        count += list == null ? 0 : list.size();
                    }
                    if (count == 0) {
                        JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.areaManagerMapGui), ModelEnviroment.getMessageResolver().resolveMessage("gui.print.noHistoryTour", new Serializable[0]));
                        break;
                    }
                    WagePrinter.printHistories(this.areaManagerMapGui, toPrint, false);
                    break;
                }
                case FILTER_ON_MAP: {
                    this.filterFromMapPrintAction.actionPerformed(e);
                    break;
                }
                case TOUR_ON_MAP: {
                    this.areaFromMapPrintAction.actionPerformed(e);
                }
            }
        }
    }

    private Tupel<String, Collection<HistoryAreaTourPdfModel>> extractPdf(AreaObjectHistoryTourMapNode node) {
        HistoryAreaTourPdfModel pdf;
        HashSet<HistoryAreaTourPdfModel> set = new HashSet<HistoryAreaTourPdfModel>();
        HistoryAreaTourModel model = ((HistoryAreaTourModelWageResult)node.getUserObject()).getModel();
        if (model != null && (pdf = model.getPdf()) != null && pdf.getData() != null) {
            set.add(pdf);
        }
        AreaObjectModel area = node.getAreaObject();
        return new Tupel<String, Collection<HistoryAreaTourPdfModel>>(area.getShortcut(), set);
    }

    private Tupel<String, Collection<HistoryAreaTourPdfModel>> extractPdf(AreaTourScheduleNode node) {
        AreaScheduleEntity entity = node.getEntity();
        HashSet<HistoryAreaTourPdfModel> set = new HashSet<HistoryAreaTourPdfModel>();
        for (HistoryAreaTourModelWageResult r : entity.getHistoryResult()) {
            HistoryAreaTourPdfModel pdf;
            HistoryAreaTourModel model = r.getModel();
            if (model == null || (pdf = model.getPdf()) == null || pdf.getData() == null) continue;
            set.add(pdf);
        }
        return new Tupel<String, Collection<HistoryAreaTourPdfModel>>(entity.getModel().iterator().next().getAreaObject().getShortcut(), set);
    }

    private Collection<Tupel<String, List<HistoryAreaTourPdfModel>>> splitSchedulesForWeek(List<AreaTourScheduleNode> schedules) {
        HashMap<AreaDelivererModel, LinkedList<Tupel<Date, HistoryAreaTourPdfModel>>> map = new HashMap<AreaDelivererModel, LinkedList<Tupel<Date, HistoryAreaTourPdfModel>>>();
        for (AreaTourScheduleNode node : schedules) {
            AreaScheduleEntity entity = node.getEntity();
            for (AreaTourScheduleModel schedule : entity.getModel()) {
                AreaDelivererModel deliverer = schedule.getDeliverer();
                if (deliverer == null) continue;
                for (HistoryAreaTourModelWageResult historyResult : entity.getHistoryResult()) {
                    HistoryAreaTourPdfModel pdf;
                    HistoryAreaTourModel model;
                    if (historyResult == null || (model = historyResult.getModel()) == null || (pdf = model.getPdf()) == null || pdf.getData() == null) continue;
                    LinkedList<Tupel<Date, HistoryAreaTourPdfModel>> list = (LinkedList<Tupel<Date, HistoryAreaTourPdfModel>>)map.get(deliverer);
                    if (list == null) {
                        list = new LinkedList<Tupel<Date, HistoryAreaTourPdfModel>>();
                        map.put(deliverer, list);
                    }
                    list.add(new Tupel<Date, HistoryAreaTourPdfModel>(model.getDate(), pdf));
                }
            }
        }
        ArrayList<Tupel<String, List<HistoryAreaTourPdfModel>>> result = new ArrayList<Tupel<String, List<HistoryAreaTourPdfModel>>>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            Collections.sort(list, new Comparator<Tupel<Date, HistoryAreaTourPdfModel>>(){

                @Override
                public int compare(Tupel<Date, HistoryAreaTourPdfModel> o1, Tupel<Date, HistoryAreaTourPdfModel> o2) {
                    return o1.getElement1().compareTo(o2.getElement1());
                }
            });
            ArrayList sList = new ArrayList(list.size());
            for (Tupel tupel : list) {
                sList.add(tupel.getElement2());
            }
            result.add(new Tupel(((AreaDelivererModel)entry.getKey()).getDelivererNumber(), sList));
        }
        return result;
    }
}

