/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.model;

import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.model.AbstractTimeObjectBucketModel;
import de.datomino.peppergis.client.manager.model.TimeExtractor;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.util.swing.blocking.BusyHandler;
import de.datomino.util.time.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class AreaScheduleTimeBucketModel
extends AbstractTimeObjectBucketModel<AreaScheduleEntity, AreaObjectModel> {
    private ModelEnviroment modelEnviroment;
    private boolean weekFilter = false;
    private Collection<AreaObjectModel> filteredAreas;
    private Collection<AreaDelivererModel> filteredDeliverers;
    private boolean dayFilter = false;
    private Date currentDay;
    private boolean unplanned = false;
    private Collection<DelivererStatus> filteredStatuses;
    private AreaLayerModel areaLayer;

    public AreaScheduleTimeBucketModel(TimeExtractor<AreaScheduleEntity> timeExtractor, ModelEnviroment modelEnviroment, BusyHandler busyHandler, AreaLayerModel areaLayer) {
        super(timeExtractor, 7, busyHandler);
        this.modelEnviroment = modelEnviroment;
        this.areaLayer = areaLayer;
    }

    public Map<AreaObjectModel, Collection<AreaScheduleEntity>> findObjects(Collection<AreaObjectModel> areaObjects, Date startTime, Date endTime, boolean withFilters) {
        Map bucketMap = super.findBuckets(areaObjects, startTime, endTime);
        HashMap<AreaObjectModel, Collection<AreaScheduleEntity>> objectMap = new HashMap<AreaObjectModel, Collection<AreaScheduleEntity>>();
        for (AreaObjectModel areaObject : bucketMap.keySet()) {
            HashSet<AreaScheduleEntity> objects = new HashSet<AreaScheduleEntity>();
            for (AreaScheduleEntity entity : bucketMap.get(areaObject)) {
                Date plannedTime = entity.getDate();
                if (!plannedTime.equals(startTime) && !plannedTime.after(startTime) || !plannedTime.before(endTime)) continue;
                objects.add(entity);
            }
            if (withFilters && !this.inFilters(areaObject, objects)) continue;
            objectMap.put(areaObject, objects);
        }
        return objectMap;
    }

    public Map<AreaObjectModel, Collection<AreaScheduleEntity>> findObjects(Date startTime, Date endTime, boolean withFilters) {
        HashMap<AreaObjectModel, Collection<AreaScheduleEntity>> objectMap = new HashMap<AreaObjectModel, Collection<AreaScheduleEntity>>();
        objectMap.putAll(this.findObjects(this.getAllAreaObjects(), startTime, endTime, withFilters));
        return objectMap;
    }

    private Collection<AreaObjectModel> getAllAreaObjects() {
        ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(this.areaLayer.countAreaObjects());
        for (AreaObjectModel area : this.areaLayer.iterableAreaObjects()) {
            list.add(area);
        }
        return list;
    }

    private boolean inFilters(AreaObjectModel areaObject, Collection<AreaScheduleEntity> entities) {
        if (this.weekFilter) {
            if (this.filteredAreas == null && this.filteredDeliverers == null) {
                return true;
            }
            if (this.filteredAreas == null) {
                return this.findDeliverer(entities);
            }
            if (this.filteredDeliverers == null) {
                return this.filteredAreas.contains(areaObject);
            }
            return this.filteredAreas.contains(areaObject) | this.findDeliverer(entities);
        }
        if (this.dayFilter) {
            HashSet<AreaTourScheduleModel> found = new HashSet<AreaTourScheduleModel>();
            for (AreaScheduleEntity entity : entities) {
                for (AreaTourScheduleModel schedule : entity.getModel()) {
                    Date plannedStartTime = schedule.getPlannedStartTime();
                    if (!TimeUtil.isSamedDay(plannedStartTime, this.currentDay)) continue;
                    found.add(schedule);
                }
            }
            boolean b = false;
            if (found.isEmpty()) {
                b = this.unplanned;
            } else {
                for (AreaTourScheduleModel schedule : found) {
                    AreaDelivererModel deliverer = schedule.getDeliverer();
                    DelivererStatus currentStatus = DelivererModelUtil.getStatus(deliverer, this.currentDay);
                    if (this.filteredStatuses != null && !this.filteredStatuses.contains((Object)currentStatus)) continue;
                    b = true;
                    break;
                }
            }
            return b;
        }
        return true;
    }

    private boolean findDeliverer(Collection<AreaScheduleEntity> entities) {
        if (this.filteredDeliverers != null) {
            for (AreaScheduleEntity entity : entities) {
                for (AreaTourScheduleModel schedule : entity.getModel()) {
                    if (this.filteredDeliverers.contains(schedule.getDeliverer())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<AreaObjectModel, Collection<AreaScheduleEntity>> callback(Collection<AreaObjectModel> areaObjects, Date startTime, Date endTime) {
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        this.busyHandler.start();
        try {
            Collection<Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>>> tupels = tourCaller.fetchAreaTourSchedulesWithTimeWindow(areaObjects, startTime, endTime);
            HashMap map = new HashMap();
            for (AreaObjectModel areaObject : areaObjects) {
                HashSet<AreaScheduleEntity> values = (HashSet<AreaScheduleEntity>)map.get(areaObject);
                if (values == null) {
                    values = new HashSet<AreaScheduleEntity>();
                    map.put(areaObject, values);
                }
                Date date = TimeUtil.normalize(startTime);
                do {
                    Collection<AreaTourScheduleModel> schedules = new HashSet<AreaTourScheduleModel>();
                    Collection<HistoryAreaTourModel> histories = new HashSet<HistoryAreaTourModel>();
                    for (Tupel<Collection<AreaTourScheduleModel>, Collection<HistoryAreaTourModel>> tupel : tupels) {
                        HistoryAreaTourModel history;
                        Collection<HistoryAreaTourModel> element2;
                        AreaTourScheduleModel schedule;
                        boolean b = false;
                        Collection<AreaTourScheduleModel> element1 = tupel.getElement1();
                        if (element1 != null && !element1.isEmpty() && areaObject.equals((schedule = element1.iterator().next()).getAreaObject()) && date.compareTo(TimeUtil.normalize(schedule.getPlannedStartTime())) == 0) {
                            schedules = element1;
                            b = true;
                        }
                        if ((element2 = tupel.getElement2()) != null && !element2.isEmpty() && (history = element2.iterator().next()) != null) {
                            String layer = history.getLayerName();
                            String shortcut = history.getShortcut();
                            if (areaObject.getShortcut().equals(shortcut) && areaObject.getAreaLayer().getDisplayname().equals(layer) && date.compareTo(TimeUtil.normalize(TimeUtil.normalize(history.getDate()))) == 0) {
                                histories = element2;
                                b = true;
                            }
                        }
                        if (!b) continue;
                        break;
                    }
                    values.add(new AreaScheduleEntity(areaObject, date, schedules, histories, this.modelEnviroment));
                } while (!endTime.before(date = TimeUtil.add(date, 5, 1)));
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            this.busyHandler.stop();
        }
    }

    public void activeWeekFilter(Collection<AreaObjectModel> filteredAreas, Collection<AreaDelivererModel> filteredDeliverers) {
        this.weekFilter = true;
        this.filteredAreas = filteredAreas;
        this.filteredDeliverers = filteredDeliverers;
        this.dayFilter = false;
    }

    public void clearWeekFilter() {
        this.weekFilter = false;
    }

    public void setDayFilter(Date currentDay, boolean unplanned, Collection<DelivererStatus> filteredStatuses) {
        this.dayFilter = true;
        this.currentDay = currentDay;
        this.unplanned = unplanned;
        this.filteredStatuses = filteredStatuses;
        this.weekFilter = false;
    }

    public void clearDayFilter() {
        this.dayFilter = false;
    }

    public void setCurrentDay(Date currentDay) {
        this.currentDay = currentDay;
    }

    public boolean isDayFilter() {
        return this.dayFilter;
    }
}

